/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.securityDomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ConfigureRSATokenAuthorization
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ConfigureRSATokenAuthorization.class, "ConfigureRSATokenAuthorization", "com.ibm.ws.security.admintask.securityDomain");
    Boolean globalSecEnabled = new Boolean(false);
    Long tokenExpiration = null;
    Long nonceCacheTimeout = null;
    String adminCertTrustStore = null;
    String adminCertTrustStoreScope = null;
    String adminCertKeyStore = null;
    String adminCertKeyStoreScope = null;
    String adminCertAlias = null;
    ObjectName trustStoreObj = null;
    ObjectName keyStoreObj = null;
    ObjectName certObj = null;

    public ConfigureRSATokenAuthorization(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ConfigureRSATokenAuthorization(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName security2 = cs.resolve(session, "Cell=:Security=")[0];
            AttributeList queryAttrs = new AttributeList();
            this.tokenExpiration = (Long)this.getParameter("tokenExpiration");
            this.nonceCacheTimeout = (Long)this.getParameter("nonceCacheTimeout");
            this.adminCertTrustStore = (String)this.getParameter("adminCertTrustStore");
            this.adminCertTrustStoreScope = (String)this.getParameter("adminCertTrustStoreScope");
            this.adminCertKeyStore = (String)this.getParameter("adminCertKeyStore");
            this.adminCertKeyStoreScope = (String)this.getParameter("adminCertKeyStoreScope");
            this.adminCertAlias = (String)this.getParameter("adminCertAlias");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tokenExpiration=" + this.tokenExpiration + " nonceCacheTimeout=" + this.nonceCacheTimeout + " adminCertTrustStore=" + this.adminCertTrustStore + " adminCertTrustStoreScope=" + this.adminCertTrustStoreScope + " adminCertKeyStore=" + this.adminCertKeyStore + " adminCertKeyStoreScope=" + this.adminCertKeyStoreScope + " adminCertAlias=" + this.adminCertAlias);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.adminCertTrustStore != null) {
                if (this.adminCertTrustStoreScope == null) {
                    this.adminCertTrustStoreScope = commandHelper.defaultScope();
                }
                queryAttrs.clear();
                ConfigServiceHelper.setAttributeValue(queryAttrs, "name", this.adminCertTrustStore);
                this.trustStoreObj = commandHelper.getObjectName(cs, session, security2, "keyStores", queryAttrs, this.adminCertTrustStoreScope);
            }
            if (this.adminCertKeyStore != null) {
                if (this.adminCertKeyStoreScope == null) {
                    this.adminCertKeyStoreScope = commandHelper.defaultScope();
                }
                queryAttrs.clear();
                ConfigServiceHelper.setAttributeValue(queryAttrs, "name", this.adminCertKeyStore);
                this.keyStoreObj = commandHelper.getObjectName(cs, session, security2, "keyStores", queryAttrs, this.adminCertKeyStoreScope);
                if (this.adminCertAlias == null || this.adminCertAlias != null && this.adminCertAlias.length() == 0) {
                    String msg = this.getMsg(resBundle, "security.admintask.noCertAlias.SECJ7745E", null);
                    throw new CommandValidationException(msg);
                }
            }
            if (this.tokenExpiration != null) {
                this.tokenExpiration = this.tokenExpiration * 60L;
            }
            if (this.nonceCacheTimeout != null) {
                this.nonceCacheTimeout = this.nonceCacheTimeout * 60L;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.admintask.securityDomain.ConfigureRolePropAuthorization.validate", "151", this);
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ObjectName secObj = null;
        AttributeList attrList = new AttributeList();
        try {
            ObjectName certObj;
            ConfigService configService = this.getConfigService();
            Session session = this.getConfigSession();
            secObj = configService.resolve(session, "Cell=:Security=")[0];
            ObjectName rolePropObj = ConfigureRSATokenAuthorization.getRolePropObj(session, configService, secObj);
            if (rolePropObj != null) {
                if (this.tokenExpiration == null) {
                    this.tokenExpiration = (Long)configService.getAttribute(session, rolePropObj, "tokenExpiration");
                }
                if (this.nonceCacheTimeout == null) {
                    this.nonceCacheTimeout = (Long)configService.getAttribute(session, rolePropObj, "nonceCacheTimeout");
                }
                if (this.trustStoreObj == null) {
                    this.trustStoreObj = (ObjectName)configService.getAttribute(session, rolePropObj, "adminCertificateTrustStore");
                }
                if (this.keyStoreObj == null) {
                    this.certObj = (ObjectName)configService.getAttribute(session, rolePropObj, "adminCertificate");
                    if (this.certObj != null) {
                        this.keyStoreObj = (ObjectName)configService.getAttribute(session, this.certObj, "keyStore");
                        if (this.adminCertAlias == null) {
                            this.adminCertAlias = (String)configService.getAttribute(session, this.certObj, "alias");
                        }
                    }
                }
            }
            if (this.tokenExpiration == null) {
                this.tokenExpiration = new Long(600L);
            }
            if (this.nonceCacheTimeout == null) {
                this.nonceCacheTimeout = new Long(1200L);
            }
            if (this.tokenExpiration >= this.nonceCacheTimeout) {
                String msg = this.getMsg(resBundle, "security.admintask.nonceValue.SECJ7746E", null);
                throw new CommandValidationException(msg);
            }
            if (this.keyStoreObj != null && !this.isAdminKeyStore(session, configService, this.keyStoreObj)) {
                String msg = this.getMsg(resBundle, "security.admintask.RSAKeyStore.SECJ7747E", new Object[]{this.adminCertKeyStore});
                throw new CommandValidationException(msg);
            }
            if (this.trustStoreObj != null && !this.isAdminKeyStore(session, configService, this.trustStoreObj)) {
                String msg = this.getMsg(resBundle, "security.admintask.RSATrustStore.SECJ7748E", new Object[]{this.adminCertTrustStore});
                throw new CommandValidationException(msg);
            }
            if (this.adminCertAlias != null) {
                if (this.keyStoreObj == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.noKeyStore.SECJ7749E", null);
                    throw new CommandValidationException(msg);
                }
                KeyStore ks = (KeyStore)MOFUtil.convertToEObject((Session)session, (ObjectName)this.keyStoreObj);
                KeyStoreInfo ksInfo = PersonalCertificateHelper.getKsInfo(session, configService, ks.getName(), ks.getManagementScope().getScopeName());
                if (!PersonalCertificateHelper.isAliasInKeyStore(this.adminCertAlias, ksInfo)) {
                    String msg = this.getMsg(resBundle, "security.admintask.certNotInKS.SECJ7750E", new Object[]{this.adminCertAlias, this.adminCertKeyStore});
                    throw new CommandValidationException(msg);
                }
            }
            if (rolePropObj == null) {
                attrList.clear();
                attrList.add(new Attribute("OID", "oid:1.3.18.0.2.30.6"));
                attrList.add(new Attribute("authContextImplClass", "com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextAdminRolePropImpl"));
                attrList.add(new Attribute("authConfig", "system.DEFAULT"));
                attrList.add(new Attribute("simpleAuthConfig", "system.DEFAULT"));
                attrList.add(new Attribute("authValidationConfig", "system.DEFAULT"));
                rolePropObj = configService.createConfigData(session, secObj, "authMechanisms", "RSAToken", attrList);
            }
            attrList.clear();
            if (this.tokenExpiration != null) {
                attrList.add(new Attribute("tokenExpiration", (long)this.tokenExpiration));
            }
            if (this.nonceCacheTimeout != null) {
                attrList.add(new Attribute("nonceCacheTimeout", (long)this.nonceCacheTimeout));
            }
            if (this.trustStoreObj != null) {
                attrList.add(new Attribute("adminCertificateTrustStore", this.trustStoreObj));
            }
            configService.setAttributes(session, rolePropObj, attrList);
            attrList.clear();
            if (this.keyStoreObj != null) {
                attrList.add(new Attribute("keyStore", this.keyStoreObj));
            }
            if (this.adminCertAlias != null) {
                attrList.add(new Attribute("alias", this.adminCertAlias));
            }
            if (this.certObj != null) {
                configService.setAttributes(session, this.certObj, attrList);
            } else if (!attrList.isEmpty() && (certObj = configService.createConfigData(session, secObj, "certificates", null, attrList)) != null) {
                attrList.clear();
                attrList.add(new Attribute("adminCertificate", certObj));
                configService.setAttributes(session, rolePropObj, attrList);
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.ConfigureRolePropAuthorization", "317");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            result.setException(new CommandValidationException(cse, cse.getMessage()));
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
        }
    }

    public static ObjectName getRolePropObj(Session session, ConfigService configService, ObjectName secObj) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRolePropObj");
        }
        ObjectName authMechObj = null;
        try {
            ArrayList mechanisms = (ArrayList)configService.getAttribute(session, secObj, "authMechanisms");
            if (mechanisms != null) {
                for (int i = 0; i < mechanisms.size(); ++i) {
                    ObjectName[] matches;
                    AttributeList authAttrs = (AttributeList)mechanisms.get(i);
                    Object authObj = ConfigServiceHelper.getAttributeValue(authAttrs, "_Websphere_Config_Data_Type");
                    if (!authObj.toString().equals("RSAToken") || (matches = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(authAttrs), null))[0] == null) continue;
                    authMechObj = matches[0];
                }
            }
        }
        catch (InvalidAttributeNameException e) {
            return authMechObj;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRolePropObj");
        }
        return authMechObj;
    }

    private boolean isAdminKeyStore(Session session, ConfigService cs, ObjectName keyStoreObj) throws Exception {
        String usage = (String)cs.getAttribute(session, keyStoreObj, "usage");
        return usage != null && usage.equalsIgnoreCase(CommandConstants.KS_USAGE_RSA);
    }
}

