/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.securityDomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.securityDomain.SecConfigTaskHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ConfigureJAASLogin
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ConfigureJAASLogin.class, "ConfigureJAASLogin", "com.ibm.ws.security.admintask.securityDomain");
    private ObjectName secObj;
    private ObjectName globalSecObj;
    private ConfigService configService;
    private Session session;
    private String type;
    private String secDomain = null;
    private String loginType = null;
    private String loginEntryAlias = null;
    private String loginModules = null;
    private String authStrategies = null;
    private String loginModule = null;
    private String authStrategy = null;
    private String customProperties = null;
    private Boolean useProxy = null;

    public ConfigureJAASLogin(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ConfigureJAASLogin(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    private boolean validLoginType(String type) {
        return type.equalsIgnoreCase("system") || type.equalsIgnoreCase("application");
    }

    private boolean validLoginStrategies(String[] strategies) {
        for (int i = 0; i < strategies.length; ++i) {
            if (strategies[i].equalsIgnoreCase("REQUIRED") || strategies[i].equalsIgnoreCase("REQUISITE") || strategies[i].equalsIgnoreCase("SUFFICIENT") || strategies[i].equalsIgnoreCase("OPTIONAL")) continue;
            return false;
        }
        return true;
    }

    public void configureJAASLoginEntry() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureJAASLoginEntry");
        }
        ArrayList attrList = null;
        String[] loginModuleEntries = null;
        String[] authStrategyEntries = null;
        HashMap<String, AttributeList> savedLoginEntries = new HashMap<String, AttributeList>();
        try {
            if (this.loginModules != null && !this.loginModules.equals("")) {
                loginModuleEntries = this.loginModules.split(",");
                if (this.authStrategies != null && !this.authStrategies.equals("")) {
                    authStrategyEntries = this.authStrategies.split(",");
                    if (!this.validLoginStrategies(authStrategyEntries)) {
                        String msg = this.getMsg(resBundle, "security.admintask.strategyTypeNotValid.SECJ7706E", null);
                        throw new CommandValidationException(msg);
                    }
                    if (loginModuleEntries.length != authStrategyEntries.length) {
                        String msg = this.getMsg(resBundle, "security.admintask.strategyTypeMismatch.SECJ7707E", null);
                        throw new CommandValidationException(msg);
                    }
                }
                if (loginModuleEntries != null && loginModuleEntries.length > 0) {
                    for (int i = 0; i < loginModuleEntries.length; ++i) {
                        if (!loginModuleEntries[i].equals("com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy")) continue;
                        String msg = this.getMsg(resBundle, "security.admintask.noLoginModulNamed.SECJ7774E", new Object[]{"com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy"});
                        throw new CommandValidationException(msg);
                    }
                }
            }
            if (this.secDomain != null) {
                AttributeList loginAttrs = this.configService.getAttributes(this.session, this.secObj, new String[]{this.type}, true);
                if ((loginAttrs = (AttributeList)ConfigServiceHelper.getAttributeValue(loginAttrs, this.type)) == null || loginAttrs.isEmpty()) {
                    AttributeList attrs = new AttributeList();
                    AttributeList newLoginEntry = new AttributeList();
                    attrs.add(new Attribute("alias", this.loginEntryAlias));
                    newLoginEntry.add(new Attribute("entries", ConfigServiceHelper.createObjectName(attrs)));
                    this.configService.createConfigData(this.session, this.secObj, this.type, "JAASConfiguration", newLoginEntry);
                }
            }
            if (attrList != null) {
                attrList.clear();
            }
            attrList = this.configService.getAttributes(this.session, this.secObj, new String[]{this.type}, true);
            AttributeList attrs = (AttributeList)ConfigServiceHelper.getAttributeValue((AttributeList)attrList, this.type);
            ObjectName[] loginObj = this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(attrs), null);
            ArrayList loginEntries = (ArrayList)ConfigServiceHelper.getAttributeValue(attrs, "entries");
            if (loginEntries != null) {
                int i;
                ObjectName entryObj = null;
                boolean entryExists = false;
                for (i = 0; i < loginEntries.size(); ++i) {
                    AttributeList loginAttrs = (AttributeList)loginEntries.get(i);
                    ObjectName[] entryObjs = this.configService.queryConfigObjects(this.session, loginObj[0], ConfigServiceHelper.createObjectName(loginAttrs), null);
                    String entryAlias = (String)ConfigServiceHelper.getAttributeValue(loginAttrs, "alias");
                    if (!entryAlias.equals(this.loginEntryAlias)) continue;
                    if (loginModuleEntries != null && loginModuleEntries.length > 0) {
                        ArrayList modules = (ArrayList)ConfigServiceHelper.getAttributeValue(loginAttrs, "loginModules");
                        for (int j = 0; j < modules.size(); ++j) {
                            AttributeList moduleAttrs = (AttributeList)modules.get(j);
                            String moduleName = (String)ConfigServiceHelper.getAttributeValue(moduleAttrs, "moduleClassName");
                            if (moduleName.equals("com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy")) {
                                ArrayList options = (ArrayList)ConfigServiceHelper.getAttributeValue(moduleAttrs, "options");
                                for (int p = 0; p < options.size(); ++p) {
                                    AttributeList option = (AttributeList)options.get(p);
                                    String name = (String)ConfigServiceHelper.getAttributeValue(option, "name");
                                    if (!name.equals("delegate")) continue;
                                    moduleName = (String)ConfigServiceHelper.getAttributeValue(option, "value");
                                }
                            }
                            ObjectName[] moduleObj = this.configService.queryConfigObjects(this.session, entryObjs[0], ConfigServiceHelper.createObjectName(moduleAttrs), null);
                            AttributeList attr = this.configService.getAttributes(this.session, moduleObj[0], null, true);
                            savedLoginEntries.put(moduleName, attr);
                            this.configService.deleteConfigData(this.session, moduleObj[0]);
                        }
                    }
                    entryObj = entryObjs[0];
                    entryExists = true;
                    break;
                }
                if (!entryExists) {
                    attrList.clear();
                    ((AttributeList)attrList).add(new Attribute("alias", this.loginEntryAlias));
                    entryObj = this.configService.createConfigData(this.session, loginObj[0], "entries", null, (AttributeList)attrList);
                }
                if (loginModuleEntries != null && loginModuleEntries.length > 0) {
                    for (i = 0; i < loginModuleEntries.length; ++i) {
                        attrList.clear();
                        String moduleEntry = loginModuleEntries[i];
                        AttributeList savedLoginEntry = (AttributeList)savedLoginEntries.get(moduleEntry);
                        if (savedLoginEntry != null) {
                            this.configService.createConfigData(this.session, entryObj, "loginModules", null, savedLoginEntry);
                            continue;
                        }
                        ((AttributeList)attrList).add(new Attribute("moduleClassName", loginModuleEntries[i]));
                        if (authStrategyEntries != null) {
                            ((AttributeList)attrList).add(new Attribute("authenticationStrategy", authStrategyEntries[i].toUpperCase()));
                        } else {
                            ((AttributeList)attrList).add(new Attribute("authenticationStrategy", "REQUIRED"));
                        }
                        this.configService.createConfigData(this.session, entryObj, "loginModules", null, (AttributeList)attrList);
                    }
                }
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.ConfigureJAASLogin", "224");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "configureJAASLoginEntry");
            }
        }
    }

    public ArrayList listJAASLoginEntries() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listJAASLoginEntries");
        }
        AttributeList attrList = null;
        ArrayList loginEntries = null;
        ArrayList<AttributeList> loginEntriesList = new ArrayList<AttributeList>();
        try {
            attrList = (AttributeList)this.configService.getAttribute(this.session, this.secObj, this.type);
            if (attrList != null) {
                loginEntries = (ArrayList)ConfigServiceHelper.getAttributeValue(attrList, "entries");
            }
            if (loginEntries != null) {
                for (int i = 0; i < loginEntries.size(); ++i) {
                    AttributeList loginAttrs = (AttributeList)loginEntries.get(i);
                    loginEntriesList.add(loginAttrs);
                }
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.ConfigureJAASLogin", "264");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listJAASLoginEntries");
            }
        }
        return loginEntriesList;
    }

    public void configureLoginModule() throws Exception {
        block32: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "configureLoginModule");
            }
            ArrayList attrList = null;
            ObjectName loginEntry = null;
            try {
                AttributeList attrs;
                if (this.authStrategy != null && !this.validLoginStrategies(new String[]{this.authStrategy})) {
                    String msg = this.getMsg(resBundle, "security.admintask.strategyTypeNotValid.SECJ7706E", null);
                    throw new CommandValidationException(msg);
                }
                if (this.loginModule.equals("com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy")) {
                    String msg = this.getMsg(resBundle, "security.admintask.noLoginModulNamed.SECJ7774E", new Object[]{"com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy"});
                    throw new CommandValidationException(msg);
                }
                if (attrList != null) {
                    attrList.clear();
                }
                if ((attrs = (AttributeList)ConfigServiceHelper.getAttributeValue((AttributeList)(attrList = this.configService.getAttributes(this.session, this.secObj, new String[]{this.type}, true)), this.type)) != null) {
                    ObjectName[] loginObj = this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(attrs), null);
                    ArrayList loginEntries = (ArrayList)ConfigServiceHelper.getAttributeValue(attrs, "entries");
                    if (loginEntries != null) {
                        ObjectName[] moduleObjs = null;
                        ObjectName moduleObj = null;
                        ObjectName delObj = null;
                        for (int i = 0; i < loginEntries.size(); ++i) {
                            AttributeList loginAttrs = (AttributeList)loginEntries.get(i);
                            ObjectName[] entryObjs = this.configService.queryConfigObjects(this.session, loginObj[0], ConfigServiceHelper.createObjectName(loginAttrs), null);
                            String entryAlias = (String)ConfigServiceHelper.getAttributeValue(loginAttrs, "alias");
                            if (!entryAlias.equals(this.loginEntryAlias)) continue;
                            loginEntry = entryObjs[0];
                            ArrayList modules = (ArrayList)ConfigServiceHelper.getAttributeValue(loginAttrs, "loginModules");
                            for (int j = 0; j < modules.size(); ++j) {
                                AttributeList moduleAttrs = (AttributeList)modules.get(j);
                                String module = (String)ConfigServiceHelper.getAttributeValue(moduleAttrs, "moduleClassName");
                                if (module.equals("com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy")) {
                                    ArrayList options = (ArrayList)ConfigServiceHelper.getAttributeValue(moduleAttrs, "options");
                                    for (int p = 0; p < options.size(); ++p) {
                                        String value;
                                        AttributeList option = (AttributeList)options.get(p);
                                        String name = (String)ConfigServiceHelper.getAttributeValue(option, "name");
                                        if (!name.equals("delegate") || !(value = (String)ConfigServiceHelper.getAttributeValue(option, "value")).equals(this.loginModule)) continue;
                                        moduleObjs = this.configService.queryConfigObjects(this.session, entryObjs[0], ConfigServiceHelper.createObjectName(moduleAttrs), null);
                                        ObjectName[] delegateObj = this.configService.queryConfigObjects(this.session, moduleObjs[0], ConfigServiceHelper.createObjectName(option), null);
                                        delObj = delegateObj[0];
                                        if (this.useProxy != null) break;
                                        this.useProxy = Boolean.TRUE;
                                        break;
                                    }
                                    if (delObj == null) continue;
                                    break;
                                }
                                if (!module.equals(this.loginModule)) continue;
                                moduleObjs = this.configService.queryConfigObjects(this.session, entryObjs[0], ConfigServiceHelper.createObjectName(moduleAttrs), null);
                                break;
                            }
                            if (moduleObjs == null) break;
                            moduleObj = moduleObjs[0];
                            break;
                        }
                        if (attrList != null) {
                            attrList.clear();
                        }
                        if (this.useProxy != null && this.useProxy.booleanValue()) {
                            ((AttributeList)attrList).add(new Attribute("moduleClassName", "com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy"));
                        } else if (this.useProxy == null || this.useProxy != null && !this.useProxy.booleanValue()) {
                            ((AttributeList)attrList).add(new Attribute("moduleClassName", this.loginModule));
                        }
                        if (this.authStrategy != null) {
                            ((AttributeList)attrList).add(new Attribute("authenticationStrategy", this.authStrategy.toUpperCase()));
                        }
                        if (moduleObj != null) {
                            if (attrList != null) {
                                this.configService.setAttributes(this.session, moduleObj, (AttributeList)attrList);
                            }
                        } else if (loginEntry != null) {
                            if (attrList != null) {
                                moduleObj = this.configService.createConfigData(this.session, loginEntry, "loginModules", null, (AttributeList)attrList);
                            }
                        } else {
                            String msg = this.getMsg(resBundle, "security.admintask.loginAliasDoesNotExist.SECJ7736E", new Object[]{this.loginEntryAlias});
                            throw new CommandValidationException(msg);
                        }
                        attrList.clear();
                        if (this.useProxy != null && this.useProxy.booleanValue() && delObj == null) {
                            ((AttributeList)attrList).add(new Attribute("name", "delegate"));
                            ((AttributeList)attrList).add(new Attribute("value", this.loginModule));
                            this.configService.createConfigData(this.session, moduleObj, "options", null, (AttributeList)attrList);
                            attrList.clear();
                        } else if (this.useProxy != null && !this.useProxy.booleanValue() && delObj != null) {
                            this.configService.deleteConfigData(this.session, delObj);
                        }
                        if (this.customProperties != null) {
                            SecConfigTaskHelper.addCustomEntries(this.session, this.configService, moduleObj, this.customProperties, "options");
                        }
                    }
                    break block32;
                }
                String msg = this.getMsg(resBundle, "security.admintask.loginAliasDoesNotExist.SECJ7736E", new Object[]{this.loginEntryAlias});
                throw new CommandValidationException(msg);
            }
            catch (Exception cse) {
                FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.ConfigureJAASLogin", "429");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "configureLoginModule");
                }
            }
        }
    }

    public ArrayList listLoginModules() throws Exception {
        ArrayList<AttributeList> moduleList;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listLoginModules");
            }
            AttributeList attrList = null;
            ArrayList loginEntries = null;
            ArrayList modules = null;
            moduleList = new ArrayList<AttributeList>();
            try {
                attrList = (AttributeList)this.configService.getAttribute(this.session, this.secObj, this.type);
                if (attrList != null) {
                    loginEntries = (ArrayList)ConfigServiceHelper.getAttributeValue(attrList, "entries");
                }
                if (loginEntries == null) break block11;
                for (int i = 0; i < loginEntries.size(); ++i) {
                    AttributeList loginAttrs = (AttributeList)loginEntries.get(i);
                    String entryAlias = (String)ConfigServiceHelper.getAttributeValue(loginAttrs, "alias");
                    if (!entryAlias.equals(this.loginEntryAlias)) continue;
                    modules = (ArrayList)ConfigServiceHelper.getAttributeValue(loginAttrs, "loginModules");
                    for (int j = 0; j < modules.size(); ++j) {
                        AttributeList module = (AttributeList)modules.get(j);
                        moduleList.add(module);
                    }
                    break;
                }
            }
            catch (Exception cse) {
                FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.ConfigureJAASLogin", "480");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "listLoginModules");
                }
            }
        }
        return moduleList;
    }

    public void unconfigureJAASLoginEntry() throws Exception {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "unconfigureJAASLoginEntry");
            }
            try {
                AttributeList attrList = this.configService.getAttributes(this.session, this.secObj, new String[]{this.type}, true);
                AttributeList attrs = (AttributeList)ConfigServiceHelper.getAttributeValue(attrList, this.type);
                if (attrs == null || attrs.isEmpty()) break block11;
                ObjectName[] loginObj = this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(attrs), null);
                ArrayList loginEntries = (ArrayList)ConfigServiceHelper.getAttributeValue(attrs, "entries");
                if (loginEntries != null) {
                    for (int i = 0; i < loginEntries.size(); ++i) {
                        AttributeList loginAttrs = (AttributeList)loginEntries.get(i);
                        ObjectName[] entryObjs = this.configService.queryConfigObjects(this.session, loginObj[0], ConfigServiceHelper.createObjectName(loginAttrs), null);
                        String entryAlias = (String)ConfigServiceHelper.getAttributeValue(loginAttrs, "alias");
                        if (!entryAlias.equals(this.loginEntryAlias)) continue;
                        if (this.okayToDeleteEntry(this.loginEntryAlias, this.type)) {
                            this.configService.deleteConfigData(this.session, entryObjs[0]);
                            break block11;
                        }
                        String msg = this.getMsg(resBundle, "security.admintask.cannotRemove.SECJ7737E", new Object[]{this.loginEntryAlias});
                        throw new CommandValidationException(msg);
                    }
                    break block11;
                }
                String msg = this.getMsg(resBundle, "security.admintask.loginDoesNotExist.SECJ7735E", null);
                throw new CommandValidationException(msg);
            }
            catch (Exception cse) {
                FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.ConfigureJAASLogin", "540");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "unconfigureJAASLoginEntry");
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AttributeList getJAASLoginEntryInfo() throws Exception {
        if (ConfigureJAASLogin.tc.isEntryEnabled()) {
            Tr.entry(ConfigureJAASLogin.tc, "getJAASLoginEntryInfo");
        }
        try {
            attrList = this.configService.getAttributes(this.session, this.secObj, new String[]{this.type}, true);
            attrs = (AttributeList)ConfigServiceHelper.getAttributeValue(attrList, this.type);
            loginEntries = (ArrayList)ConfigServiceHelper.getAttributeValue(attrs, "entries");
            if (loginEntries == null) ** GOTO lbl-1000
            ** GOTO lbl11
lbl-1000:
            // 1 sources

            {
                msg = this.getMsg(ConfigureJAASLogin.resBundle, "security.admintask.loginDoesNotExist.SECJ7735E", null);
                throw new CommandValidationException(msg);
lbl11:
                // 2 sources

                for (i = 0; i < loginEntries.size(); ++i) {
                    loginAttrs = (AttributeList)loginEntries.get(i);
                    entryAlias = (String)ConfigServiceHelper.getAttributeValue(loginAttrs, "alias");
                    if (entryAlias.equals(this.loginEntryAlias)) {
                        var7_10 = loginAttrs;
                        return var7_10;
                    }
                    ** try [egrp 2[TRYBLOCK] [1 : 144->204)] { 
lbl18:
                    // 1 sources

                }
                msg = this.getMsg(ConfigureJAASLogin.resBundle, "security.admintask.loginAliasDoesNotExist.SECJ7736E", new Object[]{this.loginEntryAlias});
                throw new CommandValidationException(msg);
            }
        }
lbl21:
        // 2 sources

        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.ConfigureJAASLogin", "586");
            if (ConfigureJAASLogin.tc.isDebugEnabled() == false) throw cse;
            Tr.debug(ConfigureJAASLogin.tc, "exception caught", cse);
            throw cse;
        }
        finally {
            if (ConfigureJAASLogin.tc.isEntryEnabled()) {
                Tr.exit(ConfigureJAASLogin.tc, "getJAASLoginEntryInfo");
            }
        }
    }

    public void unconfigureLoginModule() throws Exception {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "unconfigureLoginModule");
            }
            try {
                AttributeList attrList = this.configService.getAttributes(this.session, this.secObj, new String[]{this.type}, true);
                AttributeList attrs = (AttributeList)ConfigServiceHelper.getAttributeValue(attrList, this.type);
                if (attrs == null || attrs.isEmpty()) break block13;
                ObjectName[] loginObj = this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(attrs), null);
                ArrayList loginEntries = (ArrayList)ConfigServiceHelper.getAttributeValue(attrs, "entries");
                ObjectName[] moduleObjs = null;
                if (loginEntries != null) {
                    block5: for (int i = 0; i < loginEntries.size(); ++i) {
                        AttributeList loginAttrs = (AttributeList)loginEntries.get(i);
                        ObjectName[] entryObjs = this.configService.queryConfigObjects(this.session, loginObj[0], ConfigServiceHelper.createObjectName(loginAttrs), null);
                        String entryAlias = (String)ConfigServiceHelper.getAttributeValue(loginAttrs, "alias");
                        if (!entryAlias.equals(this.loginEntryAlias)) continue;
                        ArrayList modules = (ArrayList)ConfigServiceHelper.getAttributeValue(loginAttrs, "loginModules");
                        block6: for (int j = 0; j < modules.size(); ++j) {
                            AttributeList moduleAttrs = (AttributeList)modules.get(j);
                            String module = (String)ConfigServiceHelper.getAttributeValue(moduleAttrs, "moduleClassName");
                            if (module.equals("com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy")) {
                                ArrayList options = (ArrayList)ConfigServiceHelper.getAttributeValue(moduleAttrs, "options");
                                for (int p = 0; p < options.size(); ++p) {
                                    String value;
                                    AttributeList option = (AttributeList)options.get(p);
                                    String name = (String)ConfigServiceHelper.getAttributeValue(option, "name");
                                    if (!name.equals("delegate") || !(value = (String)ConfigServiceHelper.getAttributeValue(option, "value")).equals(this.loginModule)) continue;
                                    moduleObjs = this.configService.queryConfigObjects(this.session, entryObjs[0], ConfigServiceHelper.createObjectName(moduleAttrs), null);
                                    this.configService.deleteConfigData(this.session, moduleObjs[0]);
                                    continue block6;
                                }
                                continue;
                            }
                            if (!module.equals(this.loginModule)) continue;
                            moduleObjs = this.configService.queryConfigObjects(this.session, entryObjs[0], ConfigServiceHelper.createObjectName(moduleAttrs), null);
                            this.configService.deleteConfigData(this.session, moduleObjs[0]);
                            continue block5;
                        }
                    }
                    break block13;
                }
                String msg = this.getMsg(resBundle, "security.admintask.loginDoesNotExist.SECJ7735E", null);
                throw new CommandValidationException(msg);
            }
            catch (Exception cse) {
                FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.ConfigureJAASLogin", "674");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "unconfigureLoginModule");
                }
            }
        }
    }

    public void unconfigureJAASLogin() throws Exception {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "unconfigureJAASLogin");
            }
            try {
                AttributeList attrs;
                AttributeList attrList = this.configService.getAttributes(this.session, this.secObj, new String[]{this.type}, true);
                if (attrList == null || (attrs = (AttributeList)ConfigServiceHelper.getAttributeValue(attrList, this.type)) == null) break block9;
                ObjectName loginObj = ConfigServiceHelper.createObjectName(attrs);
                if (loginObj != null) {
                    this.configService.deleteConfigData(this.session, loginObj);
                    break block9;
                }
                String msg = this.getMsg(resBundle, "security.admintask.loginDoesNotExist.SECJ7735E", null);
                throw new CommandValidationException(msg);
            }
            catch (Exception cse) {
                FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.ConfigureJAASLogin", "715");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "unconfigureLocalOSUserRegistry");
                }
            }
        }
    }

    private boolean okayToDeleteEntry(String alias, String type) {
        boolean isOkay = true;
        if (this.secDomain != null) {
            return isOkay;
        }
        if (type.equals("systemLoginConfig")) {
            if (alias.equals("SWAM") || alias.equals("KRB5") || alias.equals("LTPA") || alias.equals("wssecurity.IDAssertion") || alias.equals("wssecurity.Signature") || alias.equals("LTPA_WEB") || alias.equals("WEB_INBOUND") || alias.equals("RMI_INBOUND") || alias.equals("DEFAULT") || alias.equals("RMI_OUTBOUND") || alias.equals("wssecurity.X509BST") || alias.equals("wssecurity.PkiPath") || alias.equals("wssecurity.PKCS7") || alias.equals("wssecurity.UsernameToken") || alias.equals("wssecurity.IDAssertionUsernameToken") || alias.equals("WSS_INBOUND") || alias.equals("WSS_OUTBOUND") || alias.equals("DESERIALIZE_ASYNCH_CONTEXT") || alias.equals("wssecurity.KRB5BST") || alias.equals("wssecurity.KRB5BSTIdentityMapping") || alias.equals("wss.generate.x509") || alias.equals("wss.consume.x509") || alias.equals("wss.generate.unt") || alias.equals("wss.consume.unt") || alias.equals("wss.generate.sct") || alias.equals("wss.consume.sct") || alias.equals("wss.caller") || alias.equals("wss.generate.pkcs7") || alias.equals("wss.consume.pkcs7") || alias.equals("wss.generate.pkiPath") || alias.equals("wss.consume.pkiPath") || alias.equals("wss.generate.ltpa") || alias.equals("wss.consume.ltpa") || alias.equals("wss.generate.ltpaProp") || alias.equals("wss.consume.ltpaProp") || alias.equals("wss.inbound.propagation") || alias.equals("wss.inbound.deserialize") || alias.equals("wss.auth.sts") || alias.equals("wss.generate.KRB5BST") || alias.equals("wss.consume.KRB5BST")) {
                isOkay = false;
            }
        } else if (type.equals("applicationLoginConfig") && (alias.equals("ClientContainer") || alias.equals("WSLogin") || alias.equals("WSKRB5Login") || alias.equals("DefaultPrincipalMapping") || alias.equals("TrustedConnectionMapping"))) {
            isOkay = false;
        }
        return isOkay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        String commandName = this.getName();
        try {
            String msg;
            this.configService = this.getConfigService();
            this.session = this.getConfigSession();
            try {
                this.secDomain = (String)this.getParameter("securityDomainName");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.loginType = (String)this.getParameter("loginType");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.loginEntryAlias = (String)this.getParameter("loginEntryAlias");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.loginModules = (String)this.getParameter("loginModules");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.authStrategies = (String)this.getParameter("authStrategies");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.loginModule = (String)this.getParameter("loginModule");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.authStrategy = (String)this.getParameter("authStrategy");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.loginEntryAlias = (String)this.getParameter("loginEntryAlias");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.useProxy = (Boolean)this.getParameter("useLoginModuleProxy");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.customProperties = (String)this.getParameter("customProperties");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            if (!this.validLoginType(this.loginType)) {
                msg = this.getMsg(resBundle, "security.admintask.InvalidLoginModuleType.SECJ7705E", null);
                throw new CommandValidationException(msg);
            }
            if (this.loginType.equalsIgnoreCase("system")) {
                this.type = "systemLoginConfig";
            } else if (this.loginType.equalsIgnoreCase("application")) {
                this.type = "applicationLoginConfig";
            }
            this.globalSecObj = SecConfigTaskHelper.getSecurityObjectName(this.session, this.configService);
            if (this.secDomain != null) {
                if ((commandName.equals("configureJAASLoginEntry") || commandName.equals("configureLoginModule") || commandName.equals("unconfigureJAASLoginEntry") || commandName.equals("unconfigureLoginModule") || commandName.equals("unconfigureJAASLogin")) && this.secDomain.equals("PassThroughToGlobalSecurity")) {
                    msg = this.getMsg(resBundle, "security.admintask.unableToRunCommand.SECJ7810E", new Object[]{commandName, this.secDomain});
                    throw new CommandValidationException(msg);
                }
                this.secObj = SecConfigTaskHelper.getSecDomain(this.session, this.configService, this.secDomain);
                if (this.secObj == null) {
                    msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{this.secDomain});
                    throw new CommandValidationException(msg);
                }
            } else {
                this.secObj = this.globalSecObj;
            }
            if (commandName.equals("configureJAASLoginEntry")) {
                this.configureJAASLoginEntry();
            }
            if (commandName.equals("listJAASLoginEntries")) {
                result.setResult(this.listJAASLoginEntries());
            }
            if (commandName.equals("configureLoginModule")) {
                this.configureLoginModule();
            }
            if (commandName.equals("listLoginModules")) {
                result.setResult(this.listLoginModules());
            }
            if (commandName.equals("unconfigureJAASLoginEntry")) {
                this.unconfigureJAASLoginEntry();
            }
            if (commandName.equals("unconfigureLoginModule")) {
                this.unconfigureLoginModule();
            }
            if (commandName.equals("unconfigureJAASLogin")) {
                this.unconfigureJAASLogin();
            }
            if (commandName.equals("getJAASLoginEntryInfo")) {
                result.setResult(this.getJAASLoginEntryInfo());
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.ConfigureJAASLogin", "868");
            Tr.debug(tc, "exception caught", cse);
            result.setException(new CommandValidationException(cse, cse.getMessage()));
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
        }
    }
}

