/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.securityDomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.securityDomain.ConfigureLTPAAuthMechanism;
import com.ibm.ws.security.admintask.securityDomain.SecConfigTaskHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigureAuthData
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ConfigureLTPAAuthMechanism.class, "ConfigureAuthData", "com.ibm.ws.security.admintask.securityDomain");
    private ObjectName secObj;
    private ObjectName globalSecObj;
    private ConfigService configService;
    private Session session;
    private String secDomain;
    private String alias;
    private String user;
    private String password;
    private String description;

    public ConfigureAuthData(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ConfigureAuthData(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    private ObjectName createAuthDataEntry() throws Exception {
        AttributeList temp = new AttributeList();
        String newAlias = this.getAlias(this.alias);
        if (!this.authDataEntryExists(this.alias)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "alias to be added is " + newAlias);
            }
            temp.add(new Attribute("alias", newAlias));
            temp.add(new Attribute("userId", this.user));
            temp.add(new Attribute("password", this.password));
            if (this.description != null) {
                temp.add(new Attribute("description", this.description));
            }
            return this.configService.createConfigData(this.session, this.secObj, "authDataEntries", null, temp);
        }
        String msg = this.getMsg(resBundle, "security.admintask.duplicateAuthDataEntry.SECJ7813E", null);
        throw new CommandValidationException(msg);
    }

    private boolean authDataEntryExists(String alias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authDataEntryExists");
        }
        boolean entryExists = false;
        String nodeName = this.getNodeName();
        AttributeList temp = this.configService.getAttributes(this.session, this.secObj, new String[]{"authDataEntries"}, true);
        ArrayList authDataEntries = (ArrayList)ConfigServiceHelper.getAttributeValue(temp, "authDataEntries");
        for (int i = 0; i < authDataEntries.size(); ++i) {
            temp = (AttributeList)authDataEntries.get(i);
            String aliasValue = (String)ConfigServiceHelper.getAttributeValue(temp, "alias");
            if (!aliasValue.equals(alias) && !aliasValue.equals(nodeName + "/" + alias)) continue;
            entryExists = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authDataEntryExists");
        }
        return entryExists;
    }

    private String getNodeName() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeName");
        }
        String nodeName = "";
        nodeName = AdminServiceFactory.getAdminService() != null ? AdminServiceFactory.getAdminService().getNodeName() : this.getNodeNameLocalMode();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeName");
        }
        return nodeName;
    }

    private String getNodeNameLocalMode() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeNameLocalMode");
        }
        String nodeName = "";
        String serverType = "";
        boolean nodeNameFound = false;
        String profileHome = System.getProperty("user.install.root");
        if (profileHome != null) {
            File cells = new File(profileHome + "/config/cells");
            File[] cellNames = cells.listFiles();
            for (int j = 0; j < cellNames.length; ++j) {
                File nodes = new File(cellNames[j] + "/nodes");
                if (nodes.listFiles() != null) {
                    File[] nodeNames = nodes.listFiles();
                    for (int k = 0; k < nodeNames.length; ++k) {
                        File[] nodeNameFiles = nodeNames[k].listFiles();
                        for (int l = 0; l < nodeNameFiles.length; ++l) {
                            if (nodeNameFiles[l].isFile() && nodeNameFiles[l].getName().equals("node.xml")) {
                                nodeName = this.getNodeNameFromXml(nodeNameFiles[l]);
                                continue;
                            }
                            if (!nodeNameFiles[l].isFile() || !nodeNameFiles[l].getName().equals("serverindex.xml")) continue;
                            serverType = this.getServerTypeFromXml(nodeNameFiles[l]);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "nodeName is " + nodeName);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "serverType is " + serverType);
                        }
                        if (nodeName.length() <= 0 || serverType.length() <= 0 || !serverType.equals("DEPLOYMENT_MANAGER") && nodeNames.length != 1) continue;
                        nodeNameFound = true;
                        break;
                    }
                }
                if (!nodeNameFound) {
                    continue;
                }
                break;
            }
        } else {
            String msg = "Unable to get profileHome";
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeNameLocalMode");
        }
        return nodeName;
    }

    private String getNodeNameFromXml(File file) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeNameFromXml");
        }
        String nodeName = "";
        try {
            Document xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            NodeList nodeData = xmlDoc.getElementsByTagName("topology.node:Node");
            if (nodeData.getLength() != 0) {
                for (int i = 0; i < nodeData.getLength(); ++i) {
                    Node nodeDataEntry = nodeData.item(i);
                    nodeName = nodeDataEntry.getAttributes().getNamedItem("name").getNodeValue();
                }
            }
        }
        catch (Exception e) {
            String msg = "Exception in attempting to parse XML file " + file.getName() + " to get the node name ";
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeNameFromXml");
        }
        return nodeName;
    }

    private String getServerTypeFromXml(File file) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerTypeFromXml");
        }
        String serverType = "";
        try {
            Document xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            NodeList serverEntries = xmlDoc.getElementsByTagName("serverEntries");
            if (serverEntries.getLength() != 0) {
                Node serverEntry;
                for (int i = 0; i < serverEntries.getLength() && !(serverType = (serverEntry = serverEntries.item(i)).getAttributes().getNamedItem("serverType").getNodeValue()).equals("DEPLOYMENT_MANAGER"); ++i) {
                }
            }
        }
        catch (Exception e) {
            String msg = "Exception in attempting to parse XML file " + file.getName() + " to get the server type ";
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerTypeFromXml");
        }
        return serverType;
    }

    private void modifyAuthDataEntry() throws Exception {
        AttributeList entry = this.getAuthDataEntry();
        ObjectName entryObj = this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(entry), null)[0];
        AttributeList add = new AttributeList();
        if (this.user != null && this.user.length() > 0) {
            add.add(new Attribute("userId", this.user));
        }
        if (this.password != null && this.password.length() > 0) {
            add.add(new Attribute("password", this.password));
        }
        if (this.description != null) {
            add.add(new Attribute("description", this.description));
        }
        this.configService.setAttributes(this.session, entryObj, add);
    }

    private void deleteAuthDataEntry() throws Exception {
        AttributeList entry = this.getAuthDataEntry();
        ObjectName entryObj = this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(entry), null)[0];
        this.configService.deleteConfigData(this.session, entryObj);
    }

    private void setPasswordStars(AttributeList a) {
        Iterator i = a.iterator();
        while (i.hasNext()) {
            Attribute t = (Attribute)i.next();
            if (!t.getName().equals("password")) continue;
            i.remove();
        }
        a.add(new Attribute("password", "*******"));
    }

    private AttributeList getAuthDataEntry() throws Exception {
        String nodeName = this.getNodeName();
        AttributeList temp = this.configService.getAttributes(this.session, this.secObj, new String[]{"authDataEntries"}, true);
        ArrayList authDataEntries = (ArrayList)ConfigServiceHelper.getAttributeValue(temp, "authDataEntries");
        for (int i = 0; i < authDataEntries.size(); ++i) {
            temp = (AttributeList)authDataEntries.get(i);
            String aliasValue = (String)ConfigServiceHelper.getAttributeValue(temp, "alias");
            if (!aliasValue.equals(this.alias) && !aliasValue.equals(nodeName + "/" + this.alias)) continue;
            this.setPasswordStars(temp);
            return temp;
        }
        String msg = this.getMsg(resBundle, "security.admintask.noAuthDataEntry.SECJ7732E", null);
        throw new CommandValidationException(msg);
    }

    private ArrayList listAuthDataEntries() throws Exception {
        ArrayList<AttributeList> result = new ArrayList<AttributeList>();
        AttributeList temp = this.configService.getAttributes(this.session, this.secObj, new String[]{"authDataEntries"}, true);
        ArrayList authDataEntries = (ArrayList)ConfigServiceHelper.getAttributeValue(temp, "authDataEntries");
        for (int i = 0; i < authDataEntries.size(); ++i) {
            AttributeList t = (AttributeList)authDataEntries.get(i);
            this.setPasswordStars(t);
            result.add(t);
        }
        return result;
    }

    private String getAlias(String alias) {
        String newAlias;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAlias");
            }
            newAlias = "";
            try {
                String propValue;
                String globalPropValue;
                String secDomainPropValue;
                String nodeName = this.getNodeName();
                newAlias = this.secDomain != null ? ((secDomainPropValue = (String)SecConfigTaskHelper.getPropertyValue(this.session, this.configService, this.secObj, "properties", "com.ibm.websphere.security.JAASAuthData.addNodeNameSecDomain")) != null && secDomainPropValue.equalsIgnoreCase("true") ? nodeName + "/" + alias : (secDomainPropValue != null && secDomainPropValue.equalsIgnoreCase("false") ? alias : ((globalPropValue = (String)SecConfigTaskHelper.getPropertyValue(this.session, this.configService, this.globalSecObj, "properties", "com.ibm.websphere.security.JAASAuthData.addNodeNameSecDomain")) != null && globalPropValue.equalsIgnoreCase("true") ? nodeName + "/" + alias : alias))) : ((propValue = (String)SecConfigTaskHelper.getPropertyValue(this.session, this.configService, this.globalSecObj, "properties", "com.ibm.websphere.security.JAASAuthData.removeNodeNameGlobal")) != null && propValue.equalsIgnoreCase("true") ? alias : nodeName + "/" + alias);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.admintask.securityDomain.ConfigureAuthData", "%c%");
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "exception caught", e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "alias name returned from getAlias is: " + newAlias);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAlias");
        }
        return newAlias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        String commandName = this.getName();
        try {
            this.configService = this.getConfigService();
            this.session = this.getConfigSession();
            try {
                this.secDomain = (String)this.getParameter("securityDomainName");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.alias = (String)this.getParameter("alias");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.user = (String)this.getParameter("user");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.password = (String)this.getParameter("password");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.description = (String)this.getParameter("description");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            this.globalSecObj = SecConfigTaskHelper.getSecurityObjectName(this.session, this.configService);
            if (this.secDomain != null) {
                String msg;
                if ((commandName.equals("createAuthDataEntry") || commandName.equals("modifyAuthDataEntry") || commandName.equals("deleteAuthDataEntry")) && this.secDomain.equals("PassThroughToGlobalSecurity")) {
                    msg = this.getMsg(resBundle, "security.admintask.unableToRunCommand.SECJ7810E", new Object[]{commandName, this.secDomain});
                    throw new CommandValidationException(msg);
                }
                this.secObj = SecConfigTaskHelper.getSecDomain(this.session, this.configService, this.secDomain);
                if (this.secObj == null) {
                    msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{this.secDomain});
                    throw new CommandValidationException(msg);
                }
            } else {
                this.secObj = this.globalSecObj;
            }
            if (commandName.equals("createAuthDataEntry")) {
                result.setResult(this.createAuthDataEntry());
            }
            if (commandName.equals("modifyAuthDataEntry")) {
                this.modifyAuthDataEntry();
            }
            if (commandName.equals("deleteAuthDataEntry")) {
                this.deleteAuthDataEntry();
            }
            if (commandName.equals("getAuthDataEntry")) {
                result.setResult(this.getAuthDataEntry());
            }
            if (commandName.equals("listAuthDataEntries")) {
                result.setResult(this.listAuthDataEntries());
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.ConfigureAuthData", "206");
            Tr.debug(tc, "exception caught", cse);
            result.setException(new CommandValidationException(cse, cse.getMessage()));
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
        }
    }
}

