/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.naming;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class NamingAuthzCommands
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(NamingAuthzCommands.class, "security", "com.ibm.ws.security.admintask.naming");
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static String NAMING_AUTHZ_FILE = "naming-authz.xml";
    private static String NAMING_READ_ROLE = "CosNamingRead";
    private static String NAMING_WRITE_ROLE = "CosNamingWrite";
    private static String NAMING_CREATE_ROLE = "CosNamingCreate";
    private static String NAMING_DELETE_ROLE = "CosNamingDelete";

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public boolean mapUsersToNamingRole(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapUsersToNamingRole", new Object[]{cmd});
        }
        Object secID = null;
        Object secDomain = null;
        try {
            List lst;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String roleName = (String)cmd.getParameter("roleName");
            String[] userids = (String[])cmd.getParameter("userids");
            String[] accessIds = (String[])cmd.getParameter("accessids");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "roleName is " + roleName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "userids " + userids);
            }
            if (accessIds != null && accessIds.length > 0) {
                this.checkAccessIdFormat(accessIds, "user");
            }
            if (!(lst = this.addRemoveUserGroup(session, configService, cmd.getName(), roleName, userids, accessIds, null)).isEmpty()) {
                StringBuffer msg = new StringBuffer("");
                for (String id : lst) {
                    msg.append(id);
                    msg.append(" ");
                }
                String newMsg = this.getMsg(resBundle, "security.admintask.naming.invalid.users.groups.SECJ7758E", new Object[]{msg.toString(), roleName});
                throw new CommandValidationException(newMsg);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.NamingAuthzCommands", "110");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapUsersToNamingRole");
            }
        }
    }

    public boolean mapGroupsToNamingRole(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapGroupsToNamingRole", new Object[]{cmd});
        }
        Object secID = null;
        Object secDomain = null;
        try {
            List lst;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String roleName = (String)cmd.getParameter("roleName");
            String[] groupids = (String[])cmd.getParameter("groupids");
            String[] accessIds = (String[])cmd.getParameter("accessids");
            String[] specialSubjects = (String[])cmd.getParameter("specialSubjects");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "roleName is " + roleName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "groupsids " + groupids);
            }
            if (accessIds != null && accessIds.length > 0) {
                this.checkAccessIdFormat(accessIds, "group");
            }
            if (!(lst = this.addRemoveUserGroup(session, configService, cmd.getName(), roleName, groupids, accessIds, specialSubjects)).isEmpty()) {
                StringBuffer msg = new StringBuffer("");
                for (String id : lst) {
                    msg.append(id);
                    msg.append(" ");
                }
                String newMsg = this.getMsg(resBundle, "security.admintask.naming.invalid.users.groups.SECJ7758E", new Object[]{msg.toString(), roleName});
                throw new CommandValidationException(newMsg);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.NamingAuthzCommands", "153");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapGroupsToNamingRole");
            }
        }
    }

    public boolean removeUsersFromNamingRole(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUsersFromNamingRole", new Object[]{cmd});
        }
        try {
            List lst;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String roleName = (String)cmd.getParameter("roleName");
            String[] userids = (String[])cmd.getParameter("userids");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "roleName is " + roleName);
            }
            if (!(lst = this.addRemoveUserGroup(session, configService, cmd.getName(), roleName, userids, null, null)).isEmpty()) {
                StringBuffer msg = new StringBuffer("");
                for (String id : lst) {
                    msg.append(id);
                    msg.append(" ");
                }
                String newMsg = this.getMsg(resBundle, "security.admintask.naming.invalid.users.groups.remove.SECJ7759E", new Object[]{msg.toString(), roleName});
                throw new CommandValidationException(newMsg);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.NamingAuthzCommands", "187");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeUsersFromNamingRole");
            }
        }
    }

    public boolean removeGroupsFromNamingRole(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeGroupsFromNamingRole", new Object[]{cmd});
        }
        try {
            List lst;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String roleName = (String)cmd.getParameter("roleName");
            String[] groupids = (String[])cmd.getParameter("groupids");
            String[] specialSubjects = (String[])cmd.getParameter("specialSubjects");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "roleName is " + roleName);
            }
            if (!(lst = this.addRemoveUserGroup(session, configService, cmd.getName(), roleName, groupids, null, specialSubjects)).isEmpty()) {
                StringBuffer msg = new StringBuffer("");
                for (String id : lst) {
                    msg.append(id);
                    msg.append(" ");
                }
                String newMsg = this.getMsg(resBundle, "security.admintask.naming.invalid.users.groups.remove.SECJ7759E", new Object[]{msg.toString(), roleName});
                throw new CommandValidationException(newMsg);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.NamingAuthzCommands", "221");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeGroupsFromNamingRole");
            }
        }
    }

    public HashMap listUsersForNamingRoles(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listUsersForNamingRoles", new Object[]{cmd});
        }
        HashMap resourceRoleMap = null;
        try {
            HashMap hashMap = resourceRoleMap = this.listIDsForNamingRoles(cmd, "users");
            return hashMap;
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.NamingAuthzCommands", "238");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listUsersForNamingRoles", resourceRoleMap);
            }
        }
    }

    public HashMap listGroupsForNamingRoles(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listGroupsForNamingRoles", new Object[]{cmd});
        }
        HashMap resourceRoleMap = null;
        try {
            HashMap hashMap = resourceRoleMap = this.listIDsForNamingRoles(cmd, "groups");
            return hashMap;
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.NamingAuthzCommands", "255");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listGroupsForNamingRoles", resourceRoleMap);
            }
        }
    }

    private HashMap listIDsForNamingRoles(AbstractAdminCommand cmd, String type) throws Exception {
        HashMap hashMap;
        ObjectName namingAuthz;
        Session session;
        ConfigService configService;
        HashMap resourceRoleMap;
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listIDsForNamingRoles", new Object[]{cmd});
            }
            resourceRoleMap = null;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            configService = helper.getConfigService();
            session = cmd.getConfigSession();
            ObjectName cell = this.getCellObjectName(session, configService);
            ObjectName[] namingAuthzs = configService.resolve(session, cell, "AuthorizationTableExt");
            namingAuthz = null;
            for (int i = 0; i < namingAuthzs.length; ++i) {
                String authzFileName = ConfigServiceHelper.getDisplayName(namingAuthzs[i]);
                if (!authzFileName.equals(NAMING_AUTHZ_FILE)) continue;
                namingAuthz = namingAuthzs[i];
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Found : " + authzFileName);
                break;
            }
            if (namingAuthz != null) break block19;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find naming-authz.xml file");
            }
            HashMap i = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listIDsForNamingAuthz", resourceRoleMap);
            }
            return i;
        }
        try {
            resourceRoleMap = this.createResourceRoleMap();
            ArrayList authorizationsList = (ArrayList)configService.getAttribute(session, namingAuthz, "authorizations", false);
            for (int k = 0; k < authorizationsList.size(); ++k) {
                ObjectName authz = (ObjectName)authorizationsList.get(k);
                ObjectName authzRoleID = (ObjectName)configService.getAttribute(session, authz, "role", false);
                String roleName = this.resolveRoleIDToRoleName(session, configService, namingAuthz, authzRoleID);
                ArrayList ids = (ArrayList)configService.getAttribute(session, authz, type, false);
                ArrayList<String> resourcesList = (ArrayList<String>)resourceRoleMap.get(roleName);
                if (resourcesList == null) {
                    resourcesList = new ArrayList<String>();
                }
                resourceRoleMap.put(roleName, resourcesList);
                for (int l = 0; l < ids.size(); ++l) {
                    ObjectName id = (ObjectName)ids.get(l);
                    String IDName = (String)configService.getAttribute(session, id, "name", false);
                    resourcesList.add(IDName);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Authorization role:  " + roleName + ".  Name:  " + IDName);
                }
                if (type == null || !type.equals("groups")) continue;
                ArrayList specialSubjectsids = (ArrayList)configService.getAttribute(session, authz, "specialSubjects", false);
                for (int m = 0; m < specialSubjectsids.size(); ++m) {
                    ObjectName specialSubject = (ObjectName)specialSubjectsids.get(m);
                    String specialSubjectType = ConfigServiceHelper.getConfigDataType(specialSubject);
                    if (specialSubjectType.equals("EveryoneExt")) {
                        resourcesList.add("EVERYONE");
                        continue;
                    }
                    if (specialSubjectType.equals("AllAuthenticatedUsersExt")) {
                        resourcesList.add("ALLAUTHENTICATED");
                        continue;
                    }
                    if (!specialSubjectType.equals("AllAuthenticatedUsersInTrustedRealmsExt")) continue;
                    resourcesList.add("ALLAUTHENTICATEDINTRUSTEDREALMS");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "naming-authz.xml name is " + namingAuthz.getCanonicalName());
            }
            hashMap = resourceRoleMap;
        }
        catch (Exception cse) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.NamingAuthzCommands", "332");
                throw cse;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "listIDsForNamingAuthz", resourceRoleMap);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listIDsForNamingAuthz", resourceRoleMap);
        }
        return hashMap;
    }

    private HashMap createResourceRoleMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResourceRoleMap");
        }
        HashMap resourceRoleMap = new HashMap(5);
        ArrayList readList = new ArrayList();
        ArrayList writeList = new ArrayList();
        ArrayList createList = new ArrayList();
        ArrayList deleteList = new ArrayList();
        resourceRoleMap.put(NAMING_READ_ROLE, readList);
        resourceRoleMap.put(NAMING_WRITE_ROLE, writeList);
        resourceRoleMap.put(NAMING_CREATE_ROLE, createList);
        resourceRoleMap.put(NAMING_DELETE_ROLE, deleteList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResourceRoleMap", resourceRoleMap);
        }
        return resourceRoleMap;
    }

    private String resolveRoleIDToRoleName(Session session, ConfigService configService, ObjectName authzTable, ObjectName roleID) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveRoleIDToRoleName", roleID);
        }
        String result = null;
        ArrayList roleList = (ArrayList)configService.getAttribute(session, authzTable, "roles", false);
        for (int i = 0; i < roleList.size(); ++i) {
            ObjectName roles = (ObjectName)roleList.get(i);
            if (!roles.equals(roleID)) continue;
            result = (String)configService.getAttribute(session, roles, "roleName", false);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveRoleIDToRoleName", result);
        }
        return result;
    }

    private List addRemoveUserGroup(Session session, ConfigService configService, String cmdName, String roleName, String[] ids, String[] accessIds, String[] specialSubjects) throws ConfigServiceException, ConnectorException, CommandValidationException {
        ObjectName predefinedRoleObjectName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRemoveUserGroup", new Object[]{cmdName, roleName, ids, accessIds});
        }
        ArrayList<String> failedList = new ArrayList<String>();
        ObjectName cell = this.getCellObjectName(session, configService);
        ObjectName[] namingAuthzs = configService.resolve(session, cell, "AuthorizationTableExt");
        ObjectName namingAuthz = null;
        for (int i = 0; i < namingAuthzs.length; ++i) {
            String authzFileName = ConfigServiceHelper.getDisplayName(namingAuthzs[i]);
            if (!authzFileName.equals(NAMING_AUTHZ_FILE)) continue;
            namingAuthz = namingAuthzs[i];
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "Found : " + authzFileName);
            break;
        }
        if ((predefinedRoleObjectName = this.resolveRoleNameToRoleID(session, configService, namingAuthz, roleName)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Role " + roleName + " does not exist");
            }
            String msg = this.getMsg(resBundle, "security.admintask.naming.invalid.roleName.SECJ7760E", new Object[]{roleName});
            throw new CommandValidationException(msg);
        }
        ArrayList authorizationsList = (ArrayList)configService.getAttribute(session, namingAuthz, "authorizations", false);
        for (int i = 0; i < authorizationsList.size(); ++i) {
            ObjectName authorization = (ObjectName)authorizationsList.get(i);
            ObjectName authorizationRole = (ObjectName)configService.getAttribute(session, authorization, "role", false);
            if (!authorizationRole.equals(predefinedRoleObjectName)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authorizationRole found" + authorizationRole.getCanonicalName());
            }
            boolean lengthsMatch = false;
            if (ids != null) {
                if (accessIds != null && ids.length == accessIds.length) {
                    lengthsMatch = true;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not adding accessIds since either they are missing or do not match the same number as the ids");
                }
                for (int j = 0; j < ids.length; ++j) {
                    ObjectName roleToDelete;
                    String id = ids[j];
                    String aId = null;
                    if (lengthsMatch) {
                        aId = accessIds[j];
                    }
                    AttributeList roleAttrList = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(roleAttrList, "name", id);
                    if (aId != null) {
                        ConfigServiceHelper.setAttributeValue(roleAttrList, "accessId", aId);
                    }
                    if (cmdName.equals("mapUsersToNamingRole")) {
                        if (this.findRoleIDInAuthorization(session, configService, authorization, "users", id) == null) {
                            configService.createConfigData(session, authorization, "users", "UserExt", roleAttrList);
                            continue;
                        }
                        failedList.add(id);
                        continue;
                    }
                    if (cmdName.equals("mapGroupsToNamingRole")) {
                        if (this.findRoleIDInAuthorization(session, configService, authorization, "groups", id) == null) {
                            configService.createConfigData(session, authorization, "groups", "GroupExt", roleAttrList);
                            continue;
                        }
                        failedList.add(id);
                        continue;
                    }
                    if (cmdName.equals("removeUsersFromNamingRole")) {
                        roleToDelete = this.findRoleIDInAuthorization(session, configService, authorization, "users", id);
                        if (roleToDelete != null) {
                            configService.deleteConfigData(session, roleToDelete);
                            continue;
                        }
                        failedList.add(id);
                        continue;
                    }
                    if (!cmdName.equals("removeGroupsFromNamingRole")) continue;
                    roleToDelete = this.findRoleIDInAuthorization(session, configService, authorization, "groups", id);
                    if (roleToDelete != null) {
                        configService.deleteConfigData(session, roleToDelete);
                        continue;
                    }
                    failedList.add(id);
                }
            }
            if (specialSubjects == null || specialSubjects.length <= 0) continue;
            for (int k = 0; k < specialSubjects.length; ++k) {
                String specSubj = specialSubjects[k];
                if (specSubj.equals("ALLAUTHENTICATED")) {
                    ObjectName checkRole = this.findRoleIDInAuthorization(session, configService, authorization, "specialSubjects", "AllAuthenticatedUsersExt");
                    if (cmdName.equals("mapUsersToNamingRole") || cmdName.equals("mapGroupsToNamingRole")) {
                        if (checkRole == null) {
                            configService.createConfigData(session, authorization, "specialSubjects", "AllAuthenticatedUsersExt", new AttributeList());
                            continue;
                        }
                        failedList.add("ALLAUTHENTICATED");
                        continue;
                    }
                    if (!cmdName.equals("removeUsersFromNamingRole") && !cmdName.equals("removeGroupsFromNamingRole")) continue;
                    if (checkRole != null) {
                        configService.deleteConfigData(session, checkRole);
                        continue;
                    }
                    failedList.add("ALLAUTHENTICATED");
                    continue;
                }
                if (specSubj.equals("EVERYONE")) {
                    ObjectName checkRole = this.findRoleIDInAuthorization(session, configService, authorization, "specialSubjects", "EveryoneExt");
                    if (cmdName.equals("mapUsersToNamingRole") || cmdName.equals("mapGroupsToNamingRole")) {
                        if (checkRole == null) {
                            configService.createConfigData(session, authorization, "specialSubjects", "EveryoneExt", new AttributeList());
                            continue;
                        }
                        failedList.add("EVERYONE");
                        continue;
                    }
                    if (!cmdName.equals("removeUsersFromNamingRole") && !cmdName.equals("removeGroupsFromNamingRole")) continue;
                    if (checkRole != null) {
                        configService.deleteConfigData(session, checkRole);
                        continue;
                    }
                    failedList.add("EVERYONE");
                    continue;
                }
                if (!specSubj.equals("ALLAUTHENTICATEDINTRUSTEDREALMS")) continue;
                ObjectName checkRole = this.findRoleIDInAuthorization(session, configService, authorization, "specialSubjects", "AllAuthenticatedUsersInTrustedRealmsExt");
                if (cmdName.equals("mapUsersToNamingRole") || cmdName.equals("mapGroupsToNamingRole")) {
                    if (checkRole == null) {
                        configService.createConfigData(session, authorization, "specialSubjects", "AllAuthenticatedUsersInTrustedRealmsExt", new AttributeList());
                        continue;
                    }
                    failedList.add("ALLAUTHENTICATEDINTRUSTEDREALMS");
                    continue;
                }
                if (!cmdName.equals("removeUsersFromNamingRole") && !cmdName.equals("removeGroupsFromNamingRole")) continue;
                if (checkRole != null) {
                    configService.deleteConfigData(session, checkRole);
                    continue;
                }
                failedList.add("ALLAUTHENTICATEDINTRUSTEDREALMS");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRemoveUserGroup");
        }
        return failedList;
    }

    private ObjectName getCellObjectName(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellObjectName", new Object[]{session, configService, this});
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell ObjectName is " + cell + ". Cell Name is " + ConfigServiceHelper.getDisplayName(cell));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellObjectName", cell);
        }
        return cell;
    }

    private ObjectName findRoleIDInAuthorization(Session session, ConfigService configService, ObjectName authzGrp, String type, String id) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findRoleIDInAuthorization", new Object[]{authzGrp, type, id});
        }
        ObjectName result = null;
        ArrayList users = (ArrayList)configService.getAttribute(session, authzGrp, type, false);
        for (int i = 0; i < users.size(); ++i) {
            ObjectName role = (ObjectName)users.get(i);
            String roleName = !type.equals("specialSubjects") ? (String)configService.getAttribute(session, role, "name", false) : ConfigServiceHelper.getConfigDataType(role);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Role name to check is " + roleName);
            }
            if (!roleName.equals(id)) continue;
            result = role;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findRoleIDInAuthorization", result);
        }
        return result;
    }

    private ObjectName resolveRoleNameToRoleID(Session session, ConfigService configService, ObjectName authzTable, String roleName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveRoleNameToRoleID", roleName);
        }
        ObjectName result = null;
        ArrayList roleList = (ArrayList)configService.getAttribute(session, authzTable, "roles", false);
        for (int i = 0; i < roleList.size(); ++i) {
            ObjectName roles = (ObjectName)roleList.get(i);
            String roleRoleName = (String)configService.getAttribute(session, roles, "roleName", false);
            if (!roleRoleName.equalsIgnoreCase(roleName)) continue;
            result = roles;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveRoleNameToRoleID", result);
        }
        return result;
    }

    private void checkAccessIdFormat(String[] aIds, String type) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccessIdFormat", aIds);
        }
        String msg = this.getMsg(resBundle, "security.admintask.naming.invalidAccessIdFormat.SECJ7812E", null);
        for (int i = 0; i < aIds.length; ++i) {
            String aId = aIds[i];
            if (aId.startsWith(type + ":")) {
                String lastPart = aId.substring(aId.indexOf(":") + 1);
                if (lastPart != null && lastPart.length() > 1 && lastPart.contains("/")) {
                    String realm = lastPart.substring(0, lastPart.indexOf("/"));
                    if (realm != null && realm.length() > 0) {
                        String uuid = lastPart.substring(lastPart.indexOf("/") + 1);
                        if (uuid != null && uuid.length() != 0) continue;
                        throw new CommandValidationException(msg);
                    }
                    throw new CommandValidationException(msg);
                }
                throw new CommandValidationException(msg);
            }
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccessIdFormat");
        }
    }
}

