/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.migrate;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.security.SecurityCommon;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ServerSecurityMigrate
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(ServerSecurityMigrate.class, "ServerSecurityMigrate", "com.ibm.ws.security.adminTasks.migrate");
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public AbstractAdminCommand createCommand(CommandMetadata metadata2) throws CommandNotFoundException {
        return super.createCommand(metadata2);
    }

    public AbstractAdminCommand loadCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        return super.loadCommand(cmdData);
    }

    public String convertServerSecurityToSecurityDomain(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertServerSecurityToSecurityDomain", new Object[]{cmd});
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService cs = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName cell = null;
        Object security2 = null;
        String serverResource = null;
        String securityDomain = null;
        String secDomainDesc = null;
        Boolean deleteServer = null;
        AttributeList securitySettings = new AttributeList();
        AttributeList csiAttrs = new AttributeList();
        AttributeList custProps = new AttributeList();
        String resource = null;
        try {
            ObjectName[] serverObj;
            serverResource = (String)cmd.getParameter("serverResource");
            securityDomain = (String)cmd.getParameter("securityDomain");
            secDomainDesc = (String)cmd.getParameter("securityDomainDescription");
            deleteServer = (Boolean)cmd.getParameter("deleteServer");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverResource: " + serverResource);
                Tr.debug(tc, "securityDomain: " + securityDomain);
                Tr.debug(tc, "securityDomainDescription: " + secDomainDesc);
                Tr.debug(tc, "deleteServer: " + deleteServer);
            }
            if ((serverObj = cs.resolve(session, serverResource)).length != 1) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Resource is not a server type.");
                }
                String msg = this.getMsg(resBundle, "security.admintask.notServerType.SECJ7797E", null);
                throw new CommandValidationException(msg);
            }
            String resConfigID = ConfigServiceHelper.getConfigDataId(serverObj[0]).toString();
            String resourceType = ConfigServiceHelper.getConfigDataType(serverObj[0]);
            resource = resConfigID != null && resConfigID.lastIndexOf(124) > 0 ? resConfigID.substring(0, resConfigID.lastIndexOf(124)) : resConfigID;
            this.isResourceInADomain(session, cs, resource);
            if (resourceType.equals("Server")) {
                ObjectName[] serverSecObj = cs.queryConfigObjects(session, serverObj[0], ConfigServiceHelper.createObjectName(null, "Security"), null);
                if (serverSecObj.length > 0) {
                    Boolean enforceFineGrainedSec;
                    Boolean appEnabled;
                    Boolean enforceJava2Security;
                    Boolean issuePermissionWarning;
                    Integer cacheTimeout;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server security object found: " + serverSecObj);
                    }
                    ObjectName secObj = serverSecObj[0];
                    SecurityCommon commonSecurity = null;
                    commonSecurity = (SecurityCommon)MOFUtil.convertToEObject((Session)session, (ObjectName)secObj);
                    Boolean useDomainQualifiedUserNames = (Boolean)cs.getAttribute(session, secObj, "useDomainQualifiedUserNames");
                    if (useDomainQualifiedUserNames != null && commonSecurity.isSetUseDomainQualifiedUserNames()) {
                        securitySettings.add(new Attribute("useDomainQualifiedUserNames", useDomainQualifiedUserNames));
                    }
                    if ((cacheTimeout = (Integer)cs.getAttribute(session, secObj, "cacheTimeout")) != null && commonSecurity.isSetCacheTimeout()) {
                        securitySettings.add(new Attribute("cacheTimeout", cacheTimeout));
                    }
                    if ((issuePermissionWarning = (Boolean)cs.getAttribute(session, secObj, "issuePermissionWarning")) != null && commonSecurity.isSetIssuePermissionWarning()) {
                        securitySettings.add(new Attribute("issuePermissionWarning", issuePermissionWarning));
                    }
                    if ((enforceJava2Security = (Boolean)cs.getAttribute(session, secObj, "enforceJava2Security")) != null && commonSecurity.isSetEnforceJava2Security()) {
                        securitySettings.add(new Attribute("enforceJava2Security", enforceJava2Security));
                    }
                    if ((appEnabled = (Boolean)cs.getAttribute(session, secObj, "appEnabled")) != null && commonSecurity.isSetAppEnabled()) {
                        securitySettings.add(new Attribute("appEnabled", appEnabled));
                    }
                    if ((enforceFineGrainedSec = (Boolean)cs.getAttribute(session, secObj, "enforceFineGrainedJCASecurity")) != null && commonSecurity.isSetEnforceFineGrainedJCASecurity()) {
                        securitySettings.add(new Attribute("enforceFineGrainedJCASecurity", enforceFineGrainedSec));
                    }
                    csiAttrs = cs.getAttributes(session, secObj, new String[]{"CSI"}, true);
                    custProps = cs.getAttributes(session, secObj, new String[]{"properties"}, true);
                    AttributeList attrList = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(attrList, "name", securityDomain);
                    ConfigServiceHelper.setAttributeValue(attrList, "description", secDomainDesc);
                    cell = this.getCellObjectName(session, cs);
                    ObjectName domain = cs.createConfigData(session, cell, "SecurityDomain", "SecurityDomain", attrList);
                    attrList.clear();
                    ObjectName secDomain = cs.createConfigData(session, domain, "AppSecurity", "AppSecurity", attrList);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Security domain created : " + secDomain);
                    }
                    if (!securitySettings.isEmpty()) {
                        cs.setAttributes(session, secDomain, securitySettings);
                    }
                    if (!csiAttrs.isEmpty()) {
                        cs.setAttributes(session, secDomain, csiAttrs);
                    }
                    if (!custProps.isEmpty()) {
                        cs.setAttributes(session, secDomain, custProps);
                    }
                    attrList.clear();
                    ConfigServiceHelper.setAttributeValue(attrList, "resourceName", resource);
                    ConfigServiceHelper.setAttributeValue(attrList, "resourceType", resourceType);
                    cs.createConfigData(session, domain, "members", "SecurityDomainMember", attrList);
                    if (deleteServer.booleanValue()) {
                        cs.deleteConfigData(session, secObj);
                    }
                    return ConfigServiceHelper.getConfigDataId(secDomain).toString();
                }
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Server level security configuration does not exist.");
                }
                String msg = this.getMsg(resBundle, "security.admintask.multidomain.oldServerSecurity.SECJ7789E", new Object[]{serverResource});
                throw new CommandValidationException(msg);
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Resource is not a server type.");
            }
            String msg = this.getMsg(resBundle, "security.admintask.notServerType.SECJ7797E", null);
            throw new CommandValidationException(msg);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.adminTask.migrate.ServerSecurityMigrate", "235");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw e;
        }
    }

    private boolean isResourceInADomain(Session session, ConfigService configService, String resourceName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isResourceInADomain");
        }
        boolean inDomain = false;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
        ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
        for (int i = 0; i < domains.length; ++i) {
            ObjectName domain = domains[i];
            List members = (List)configService.getAttribute(session, domain, "members");
            for (AttributeList member : members) {
                if (!resourceName.equals(ConfigServiceHelper.getAttributeValue(member, "resourceName"))) continue;
                String name = (String)configService.getAttribute(session, domain, "name");
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error: " + resourceName + " already exists in the " + name + " domain.");
                }
                String msg = this.getMsg(resBundle, "security.admintask.scope.in.domain.SECJ7703E", new Object[]{resourceName, name});
                throw new CommandValidationException(msg);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isResouceInADomain");
        }
        return inDomain;
    }

    private ObjectName getCellObjectName(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellObjectName", new Object[]{session, configService, this});
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Policy");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell ObjectName is " + cell + ". Cell Name is " + ConfigServiceHelper.getDisplayName(cell));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellObjectName", cell);
        }
        return cell;
    }
}

