/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.signing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedConfiguratorFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateAuditSigningConfig
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(CreateAuditSigningConfig.class, "AUDIT", "com.ibm.ws.security.admintask.audit.signing");
    private Boolean enable = null;
    private Boolean useEncryptionCert = null;
    private String certAlias = null;
    private Boolean autogenCert = null;
    private Boolean importCert = null;
    private String certKeyFileName = null;
    private String certKeyFilePath = null;
    private String certKeyFileType = null;
    private String certKeyFilePassword = null;
    private String certAliasToImport = null;
    private String signingKeyStoreRef = null;
    private String signingKeyStorePath = null;
    private String signingKeyStoreType = null;
    private String signingKeyStorePassword = null;
    private String signingKeyStoreConfirmPassword = null;
    private String origCertAlias = null;
    private Boolean keyStoreIsFileBased = Boolean.TRUE;
    private Boolean keyStoreReadOnly = Boolean.FALSE;
    private Boolean keyStoreInitAtStartup = null;
    private String keyStoreCustomProvider = null;
    private Boolean keyStoreStashFile = null;
    private String scopeName = null;
    private boolean createKeyFile = true;
    private String keyStoreDescription = null;
    private ObjectName mgmScopeObjName = null;
    private boolean createMgmScope = false;
    String keyFileName = null;
    ObjectName keyStoreCreated = null;
    boolean keyStoreFound = false;

    public CreateAuditSigningConfig(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateAuditSigningConfig(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        String msg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            boolean granted;
            RoleBasedConfigurator configurator = RoleBasedConfiguratorFactory.getConfigurator();
            RoleBasedAuthorizer adminAuthorizer = configurator.getRoleBasedAuthorizer("admin-authz", "domain");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got the RoleBasedAuthorizer object.");
            }
            if (!(granted = adminAuthorizer.isCallerInRole("administrator"))) {
                String msg2 = this.getMsg(resBundle, "security.admintask.UserNotInRole", new Object[]{"administrator"});
                throw new CommandValidationException(msg2);
            }
        }
        catch (Exception e) {
            String msg3 = e.getMessage();
            throw new CommandValidationException(msg3);
        }
        this.enable = (Boolean)this.getParameter("enableAuditSigning");
        if (this.enable != null && !this.enable.booleanValue()) {
            msg = this.getMsg(resBundle, "security.admintask.CannotConfigSigning", null);
            throw new CommandValidationException(msg);
        }
        this.certAlias = (String)this.getParameter("certAlias");
        if (this.certAlias == null || this.certAlias.length() == 0) {
            msg = this.getMsg(resBundle, "security.admintask.NoCertAliasValue", null);
            throw new CommandValidationException(msg);
        }
        if (this.certAlias != null && this.certAlias.length() != 0) {
            if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                this.origCertAlias = this.certAlias;
            }
            this.certAlias = this.certAlias.toLowerCase();
        }
        this.useEncryptionCert = (Boolean)this.getParameter("useEncryptionCert");
        this.autogenCert = (Boolean)this.getParameter("autogenCert");
        this.importCert = (Boolean)this.getParameter("importCert");
        if (this.useEncryptionCert != null && this.useEncryptionCert.booleanValue() && (this.autogenCert != null && this.autogenCert.booleanValue() || this.importCert != null && this.importCert.booleanValue())) {
            msg = this.getMsg(resBundle, "security.admintask.ReuseCertError", null);
            throw new CommandValidationException(msg);
        }
        if ((this.useEncryptionCert == null || !this.useEncryptionCert.booleanValue()) && this.autogenCert != null && this.importCert != null && this.autogenCert.equals(Boolean.TRUE) && this.importCert.equals(Boolean.TRUE)) {
            msg = this.getMsg(resBundle, "security.admintask.MustSpecifyCertGenMethod", null);
            throw new CommandValidationException(msg);
        }
        this.certKeyFileName = (String)this.getParameter("certKeyFileName");
        if (this.importCert != null && this.importCert.booleanValue() && (this.certKeyFileName == null || this.certKeyFileName.length() == 0)) {
            msg = this.getMsg(resBundle, "security.admintask.NoCertKeyFileNameValue", null);
            throw new CommandValidationException(msg);
        }
        this.certKeyFilePath = (String)this.getParameter("certKeyFilePath");
        if (this.importCert != null && this.importCert.booleanValue() && (this.certKeyFilePath == null || this.certKeyFilePath.length() == 0)) {
            msg = this.getMsg(resBundle, "security.admintask.NoCertKeyFilePathValue", null);
            throw new CommandValidationException(msg);
        }
        this.certKeyFileType = (String)this.getParameter("certKeyFileType");
        if (this.importCert != null && this.importCert.booleanValue() && (this.certKeyFileType == null || this.certKeyFileType.length() == 0)) {
            msg = this.getMsg(resBundle, "security.admintask.NoCertKeyFileTypeValue", null);
            throw new CommandValidationException(msg);
        }
        this.certKeyFilePassword = (String)this.getParameter("certKeyFilePassword");
        if (this.importCert != null && this.importCert.booleanValue() && (this.certKeyFilePassword == null || this.certKeyFilePassword.length() == 0)) {
            msg = this.getMsg(resBundle, "security.admintask.NoCertKeyFilePasswordValue", null);
            throw new CommandValidationException(msg);
        }
        this.certAliasToImport = (String)this.getParameter("certAliasToImport");
        if (this.importCert != null && this.importCert.booleanValue() && (this.certAliasToImport == null || this.certAliasToImport.length() == 0)) {
            msg = this.getMsg(resBundle, "security.admintask.NoCertAliasToImport", null);
            throw new CommandValidationException(msg);
        }
        if (this.certAliasToImport != null && this.certAliasToImport.length() != 0) {
            this.certAliasToImport = this.certAliasToImport.toLowerCase();
        }
        this.signingKeyStoreRef = (String)this.getParameter("signingKeyStoreRef");
        if (this.signingKeyStoreRef == null || this.signingKeyStoreRef.length() == 0) {
            msg = this.getMsg(resBundle, "security.admintask.NoKeyStoreNameValue", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enable: " + this.enable + " certAlias: " + this.certAlias + " useEncryptionCert: " + this.useEncryptionCert + " autogenCert: " + this.autogenCert + " importCert: " + this.importCert + " certKeyFileName: " + this.certKeyFileName + " certKeyFilePath: " + this.certKeyFilePath + " certKeyFileType: " + this.certKeyFileType + " certKeyFilePassword: *** " + " certAliasToImport: " + this.certAliasToImport + " signingKeyStoreRef: " + this.signingKeyStoreRef);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void afterStepsExecuted() {
        String signingKeyStoreName;
        String signingScope;
        ObjectName policyObject;
        String foundKeyStoreRef;
        AttributeList settings;
        Session session;
        ConfigService cs;
        TaskCommandResultImpl result;
        block58: {
            AttributeList al;
            int j;
            ArrayList aList;
            boolean foundCert;
            block59: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "afterStepsExecuted");
                }
                super.afterStepsExecuted();
                result = (TaskCommandResultImpl)this.getTaskCommandResult();
                if (!result.isSuccessful()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "afterStepsExecuted");
                    }
                    return;
                }
                cs = ConfigServiceFactory.getConfigService();
                session = this.getConfigSession();
                ObjectName audit = null;
                ObjectName security2 = null;
                settings = new AttributeList();
                foundKeyStoreRef = null;
                try {
                    CommandResult cmdResult;
                    AdminCommand getUserCmd;
                    CommandMgr commandMgr;
                    block62: {
                        block63: {
                            block64: {
                                block60: {
                                    CommandResult cmdResult2;
                                    block61: {
                                        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
                                        audit = cs.queryConfigObjects(session, null, pattern, null)[0];
                                        if (audit == null) {
                                            String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                                            result.addWarnings(msg);
                                            result.setResult(new Boolean(false));
                                            result.setException(new CommandException(msg));
                                            return;
                                        }
                                        AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
                                        policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
                                        if (policyObject != null && tc.isDebugEnabled()) {
                                            Tr.debug(tc, "policyObj: " + policyObject);
                                        }
                                        ObjectName certObj = (ObjectName)cs.getAttribute(session, policyObject, "encryptionCert");
                                        String alias = null;
                                        ObjectName keystore = null;
                                        String keyName = null;
                                        String keyPath = null;
                                        String keyPassword = null;
                                        String keyType = null;
                                        if (certObj == null) {
                                            Tr.debug(tc, "no encryption keystore");
                                        } else if (this.useEncryptionCert != null && this.useEncryptionCert.booleanValue()) {
                                            alias = (String)cs.getAttribute(session, certObj, "alias");
                                            keystore = (ObjectName)cs.getAttribute(session, certObj, "keyStore");
                                            keyName = (String)cs.getAttribute(session, keystore, "name");
                                            keyPath = (String)cs.getAttribute(session, keystore, "location");
                                            keyPassword = (String)cs.getAttribute(session, keystore, "password");
                                            keyType = (String)cs.getAttribute(session, keystore, "type");
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, " >>> Encryption keyStore name: " + keyName + " keyPath: " + keyPath + " keyType: " + keyType + "certAlias: " + alias);
                                            }
                                        }
                                        settings.add(new Attribute("sign", this.enable));
                                        security2 = cs.resolve(session, "Cell=:Security=")[0];
                                        boolean found = false;
                                        ArrayList keystoreList = (ArrayList)cs.getAttribute(session, security2, "keyStores");
                                        for (int i = 0; i < keystoreList.size(); ++i) {
                                            AttributeList keystoreAttrs = (AttributeList)keystoreList.get(i);
                                            ObjectName keystoreObj = ConfigServiceHelper.createObjectName(keystoreAttrs);
                                            String keystoreName = ConfigServiceHelper.getAttributeValue(keystoreAttrs, "name").toString();
                                            String keystoreRef = ConfigServiceHelper.getConfigDataId(keystoreObj).toString().split("#")[1];
                                            if (!keystoreRef.equals(this.signingKeyStoreRef)) continue;
                                            found = true;
                                            this.keyStoreCreated = keystoreObj;
                                            foundKeyStoreRef = keystoreRef;
                                            break;
                                        }
                                        if (!found) {
                                            String msg = this.getMsg(resBundle, "security.admintask.NoKeyStore", null);
                                            result.addWarnings(msg);
                                            result.setResult(new Boolean(false));
                                            result.setException(new CommandException(msg));
                                            return;
                                        }
                                        ObjectName objectCreated = this.keyStoreCreated;
                                        ObjectName scope = (ObjectName)cs.getAttribute(session, this.keyStoreCreated, "managementScope");
                                        signingScope = (String)cs.getAttribute(session, scope, "scopeName");
                                        signingKeyStoreName = (String)cs.getAttribute(session, this.keyStoreCreated, "name");
                                        AttributeList attrList = new AttributeList();
                                        if (this.useEncryptionCert == null || !this.useEncryptionCert.booleanValue()) break block60;
                                        Boolean encryptionEnabled = (Boolean)cs.getAttribute(session, policyObject, "encrypt");
                                        if (!encryptionEnabled.booleanValue()) {
                                            String msg = this.getMsg(resBundle, "security.admintask.NoEncryptionKeyStore", null);
                                            result.addWarnings(msg);
                                            result.setResult(new Boolean(false));
                                            result.setException(new CommandException(msg));
                                            return;
                                        }
                                        if (keystore == null) {
                                            String msg = this.getMsg(resBundle, "security.admintask.NoEncryptionKeyStore", null);
                                            result.addWarnings(msg);
                                            result.setResult(new Boolean(false));
                                            result.setException(new CommandException(msg));
                                            return;
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Sign keystore ref: " + this.signingKeyStoreRef + " Sign keystore name: " + signingKeyStoreName + " Sign scope: " + signingScope + " Encryption keyStore name: " + keyName + " keyPath: " + keyPath + " keyType: " + keyType);
                                        }
                                        CommandMgr commandMgr2 = CommandMgr.getCommandMgr();
                                        AdminCommand getUserCmd2 = commandMgr2.createCommand("importEncryptionCertificate");
                                        getUserCmd2.setParameter("keyStoreName", signingKeyStoreName);
                                        getUserCmd2.setParameter("keyStoreScope", signingScope);
                                        getUserCmd2.setParameter("keyFilePath", keyPath);
                                        getUserCmd2.setParameter("keyFilePassword", keyPassword);
                                        getUserCmd2.setParameter("keyFileType", keyType);
                                        getUserCmd2.setParameter("certificateAliasFromKeyFile", alias);
                                        getUserCmd2.setParameter("certificateAlias", this.certAlias);
                                        getUserCmd2.setConfigSession(session);
                                        getUserCmd2.execute();
                                        cmdResult2 = getUserCmd2.getCommandResult();
                                        if (!cmdResult2.isSuccessful()) break block61;
                                        if (((Boolean)cmdResult2.getResult()).booleanValue()) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Successfully imported self signed personal certificate for audit signing");
                                            }
                                            break block62;
                                        } else {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Was not successful importing self signed personal certificate for audit signing");
                                            }
                                            String msg = this.getMsg(resBundle, "security.admintask.ImportCertFailure", null);
                                            if (cmdResult2.getException() != null && cmdResult2.getException().getMessage() != null) {
                                                msg = msg.concat(": ");
                                                msg = msg.concat(cmdResult2.getException().getMessage());
                                            }
                                            result.addWarnings(msg);
                                            result.setResult(new Boolean(false));
                                            result.setException(new CommandException(msg));
                                            return;
                                        }
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Was not successful importing self signed personal certificate for audit signing");
                                    }
                                    String msg = this.getMsg(resBundle, "security.admintask.ImportCertFailure", null);
                                    if (cmdResult2.getException() != null && cmdResult2.getException().getMessage() != null) {
                                        msg = msg.concat(": ");
                                        msg = msg.concat(cmdResult2.getException().getMessage());
                                    }
                                    result.addWarnings(msg);
                                    result.setResult(new Boolean(false));
                                    result.setException(new CommandException(msg));
                                    return;
                                }
                                if (this.autogenCert == null || !this.autogenCert.booleanValue()) break block63;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Sign keystore name: " + signingKeyStoreName + " Sign scope: " + signingScope + " certAlias: " + this.certAlias);
                                }
                                commandMgr = CommandMgr.getCommandMgr();
                                getUserCmd = commandMgr.createCommand("createSelfSignedCertificate");
                                getUserCmd.setParameter("keyStoreName", signingKeyStoreName);
                                getUserCmd.setParameter("keyStoreScope", signingScope);
                                getUserCmd.setParameter("certificateAlias", this.certAlias);
                                getUserCmd.setParameter("certificateSize", new Integer(1024));
                                getUserCmd.setParameter("certificateCommonName", InetAddress.getLocalHost().getHostName());
                                getUserCmd.setParameter("certificateOrganization", "IBM");
                                getUserCmd.setConfigSession(session);
                                getUserCmd.execute();
                                cmdResult = getUserCmd.getCommandResult();
                                if (!cmdResult.isSuccessful()) break block64;
                                if (((Boolean)cmdResult.getResult()).booleanValue()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Successfully created self signed personal certificate for audit signing");
                                    }
                                    break block62;
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Was not successful creating self signed personal certificate for audit signing");
                                    }
                                    String msg = this.getMsg(resBundle, "security.admintask.AutogenCertFailure", null);
                                    if (cmdResult.getException() != null && cmdResult.getException().getMessage() != null) {
                                        msg = msg.concat(": ");
                                        msg = msg.concat(cmdResult.getException().getMessage());
                                    }
                                    result.addWarnings(msg);
                                    result.setResult(new Boolean(false));
                                    result.setException(new CommandException(msg));
                                    return;
                                }
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Was not successful creating self signed personal certificate for audit signing");
                            }
                            String msg = this.getMsg(resBundle, "security.admintask.AutogenCertFailure", null);
                            if (cmdResult.getException() != null && cmdResult.getException().getMessage() != null) {
                                msg = msg.concat(": ");
                                msg = msg.concat(cmdResult.getException().getMessage());
                            }
                            result.addWarnings(msg);
                            result.setResult(new Boolean(false));
                            result.setException(new CommandException(msg));
                            return;
                        }
                        if (this.importCert != null && this.importCert.booleanValue()) {
                            commandMgr = CommandMgr.getCommandMgr();
                            getUserCmd = commandMgr.createCommand("importCertificate");
                            getUserCmd.setParameter("keyStoreName", signingKeyStoreName);
                            getUserCmd.setParameter("keyStoreScope", signingScope);
                            getUserCmd.setParameter("keyFilePath", this.certKeyFilePath);
                            getUserCmd.setParameter("keyFilePassword", this.certKeyFilePassword);
                            getUserCmd.setParameter("keyFileType", this.certKeyFileType);
                            getUserCmd.setParameter("certificateAliasFromKeyFile", this.certAliasToImport);
                            getUserCmd.setParameter("certificateAlias", this.certAlias);
                            getUserCmd.setConfigSession(session);
                            getUserCmd.execute();
                            cmdResult = getUserCmd.getCommandResult();
                            if (cmdResult.isSuccessful()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Successfully imported self signed personal certificate for audit signing");
                                }
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Was not successful importing self signed personal certificate for audit signing");
                                }
                                String msg = this.getMsg(resBundle, "security.admintask.ImportCertFailure", null);
                                if (cmdResult.getException() != null && cmdResult.getException().getMessage() != null) {
                                    msg = msg.concat(": ");
                                    msg = msg.concat(cmdResult.getException().getMessage());
                                }
                                result.addWarnings(msg);
                                result.setResult(new Boolean(false));
                                result.setException(new CommandException(msg));
                                return;
                            }
                        }
                    }
                    if (this.autogenCert == null || this.autogenCert.booleanValue() || this.importCert == null || this.importCert.booleanValue() || this.useEncryptionCert == null || this.useEncryptionCert.booleanValue() || this.certAlias == null || this.certAlias.length() == 0) break block58;
                    commandMgr = CommandMgr.getCommandMgr();
                    getUserCmd = commandMgr.createCommand("listPersonalCertificates");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "keyStoreName: " + signingKeyStoreName);
                    }
                    getUserCmd.setParameter("keyStoreName", signingKeyStoreName);
                    getUserCmd.setParameter("keyStoreScope", this.scopeName);
                    getUserCmd.setConfigSession(session);
                    getUserCmd.execute();
                    cmdResult = getUserCmd.getCommandResult();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cmdResult.isSuccessful: " + cmdResult.isSuccessful());
                        Tr.debug(tc, "cmdResult.getResult: " + cmdResult.getResult().toString());
                    }
                    if (cmdResult.isSuccessful()) {
                        foundCert = false;
                        aList = (ArrayList)cmdResult.getResult();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "list size: " + aList.size());
                        }
                        break block59;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Was unsuccessful listing the certificate aliases in the referenced keystore");
                    }
                    String msg = this.getMsg(resBundle, "security.admintask.ListCertFailure", null);
                    if (cmdResult.getException() != null && cmdResult.getException().getMessage() != null) {
                        msg = msg.concat(": ");
                        msg = msg.concat(cmdResult.getException().getMessage());
                    }
                    result.addWarnings(msg);
                    result.setResult(new Boolean(false));
                    result.setException(new CommandException(msg));
                    return;
                }
                catch (ConfigServiceException e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.signing.CreateAuditSigningConfig.afterStepsExecuted", "154");
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Error getting configuration: ", e.getMessage());
                    }
                    String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
                    if (e.getMessage() != null) {
                        msg = msg.concat(": ");
                        msg = msg.concat(e.getMessage());
                    }
                    e.printStackTrace();
                    result.addWarnings(msg);
                    result.setResult(new Boolean(false));
                    result.setException(new CommandException(msg));
                    return;
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.signing.CreateAuditSigningConfig.afterStepsExecuted", "154");
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Error getting configuration: ", e.getMessage());
                    }
                    String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
                    if (e.getMessage() != null) {
                        msg = msg.concat(": ");
                        msg = msg.concat(e.getMessage());
                    }
                    e.printStackTrace();
                    result.addWarnings(msg);
                    result.setResult(new Boolean(false));
                    result.setException(new CommandException(msg));
                    return;
                }
            }
            for (j = 0; j < aList.size(); ++j) {
                al = (AttributeList)aList.get(j);
                for (Attribute a : al) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attribute: " + a.toString());
                    }
                    if (!a.getName().equals("alias") || !a.getValue().equals(this.certAlias)) continue;
                    foundCert = true;
                    break;
                }
                if (foundCert) break;
            }
            if (!foundCert) {
                if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    for (j = 0; j < aList.size(); ++j) {
                        al = (AttributeList)aList.get(j);
                        for (Attribute a : al) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "z check,attribute: " + a.toString());
                            }
                            if (!a.getName().equals("alias") || !a.getValue().equals(this.origCertAlias)) continue;
                            foundCert = true;
                            break;
                        }
                        if (foundCert) break;
                    }
                }
                if (!foundCert) {
                    String msg = this.getMsg(resBundle, "security.admintask.CertNotInKeyStore", null);
                    result.addWarnings(msg);
                    result.setResult(new Boolean(false));
                    result.setException(new CommandException(msg));
                    return;
                }
            }
        }
        settings.add(new Attribute("securityXmlSignerKeyStoreName", signingKeyStoreName));
        settings.add(new Attribute("securityXmlSignerCertAlias", this.certAlias));
        settings.add(new Attribute("securityXmlSignerScopeName", signingScope));
        cs.setAttributes(session, policyObject, settings);
        result.setResult(foundKeyStoreRef);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private String fixLocation(String repositoryRoot, String location) {
        location = location.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixLocation", new Object[]{repositoryRoot, location});
        }
        int index = location.indexOf("/cells/");
        String newPath = location;
        if (index != -1) {
            String lastPart = location.substring(index);
            newPath = repositoryRoot + lastPart;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixLocation -> " + newPath);
        }
        return newPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate getCertFromArmFile(String type) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertFromArmFile");
        }
        String fileName = null;
        String filePath = null;
        X509Certificate cert = null;
        if (type.equals("server")) {
            fileName = "serverCert.arm";
        } else if (type.equals("client")) {
            fileName = "clientCert.arm";
        } else {
            return null;
        }
        FileInputStream fis = null;
        String profilePath = System.getProperty("user.install.root");
        filePath = profilePath + "/etc/" + fileName;
        try {
            CertificateFactory certificatefactory = null;
            Collection<? extends Certificate> collection = null;
            fis = new FileInputStream(filePath);
            certificatefactory = CertificateFactory.getInstance("X509");
            collection = certificatefactory.generateCertificates(fis);
            X509Certificate[] certFromReqFile = new X509Certificate[collection.size()];
            Iterator<? extends Certificate> iterator = collection.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                certFromReqFile[i] = (X509Certificate)iterator.next();
                ++i;
            }
            cert = certFromReqFile[0];
        }
        catch (FileNotFoundException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, filePath + " does not exist.  Certificate will no be used.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCertFromArmFile");
            }
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception recieve while trying to get certificate from arm file: " + e.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCertFromArmFile");
            }
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertFromArmFile");
        }
        return cert;
    }
}

