/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.policy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.rolebasedauthz.AuthorizationTableExt;
import com.ibm.websphere.models.config.rolebasedauthz.RoleAssignmentExt;
import com.ibm.websphere.models.config.rolebasedauthz.SecurityRoleExt;
import com.ibm.websphere.models.config.rolebasedauthz.impl.RolebasedauthzFactoryImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.role.PluggableAuthorizationTableProxy;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class SetAuditorId
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(SetAuditorId.class, "AUDIT", "com.ibm.ws.security.admintask.audit.policy");
    String auditorId = null;

    public SetAuditorId(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public SetAuditorId(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    private AuthorizationTableExt getAuthTable(Session session, String subStr, WorkSpace ws) throws WorkSpaceException, Exception {
        String resourceName = "";
        resourceName = "audit-authz.xml";
        AuthorizationTableExt atx = null;
        RepositoryContext cellContext = AppUtils.findContext("cells", subStr, null, null, ws, true);
        cellContext.extract(resourceName, false);
        Resource resource = cellContext.getResourceSet().createResource(URI.createURI(resourceName));
        resource.load(new HashMap());
        EList ext = resource.getContents();
        Iterator itr = ext.iterator();
        while (itr.hasNext() && !(atx = (AuthorizationTableExt)itr.next()).getContext().equals("domain")) {
        }
        return atx;
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.auditorId = (String)this.getParameter("name");
        if (this.auditorId == null || this.auditorId.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidAuditorId", null);
            throw new CommandValidationException(msg);
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        String subStr = null;
        WorkSpace ws = null;
        String cellNameQualifier = "_Websphere_Config_Data_Display_Name";
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            ObjectName cellName = cs.resolve(session, "Cell=")[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell = " + cellName.toString());
            }
            int index1 = cellName.toString().indexOf("_Websphere_Config_Data_Display_Name");
            subStr = cellName.toString().substring(index1);
            int index2 = subStr.indexOf(",");
            subStr = subStr.substring(0, index2);
            int index3 = subStr.indexOf("=");
            subStr = subStr.substring(index3 + 1);
            ws = WorkspaceHelper.getWorkspace((Session)session);
        }
        catch (Throwable th) {
            String msg = this.getMsg(resBundle, "security.admintask.FailAccesstoSecWS", null);
            throw new CommandValidationException(msg);
        }
        PluggableAuthorizationTableProxy patp = PluggableAuthorizationTableProxy.getAuthorizationTableProxy();
        if (patp != null && patp.isSAFAuthorizationEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "z with SAF enabled");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAF NOT enabled");
            }
            try {
                RolebasedauthzFactoryImpl authFactory = new RolebasedauthzFactoryImpl();
                boolean found_in_audit_authz = false;
                AuthorizationTableExt authTable = this.getAuthTable(session, subStr, ws);
                if (authTable != null) {
                    EList authorizations = authTable.getAuthorizations();
                    for (RoleAssignmentExt roleAssignment : authorizations) {
                        SecurityRoleExt role;
                        if (roleAssignment == null || !(role = roleAssignment.getRole()).getRoleName().equals("auditor")) continue;
                        EList userList = roleAssignment.getUsers();
                        for (Object user : userList) {
                            Tr.debug(tc, "user.getName: " + user.getName());
                            if (!user.getName().equals(this.auditorId)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "found user " + this.auditorId + " in audit-authz.xml");
                            }
                            found_in_audit_authz = true;
                        }
                    }
                    if (!found_in_audit_authz) {
                        CommandMgr commandMgr = CommandMgr.getCommandMgr();
                        AdminCommand getUserCmd = commandMgr.createCommand("mapAuditGroupIDsOfAuthorizationGroup");
                        getUserCmd.setConfigSession(session);
                        getUserCmd.execute();
                        CommandResult cmdResult = getUserCmd.getCommandResult();
                        ArrayList returnedUsers = new ArrayList();
                        if (cmdResult.isSuccessful() && cmdResult.getResult() != null) {
                            returnedUsers = (ArrayList)cmdResult.getResult();
                        }
                        if (!returnedUsers.isEmpty()) {
                            for (Object user : returnedUsers) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "found authz: " + (String)user + ", comparing to: " + this.auditorId);
                                }
                                if (!((String)user).equalsIgnoreCase(this.auditorId)) continue;
                                found_in_audit_authz = true;
                                break;
                            }
                        }
                        if (!found_in_audit_authz) {
                            String msg = this.getMsg(resBundle, "security.audit.auditorId.change.error", null);
                            throw new CommandValidationException(msg);
                        }
                    }
                }
            }
            catch (WorkSpaceException e) {
                e.printStackTrace();
                String msg = this.getMsg(resBundle, "security.audit.auditorId.change.ws.error", null);
                throw new CommandValidationException(msg);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                throw new CommandValidationException(msg);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            ObjectName policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            AttributeList settings = new AttributeList();
            settings.add(new Attribute("auditorId", this.auditorId));
            cs.setAttributes(session, policyObject, settings);
            result.setResult(new Boolean(true));
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.policy.SetAuditorId.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.policy.SetAuditorId.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

