/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.policy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.rolebasedauthz.AuthorizationTableExt;
import com.ibm.websphere.models.config.rolebasedauthz.RoleAssignmentExt;
import com.ibm.websphere.models.config.rolebasedauthz.SecurityRoleExt;
import com.ibm.websphere.models.config.rolebasedauthz.UserExt;
import com.ibm.websphere.models.config.rolebasedauthz.impl.RolebasedauthzFactoryImpl;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.UserRegistry;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.security.audit.AuditServiceImpl;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.role.PluggableAuthorizationTableProxy;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.ContextHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ModifyAuditPolicy
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ModifyAuditPolicy.class, "AUDIT", "com.ibm.ws.security.admintask.audit.policy");
    private Boolean auditEnabled = new Boolean(false);
    private String auditPolicy = null;
    private String auditorId = null;
    private String auditorPwd = null;
    private Boolean sign = new Boolean(false);
    private Boolean encrypt = new Boolean(false);
    private Boolean batching = new Boolean(false);
    private Boolean verbose = new Boolean(false);
    private String keystoreRef = null;
    private String encryptionCertRef = null;
    private boolean retrievedEnabledSetting = false;
    private boolean retrievedEncryptSetting = false;
    private boolean found = false;
    private static AuditService auditService = null;
    private ConcurrentHashMap auditOutcome = new ConcurrentHashMap();

    public ModifyAuditPolicy(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ModifyAuditPolicy(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    private AuthorizationTableExt getAuthTable(Session session, String subStr, WorkSpace ws) throws WorkSpaceException, Exception {
        String resourceName = "";
        resourceName = "audit-authz.xml";
        AuthorizationTableExt atx = null;
        RepositoryContext cellContext = AppUtils.findContext("cells", subStr, null, null, ws, true);
        cellContext.extract(resourceName, false);
        Resource resource = cellContext.getResourceSet().createResource(URI.createURI(resourceName));
        resource.load(new HashMap());
        EList ext = resource.getContents();
        Iterator itr = ext.iterator();
        while (itr.hasNext() && !(atx = (AuthorizationTableExt)itr.next()).getContext().equals("domain")) {
        }
        return atx;
    }

    public boolean validAction(String action) {
        return action.equals("WARN") || action.equals("NOWARN") || action.equals("FATAL");
    }

    public void validate() throws CommandValidationException {
        String msg;
        ObjectName pattern;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        String subStr = null;
        WorkSpace ws = null;
        String cellNameQualifier = "_Websphere_Config_Data_Display_Name";
        try {
            pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg2 = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                throw new CommandValidationException(msg2);
            }
            AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            ObjectName policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            Boolean enabledSetting = (Boolean)cs.getAttribute(session, policyObject, "auditEnabled");
            this.retrievedEnabledSetting = enabledSetting;
            Boolean encryptSetting = (Boolean)cs.getAttribute(session, policyObject, "encrypt");
            this.retrievedEncryptSetting = encryptSetting;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retrieved enabled setting: " + this.retrievedEnabledSetting);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retrieved encrypt setting: " + this.retrievedEncryptSetting);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.policy.ModifyAuditPolicy.validation", "%");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg3 = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg3 = msg3.concat(": ");
                msg3 = msg3.concat(e.getMessage());
            }
            throw new CommandValidationException(msg3);
        }
        this.auditEnabled = (Boolean)this.getParameter("auditEnabled");
        if (this.auditEnabled == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "auditEnabled == null");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEnabled != null: " + this.auditEnabled);
        }
        this.auditPolicy = (String)this.getParameter("auditPolicy");
        if (this.auditPolicy != null && this.auditPolicy.length() > 0 && !this.validAction(this.auditPolicy)) {
            msg = this.getMsg(resBundle, "security.admintask.InvalidActionType", null);
            throw new CommandValidationException(msg);
        }
        this.auditorId = (String)this.getParameter("auditorId");
        if ((this.auditEnabled != null && this.auditEnabled.booleanValue() || this.auditEnabled == null && this.retrievedEnabledSetting) && this.auditorId != null && this.auditorId.length() == 0) {
            msg = this.getMsg(resBundle, "security.admintask.CannotRemoveAuditorId", null);
            throw new CommandValidationException(msg);
        }
        try {
            pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            ObjectName cellName = cs.resolve(session, "Cell=")[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell = " + cellName.toString());
            }
            int index1 = cellName.toString().indexOf("_Websphere_Config_Data_Display_Name");
            subStr = cellName.toString().substring(index1);
            int index2 = subStr.indexOf(",");
            subStr = subStr.substring(0, index2);
            int index3 = subStr.indexOf("=");
            subStr = subStr.substring(index3 + 1);
            ws = WorkspaceHelper.getWorkspace((Session)session);
        }
        catch (Throwable th) {
            String msg4 = this.getMsg(resBundle, "security.admintask.FailAccesstoSecWS", null);
            throw new CommandValidationException(msg4);
        }
        if (tc.isDebugEnabled() && this.auditorId != null) {
            Tr.debug(tc, "auditorId: " + this.auditorId + " auditorId.length() = " + this.auditorId.length() + " auditEnabled: " + this.auditEnabled);
        }
        if ((this.auditorId == null || this.auditorId.length() != 0 || this.auditEnabled.booleanValue()) && this.auditorId != null) {
            PluggableAuthorizationTableProxy patp = PluggableAuthorizationTableProxy.getAuthorizationTableProxy();
            if (patp != null && patp.isSAFAuthorizationEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "z with SAF enabled");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SAF NOT enabled");
                }
                RolebasedauthzFactoryImpl authFactory = new RolebasedauthzFactoryImpl();
                boolean found_in_audit_authz = false;
                try {
                    AuthorizationTableExt authTable = this.getAuthTable(session, subStr, ws);
                    if (authTable != null) {
                        EList authorizations = authTable.getAuthorizations();
                        for (RoleAssignmentExt roleAssignment : authorizations) {
                            SecurityRoleExt role;
                            if (roleAssignment == null || !(role = roleAssignment.getRole()).getRoleName().equals("auditor")) continue;
                            EList userList = roleAssignment.getUsers();
                            for (UserExt user : userList) {
                                if (!user.getName().equals(this.auditorId)) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "found user " + this.auditorId + " in audit-authz.xml");
                                }
                                found_in_audit_authz = true;
                            }
                        }
                        if (!found_in_audit_authz) {
                            boolean id_is_primaryAdminID = false;
                            HashMap returnedSpecialSubjects = new HashMap();
                            String primaryAdminId = null;
                            CommandMgr commandMgr = CommandMgr.getCommandMgr();
                            AdminCommand getUserCmd = commandMgr.createCommand("listAuditGroupIDsOfAuthorizationGroup");
                            getUserCmd.setConfigSession(session);
                            getUserCmd.execute();
                            CommandResult cmdResult = getUserCmd.getCommandResult();
                            if (cmdResult.isSuccessful() && cmdResult.getResult() != null) {
                                returnedSpecialSubjects = (HashMap)cmdResult.getResult();
                            }
                            if (!returnedSpecialSubjects.isEmpty()) {
                                for (ArrayList al : returnedSpecialSubjects.values()) {
                                    for (String subject : al) {
                                        if (!subject.equals("PRIMARYADMINID")) continue;
                                        ObjectName security2 = null;
                                        try {
                                            ObjectName pattern2 = ConfigServiceHelper.createObjectName(null, "Security");
                                            ObjectName cellName = cs.resolve(session, "Cell=")[0];
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "cell = " + cellName.toString());
                                            }
                                            if (cellName != null) {
                                                security2 = cs.queryConfigObjects(session, cellName, pattern2, null)[0];
                                            }
                                            int index1 = cellName.toString().indexOf("_Websphere_Config_Data_Display_Name");
                                            String subStr1 = cellName.toString().substring(index1);
                                            int index2 = subStr1.indexOf(",");
                                            subStr1 = subStr1.substring(0, index2);
                                            int index3 = subStr1.indexOf("=");
                                            subStr1 = subStr1.substring(index3 + 1);
                                            RepositoryContext cellC = AppUtils.findContext("cells", subStr1, null, null, ws, true);
                                            URI uri = URI.createURI("security.xml");
                                            Resource res = cellC.getResourceSet().getResource(uri, true);
                                            Security contents = (Security)res.getContents().get(0);
                                            UserRegistry activeUserRegistry = contents.getActiveUserRegistry();
                                            ObjectName activeUserRegistryObj = (ObjectName)cs.getAttribute(session, security2, "activeUserRegistry");
                                            if (activeUserRegistry == null) continue;
                                            primaryAdminId = new String(activeUserRegistry.getPrimaryAdminId());
                                        }
                                        catch (Throwable th) {
                                            result.setException(new CommandException(th.getMessage()));
                                        }
                                    }
                                }
                            }
                            if (primaryAdminId != null && primaryAdminId.equals(this.auditorId)) {
                                id_is_primaryAdminID = true;
                            }
                            if (!id_is_primaryAdminID) {
                                String msg5 = this.getMsg(resBundle, "security.audit.auditorId.change.error", null);
                                throw new CommandValidationException(msg5);
                            }
                        }
                    }
                }
                catch (WorkSpaceException e) {
                    e.printStackTrace();
                    String msg6 = this.getMsg(resBundle, "security.audit.auditorId.change.ws.error", null);
                    throw new CommandValidationException(msg6);
                }
                catch (Exception e) {
                    String msg7 = e.getMessage();
                    throw new CommandValidationException(msg7);
                }
            }
        }
        this.auditorPwd = (String)this.getParameter("auditorPwd");
        if ((this.auditEnabled != null && this.auditEnabled.booleanValue() || this.auditEnabled == null && this.retrievedEnabledSetting) && this.auditorPwd != null && this.auditorPwd.length() == 0) {
            msg = this.getMsg(resBundle, "security.admintask.CannotRemoveAuditorPwd", null);
            throw new CommandValidationException(msg);
        }
        this.sign = (Boolean)this.getParameter("sign");
        this.encrypt = (Boolean)this.getParameter("encrypt");
        this.verbose = (Boolean)this.getParameter("verbose");
        this.encryptionCertRef = (String)this.getParameter("encryptionCert");
        if (tc.isDebugEnabled()) {
            if (this.auditEnabled != null) {
                Tr.debug(tc, "auditEnabled: " + this.auditEnabled.toString());
            }
            if (this.auditPolicy != null && this.auditPolicy.length() != 0) {
                Tr.debug(tc, "auditPolicy: " + this.auditPolicy);
            }
            if (this.auditorId != null && this.auditorId.length() != 0) {
                Tr.debug(tc, "auditorId: " + this.auditorId);
            }
            if (this.auditorPwd != null && this.auditorPwd.length() != 0) {
                Tr.debug(tc, "auditorPwd: ******");
            }
            if (this.sign != null) {
                Tr.debug(tc, "sign: " + this.sign.toString());
            }
            if (this.encrypt != null) {
                Tr.debug(tc, "encrypt: " + this.encrypt.toString());
            }
            if (this.verbose != null) {
                Tr.debug(tc, "verbose: " + this.verbose.toString());
            }
            if (this.encryptionCertRef != null) {
                Tr.debug(tc, "encryptionCertRef: " + this.encryptionCertRef);
            }
        }
        if (this.auditEnabled == null && this.auditPolicy == null && this.auditorId == null && this.auditorPwd == null && this.sign == null && this.encrypt == null && this.verbose == null && this.encryptionCertRef == null) {
            msg = this.getMsg(resBundle, "security.admintask.MissingModifyParms", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        SecurityConfig security2 = null;
        try {
            String msg;
            AttributeList notificationArray;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg2 = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg2);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg2));
                return;
            }
            AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "policyAttrs: " + policyAttrs.toString());
            }
            ObjectName policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            AttributeList settings = new AttributeList();
            if (this.auditEnabled != null) {
                ContextHandler contextHandler = null;
                if (auditService == null) {
                    auditService = ContextManagerFactory.getInstance().getAuditService();
                }
                if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
                    String msg3 = "security.audit.service.context.error";
                    auditService.processAuditFailure(msg3, null);
                    result.addWarnings(msg3);
                    result.setResult(new Boolean(false));
                    result.setException(new CommandException(msg3));
                    return;
                }
                if (auditService != null && auditService.isEventRequired("SECURITY_MGMT_AUDIT", "SUCCESS")) {
                    if (contextHandler != null) {
                        security2 = SecurityObjectLocator.getSecurityConfig();
                        String activeUserRegistry = security2.getActiveUserRegistry().getType();
                        HashMap data = DataHelper.buildSessionData(null, null, null, null);
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = this.auditEnabled != false ? DataHelper.buildAccessData("WASServer", "enable", null, null, "authzSuccess", "AuditSubSystem", "process", new Long(0L), null, null, null, null) : DataHelper.buildAccessData("WASServer", "disable", null, null, "authzSuccess", "AuditSubSystem", "process", new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData(auditService.getLastTrailId(), auditService.getEventTrailIds(), new Date(), new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = this.auditEnabled != false ? DataHelper.buildMgmtData("subSystem", "enable", null) : DataHelper.buildMgmtData("subSystem", "disable", null);
                        this.auditOutcome = this.auditEnabled != false ? DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 84L) : DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 88L);
                    }
                    try {
                        auditService.sendEvent("SECURITY_MGMT_AUDIT", this.auditOutcome);
                    }
                    catch (ProviderFailureException e) {
                        Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                        String msg4 = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(msg4, e);
                    }
                }
                settings.add(new Attribute("auditEnabled", this.auditEnabled));
            }
            if ((notificationArray = (AttributeList)cs.getAttribute(session, audit, "auditNotificationMonitor")) == null && this.auditPolicy != null && (this.auditPolicy.equals("WARN") || this.auditPolicy.equals("FATAL"))) {
                msg = this.getMsg(resBundle, "security.admintask.NotificationMonitorNotConfigured", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            if (this.auditPolicy != null) {
                settings.add(new Attribute("auditPolicy", this.auditPolicy));
            }
            if (this.auditorId != null) {
                settings.add(new Attribute("auditorId", this.auditorId));
            }
            if (this.auditorPwd != null) {
                settings.add(new Attribute("auditorPwd", this.auditorPwd));
            }
            if (this.sign != null) {
                settings.add(new Attribute("sign", this.sign));
            }
            if (this.encrypt != null) {
                settings.add(new Attribute("encrypt", this.encrypt));
            }
            if (this.verbose != null) {
                settings.add(new Attribute("verbose", this.verbose));
            }
            if (this.encryptionCertRef != null && this.encryptionCertRef.length() == 0) {
                if (this.encrypt != null && this.encrypt.booleanValue() || this.encrypt == null && this.retrievedEncryptSetting) {
                    msg = this.getMsg(resBundle, "security.admintask.CannotDeleteEncryptionCert", null);
                    result.addWarnings(msg);
                    result.setResult(new Boolean(false));
                    result.setException(new CommandException(msg));
                    return;
                }
                this.found = true;
                settings.add(new Attribute("encryptionCert", null));
            }
            if (this.encryptionCertRef != null && this.encryptionCertRef.length() != 0) {
                ArrayList certArray = (ArrayList)cs.getAttribute(session, audit, "certificates");
                for (int i = 0; i < certArray.size(); ++i) {
                    AttributeList certAttrs = (AttributeList)certArray.get(i);
                    for (Attribute o : certAttrs) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "certAttrs name: " + o.getName());
                        }
                        if (o.getValue() != null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "certAttrs value: " + o.getValue().toString());
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "certAttrs value: null");
                    }
                    String cert = ConfigServiceHelper.getAttributeValue(certAttrs, "_Websphere_Config_Data_Id").toString();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cert = " + cert);
                    }
                    if (!(cert = cert.split("#")[1]).equals(this.encryptionCertRef)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "found matching encryption cert");
                    }
                    this.found = true;
                    ObjectName c = ConfigServiceHelper.createObjectName(certAttrs);
                    if (c != null && tc.isDebugEnabled()) {
                        Tr.debug(tc, "cert: " + c.toString());
                    }
                    settings.add(new Attribute("encryptionCert", c));
                    break;
                }
            }
            if (!this.found && this.encryptionCertRef != null) {
                msg = this.getMsg(resBundle, "security.admintask.InvalidCertRef", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            if (settings != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "settings: " + settings.toString());
                }
            } else {
                msg = this.getMsg(resBundle, "security.admintask.CreateObjFailure", null);
                msg = msg.concat(": AuditServiceProvider");
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            cs.setAttributes(session, policyObject, settings);
            result.setResult(new Boolean(true));
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.policy.ModifyAuditPolicy.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.policy.ModifyAuditPolicy.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

