/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.notification;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListAuditNotificationMonitors
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ListAuditNotificationMonitors.class, "AUDIT", "com.ibm.ws.security.admintask.audit.notification");
    private String notificationRef = null;

    public ListAuditNotificationMonitors(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListAuditNotificationMonitors(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        ArrayList<AttributeList> referenceList = new ArrayList<AttributeList>();
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList notificationArray = (AttributeList)cs.getAttribute(session, audit, "auditNotificationMonitor");
            Attribute monitorRef = null;
            Attribute notRefAttr = null;
            if (notificationArray != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Number of notification monitor attributes: " + notificationArray.size());
                }
                for (int j = 0; j < notificationArray.size(); ++j) {
                    Attribute a = (Attribute)notificationArray.get(j);
                    if (a.getName().equals("_Websphere_Config_Data_Id")) {
                        String al = a.getValue().toString();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "AL: " + al);
                        }
                        String s = al.split("#")[1];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "s: " + s);
                        }
                        monitorRef = new Attribute("monitorRef", s);
                    }
                    if (!a.getName().equals("wsNotification")) continue;
                    String longRef = a.getValue().toString();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "longRef: " + longRef);
                    }
                    int index1 = longRef.indexOf("#");
                    String s = longRef.substring(index1 + 1, longRef.length());
                    int index2 = s.indexOf(",");
                    String notRef = s.substring(0, index2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "notRef: " + notRef);
                    }
                    notRefAttr = new Attribute("notificationRef", notRef);
                }
                notificationArray.add(monitorRef);
                notificationArray.add(notRefAttr);
                referenceList.add(notificationArray);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "referenceList: " + referenceList.toString());
            }
            result.setResult(referenceList);
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.ListAuditNotificationMonitors.afterStepsExecuted", "147");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            e.printStackTrace();
            result.addWarnings(msg);
            result.setResult(referenceList);
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.ListAuditNotificationMonitors.afterStepsExecuted", "147");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            e.printStackTrace();
            result.addWarnings(msg);
            result.setResult(referenceList);
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

