/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.security.admintask.audit.certificates.PersonalCertificateHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteAuditKeyStore
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteAuditKeyStore.class, "Audit", "com.ibm.ws.security.admintask.audit.keyStores");
    private String keyStoreName = null;
    private String scopeName = null;
    private Boolean removeKeyStoreFile = null;
    KeyStoreInfo ksInfo = null;
    private ObjectName keyStoreObjName = null;

    public DeleteAuditKeyStore(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public DeleteAuditKeyStore(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName pattern = null;
        ObjectName matches = null;
        ObjectName audit = null;
        boolean keyStoreFound = false;
        try {
            pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.removeKeyStoreFile = (Boolean)this.getParameter(CommandConstants.REMOVE_KEY_STORE_FILE);
            matches = cs.resolve(session, "Cell=")[0];
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
                Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyStoreName);
            boolean keyStoreNameFound = commandHelper.exists(cs, session, audit, CommandConstants.KEY_STORES, queryAttrs, this.scopeName);
            if (!keyStoreNameFound) {
                String msg = this.keyStoreName + "object name not found.";
                throw new CommandValidationException(msg);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreNameFound");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "passing in object: " + audit.toString());
            }
            this.keyStoreObjName = commandHelper.getObjectName(cs, session, audit, CommandConstants.KEY_STORES, queryAttrs, this.scopeName);
            if (tc.isDebugEnabled() && this.keyStoreObjName != null) {
                Tr.debug(tc, "keyStoreObjName: " + this.keyStoreObjName.toString());
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.scopeName);
        }
        catch (ConfigServiceException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception is" + e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is" + e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName audit = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (this.deleteKeyStore(session, cs, this.keyStoreObjName)) {
                String msg = "KeyStore successfully deleted.";
                result.setResult(msg);
            }
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private boolean deleteKeyStore(Session session, ConfigService cs, ObjectName ks) throws Exception {
        boolean keyStoreDeleted = false;
        String keyFileName = null;
        String workSpaceKeyFileName = null;
        Boolean readOnly = null;
        Boolean stash = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteKeyStore");
        }
        keyFileName = (String)cs.getAttribute(session, ks, "location");
        keyFileName = KeyStoreManager.getInstance().expand(keyFileName);
        workSpaceKeyFileName = this.ksInfo.getLocation();
        workSpaceKeyFileName = KeyStoreManager.getInstance().expand(workSpaceKeyFileName);
        readOnly = (Boolean)cs.getAttribute(session, ks, "readOnly");
        stash = (Boolean)cs.getAttribute(session, ks, "createStashFileForCMS");
        try {
            cs.deleteConfigData(session, ks);
        }
        catch (Exception e) {
            throw new ConfigServiceException(e.getMessage());
        }
        if (stash.booleanValue()) {
            File file;
            String workSpaceStashFileName = null;
            int index = workSpaceKeyFileName.lastIndexOf(".");
            workSpaceStashFileName = index != -1 ? workSpaceKeyFileName.substring(0, index + 1) + "sth" : workSpaceKeyFileName + ".sth";
            if (workSpaceStashFileName != null && (file = new File(workSpaceStashFileName)).isFile() && file.canWrite() && this.removeKeyStoreFile.booleanValue()) {
                DeleteAuditKeyStore.setWorkspaceUpdated(session, workSpaceStashFileName);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeKeyStoreFile: " + this.removeKeyStoreFile);
        }
        if (!readOnly.booleanValue() && this.removeKeyStoreFile.booleanValue()) {
            try {
                File keyFile = new File(keyFileName);
                if (keyFile.isFile() && keyFile.canWrite()) {
                    keyFile.delete();
                }
                keyStoreDeleted = true;
                if (stash.booleanValue()) {
                    File file;
                    String stashFileName = null;
                    int index = keyFileName.lastIndexOf(".");
                    stashFileName = index != -1 ? keyFileName.substring(0, index + 1) + "sth" : keyFileName + ".sth";
                    if (stashFileName != null && (file = new File(stashFileName)).isFile() && file.canWrite()) {
                        file.delete();
                    }
                }
                DeleteAuditKeyStore.setWorkspaceUpdated(session, workSpaceKeyFileName);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception recieved is " + e.getMessage());
                }
                throw new Exception(e);
            }
        } else {
            keyStoreDeleted = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteKeyStore");
        }
        return keyStoreDeleted;
    }

    public static void setWorkspaceUpdated(Session session, String fileLocation) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setWorkspaceUpdated");
            }
            fileLocation = fileLocation.replace("\\", "/");
            try {
                String expandLocation = KeyStoreManager.getInstance().expand(fileLocation);
                WorkSpace ws = WorkSpaceManagerFactory.getManager().getWorkSpace(session.toString());
                String cell = "cells/" + ManagementScopeManager.getInstance().getCellName();
                int index = expandLocation.indexOf(cell);
                if (index != -1) {
                    expandLocation = expandLocation.substring(index + cell.length() + 1);
                    RepositoryContext cellC = ws.findContext(cell);
                    cellC.notifyChanged(2, expandLocation);
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception while setting a workspace file to delete " + e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setWorkspaceUpdated");
        }
    }
}

