/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.eventfactory;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateAuditEventFactory
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(CreateAuditEventFactory.class, "AUDIT", "com.ibm.ws.security.admintask.audit.eventfactory");
    String uniqueName = null;
    String className = null;
    String customProperties = null;
    String[] customPropName = new String[10];
    String[] customPropValue = new String[10];
    String auditFilters = null;
    String provider = null;

    public CreateAuditEventFactory(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateAuditEventFactory(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void addCustomProperties(Session session, ConfigService cs, ObjectName targetObj, String propString) throws Exception {
        if (!CreateAuditEventFactory.isCustomPropStringGood(propString)) {
            String msg = this.getMsg(resBundle, "security.admintask.badCustomProp.SECJ7773E", new Object[]{propString});
            throw new CommandValidationException(msg);
        }
        CreateAuditEventFactory.addCustomValues(session, cs, targetObj, propString, "properties");
    }

    public static void addCustomValues(Session session, ConfigService cs, ObjectName targetObj, String propString, String customEntName) throws Exception {
        if (propString != null && propString.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(propString, "\"");
            while (tokenizer.hasMoreTokens()) {
                List props = null;
                AttributeList attributeList = cs.getAttributes(session, targetObj, new String[]{customEntName}, false);
                if (attributeList != null) {
                    props = (List)((Attribute)attributeList.get(0)).getValue();
                }
                AttributeList attrList = new AttributeList();
                String entry = tokenizer.nextToken();
                if (entry != null && entry.equals(",")) continue;
                ObjectName property = null;
                int index = entry.indexOf("=");
                if (index <= 0) continue;
                String name = entry.substring(0, index);
                String value = entry.substring(index + 1);
                attrList.clear();
                attrList.add(new Attribute("name", name));
                if (value != null && value.equals("''")) {
                    attrList.add(new Attribute("value", ""));
                } else {
                    attrList.add(new Attribute("value", value));
                }
                if (props != null && !props.isEmpty()) {
                    boolean propertySet = false;
                    for (int j = 0; j < props.size(); ++j) {
                        property = (ObjectName)props.get(j);
                        String propName = (String)cs.getAttribute(session, property, "name");
                        if (!propName.equals(name)) continue;
                        cs.deleteConfigData(session, property);
                        if (value != null && value.length() > 0) {
                            cs.createConfigData(session, targetObj, customEntName, null, attrList);
                        }
                        propertySet = true;
                        break;
                    }
                    if (propertySet || value == null || value.length() <= 0) continue;
                    cs.createConfigData(session, targetObj, customEntName, null, attrList);
                    continue;
                }
                if (value == null || value.length() <= 0) continue;
                cs.createConfigData(session, targetObj, customEntName, null, attrList);
            }
        }
    }

    public static boolean isCustomPropStringGood(String propString) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCustomPropStringGood", propString);
        }
        try {
            if (propString != null && propString.length() > 0) {
                if (!propString.startsWith("\"") && !propString.endsWith("\"")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "isCustomPropStringGood: false");
                    }
                    return false;
                }
                StringTokenizer tokenizer = new StringTokenizer(propString, "\"");
                while (tokenizer.hasMoreTokens()) {
                    String getComma;
                    String token = tokenizer.nextToken();
                    if (token.indexOf("=") < 0) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "isCustomPropStringGood: false");
                        }
                        return false;
                    }
                    if (!tokenizer.hasMoreTokens() || (getComma = tokenizer.nextToken()) != null && getComma.equals(",") && tokenizer.hasMoreTokens()) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "isCustomPropStringGood: false");
                    }
                    return false;
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while tokenizing custom property string " + e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCustomPropStringGood: true");
        }
        return true;
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.uniqueName = (String)this.getParameter("uniqueName");
        if (this.uniqueName == null || this.uniqueName.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidUniqueName", null);
            throw new CommandValidationException(msg);
        }
        this.className = (String)this.getParameter("className");
        if (this.className == null || this.className.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidClassName", null);
            throw new CommandValidationException(msg);
        }
        this.customProperties = (String)this.getParameter("customProperties");
        if (this.customProperties != null && this.customProperties.length() != 0 && this.customProperties.indexOf("=") == -1) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidCustomProperty", null);
            throw new CommandValidationException(msg);
        }
        this.auditFilters = (String)this.getParameter("auditFilters");
        if (this.auditFilters == null || this.auditFilters.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidAuditFilters", null);
            throw new CommandValidationException(msg);
        }
        this.provider = (String)this.getParameter("provider");
        if (this.provider == null || this.provider.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidProvider", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            ObjectName policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            ArrayList factoryList = (ArrayList)cs.getAttribute(session, policyObject, "auditEventFactories");
            for (int i = 0; i < factoryList.size(); ++i) {
                AttributeList factoryAttrs = (AttributeList)factoryList.get(i);
                ObjectName auditEventFactory = ConfigServiceHelper.createObjectName(factoryAttrs);
                String efName = (String)cs.getAttribute(session, auditEventFactory, "name");
                if (!efName.equals(this.uniqueName)) continue;
                String msg = this.getMsg(resBundle, "security.admintask.EventFactoryExists", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList settings = new AttributeList();
            settings.add(new Attribute("name", this.uniqueName));
            settings.add(new Attribute("className", this.className));
            ObjectName providerObj = null;
            boolean foundProvider = false;
            ArrayList<ObjectName> pList = new ArrayList<ObjectName>();
            ArrayList providerArray = (ArrayList)cs.getAttribute(session, policyObject, "auditServiceProviders");
            for (int k = 0; k < providerArray.size(); ++k) {
                AttributeList providerAttrs = (AttributeList)providerArray.get(k);
                providerObj = ConfigServiceHelper.createObjectName(providerAttrs);
                String filterR = ConfigServiceHelper.getConfigDataId(providerObj).toString().split("#")[1];
                if (!filterR.equals(this.provider)) continue;
                pList.add(providerObj);
                foundProvider = true;
                break;
            }
            if (!foundProvider) {
                String msg = this.getMsg(resBundle, "security.admintask.InvalidProvider", null);
                result.addWarnings(msg);
                result.setException(new CommandException(msg));
                result.setResult(new Boolean(false));
                return;
            }
            settings.add(new Attribute("auditServiceProvider", providerObj));
            ArrayList<ObjectName> aList = new ArrayList<ObjectName>();
            StringTokenizer st = new StringTokenizer(this.auditFilters, ",; ");
            boolean index = false;
            while (st.hasMoreTokens()) {
                String filter = st.nextToken();
                boolean foundSpec = false;
                ArrayList filterArray = (ArrayList)cs.getAttribute(session, audit, "auditSpecifications");
                for (int k = 0; k < filterArray.size(); ++k) {
                    AttributeList filterAttrs = (AttributeList)filterArray.get(k);
                    ObjectName auditSpec = ConfigServiceHelper.createObjectName(filterAttrs);
                    String filterR = ConfigServiceHelper.getConfigDataId(auditSpec).toString().split("#")[1];
                    if (!filterR.equals(filter)) continue;
                    aList.add(auditSpec);
                    foundSpec = true;
                }
                if (foundSpec) continue;
                String msg = this.getMsg(resBundle, "security.admintask.InvalidFilterRef", null);
                result.addWarnings(msg);
                result.setException(new CommandException(msg));
                result.setResult(new Boolean(false));
                return;
            }
            settings.add(new Attribute("auditSpecifications", aList));
            ObjectName eventFactoryObj = cs.createConfigData(session, policyObject, "auditEventFactories", "AuditEventFactory", settings);
            this.addCustomProperties(session, cs, eventFactoryObj, this.customProperties);
            if (settings == null) {
                String msg = this.getMsg(resBundle, "security.admintask.CreateObjFailure", null);
                msg = msg.concat(": AuditServiceProvider");
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList newAttrs = cs.getAttributes(session, eventFactoryObj, null, true);
            String nRef = ConfigServiceHelper.getAttributeValue(newAttrs, "_Websphere_Config_Data_Id").toString();
            nRef = nRef.split("#")[1];
            result.setResult(nRef);
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.eventfactory.CreateAuditEventFactory.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.eventfactory.CreateAuditEventFactory.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

