/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.emitter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SetAuditEmitterFilters
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(SetAuditEmitterFilters.class, "AUDIT", "com.ibm.ws.security.admintask.audit.emitter");
    String emitterRef = null;
    String filtersRef = null;

    public SetAuditEmitterFilters(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public SetAuditEmitterFilters(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.emitterRef = (String)this.getParameter("emitterRef");
        if (this.emitterRef == null || this.emitterRef.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidProvider", null);
            throw new CommandValidationException(msg);
        }
        this.filtersRef = (String)this.getParameter("filtersRef");
        if (this.filtersRef == null || this.filtersRef.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidFilterRef", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        Object s = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            ObjectName policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            boolean found = false;
            ArrayList emitterList = (ArrayList)cs.getAttribute(session, policyObject, "auditServiceProviders");
            for (int i = 0; i < emitterList.size(); ++i) {
                AttributeList emitterAttrs = (AttributeList)emitterList.get(i);
                ObjectName auditEmitter = ConfigServiceHelper.createObjectName(emitterAttrs);
                String auditEmitterRef = ConfigServiceHelper.getAttributeValue(emitterAttrs, "_Websphere_Config_Data_Id").toString();
                if (!(auditEmitterRef = auditEmitterRef.split("#")[1]).equals(this.emitterRef)) continue;
                ArrayList<ObjectName> aList = new ArrayList<ObjectName>();
                StringTokenizer st = new StringTokenizer(this.filtersRef, ",; ");
                boolean index = false;
                while (st.hasMoreTokens()) {
                    String filter = st.nextToken();
                    boolean foundFilter = false;
                    ArrayList filterArray = (ArrayList)cs.getAttribute(session, audit, "auditSpecifications");
                    for (int k = 0; k < filterArray.size(); ++k) {
                        AttributeList filterAttrs = (AttributeList)filterArray.get(k);
                        ObjectName auditSpec = ConfigServiceHelper.createObjectName(filterAttrs);
                        String filterRef = ConfigServiceHelper.getConfigDataId(auditSpec).toString().split("#")[1];
                        if (!filterRef.equals(filter)) continue;
                        foundFilter = true;
                        aList.add(auditSpec);
                        break;
                    }
                    if (foundFilter) continue;
                    String msg = this.getMsg(resBundle, "security.admintask.InvalidFilterRef", null);
                    result.addWarnings(msg);
                    result.setResult(new Boolean(false));
                    result.setException(new CommandException(msg));
                    return;
                }
                ArrayList auditSpecs = (ArrayList)cs.getAttribute(session, auditEmitter, "auditSpecifications");
                auditSpecs.clear();
                auditSpecs.addAll(aList);
                ConfigServiceHelper.setAttributeValue(emitterAttrs, "auditSpecifications", auditSpecs);
                cs.setAttributes(session, auditEmitter, emitterAttrs);
                found = true;
                result.setResult(new Boolean(true));
                break;
            }
            if (!found) {
                String msg = this.getMsg(resBundle, "security.admintask.InvalidProvider", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
            }
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.emitter.SetAuditEmitterFilters.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.emitter.SetAuditEmitterFilters.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

