/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.emitter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.audit.utils.AuditCommandHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateSMFEmitter
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(CreateSMFEmitter.class, "AUDIT", "com.ibm.ws.security.admintask.audit.emitter");
    String uniqueName = null;
    String className = null;
    String eventFormatterClass = null;
    String customProperties = null;
    String[] customPropName = new String[10];
    String[] customPropValue = new String[10];
    String auditFilters = null;

    public CreateSMFEmitter(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateSMFEmitter(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.uniqueName = (String)this.getParameter("uniqueName");
        if (this.uniqueName == null || this.uniqueName.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidUniqueName", null);
            throw new CommandValidationException(msg);
        }
        this.auditFilters = (String)this.getParameter("auditFilters");
        if (this.auditFilters == null || this.auditFilters.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidAuditFilters", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            ObjectName policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            ArrayList emitterList = (ArrayList)cs.getAttribute(session, policyObject, "auditServiceProviders");
            for (int i = 0; i < emitterList.size(); ++i) {
                AttributeList emitterAttrs = (AttributeList)emitterList.get(i);
                ObjectName emitterFactory = ConfigServiceHelper.createObjectName(emitterAttrs);
                String emitterName = (String)cs.getAttribute(session, emitterFactory, "name");
                if (!emitterName.equals(this.uniqueName)) continue;
                String msg = this.getMsg(resBundle, "security.admintask.EmitterExists", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList settings = new AttributeList();
            String className = "com.ibm.ws.security.audit.zOS.SMFEmitterImpl";
            settings.add(new Attribute("name", this.uniqueName));
            settings.add(new Attribute("className", className));
            ArrayList<ObjectName> filterList = new ArrayList<ObjectName>();
            StringTokenizer st = new StringTokenizer(this.auditFilters, ",; ");
            while (st.hasMoreTokens()) {
                String filter = st.nextToken();
                boolean found = false;
                ArrayList filterArray = (ArrayList)cs.getAttribute(session, audit, "auditSpecifications");
                for (int k = 0; k < filterArray.size(); ++k) {
                    AttributeList filterAttrs = (AttributeList)filterArray.get(k);
                    ObjectName auditSpec = ConfigServiceHelper.createObjectName(filterAttrs);
                    String filterR = ConfigServiceHelper.getConfigDataId(auditSpec).toString().split("#")[1];
                    if (!filterR.equals(filter)) continue;
                    found = true;
                    filterList.add(auditSpec);
                    break;
                }
                if (found) continue;
                String msg = this.getMsg(resBundle, "security.admintask.InvalidAuditFilters", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            settings.add(new Attribute("auditSpecifications", filterList));
            if (settings == null) {
                String msg = this.getMsg(resBundle, "security.admintask.CreateObjFailure", null);
                msg = msg.concat(": AuditServiceProvider");
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            ObjectName serviceProviderObj = cs.createConfigData(session, policyObject, "auditServiceProviders", "AuditServiceProvider", settings);
            AuditCommandHelper.addCustomProperties(session, cs, serviceProviderObj, this.customProperties);
            AttributeList newAttrs = cs.getAttributes(session, serviceProviderObj, null, true);
            String nRef = ConfigServiceHelper.getAttributeValue(newAttrs, "_Websphere_Config_Data_Id").toString();
            nRef = nRef.split("#")[1];
            result.setResult(nRef);
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.emitter.CreateSMFEmitter.afterStepsExecuted", "%C");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.emitter.CreateSMFEmitter.afterStepsExecuted", "%C");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

