/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.certificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.security.admintask.audit.certificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.ObjectName;

public class ListCertAliases
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ListCertAliases.class, "AUDIT", "com.ibm.ws.security.admintask.audit.certificates");
    private String keyStoreName = null;
    private String scopeName = null;

    public ListCertAliases(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListCertAliases(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void beforeStepsExecuted() {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "beforeStepsExecuted");
            }
            super.beforeStepsExecuted();
            ObjectName audit = null;
            TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
            if (!result.isSuccessful()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeStepsExecuted");
                }
                return;
            }
            try {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
                ConfigService cs = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                audit = cs.queryConfigObjects(session, null, pattern, null)[0];
                this.keyStoreName = (String)this.getParameter("keyStoreName");
                this.scopeName = (String)this.getParameter("keyStoreScope");
                CommandHelper commandHelper = new CommandHelper();
                ObjectName cell = cs.resolve(session, "Cell=")[0];
                if (this.scopeName == null) {
                    this.scopeName = commandHelper.defaultCellScope(cell);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                    }
                }
                result.setResult(this.personalCertificateList(session, cs, this.keyStoreName, this.scopeName));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "result: " + result.toString());
                }
            }
            catch (Exception e) {
                result.setException(new CommandException(e, e.getMessage()));
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "caught exception: " + e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    public List personalCertificateList(Session session, ConfigService cs, String keyStore, String scope) throws Exception {
        KeyStoreInfo keyStoreInfo = null;
        List certList = null;
        try {
            keyStoreInfo = PersonalCertificateHelper.getKsInfo(session, cs, keyStore, scope);
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        try {
            certList = this.getPersonalCerts(keyStoreInfo);
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        return certList;
    }

    public List getPersonalCerts(KeyStoreInfo keyStoreInfo) throws Exception {
        ArrayList<String> personalCerts = new ArrayList<String>();
        Object certAttr = null;
        boolean isRACFType = false;
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(keyStoreInfo);
        if (keyStoreInfo.getType().equals("JCERACFKS") || keyStoreInfo.getType().equals("JCECCARACFKS")) {
            isRACFType = true;
        }
        try {
            Object[] aliases;
            Object[] parms = null;
            String method2 = "aliases";
            if (isRACFType) {
                parms = new Object[]{"audit_keystore"};
            }
            if ((aliases = wsksr.invokeKeyStoreCommand(method2, parms)) != null) {
                for (int i = 0; i < aliases.length; ++i) {
                    Object[] certArray;
                    X509Certificate cert;
                    String alias = (String)aliases[i];
                    method2 = "isKeyEntry";
                    parms = isRACFType ? new Object[]{"audit_keystore", alias} : new Object[]{alias};
                    Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
                    if (!((Boolean)isKeyEntry[0]).booleanValue() || (cert = (X509Certificate)(certArray = wsksr.invokeKeyStoreCommand(method2 = "getCertificate", parms = isRACFType ? new Object[]{"audit_keystore", alias} : new Object[]{alias}))[0]) == null || CertificateRequestHelper.isKeyCertReq(cert, alias) != null) continue;
                    personalCerts.add(alias);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Alias list from keystore is null.  The server mbean may not be availible.");
            }
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        return personalCerts;
    }
}

