/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.certificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.security.admintask.audit.certificates.PersonalCertificateHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.ObjectName;

public class CreateAuditSelfSignedCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateAuditSelfSignedCertificate.class, "Audit", "com.ibm.ws.security.admintask.audit.certificates");
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certLabel = null;
    private String certCommonName = null;
    private String certOrganization = null;
    private String certOrganizationalUnit = null;
    private int certSize = 0;
    private String certVersion = null;
    private String certZip = null;
    private String certCountry = null;
    private int certValidDays = 0;
    private String certLocality = null;
    private String certState = null;
    private KeyStoreInfo ksInfo = null;
    private CertReqInfo certInfo = null;

    public CreateAuditSelfSignedCertificate(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateAuditSelfSignedCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName pattern = null;
        ObjectName audit = null;
        Object keyFileName = null;
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certLabel = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            this.certCommonName = (String)this.getParameter(CommandConstants.CERT_COMMON_NAME);
            this.certSize = (Integer)this.getParameter(CommandConstants.CERT_SIZE);
            this.certOrganization = (String)this.getParameter(CommandConstants.CERT_ORGANIZATION);
            this.certOrganizationalUnit = (String)this.getParameter(CommandConstants.CERT_ORGANIZATIONAL_UNIT);
            this.certLocality = (String)this.getParameter(CommandConstants.CERT_LOCALITY);
            this.certState = (String)this.getParameter(CommandConstants.CERT_STATE);
            this.certZip = (String)this.getParameter(CommandConstants.CERT_ZIP);
            this.certCountry = (String)this.getParameter(CommandConstants.CERT_COUNTRY);
            this.certVersion = (String)this.getParameter(CommandConstants.CERT_VERSION);
            this.certValidDays = (Integer)this.getParameter(CommandConstants.CERT_DAYS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " certlabel=" + this.certLabel + " certCommonName=" + this.certCommonName + " certSize=" + this.certSize + " certOrganization=" + this.certOrganization + " certOrganizationalUnit=" + this.certOrganizationalUnit + " certLocality=" + this.certLocality + " certState=" + this.certState + " certZip=" + this.certZip + " certCountry=" + this.certCountry + " certVersion=" + this.certVersion + " certValidDays=" + this.certValidDays);
            }
            if (this.certValidDays < 1 || this.certValidDays > 7300) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.object.exists.CWPKI0628E=CWPKI0628E", "Valid days parameter is out of range.  It should be between 1 and 7300 days.");
                throw new CommandValidationException(msg);
            }
            String SubjectDN = this.makeSubjectDN(this.certCommonName, this.certOrganization, this.certOrganizationalUnit, this.certLocality, this.certState, this.certZip, this.certCountry);
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(cell);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
                }
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            this.certInfo = new CertReqInfo(this.certLabel, this.certSize, SubjectDN, this.certValidDays, this.ksInfo, null);
        }
        catch (ConfigServiceException e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean created = false;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            created = this.personalCertificateCreate(this.certInfo);
            result.setResult(new Boolean(created));
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public String makeSubjectDN(String commonName, String organization, String organizationalUnit, String locality, String state, String zip, String country) throws CommandValidationException {
        String DN = null;
        if (commonName == null) {
            String msg = "CommonName is missing, unable to create the Certificate.";
            throw new CommandValidationException(msg);
        }
        DN = "CN=" + commonName;
        if (organizationalUnit != null) {
            DN = DN + ", OU=" + organizationalUnit;
        }
        if (organization == null) {
            String msg = "Organization is missing, unable to create the Certificate.";
            throw new CommandValidationException(msg);
        }
        DN = DN + ", O=" + organization;
        if (locality != null) {
            DN = DN + ", L=" + locality;
        }
        if (state != null) {
            DN = DN + ", ST=" + state;
        }
        if (zip != null) {
            DN = DN + ", POSTALCODE=" + zip;
        }
        if (country == null) {
            String msg = "Country is missing, unable to create the Certificate.";
            throw new CommandValidationException(msg);
        }
        DN = DN + ", C=" + country;
        return DN;
    }

    public boolean personalCertificateCreate(CertReqInfo ssCertInfo) throws Exception {
        boolean certCreated = false;
        String alias = null;
        String subjectDN = null;
        int size = 0;
        int validDays = 0;
        KeyStoreInfo keyStoreInfo = null;
        String keyStoreProvider = null;
        String password = null;
        String type = null;
        subjectDN = ssCertInfo.getSubjectDN();
        alias = ssCertInfo.getLabel();
        size = ssCertInfo.getSize();
        validDays = ssCertInfo.getValidDays();
        keyStoreInfo = ssCertInfo.getKsInfo();
        keyStoreProvider = keyStoreInfo.getProvider();
        type = keyStoreInfo.getType();
        password = keyStoreInfo.getPassword();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "location: " + keyStoreInfo.getLocation());
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(keyStoreInfo);
        PkSsCertificate SsCertificate = null;
        X509Certificate certificate = null;
        PrivateKey privateKey = null;
        String method2 = "containsAlias";
        Object[] parms = new Object[]{alias};
        Object[] exists = wsksr.invokeKeyStoreCommand(method2, parms);
        if (((Boolean)exists[0]).booleanValue()) {
            String msg = this.getMsg(resBundle, "security.admintask.CertAliasExists", null);
            throw new CommandValidationException(msg);
        }
        if (type != null && (type.equals("CMSKS") || type.equals("IBMi5OSKeyStore"))) {
            keyStoreProvider = JSSEProviderFactory.isFipsEnabled() ? "IBMJCEFIPS" : "IBMJCE";
        }
        Date deltaDate = new Date();
        deltaDate.setTime(deltaDate.getTime() - 86400000L);
        SsCertificate = PkSsCertFactory.newSsCert((int)size, (String)subjectDN, (int)validDays, (Date)deltaDate, (boolean)true, (boolean)true, (String)keyStoreProvider);
        if (SsCertificate != null) {
            certificate = SsCertificate.getCertificate();
            privateKey = SsCertificate.getKey();
            method2 = "setKeyEntry";
            parms = new Object[]{alias, privateKey, password.toCharArray(), new X509Certificate[]{certificate}};
            wsksr.invokeKeyStoreCommand(method2, parms);
            certCreated = true;
            try {
                Tr.audit(tc, "Self Signed Certificate: notBefore time: " + certificate.getNotBefore().toString() + " notAfter time: " + certificate.getNotAfter().toString());
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (certCreated) {
            Session session = this.getConfigSession();
            PersonalCertificateHelper.setWorkspaceUpdated(session, ssCertInfo.getKsInfo().getLocation());
        }
        return certCreated;
    }
}

