/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.SetLdapConfig;
import com.ibm.ws.security.admintask.securityDomain.SecConfigTaskHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.util.ConfigUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.ObjectName;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class ValidateLDAPConnection
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ValidateLDAPConnection.class, "ValidateLDAPConnection", "com.ibm.ws.security.admintask");
    private String hostName = null;
    private Integer portNumber = new Integer(389);
    private Boolean sslEnabled = null;
    private String sslAlias = null;
    private String type = null;
    private String baseDN = null;
    private String bindDN = null;
    private String bindPwd = null;
    private String securityDomain = null;
    private SetLdapConfig ldapConfig;
    static String ldapPropsFile = "/com/ibm/websphere/security/ldap/LdapConfig.properties";
    private static String objectFilter = "(objectclass=*)";
    public static final String GROUP_FILTER = "group.filter";
    private static final String iPlanet_OBJECT_FILTER = "(|(objectclass=*)(objectclass=ldapsubentry))";
    private static final String MS_OBJECT_FILTER = "(objectCategory=*)";

    public ValidateLDAPConnection(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ValidateLDAPConnection(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        this.hostName = (String)this.getParameter("hostname");
        if ((Integer)this.getParameter("port") != null) {
            this.portNumber = (Integer)this.getParameter("port");
        }
        this.sslEnabled = (Boolean)this.getParameter("sslEnabled");
        this.sslAlias = (String)this.getParameter("sslAlias");
        this.type = (String)this.getParameter("type");
        this.baseDN = (String)this.getParameter("baseDN");
        this.baseDN = this.baseDN != null ? ConfigUtils.variableMapExpand(this.baseDN) : "";
        this.bindDN = (String)this.getParameter("bindDN");
        this.bindPwd = (String)this.getParameter("bindPassword");
        if (this.hostName != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "hostName = " + this.hostName);
        }
        this.securityDomain = (String)this.getParameter("securityDomainName");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "unsuccessful at getting TaskCommandResultImpl afterStepsExecuted");
            }
            return;
        }
        try {
            String ldapProtocol = "ldap://";
            StringBuffer ldapUrl = new StringBuffer();
            int ldapServerTypeValue = 0;
            if (this.hostName.indexOf(":") != -1) {
                ldapUrl.append(ldapProtocol).append("[" + this.hostName + "]");
            } else {
                ldapUrl.append(ldapProtocol).append(this.hostName);
            }
            if (this.portNumber != null && this.portNumber > 0) {
                ldapUrl.append(":" + this.portNumber);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ldapUrl = " + ldapUrl.toString());
            }
            String realm = new String(this.hostName + ":" + this.portNumber);
            Properties props = new Properties();
            if (this.type != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ldapServerType = " + this.type);
                }
                Properties ldapProps = null;
                try {
                    InputStream is = this.getClass().getResourceAsStream(ldapPropsFile);
                    ldapProps = new Properties();
                    ldapProps.load(is);
                }
                catch (IOException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "IOException opening ldapPropsFile");
                    }
                    e.printStackTrace();
                    result.setResult(new Boolean(false));
                    String msg = this.getMsg(resBundle, "security.admintask.ExceptionLDAPConnect", null);
                    result.setException(new CommandException(e, msg));
                    return;
                }
                if (ldapProps != null) {
                    if (this.type.equalsIgnoreCase("IBM_DIRECTORY_SERVER")) {
                        ldapServerTypeValue = 0;
                    } else if (this.type.equalsIgnoreCase("SECUREWAY")) {
                        ldapServerTypeValue = 1;
                    } else if (this.type.equalsIgnoreCase("IPLANET")) {
                        ldapServerTypeValue = 2;
                    } else if (this.type.equalsIgnoreCase("NETSCAPE")) {
                        ldapServerTypeValue = 3;
                    } else if (this.type.equalsIgnoreCase("DOMINO502")) {
                        ldapServerTypeValue = 4;
                    } else if (this.type.equalsIgnoreCase("NDS")) {
                        ldapServerTypeValue = 5;
                    } else if (this.type.equalsIgnoreCase("ACTIVE_DIRECTORY")) {
                        ldapServerTypeValue = 6;
                    } else if (this.type.equalsIgnoreCase("CUSTOM")) {
                        ldapServerTypeValue = 7;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ldapServerTypeValue = " + ldapServerTypeValue);
                    }
                    switch (ldapServerTypeValue) {
                        case 0: {
                            props.setProperty("user.filter", ldapProps.getProperty("ibm_dir_server.user.filter"));
                            props.setProperty(GROUP_FILTER, ldapProps.getProperty("ibm_dir_server.group.filter"));
                            props.setProperty("user.idmap", ldapProps.getProperty("ibm_dir_server.user.idmap"));
                            props.setProperty("group.idmap", ldapProps.getProperty("ibm_dir_server.group.idmap"));
                            props.setProperty("groupmember.idmap", ldapProps.getProperty("ibm_dir_server.groupmember.idmap"));
                            break;
                        }
                        case 1: {
                            props.setProperty("user.filter", ldapProps.getProperty("secureway.user.filter"));
                            props.setProperty(GROUP_FILTER, ldapProps.getProperty("secureway.group.filter"));
                            props.setProperty("user.idmap", ldapProps.getProperty("secureway.user.idmap"));
                            props.setProperty("group.idmap", ldapProps.getProperty("secureway.group.idmap"));
                            props.setProperty("groupmember.idmap", ldapProps.getProperty("secureway.groupmember.idmap"));
                            break;
                        }
                        case 2: {
                            props.setProperty("user.filter", ldapProps.getProperty("iplanet.user.filter"));
                            props.setProperty(GROUP_FILTER, ldapProps.getProperty("iplanet.group.filter"));
                            props.setProperty("user.idmap", ldapProps.getProperty("iplanet.user.idmap"));
                            props.setProperty("group.idmap", ldapProps.getProperty("iplanet.group.idmap"));
                            props.setProperty("groupmember.idmap", ldapProps.getProperty("iplanet.groupmember.idmap"));
                            break;
                        }
                        case 3: {
                            props.setProperty("user.filter", ldapProps.getProperty("netscape.user.filter"));
                            props.setProperty(GROUP_FILTER, ldapProps.getProperty("netscape.group.filter"));
                            props.setProperty("user.idmap", ldapProps.getProperty("netscape.user.idmap"));
                            props.setProperty("group.idmap", ldapProps.getProperty("netscape.group.idmap"));
                            props.setProperty("groupmember.idmap", ldapProps.getProperty("netscape.groupmember.idmap"));
                            break;
                        }
                        case 4: {
                            props.setProperty("user.filter", ldapProps.getProperty("domino50.user.filter"));
                            props.setProperty(GROUP_FILTER, ldapProps.getProperty("domino50.group.filter"));
                            props.setProperty("user.idmap", ldapProps.getProperty("domino50.user.idmap"));
                            props.setProperty("group.idmap", ldapProps.getProperty("domino50.group.idmap"));
                            props.setProperty("groupmember.idmap", ldapProps.getProperty("domino50.groupmember.idmap"));
                            break;
                        }
                        case 6: {
                            props.setProperty("user.filter", ldapProps.getProperty("actived.user.filter"));
                            props.setProperty(GROUP_FILTER, ldapProps.getProperty("actived.group.filter"));
                            props.setProperty("user.idmap", ldapProps.getProperty("actived.user.idmap"));
                            props.setProperty("group.idmap", ldapProps.getProperty("actived.group.idmap"));
                            props.setProperty("groupmember.idmap", ldapProps.getProperty("actived.groupmember.idmap"));
                            break;
                        }
                        case 5: {
                            props.setProperty("user.filter", ldapProps.getProperty("edirectory.user.filter"));
                            props.setProperty(GROUP_FILTER, ldapProps.getProperty("edirectory.group.filter"));
                            props.setProperty("user.idmap", ldapProps.getProperty("edirectory.user.idmap"));
                            props.setProperty("group.idmap", ldapProps.getProperty("edirectory.group.idmap"));
                            props.setProperty("groupmember.idmap", ldapProps.getProperty("edirectory.groupmember.idmap"));
                            break;
                        }
                    }
                }
            }
            props.setProperty("security.registry.ldap.reuseConn", "true");
            props.setProperty("CustUserRegImplClass", "com.ibm.ws.security.registry.ldap.LdapRegistryImpl");
            props.setProperty("security.registry.ldap.searchTimeLimit", "120");
            props.setProperty("dirType", this.type);
            props.setProperty("LDAP.server.realm", realm);
            props.setProperty("ldap.basedn", this.baseDN);
            props.setProperty("java.naming.provider.url", ldapUrl.toString());
            props.setProperty("sslEnabled", this.sslEnabled.toString());
            if (this.sslAlias != null) {
                props.setProperty("sslAlias", this.sslAlias);
                props.put("LDAP.validation", "true");
                props.put("security.registry.ldap.SSLAlias", this.sslAlias);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "LDAP.validation is set to truesecurity.registry.ldap.SSLAlias is set to" + this.sslAlias);
                }
            }
            if (this.bindDN != null) {
                props.setProperty("java.naming.security.principal", this.bindDN);
            }
            if (this.bindPwd != null) {
                props.setProperty("java.naming.security.credentials", this.bindPwd);
            } else if (this.bindDN != null) {
                try {
                    ObjectName regObj;
                    ConfigService configService = this.getConfigService();
                    Session session = this.getConfigSession();
                    ObjectName secObj = null;
                    secObj = this.securityDomain != null ? SecConfigTaskHelper.getSecDomain(session, configService, this.securityDomain) : SecConfigTaskHelper.getSecurityObjectName(session, configService);
                    if (secObj != null && (regObj = SecConfigTaskHelper.getRegObj(session, configService, secObj, "LDAPUserRegistry")) != null) {
                        this.bindPwd = (String)configService.getAttribute(session, regObj, "bindPassword");
                        if (this.bindPwd != null) {
                            props.setProperty("java.naming.security.credentials", this.bindPwd);
                        }
                    }
                }
                catch (Exception exc) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "caught exception testing ldapConfig");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, exc.toString());
                    }
                    String msg = exc.toString();
                    result.addWarnings(msg);
                    result.setResult(new Boolean(false));
                    result.setException(new CommandException(msg));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "afterStepsExecuted");
                    }
                    return;
                }
            }
            props.setProperty("certificate.map.mode", "exactDNMode");
            Properties expandedProps = ConfigUtils.expandProps(props);
            if (tc.isDebugEnabled()) {
                Properties printProps = SetLdapConfig.clearPasswordProps(expandedProps);
                Tr.debug(tc, "props = " + printProps.toString());
            }
            try {
                this.ldapConfig = new SetLdapConfig(expandedProps);
            }
            catch (Exception exc) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caught exception creating ldapConfig");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, exc.toString());
                }
                String msg = exc.toString();
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
                return;
            }
            SetLdapConfig tmpConfig = new SetLdapConfig(this.ldapConfig);
            if (ldapServerTypeValue != 7) {
                String filter = tmpConfig.getFilter(GROUP_FILTER).prepare("*").toLowerCase();
                if (filter.indexOf("ldapsubentry") > -1) {
                    objectFilter = iPlanet_OBJECT_FILTER;
                }
                if (filter.indexOf("objectcategory") > -1) {
                    objectFilter = MS_OBJECT_FILTER;
                }
            }
            SearchControls controls = new SearchControls();
            controls.setSearchScope(0);
            controls.setReturningObjFlag(false);
            controls.setTimeLimit(120);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "baseDN: " + this.baseDN + " objectFilter = " + objectFilter);
            }
            try {
                InitialDirContext ctx = new InitialDirContext(tmpConfig);
                NamingEnumeration<SearchResult> e = ctx.search(this.baseDN, objectFilter, controls);
                ctx.close();
                result.setResult(new Boolean(true));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
                return;
            }
            catch (AuthenticationNotSupportedException anse) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "javax.naming.AuthenticationNotSupportedException");
                }
                String msg = this.getMsg(resBundle, "security.admintask.ExceptionLDAPConnect", null);
                msg = msg.concat(": AuthenticationNotSupportedException: ");
                msg = msg.concat(anse.getExplanation());
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
                return;
            }
            catch (AuthenticationException ae) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "javax.naming.AuthenticationException" + ae.getExplanation());
                }
                String msg = this.getMsg(resBundle, "security.admintask.ExceptionLDAPConnect", null);
                msg = msg.concat(": AuthenticationException: ");
                msg = msg.concat(ae.getExplanation());
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
                return;
            }
            catch (NamingException ne) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "javax.naming.NamingException " + ne.getExplanation());
                }
                ne.printStackTrace();
                String msg = this.getMsg(resBundle, "security.admintask.ExceptionLDAPConnect", null);
                msg = msg.concat(": NamingException: ");
                msg = msg.concat(ne.getExplanation());
                msg = msg.concat(" " + ne.getCause());
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setResult(new Boolean(false));
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.ValidateLDAPConnection", "460");
            String msg = this.getMsg(resBundle, "security.admintask.ExceptionLDAPConnect", null);
            result.setException(new CommandException(e, msg));
            return;
        }
    }
}

