/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.adminCommand;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.scripting.StringHandler;
import com.ibm.ws.scripting.DefaultStringHandler;
import com.ibm.ws.scripting.ExtensionHelper;
import com.ibm.ws.scripting.HandlerRegistry;
import com.ibm.ws.scripting.JaclUtilities;
import com.ibm.ws.scripting.JythonUtilities;
import com.ibm.ws.scripting.LanguageUtilities;
import com.ibm.ws.scripting.ObjectNameHelper;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.adminCommand.AdminCmd;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import org.eclipse.emf.common.util.EList;

public class AdminCmdScriptGenerator
extends AdminCmd {
    public static String CMD_FRAMEWORK_SCRIPTING_OBJECT = "AdminTask";
    private static TraceComponent tc = Tr.register(AdminCmdScriptGenerator.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private LanguageUtilities _langUtil;
    private DefaultStringHandler _handler;

    public AdminCmdScriptGenerator(String lang) throws ScriptingException {
        this.setLanguage(lang);
        this._handler = new DefaultStringHandler(this._langUtil);
        ExtensionHelper.processRegisterHandlersInExtensions();
    }

    public void setLanguage(String lang) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLanguage", new Object[]{lang});
        }
        ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.ws.scripting.resources.wscpMessage", Locale.getDefault());
        if (lang.equalsIgnoreCase("jacl")) {
            this._langUtil = new JaclUtilities(bundle);
        } else if (lang.equalsIgnoreCase("jython")) {
            this._langUtil = new JythonUtilities(bundle);
        } else {
            throw new ScriptingException(ObjectNameHelper.getFormattedMessage("WASX8010E", "Invalid scripting language: " + lang, new Object[]{lang}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLanguage");
        }
    }

    public String getLanguage() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLanguage");
        }
        String ret = null;
        if (this._langUtil != null) {
            if (this._langUtil instanceof JaclUtilities) {
                ret = "jacl";
            } else if (this._langUtil instanceof JythonUtilities) {
                ret = "jython";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLanguage - " + ret);
        }
        return ret;
    }

    public String generateScriptFromCmd(AdminCommand adminCmd) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateScriptFromCmd", new Object[]{adminCmd.getName()});
        }
        String cmdName = adminCmd.getName();
        Object cmdTargetObject = adminCmd.getTargetObject();
        String targetObjectString = null;
        if (cmdTargetObject != null && (targetObjectString = this.formDisplayString(cmdTargetObject)).indexOf(" ") >= 0 && !targetObjectString.startsWith("\"") && !targetObjectString.endsWith("\"")) {
            targetObjectString = "\"" + targetObjectString + "\"";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "target object string: " + targetObjectString);
        }
        StringBuffer cmdParamString = new StringBuffer();
        Collection col = adminCmd.listSetParams();
        String paramString = this.buildParameters(adminCmd, col);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parameter string: " + paramString);
        }
        String stepString = null;
        if (adminCmd instanceof TaskCommand) {
            stepString = this.buildSteps((TaskCommand)adminCmd);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "step string: " + stepString);
            }
        }
        String ret = this._langUtil.buildAdminCmdString(CMD_FRAMEWORK_SCRIPTING_OBJECT, adminCmd.getName(), targetObjectString, paramString, stepString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateScriptFromCmd - " + ret);
        }
        return ret;
    }

    private String buildParameters(AdminCommand adminCmd, Collection col) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildParameters", new Object[]{col});
        }
        Iterator iter = col.iterator();
        StringBuffer value = new StringBuffer();
        CommandMetadata metadata2 = adminCmd.getCommandMetadata();
        boolean isPassword = false;
        while (iter.hasNext()) {
            isPassword = false;
            String paramName = (String)iter.next();
            try {
                if (adminCmd.isPrivateParameter(paramName)) {
                }
            }
            catch (InvalidParameterNameException ex) {}
            continue;
            if (paramName.toLowerCase().indexOf("password") >= 0 || paramName.toLowerCase().indexOf("pwd") >= 0 || paramName.toLowerCase().indexOf("passwd") >= 0) {
                isPassword = true;
            }
            boolean isPath = false;
            boolean isPathNeedCorrection = false;
            if (paramName.toLowerCase().indexOf("path") >= 0) {
                isPath = true;
            }
            if (value.toString().length() > 0) {
                value.append(" ");
            }
            value.append("-");
            value.append(paramName);
            value.append(" ");
            Object obj = null;
            try {
                obj = adminCmd.getOrigParameterValue(paramName);
                if (isPassword) {
                    obj = "*****";
                }
            }
            catch (InvalidParameterNameException ex) {
                throw new ScriptingException();
            }
            if (obj == null) continue;
            String data = this.formDisplayString(obj);
            String lang = this.getLanguage();
            Tr.debug(tc, "obj class type " + obj.getClass());
            Tr.debug(tc, "data: " + data);
            if (!(obj instanceof AttributeList) && !(obj instanceof Attribute) && obj.getClass() != Object[].class && obj.getClass() != Integer[].class && obj.getClass() != ArrayList.class && obj.getClass() != List.class && obj.getClass() != Hashtable.class && obj.getClass() != Properties.class) {
                if (data.indexOf(" ") >= 0 && !data.startsWith("\"") && !data.endsWith("\"") && data.indexOf("\"") < 0) {
                    data = "\"" + data + "\"";
                } else if (obj.getClass() == String.class) {
                    if (data.indexOf(" ") >= 0 && data.indexOf("\"") >= 0 || data.startsWith("\"") && data.endsWith("\"")) {
                        data = lang.equalsIgnoreCase("jacl") ? "{" + data + "}" : "[" + data + "]";
                    } else if (data.startsWith("-")) {
                        data = "\"" + data + "\"";
                    }
                }
            }
            if (obj.getClass() == String[].class) {
                StringTokenizer strtok = new StringTokenizer(data, ";", false);
                String next = null;
                StringBuffer buf = new StringBuffer();
                while (strtok.hasMoreTokens()) {
                    next = strtok.nextToken();
                    if (next.startsWith("\"") && !next.endsWith("\"")) {
                        next = next + "\"";
                    } else if (!next.startsWith("\"") && next.endsWith("\"")) {
                        next = "\"" + next;
                    } else if (next.indexOf(" ") >= 0 && !next.startsWith("\"") && !next.endsWith("\"")) {
                        next = "\"" + next + "\"";
                    }
                    buf.append(next);
                    buf.append(" ");
                }
                data = buf.length() == 0 ? "\"\"" : (lang.equalsIgnoreCase("jacl") ? "{" + buf.toString() + "}" : "[" + buf.toString() + "]");
            }
            if (obj.getClass() == Properties.class) {
                Tr.debug(tc, "data " + data);
                if (data.length() > 0) {
                    if (lang.equalsIgnoreCase("jacl") && data.indexOf("{") == data.lastIndexOf("{")) {
                        data = "{" + data + "}";
                    } else if (lang.equalsIgnoreCase("jython") && data.indexOf("[") == data.lastIndexOf("[")) {
                        data = "[" + data + "]";
                    }
                }
            }
            if (isPath && data.indexOf(92) >= 0) {
                data = data.replace('\\', '/');
            }
            value.append(data);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildParameters - " + value.toString());
        }
        return value.toString();
    }

    private String buildSteps(TaskCommand taskCmd) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildSteps");
        }
        String[] steps = taskCmd.listCommandSteps();
        StringBuffer stepsParamString = new StringBuffer();
        for (int i = 0; i < steps.length; ++i) {
            CommandStep cmdStep = taskCmd.getCommandStep(steps[i]);
            if (!cmdStep.isEnabled()) continue;
            CommandStepMetadata stepMetadata = (CommandStepMetadata)cmdStep.getCommandMetadata();
            StringBuffer aStepParamString = new StringBuffer();
            if (stepMetadata.isTable()) {
                for (int j = 0; j < cmdStep.getNumberOfRows(); ++j) {
                    Collection col = cmdStep.listSetParams(j);
                    String aParamString = this.buildStepParameters(col, cmdStep, stepMetadata, j);
                    if (aParamString == null || aParamString.length() == 0) continue;
                    if (aStepParamString.length() > 0) {
                        aStepParamString.append(" ");
                    }
                    aStepParamString.append(this._langUtil.getOpenNestedAttribute());
                    aStepParamString.append(aParamString);
                    aStepParamString.append(this._langUtil.getCloseNestedAttribute());
                }
            } else {
                Collection col = cmdStep.listSetParams(0);
                String aParamString = this.buildParameters(cmdStep, col);
                aStepParamString.append(aParamString);
                Tr.debug(tc, "aStepParamString " + aStepParamString);
            }
            if (aStepParamString.length() <= 0) continue;
            if (stepsParamString.length() > 0) {
                stepsParamString.append(" ");
            }
            stepsParamString.append("-");
            stepsParamString.append(cmdStep.getName());
            stepsParamString.append(" ");
            stepsParamString.append(this._langUtil.getOpenNestedAttribute());
            stepsParamString.append(aStepParamString.toString());
            stepsParamString.append(this._langUtil.getCloseNestedAttribute());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildSteps - " + stepsParamString.toString());
        }
        return stepsParamString.toString();
    }

    private String buildStepParameters(Collection col, CommandStep cmdStep, CommandStepMetadata stepMetadata, int rowIndex) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildStepParameters - " + col + " " + rowIndex);
        }
        StringBuffer buf = new StringBuffer();
        if (!col.isEmpty()) {
            EList paramList = stepMetadata.getParameters();
            for (int i = 0; i < paramList.size(); ++i) {
                String data;
                ParameterMetadata paramMetadata = (ParameterMetadata)paramList.get(i);
                Object paramValue = null;
                try {
                    if (cmdStep.isPrivateParameter(paramMetadata.getName())) continue;
                    if (!paramMetadata.isReadonly() || paramMetadata.isKeyField()) {
                        paramValue = cmdStep.getParameter(paramMetadata.getName(), rowIndex);
                    }
                }
                catch (InvalidParameterNameException ex) {
                    // empty catch block
                }
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                if (paramValue == null || paramValue instanceof String && ((String)paramValue).trim().equals("") || paramMetadata.isReadonly() && !paramMetadata.isKeyField()) {
                    buf.append("\"\"");
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Param name: " + paramMetadata.getName() + " " + "value: \"\"");
                    continue;
                }
                if (paramValue instanceof String && paramValue.toString().indexOf("{") > 0 && paramValue.toString().indexOf("}") > 0) {
                    paramValue = "\"" + paramValue + "\"";
                }
                if ((data = this.formDisplayString(paramValue)).indexOf(" ") >= 0 && !data.startsWith("\"") && !data.endsWith("\"")) {
                    data = "\"" + data + "\"";
                }
                buf.append(data);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildStepParameters - " + buf.toString());
        }
        return buf.toString();
    }

    protected String formDisplayString(Object val) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formDisplayString", new Object[]{val});
        }
        String ret = new String();
        String lang = this.getLanguage();
        if (val == null) {
            ret = new String("null");
        } else {
            StringHandler handler = null;
            Class<?> cls = val.getClass();
            if (cls != null) {
                handler = HandlerRegistry.getHandler(cls);
            }
            if (handler != null) {
                ret = handler.formDisplayString(val, this.getLanguage());
                String nl = System.getProperty("line.separator");
                if (cls == String[].class) {
                    int index;
                    ret = ret.trim();
                    while ((index = ret.indexOf("\"")) != -1) {
                        StringBuffer buf1 = new StringBuffer(ret);
                        buf1.replace(index, index + 1, "");
                        ret = buf1.toString();
                    }
                    while ((index = ret.indexOf(nl)) != -1) {
                        StringBuffer buf = new StringBuffer(ret);
                        buf.replace(index, index + nl.length(), ";");
                        ret = buf.toString();
                    }
                } else if (cls == Properties.class) {
                    if (lang.equalsIgnoreCase("jacl")) {
                        int index;
                        while ((index = ret.indexOf(nl)) != -1) {
                            StringBuffer buf = new StringBuffer(ret);
                            buf.replace(index, index + nl.length(), " ");
                            ret = buf.toString();
                        }
                        if (((Properties)val).size() > 1) {
                            ret = "{ " + ret + " }";
                        }
                    }
                } else if (cls == Object[].class || cls == Integer[].class) {
                    int index;
                    ret = ret.trim();
                    while ((index = ret.indexOf(nl)) != -1) {
                        ret = ret.replace(nl, " ");
                        if (lang.equalsIgnoreCase("jacl")) {
                            ret = "{" + ret + "}";
                            continue;
                        }
                        ret = "[" + ret + "]";
                    }
                } else if (cls == AttributeList.class && lang.equalsIgnoreCase("jacl")) {
                    ret = "{ " + ret + " }";
                } else if (cls == ArrayList.class || cls == List.class) {
                    if ((ret = ret.trim()).indexOf(nl) > 0) {
                        int index;
                        StringTokenizer strtok = new StringTokenizer(ret, nl);
                        String next = null;
                        StringBuffer buf = new StringBuffer();
                        while (strtok.hasMoreTokens()) {
                            next = strtok.nextToken();
                            if (next.startsWith("\"") && next.endsWith("\"")) {
                                next = next.substring(1, next.length() - 1);
                            }
                            if (next.indexOf(" ") != -1) {
                                next = "\"" + next + "\"";
                            }
                            if (lang.equalsIgnoreCase("jacl")) {
                                buf.append(next);
                                buf.append(" ");
                            }
                            if (!lang.equalsIgnoreCase("jython")) continue;
                            buf.append(next);
                            buf.append(" ");
                        }
                        ret = buf.toString();
                        while ((index = ret.indexOf(nl)) != -1) {
                            ret = ret.replace(nl, " ");
                        }
                    }
                    if (ret.startsWith("\"") && ret.endsWith("\"")) {
                        ret = ret.substring(1, ret.length() - 1);
                    }
                    if (lang.equalsIgnoreCase("jython")) {
                        ret = "[" + ret.trim() + "]";
                    }
                    if (lang.equalsIgnoreCase("jacl")) {
                        ret = "{" + ret.trim() + "}";
                    }
                } else if (cls == Hashtable.class) {
                    ret = this._langUtil.hashtableToStringForAdminTask((Hashtable)val);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formDisplayString - " + ret);
        }
        return ret;
    }
}

