/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.AttrInfo;
import com.ibm.ws.scripting.ContainmentInfo;
import com.ibm.ws.scripting.ScriptingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;

public class MetaInfoCache {
    private static TraceComponent tc = Tr.register(MetaInfoCache.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static MetaInfoCache _self = null;
    private AbstractShell _shell = null;
    private Hashtable containmentCache = null;
    private ConfigService configServiceProxy = null;
    private Hashtable typeToAttributeMap = null;
    private Hashtable flatAttributeMap = null;
    private Properties subtypeMap = null;
    private String[] supportedTypes = null;

    public static MetaInfoCache getInstance() {
        if (_self == null) {
            _self = new MetaInfoCache();
        }
        return _self;
    }

    public MetaInfoCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MetaInfoCache");
        }
        _self = this;
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MetaInfoCache");
        }
    }

    private void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.configServiceProxy = AdminConfigClient.getConfigService();
        this.typeToAttributeMap = new Hashtable();
        this.flatAttributeMap = new Hashtable();
        this.containmentCache = new Hashtable();
        this.subtypeMap = new Properties();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void setShell(AbstractShell shell) {
        this._shell = shell;
    }

    public void reconnect() throws AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reconnect");
        }
        this.containmentCache = null;
        this.typeToAttributeMap = null;
        this.flatAttributeMap = null;
        this.subtypeMap = null;
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reconnect");
        }
    }

    public String[] getTypes() throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTypes");
        }
        if (this.supportedTypes == null) {
            this.supportedTypes = this.configServiceProxy.getSupportedConfigObjectTypes();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTypes");
        }
        return this.supportedTypes;
    }

    public String[] getParentTypes(String type) throws ScriptingException, AdminException, ConnectorException {
        ContainmentInfo ci;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentTypes - " + type);
        }
        if ((ci = (ContainmentInfo)this.containmentCache.get(type)) == null) {
            ci = this.updateContainmentCache(type);
        }
        if (ci == null) {
            this._shell.setAndThrowScriptingException("WASX7086E", "Unable to find relationship info for " + type, new Object[]{type});
        }
        String[] ret = ci.getParentTypes();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentTypes");
        }
        return ret;
    }

    public Properties getContentTypes(String type) throws ScriptingException, AdminException, ConnectorException {
        ContainmentInfo ci;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContentTypes - " + type);
        }
        if ((ci = (ContainmentInfo)this.containmentCache.get(type)) == null) {
            ci = this.updateContainmentCache(type);
        }
        if (ci == null) {
            this._shell.setAndThrowScriptingException("WASX7086E", "Unable to find relationship info for " + type, new Object[]{type});
        }
        Properties ret = ci.getChildren();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContentTypes");
        }
        return ret;
    }

    private ContainmentInfo updateContainmentCache(String type) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateContainmentCache - " + type);
        }
        AttributeList aList = this.configServiceProxy.getRelationshipsMetaInfo(type);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "got back relationships metainfo - size " + (aList == null ? "null" : Integer.toString(aList.size())));
        }
        ContainmentInfo ci = new ContainmentInfo(type);
        block0: for (int i = 0; i < aList.size(); ++i) {
            Attribute a;
            int j;
            Attribute at = (Attribute)aList.get(i);
            AttributeList al = (AttributeList)at.getValue();
            String name = at.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name of Attr is " + name);
            }
            if (name.equals("parent")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found a parent!");
                }
                for (j = 0; j < al.size(); ++j) {
                    a = (Attribute)al.get(j);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "name of sub attr is " + a.getName());
                    }
                    if (!a.getName().equals("_Attribute_MetaInfo_Type")) continue;
                    ci.addParentTypes((ArrayList)a.getValue());
                    continue block0;
                }
                continue;
            }
            for (j = 0; j < al.size(); ++j) {
                a = (Attribute)al.get(j);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name of sub attr is " + a.getName());
                }
                if (!a.getName().equals("_Attribute_MetaInfo_Type")) continue;
                ci.addChild((String)a.getValue(), name);
                if (!tc.isDebugEnabled()) continue block0;
                Tr.debug(tc, "val: " + a.getValue());
                continue block0;
            }
        }
        this.containmentCache.put(type, ci);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateContainmentCache");
        }
        return ci;
    }

    public void attrNameValidityCheck(String type, String[] attrs) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attrNameValidityCheck - " + type);
        }
        if (attrs == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "attrNameValidityCheck - null");
            }
            return;
        }
        Vector v = this.getFlatAttributeMap(type);
        StringBuffer bad = new StringBuffer();
        boolean errors = false;
        for (int i = 0; i < attrs.length; ++i) {
            String aName = attrs[i];
            boolean found = false;
            for (int j = 0; j < v.size(); ++j) {
                AttrInfo ai = (AttrInfo)v.get(j);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "current: " + aName + "; matching with: " + ai.getName());
                }
                if (!aName.equals(ai.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (bad.length() > 0) {
                bad.append(" ");
            }
            bad.append(aName);
            errors = true;
        }
        if (errors) {
            this._shell.setAndThrowScriptingException("WASX7080E", "Invalid attributes specified.", new Object[]{type, bad.toString()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attrNameValidityCheck");
        }
    }

    private Hashtable getAttributeCacheForType(String type) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeCacheForType - " + type);
        }
        if (!this.typeToAttributeMap.containsKey(type)) {
            if (tc.isEntryEnabled()) {
                Tr.event(tc, "type " + type + " not in map; get meta info...");
            }
            AttributeList aList = this.configServiceProxy.getAttributesMetaInfo(type);
            if (tc.isEntryEnabled()) {
                Tr.event(tc, "got metainfo for type " + type);
            }
            this.convertMetadataToAttrInfoCache(type, aList);
        }
        Hashtable attrs = (Hashtable)this.typeToAttributeMap.get(type);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeCacheForType");
        }
        return attrs;
    }

    private void convertMetadataToAttrInfoCache(String type, AttributeList aList) throws ScriptingException, AdminException, ConnectorException {
        block12: {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "convertMetadataToAttrCacheInfo " + type);
                }
                Hashtable<String, AttrInfo> allAttrs = new Hashtable<String, AttrInfo>();
                Vector<AttrInfo> flatAttrs = new Vector<AttrInfo>();
                if (aList == null) break block12;
                if (tc.isEntryEnabled()) {
                    Tr.event(tc, "Size of AttributeList is " + aList.size());
                }
                for (int i = 0; i < aList.size(); ++i) {
                    AttrInfo aInfo;
                    block13: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Dealing with attribute: " + ((Attribute)aList.get(i)).getName());
                        }
                        AttributeList attr = (AttributeList)((Attribute)aList.get(i)).getValue();
                        aInfo = this.createAttrInfo(attr);
                        if (tc.isEntryEnabled()) {
                            Tr.event(tc, "Created attr info for " + aInfo.getName());
                        }
                        if (aInfo.isObject()) {
                            try {
                                this.addEmbeddedInfo(aInfo);
                            }
                            catch (Exception e) {
                                if (!tc.isEntryEnabled()) break block13;
                                Tr.event(tc, "Caught exception adding embedded info.");
                            }
                        }
                    }
                    if (aInfo.hasSubtypes() && !aInfo.isReference()) {
                        this.mapSubtypes(type, aInfo);
                    }
                    allAttrs.put(aInfo.getName(), aInfo);
                    flatAttrs.add(aInfo);
                }
                this.typeToAttributeMap.put(type, allAttrs);
                this.flatAttributeMap.put(type, flatAttrs);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ScriptingException(e.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertmetadataToAttrCacheInfo");
        }
    }

    private void addEmbeddedInfo(AttrInfo aInfo) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEmbeddedInfo - " + aInfo.getType());
        }
        AttributeList embeddedAL = null;
        if (this.flatAttributeMap.containsKey(aInfo.getType())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addEmbeddedInfo - already done");
            }
            return;
        }
        this.flatAttributeMap.put(aInfo.getType(), "dummy");
        try {
            if (!aInfo.getType().equals("Boolean")) {
                embeddedAL = this.configServiceProxy.getAttributesMetaInfo(aInfo.getType());
            }
        }
        catch (Exception ex) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.event(tc, "got meta info for " + aInfo.getType());
        }
        Vector<AttrInfo> flatAttrs = new Vector<AttrInfo>();
        if (!aInfo.getType().equals("Boolean")) {
            for (int i = 0; i < embeddedAL.size(); ++i) {
                AttributeList innerA = (AttributeList)((Attribute)embeddedAL.get(i)).getValue();
                AttrInfo innerInfo = this.createAttrInfo(innerA);
                if (tc.isEntryEnabled()) {
                    Tr.event(tc, "Created attr info for " + innerInfo.getName());
                }
                if (innerInfo.isObject()) {
                    this.addEmbeddedInfo(innerInfo);
                }
                if (innerInfo.hasSubtypes()) {
                    this.mapSubtypes(aInfo.getType(), innerInfo);
                }
                aInfo.addContained(innerInfo.getName(), innerInfo);
                flatAttrs.add(innerInfo);
            }
        }
        this.flatAttributeMap.put(aInfo.getType(), flatAttrs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEmbeddedInfo - " + aInfo.getType());
        }
    }

    private void mapSubtypes(String parentType, AttrInfo aInfo) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapSubtypes - " + parentType);
        }
        ArrayList subtypes = aInfo.getSubtypes();
        String attrName = aInfo.getName();
        for (int i = 0; i < subtypes.size(); ++i) {
            Object subtype;
            String key = (String)subtypes.get(i) + ":" + parentType;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding to subtypeMap: " + key + " = " + attrName);
            }
            if ((subtype = this.subtypeMap.get(key)) != null) {
                if (subtype instanceof Vector) {
                    if (((Vector)subtype).contains(attrName)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Existing key found with value " + (Vector)subtype);
                    }
                    ((Vector)subtype).addElement(attrName);
                    this.subtypeMap.put(key, subtype);
                    continue;
                }
                if (!(subtype instanceof String) || attrName.equals(subtype)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Existing key found with value " + (String)subtype);
                }
                Vector<String> vec = new Vector<String>();
                vec.addElement((String)subtype);
                vec.addElement(attrName);
                this.subtypeMap.put(key, vec);
                continue;
            }
            this.subtypeMap.setProperty(key, attrName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapSubtypes");
        }
    }

    private Object getSubtype(String parentType, String containedType) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubtype - " + parentType + " " + containedType);
        }
        Vector v = this.getFlatAttributeMap(parentType);
        Object ret = this.subtypeMap.get(containedType + ":" + parentType);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubtype - " + ret);
        }
        return ret;
    }

    public void dumpTypeToAttributeCache() {
        Enumeration keys = this.typeToAttributeMap.keys();
        while (keys.hasMoreElements()) {
            String type = (String)keys.nextElement();
            System.out.println("Type: " + type);
            System.out.println("-------------------------------");
            System.out.println("");
            Hashtable attrs = (Hashtable)this.typeToAttributeMap.get(type);
            if (attrs == null) continue;
            Enumeration names = attrs.keys();
            while (names.hasMoreElements()) {
                this.dumpAttrInfo((AttrInfo)attrs.get(names.nextElement()), 0);
            }
        }
    }

    private void dumpAttrInfo(AttrInfo attr, int indent) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            buf.append(" ");
        }
        buf.append(attr.getName());
        buf.append("\t");
        buf.append(attr.getType());
        buf.append("\t");
        Object dv = attr.defaultValue();
        buf.append(dv != null ? attr.defaultValue().toString() : "\t");
        buf.append("\t");
        buf.append(attr.isObject());
        buf.append("\t");
        buf.append(attr.isReference());
        buf.append("\t");
        buf.append(attr.isCollection());
        Hashtable p = attr.enumInfo();
        if (p != null) {
            buf.append("\n\t");
            Enumeration e = p.keys();
            while (e.hasMoreElements()) {
                String nm = (String)e.nextElement();
                buf.append(nm);
                buf.append(":");
                buf.append(p.get(nm).toString());
                if (!e.hasMoreElements()) continue;
                buf.append(", ");
            }
        }
        System.out.println(buf.toString());
        if (attr.isObject()) {
            Hashtable attrs = attr.getContained();
            Enumeration names = attrs.keys();
            while (names.hasMoreElements()) {
                this.dumpAttrInfo((AttrInfo)attrs.get(names.nextElement()), indent + 2);
            }
        }
    }

    public void dumpFlatAttrCache() {
        Enumeration keys = this.flatAttributeMap.keys();
        while (keys.hasMoreElements()) {
            String type = (String)keys.nextElement();
            System.out.println("Type: " + type);
            System.out.println("-------------------------------");
            System.out.println("");
            StringBuffer buf = new StringBuffer();
            Vector v = (Vector)this.flatAttributeMap.get(type);
            for (int i = 0; i < v.size(); ++i) {
                AttrInfo ai = (AttrInfo)v.get(i);
                buf.append(ai.getName());
                if (i >= v.size()) continue;
                buf.append(" ");
            }
            System.out.println(buf.toString());
        }
    }

    public void dumpContainmentCache() {
        Enumeration keys = this.containmentCache.keys();
        while (keys.hasMoreElements()) {
            String type = (String)keys.nextElement();
            System.out.println("Type: " + type);
            System.out.println("-------------------------------");
            System.out.println("");
        }
    }

    private AttrInfo createAttrInfo(AttributeList attr) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAttrInfo");
        }
        String name = null;
        String type = null;
        boolean object = false;
        boolean reference = false;
        Hashtable enuminfo = null;
        Object defaultval = null;
        boolean collection = false;
        boolean subtypes = false;
        List listOfSubtypes = null;
        boolean required = false;
        String start = null;
        String deprecated = null;
        String removed = null;
        for (int i = 0; i < attr.size(); ++i) {
            Boolean temp;
            String attrName = ((Attribute)attr.get(i)).getName();
            if (((Attribute)attr.get(i)).getName().equals("_Attribute_MetaInfo_Name")) {
                name = (String)((Attribute)attr.get(i)).getValue();
                continue;
            }
            if (((Attribute)attr.get(i)).getName().equals("_Attribute_MetaInfo_Type")) {
                type = (String)((Attribute)attr.get(i)).getValue();
                continue;
            }
            if (((Attribute)attr.get(i)).getName().equals("_Attribute_MetaInfo_Subtypes")) {
                subtypes = true;
                listOfSubtypes = (List)((Attribute)attr.get(i)).getValue();
                continue;
            }
            if (((Attribute)attr.get(i)).getName().equals("_Attribute_MetaInfo_Default_Value")) {
                defaultval = ((Attribute)attr.get(i)).getValue();
                continue;
            }
            if (((Attribute)attr.get(i)).getName().equals("_Attribute_MetaInfo_Is_Object")) {
                temp = (Boolean)((Attribute)attr.get(i)).getValue();
                object = temp;
                continue;
            }
            if (((Attribute)attr.get(i)).getName().equals("_Attribute_MetaInfo_Is_Reference")) {
                temp = (Boolean)((Attribute)attr.get(i)).getValue();
                reference = temp;
                continue;
            }
            if (((Attribute)attr.get(i)).getName().equals("_Attribute_MetaInfo_Is_Collection")) {
                temp = (Boolean)((Attribute)attr.get(i)).getValue();
                collection = temp;
                continue;
            }
            if (((Attribute)attr.get(i)).getName().equals("_Attribute_MetaInfo_Enum_Info")) {
                AttributeList enumAList = (AttributeList)((Attribute)attr.get(i)).getValue();
                enuminfo = this.createEnumInfo(enumAList);
                continue;
            }
            if (((Attribute)attr.get(i)).getName().equals("_Attribute_MetaInfo_Is_Required")) {
                temp = (Boolean)((Attribute)attr.get(i)).getValue();
                required = temp;
                continue;
            }
            if (((Attribute)attr.get(i)).getName().equals("_Attribute_MetaInfo_Start")) {
                start = (String)((Attribute)attr.get(i)).getValue();
                continue;
            }
            if (((Attribute)attr.get(i)).getName().equals("_Attribute_MetaInfo_Removed")) {
                removed = (String)((Attribute)attr.get(i)).getValue();
                continue;
            }
            if (!((Attribute)attr.get(i)).getName().equals("_Attribute_MetaInfo_Deprecated")) continue;
            deprecated = (String)((Attribute)attr.get(i)).getValue();
        }
        AttrInfo info = new AttrInfo(name, type, object, reference, defaultval, enuminfo, collection, subtypes, required, start, removed, deprecated);
        if (subtypes) {
            info.addSubtypes(listOfSubtypes);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAttrInfo: " + name + "; type: " + type);
        }
        return info;
    }

    private Hashtable createEnumInfo(AttributeList aList) throws ScriptingException {
        Hashtable<String, Integer> ret = new Hashtable<String, Integer>();
        try {
            for (int i = 0; i < aList.size(); ++i) {
                String enumLiteral = ((Attribute)aList.get(i)).getName();
                Integer enumValue = (Integer)((Attribute)aList.get(i)).getValue();
                ret.put(enumLiteral, enumValue);
            }
        }
        catch (Exception e) {
            this._shell.setAndThrowScriptingException("WASX7081E", "Error obtaining enum information.", new Object[]{e.toString()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEnumInfo");
        }
        return ret;
    }

    public String[] getAttributeNamesForType(String type) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeNamesForType " + type);
        }
        Hashtable attrs = this.getAttributeCacheForType(type);
        String[] sarray = new String[attrs.size()];
        int j = 0;
        Enumeration vEnum = attrs.keys();
        while (vEnum.hasMoreElements()) {
            StringBuffer buf = new StringBuffer();
            AttrInfo attr = (AttrInfo)attrs.get((String)vEnum.nextElement());
            if (attr.getRemoved() != null && !attr.getRemoved().equals("")) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "attribute " + attr.getName() + " tagged as removed. Skipping this attribute");
                continue;
            }
            buf.append(attr.getName());
            buf.append(" ");
            buf.append(attr.getDecoratedType());
            sarray[j] = buf.toString();
            ++j;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeNamesForType " + type);
        }
        return sarray;
    }

    public boolean isCollectionReln(String containingType, String relname) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCollectionReln : " + containingType + " " + relname);
        }
        Vector v = this.getFlatAttributeMap(containingType);
        boolean ret = false;
        for (int i = 0; i < v.size(); ++i) {
            if (!relname.equals(((AttrInfo)v.get(i)).getName())) continue;
            if (((AttrInfo)v.get(i)).isCollection()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, relname + " is a collection.");
                }
                ret = true;
                break;
            }
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, relname + " is not a collection.");
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCollectionReln");
        }
        return ret;
    }

    public String findAttrNameForType(String containingType, String memberType) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findAttrNameForType : " + memberType + " in " + containingType);
        }
        Vector v = this.getFlatAttributeMap(containingType);
        String ret = null;
        boolean ambiguous = false;
        StringBuffer badstuff = new StringBuffer();
        try {
            for (int i = 0; i < v.size(); ++i) {
                if (!memberType.equals(((AttrInfo)v.get(i)).getType())) continue;
                if (ret != null) {
                    if (!ambiguous) {
                        badstuff.append(ret);
                        badstuff.append(" ");
                    }
                    ambiguous = true;
                    badstuff.append(((AttrInfo)v.get(i)).getName());
                    badstuff.append(" ");
                }
                ret = ((AttrInfo)v.get(i)).getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ScriptingException(e.toString());
        }
        if (ret == null) {
            Object type = this.getSubtype(containingType, memberType);
            if (type instanceof Vector) {
                if (((Vector)type).size() > 1) {
                    ambiguous = true;
                }
            } else if (type instanceof String) {
                ret = (String)type;
            }
        }
        if (ambiguous) {
            this._shell.setAndThrowScriptingException("WASX7082E", "Found ambiguous type in the model.", new Object[]{containingType, memberType, badstuff.toString()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findAttrNameForType - " + ret);
        }
        return ret;
    }

    public String findContentNameForType(String containingType, String memberType) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findContentNameForType : " + memberType + " in " + containingType);
        }
        String type = null;
        ContainmentInfo ci = (ContainmentInfo)this.containmentCache.get(containingType);
        if (ci == null) {
            ci = this.updateContainmentCache(containingType);
        }
        if (ci == null) {
            this._shell.setAndThrowScriptingException("WASX7086E", "Unable to find relationship info for " + containingType, new Object[]{containingType});
        }
        Properties kids = ci.getChildren();
        type = kids.getProperty(memberType);
        if (tc.isDebugEnabled()) {
            Enumeration<?> pnames = kids.propertyNames();
            while (pnames.hasMoreElements()) {
                String pname = (String)pnames.nextElement();
                Tr.debug(tc, "Propnames: " + pname + "; value: " + kids.getProperty(pname));
            }
            Tr.debug(tc, "memberType is " + memberType);
        }
        if (type == null) {
            type = this.findAttrNameForType(containingType, memberType);
        }
        if (type == null) {
            this._shell.setAndThrowScriptingException("WASX7129E", "Cannot create objects of type " + memberType + " in parents of type " + containingType, new Object[]{memberType, containingType});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findContentNameForType - " + type);
        }
        return type;
    }

    public Vector getFlatAttributeMap(String containingType) throws ScriptingException, AdminException, ConnectorException {
        Vector v;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFlatAttributeMap - " + containingType);
        }
        if ((v = (Vector)this.flatAttributeMap.get(containingType)) == null || v.size() == 0) {
            Hashtable dummy = this.getAttributeCacheForType(containingType);
            v = (Vector)this.flatAttributeMap.get(containingType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFlatAttributeMap");
        }
        return v;
    }

    public void getCorrectError(String containingType, String memberType, String nameInParent) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCorrectError : " + memberType + " in " + containingType + " with " + nameInParent);
        }
        String type = null;
        boolean correctType = false;
        boolean correctAttr = false;
        ContainmentInfo ci = (ContainmentInfo)this.containmentCache.get(containingType);
        if (ci == null) {
            ci = this.updateContainmentCache(containingType);
        }
        if (ci == null) {
            this._shell.setAndThrowScriptingException("WASX7086E", "Unable to find relationship info for " + containingType, new Object[]{containingType});
        }
        Properties kids = ci.getChildren();
        type = kids.getProperty(memberType);
        if (tc.isDebugEnabled()) {
            Enumeration<?> pnames = kids.propertyNames();
            while (pnames.hasMoreElements()) {
                String pname = (String)pnames.nextElement();
                Tr.debug(tc, "Propnames: " + pname + "; value: " + kids.getProperty(pname));
            }
            Tr.debug(tc, "type is " + type);
        }
        if (type == null) {
            Vector v = this.getFlatAttributeMap(containingType);
            block1: for (int i = 0; i < v.size(); ++i) {
                AttrInfo attrI = (AttrInfo)v.get(i);
                if (!nameInParent.equals(attrI.getName())) continue;
                correctAttr = true;
                ArrayList subtypes = attrI.getSubtypes();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "subtypes are " + subtypes);
                }
                if (subtypes == null) {
                    String attrType = attrI.getType();
                    if (!memberType.equals(attrType)) continue;
                    correctType = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "correctType is " + attrType);
                    }
                    break;
                }
                for (int j = 0; j < subtypes.size(); ++j) {
                    if (!memberType.equals(subtypes.get(j))) continue;
                    correctType = true;
                    if (!tc.isDebugEnabled()) continue block1;
                    Tr.debug(tc, "correct subtype is " + subtypes.get(j));
                    continue block1;
                }
            }
        } else {
            correctType = true;
            correctAttr = true;
        }
        if (!correctType && correctAttr) {
            this._shell.setAndThrowScriptingException("WASX7129E", "Cannot create objects of type " + memberType + " in parents of type " + containingType, new Object[]{memberType, containingType});
        }
        if (!correctAttr) {
            this._shell.setAndThrowScriptingException("WASX7080E", "Invalid attributes specified.", new Object[]{containingType, nameInParent});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCorrectError");
        }
    }
}

