/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.logging.MessageConverter;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.ScriptingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.StringReader;
import java.util.Locale;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class MessageLookup {
    protected static final TraceComponent tc = Tr.register(MessageLookup.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static String directory = null;

    public static boolean initializeMessageDB(Locale locale) {
        int countryIndex;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeMessageDB ", new Object[]{locale});
        }
        boolean result = false;
        String loc = locale.toString();
        directory = MessageLookup.getDirectory(loc);
        if (directory == null && (countryIndex = loc.lastIndexOf(95)) > 0) {
            loc = loc.substring(0, countryIndex);
            directory = MessageLookup.getDirectory(loc);
        }
        if (directory == null) {
            directory = MessageLookup.getDirectory("en");
        }
        if (directory != null) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeMessageDB");
        }
        return result;
    }

    private static String getDirectory(String loc) {
        File f;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDirectory " + loc);
        }
        String result = null;
        String dir = System.getProperty("was.install.root") + File.separator + "properties" + File.separator + "messages" + File.separator + loc;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Directory is " + directory);
        }
        if ((f = new File(dir)).exists()) {
            result = dir;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDirectory " + directory);
        }
        return result;
    }

    public static String getMessages(AbstractShell shell, String id) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessages " + id);
        }
        shell.setLastException(null);
        StringBuffer buf = new StringBuffer();
        if (directory == null) {
            shell.setAndThrowScriptingException("WASX7364E", "no help available", new Object[]{id});
        }
        try {
            File dir = new File(directory);
            String[] files = dir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".xml");
                }
            });
            String convertedId = id;
            if (MessageConverter.determineMsgType(id) == MessageConverter.MESSAGE_ID_V6) {
                convertedId = MessageConverter.convert(id, MessageConverter.CONVERSION_TYPE_WASV6_TO_WASV5);
            }
            for (int i = 0; i < files.length; ++i) {
                FileInputStream in = new FileInputStream(directory + File.separator + files[i]);
                byte[] buffer = new byte[in.available()];
                in.read(buffer);
                String str = MessageLookup.getMessage(new String(buffer), convertedId);
                in.close();
                if (str == null) continue;
                String explanation = MessageLookup.getExplanation(str);
                String useraction = MessageLookup.getUserAction(str);
                buf.append(shell.getFormattedMessage("WASX7362I", new Object[]{explanation.trim(), useraction.trim()}, "Explanation: {0}\n User action: {1}\n"));
                break;
            }
        }
        catch (Exception e) {
            shell.setLastException(e);
            throw new ScriptingException(e.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessages");
        }
        return buf.toString();
    }

    private static String getMessage(String str, String id) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessage " + id);
        }
        String result = null;
        int firstIndex = str.indexOf("<Message ID=\"" + id);
        if (firstIndex != -1) {
            String newStr = str.substring(firstIndex);
            int endIndex = newStr.indexOf("</Message>");
            result = newStr.substring(0, endIndex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessage");
        }
        return result;
    }

    private static String getExplanation(String str) {
        int endIndex;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExplanation " + str);
        }
        String explanation = null;
        int firstIndex = str.indexOf("<Explanation>");
        if (firstIndex != -1 && (endIndex = str.indexOf("</Explanation>")) != -1) {
            String temp = str.substring(firstIndex, endIndex);
            int msgIndex = temp.indexOf(">");
            explanation = temp.substring(msgIndex + 1);
        }
        Tr.debug(tc, "explanation before: " + explanation);
        StringBuffer buffer = new StringBuffer(13 + explanation.length() + 14);
        buffer.append("<Explanation>");
        buffer.append(explanation);
        buffer.append("</Explanation>");
        final StringBuffer result = new StringBuffer(explanation.length());
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(new DefaultHandler(){

                public void characters(char[] ch, int start, int length) throws SAXException {
                    result.append(new String(ch, start, length));
                }
            });
            reader.parse(new InputSource(new StringReader(buffer.toString())));
        }
        catch (Exception e) {
            return "unknown";
        }
        Tr.debug(tc, "explanation after " + result.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExplanation");
        }
        return result.toString();
    }

    private static String getUserAction(String str) {
        int endIndex;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserAction " + str);
        }
        String useraction = null;
        int firstIndex = str.indexOf("<UserResponse>");
        if (firstIndex != -1 && (endIndex = str.indexOf("</UserResponse>")) != -1) {
            String temp = str.substring(firstIndex, endIndex);
            int msgIndex = temp.indexOf(">");
            useraction = temp.substring(msgIndex + 1);
        }
        Tr.debug(tc, "useraction before: " + useraction);
        StringBuffer buffer = new StringBuffer(14 + useraction.length() + 15);
        buffer.append("<UserResponse>");
        buffer.append(useraction);
        buffer.append("</UserResponse>");
        final StringBuffer result = new StringBuffer(useraction.length());
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(new DefaultHandler(){

                public void characters(char[] ch, int start, int length) throws SAXException {
                    result.append(new String(ch, start, length));
                }
            });
            reader.parse(new InputSource(new StringReader(buffer.toString())));
        }
        catch (Exception e) {
            return "unknown";
        }
        Tr.debug(tc, "useraction after " + result.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserAction");
        }
        return result.toString();
    }
}

