/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.exception.AppRefException;
import com.ibm.ws.exception.WsException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class ExceptionSupport {
    private static TraceComponent tc = Tr.register(ExceptionSupport.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static ResourceBundle bundle = null;
    private static final String nl = System.getProperty("line.separator");

    public static void setBundle(ResourceBundle b) {
        bundle = b;
    }

    public static String getMessage(Throwable e, String specialPrefix) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessage");
        }
        Object debugSource = null;
        String msg = null;
        if (e == null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMessage - null");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "class is " + e.getClass().getName());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "tostring is " + e.toString());
        }
        Throwable nested = null;
        String currentMessage = null;
        if (e instanceof AppRefException) {
            msg = ExceptionSupport.decodeAppRefException((AppRefException)e);
        } else if (e instanceof WsException) {
            nested = ((WsException)e).getCause();
            if (nested != null) {
                msg = ExceptionSupport.getMessage(nested, specialPrefix);
            } else {
                currentMessage = e.getMessage();
                if (specialPrefix != null && msg != null && !msg.startsWith(specialPrefix)) {
                    currentMessage = e.toString();
                }
                if (currentMessage == null) {
                    currentMessage = e.toString();
                }
            }
        } else if (e instanceof MBeanException) {
            nested = ((MBeanException)e).getTargetException();
            msg = ExceptionSupport.getMessage(nested, specialPrefix);
        } else if (e instanceof AppDeploymentException) {
            currentMessage = ((AppDeploymentException)e).toString();
            nested = ((AppDeploymentException)e).getEmbeddedEx();
            if (nested != null) {
                msg = ExceptionSupport.getMessage(nested, specialPrefix);
            }
        } else if (e instanceof ReflectionException) {
            nested = ((ReflectionException)e).getTargetException();
            msg = ExceptionSupport.getMessage(nested, specialPrefix);
        } else if (e instanceof JMException) {
            currentMessage = e.getMessage();
            if (currentMessage == null) {
                currentMessage = e.toString();
            }
        } else if (e instanceof RuntimeErrorException) {
            nested = ((RuntimeErrorException)e).getTargetError();
            msg = ExceptionSupport.getMessage(nested, specialPrefix);
        } else if (e instanceof RuntimeMBeanException) {
            nested = ((RuntimeMBeanException)e).getTargetException();
            msg = ExceptionSupport.getMessage(nested, specialPrefix);
            if (msg == null) {
                msg = ExceptionSupport.decodeRuntimeException((RuntimeException)nested);
            }
        } else if (e instanceof RuntimeOperationsException) {
            nested = ((RuntimeOperationsException)e).getTargetException();
            msg = ExceptionSupport.getMessage(nested, specialPrefix);
        } else if (e instanceof JMRuntimeException) {
            currentMessage = e.getMessage();
            if (currentMessage == null) {
                currentMessage = e.toString();
            }
        } else {
            currentMessage = e.toString();
        }
        StringBuffer buf = new StringBuffer();
        buf.append(e.getClass().getName());
        if (currentMessage != null) {
            buf.append(": ");
            buf.append(currentMessage);
        }
        buf.append(nl);
        if (msg != null && !msg.trim().equals("")) {
            buf.append(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessage " + buf.toString());
        }
        return buf.toString();
    }

    public static String getDiagnosticInfo(Exception e) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDiagnosticInfo");
        }
        Object debugSource = null;
        Object msg = null;
        if (e == null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getDiagnosticInfo - null");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "class is " + e.getClass().getName());
        }
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static String decodeRuntimeException(RuntimeException ex) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decodeRuntimeException");
        }
        String msg = null;
        String ret = null;
        Object[] args = null;
        if (ex instanceof UnsupportedOperationException) {
            msg = bundle.getString("WASX7130E");
        } else {
            msg = bundle.getString("WASX7131E");
            args = new Object[]{ex.getClass().getName()};
        }
        ret = MessageFormat.format(msg, args);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decodeRuntimeException - " + ret);
        }
        return ret;
    }

    private static String decodeAppRefException(AppRefException ex) {
        String msg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decodeRuntimeException");
        }
        StringBuffer buf = new StringBuffer();
        String aList = ex.getAppListString();
        String oList = ex.getObjectListString();
        if (!aList.equals("")) {
            msg = bundle.getString("WASX7398E");
            buf.append(msg);
            buf.append(aList);
        }
        if (!oList.equals("")) {
            msg = bundle.getString("WASX7399E");
            buf.append(msg);
            buf.append(oList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decodeAppRefException - " + buf.toString());
        }
        return buf.toString();
    }
}

