/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.ScriptingException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.ObjectName;

public class ConfigNameCache {
    private static TraceComponent tc = Tr.register(ConfigNameCache.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private Hashtable cache = null;
    private int cacheSize = 0;
    private ConfigHelper configHelper = null;
    private Session session;
    private ConfigService configServiceProxy = null;

    public ConfigNameCache(ConfigHelper helper, int size, Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigNameCache");
        }
        this.configHelper = helper;
        this.cacheSize = size;
        this.session = session;
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigNameCache");
        }
    }

    protected void reconnect() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reconnect");
        }
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reconnect");
        }
    }

    private void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.cache = new Hashtable(this.cacheSize);
        this.configServiceProxy = AdminConfigClient.getConfigService();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void add(String name, String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add - " + name);
        }
        if (this.cache.contains(name) && type.equals((String)this.cache.get(name))) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "add - in cache already");
            }
            return;
        }
        name = this.configHelper.cleanString(name);
        this.cache.put(name, type);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add");
        }
    }

    public String getType(String name) throws ScriptingException, AdminException, ConnectorException {
        String ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getType");
        }
        if ((ret = (String)this.cache.get(name)) == null) {
            ObjectName tempON = this.configHelper.stringToObjectName(name);
            ObjectName[] oList = this.configServiceProxy.queryConfigObjects(this.session, null, tempON, null);
            for (int i = 0; oList != null && i < oList.length; ++i) {
                ObjectName[] tList;
                ConfigDataId id;
                ret = oList[i].getKeyProperty("_Websphere_Config_Data_Type");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found type " + ret + " for name " + name);
                }
                if ((id = ConfigServiceHelper.getConfigDataId(oList[i])).isResolved()) continue;
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Id is not resolved; need to make another call.");
                }
                if ((tList = this.configServiceProxy.queryConfigObjects(this.session, null, oList[i], null)) == null || tList.length != 1) {
                    throw new ScriptingException("Cannot get resolved confid id" + id);
                }
                name = tList[0].getKeyProperty("_Websphere_Config_Data_Id");
            }
            if (ret != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding: " + name + " as type " + ret);
                }
                this.add(name, ret);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getType");
        }
        return ret;
    }

    public void dumpNameCache() {
        Enumeration en = this.cache.keys();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String val = (String)this.cache.get(name);
            System.out.println(name + "\t" + val);
        }
    }
}

