/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.websphere.management.application.AppNotification;
import java.io.Serializable;
import java.util.Properties;
import javax.management.Notification;
import javax.management.NotificationFilter;

public class AppNotificationFilter
implements NotificationFilter,
Serializable {
    private static final long serialVersionUID = -4954329529798437349L;
    private String appName;
    private String relevantType;
    private String handbackId = null;

    public AppNotificationFilter(String name, String type) {
        this.appName = name;
        this.relevantType = type;
    }

    public AppNotificationFilter(String name, String type, String id) {
        this.appName = name;
        this.relevantType = type;
        this.handbackId = id;
    }

    public boolean isNotificationEnabled(Notification ntfyObj) {
        String type = ntfyObj.getType();
        boolean ret = false;
        if (type.equals(this.relevantType)) {
            Object ud = ntfyObj.getUserData();
            if (ud instanceof AppNotification) {
                Properties p = ((AppNotification)ud).props;
                String notifAppName = p.getProperty("appname");
                String notifHandBackId = p.getProperty("HandBackForClient");
                ret = this.appName.equals(notifAppName) ? true : notifHandBackId != null && notifHandBackId.equals(this.handbackId);
            } else {
                ret = false;
            }
        }
        return ret;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getRelevantType() {
        return this.relevantType;
    }
}

