/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.configservice.SessionPropertyConstants;
import com.ibm.websphere.management.configservice.ValidationResult;
import com.ibm.websphere.management.configservice.tasks.InstallRARTask;
import com.ibm.websphere.management.configservice.tasks.ServerClusterTasks;
import com.ibm.websphere.management.configservice.tasks.UninstallRARTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.AppRefException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.util.PlatformUtils;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminControlClient;
import com.ibm.ws.scripting.ArrayListAttrHelper;
import com.ibm.ws.scripting.AttrHelper;
import com.ibm.ws.scripting.AttrInfo;
import com.ibm.ws.scripting.BaseAttrHelper;
import com.ibm.ws.scripting.BooleanAttrHelper;
import com.ibm.ws.scripting.CommonScriptingObject;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.EnumArrayAttrHelper;
import com.ibm.ws.scripting.EnumAttrHelper;
import com.ibm.ws.scripting.ExceptionSupport;
import com.ibm.ws.scripting.HelpSupport;
import com.ibm.ws.scripting.IntegerArrayAttrHelper;
import com.ibm.ws.scripting.IntegerAttrHelper;
import com.ibm.ws.scripting.LongAttrHelper;
import com.ibm.ws.scripting.MetaInfoCache;
import com.ibm.ws.scripting.ObjectAttrHelper;
import com.ibm.ws.scripting.ObjectNameArrayAttrHelper;
import com.ibm.ws.scripting.ObjectNameAttrHelper;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.StringArrayAttrHelper;
import com.ibm.ws.scripting.types.CommonSecureInteropTSHelper;
import com.ibm.ws.scripting.types.HTTPTransportTSHelper;
import com.ibm.ws.scripting.types.IIOPTransportTSHelper;
import com.ibm.ws.scripting.types.LDAPUserRegistryTSHelper;
import com.ibm.ws.scripting.types.PropertyTSHelper;
import com.ibm.ws.scripting.types.SOAPConnectorTSHelper;
import com.ibm.ws.scripting.types.SSLConfigTSHelper;
import com.ibm.ws.scripting.types.SecureSocketLayerTSHelper;
import com.ibm.ws.scripting.types.SecurityTSHelper;
import com.ibm.ws.scripting.types.TransportLayerTSHelper;
import com.ibm.ws.scripting.types.TypeSpecificHelper;
import com.ibm.ws.scripting.types.WASTopicConnectionFactoryTSHelper;
import com.ibm.ws.scripting.types.WebContainerTSHelper;
import com.ibm.ws.util.ImplFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class AdminConfigClient
extends CommonScriptingObject {
    private static TraceComponent tc = Tr.register(AdminConfigClient.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static AdminConfigClient _self = null;
    private Session _session = null;
    private boolean overwriteOnSave = false;
    private Integer validationLevel = null;
    private boolean validationLevelChanged = true;
    private Boolean crossValidationEnabled = null;
    private boolean crossValidationEnabledChanged = true;
    private HashMap levelMapper = null;
    private PrintWriter validationWriter = null;
    private String validationOutputFileName = null;
    private int[] validationCounters = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String VALIDATION_FILE_PROP = "com.ibm.ws.scripting.validationOutput";
    private static final String VALIDATION_FILE_PROP_DEFAULT = "wsadmin.valout";
    private static final String VALIDATION_LEVEL_PROP = "com.ibm.ws.scripting.validationLevel";
    private static final Integer VALIDATION_LEVEL_PROP_DEFAULT = SessionPropertyConstants.HIGHEST_LEVEL_VALIDATION;
    private static final String VALIDATION_CROSS_PROP = "com.ibm.ws.scripting.crossDocumentValidationEnabled";
    private static final Boolean VALIDATION_CROSS_PROP_DEFAULT = Boolean.TRUE;
    private static final String CLUSTERTYPE = "ServerCluster";
    private static final String MEMBERTYPE = "ClusterMember";
    private static final String SERVERTYPE = "Server";
    private static final String NODETYPE = "Node";
    private MetaInfoCache metaCache = null;
    private ConfigNameCache nameCache = null;
    private static ConfigService configServiceProxy = null;
    private ServerClusterTasks clusterTasks = null;
    private static ArrayList validInstallRarOptions = null;
    private static ArrayList validUninstallRarOptions = null;
    protected static int returnCode = 0;
    private ConfigHelper configHelper = null;
    private static final int NAME_CACHE_SIZE = 20;
    private static final String ANONYMOUS = "Script";
    private Hashtable helperTable = null;
    private Hashtable typeSpecificHelperTable = null;
    private String S_Attribute = null;
    private String S_Type = null;
    private String S_Default = null;
    private static final int MARGIN = 32;

    public static AdminConfigClient getInstance() {
        return _self;
    }

    public static ConfigService getConfigService() {
        return configServiceProxy;
    }

    protected ConfigHelper getConfigHelper() {
        return this.configHelper;
    }

    public AdminConfigClient(AbstractShell shell) throws AdminException, ConnectorException {
        super(shell, null);
        File output;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AdminConfigClient");
        }
        _self = this;
        this.init();
        if (configServiceProxy != null) {
            String[] files = null;
            StringBuffer buf = new StringBuffer();
            try {
                files = configServiceProxy.getUnsavedChanges(this.getCurrentSession());
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        buf.append(files[i]);
                        buf.append(nl);
                    }
                }
            }
            catch (Exception ae) {
                String msg = ae.getMessage();
                if (msg != null && msg.startsWith("ADMN1211E")) {
                    configServiceProxy = null;
                    StringWriter sw = new StringWriter();
                    ae.printStackTrace(new PrintWriter(sw));
                    Tr.error(tc, ae.toString() + nl + sw.toString());
                    Tr.warning(tc, "WASX8025W");
                    System.out.println(this._shell.getFormattedMessage("WASX8025W", new Object[0], "AdminConfig object is not available"));
                }
                this._shell.setLastException(ae);
                String detail = ExceptionSupport.getMessage(ae, "WASX");
                if (detail == null) {
                    detail = ae.toString();
                }
                throw new ScriptingException(detail);
            }
            if (buf.length() > 0) {
                Tr.audit(tc, "WASX7240I", new Object[]{buf.toString()});
                this.reset();
            }
        }
        this.metaCache = MetaInfoCache.getInstance();
        this.metaCache.setShell(this._shell);
        this.configHelper = new ConfigHelper(this._shell, "WebSphere");
        this.nameCache = new ConfigNameCache(this.configHelper, 20, this.getCurrentSession());
        this.helperTable = new Hashtable();
        this.helperTable.put("String", new BaseAttrHelper(this.configHelper, this.nameCache, this._shell));
        this.helperTable.put("String*", new StringArrayAttrHelper(this.configHelper, this.nameCache, this._shell));
        BaseAttrHelper attrHelper = new IntegerAttrHelper(this.configHelper, this.nameCache, this._shell);
        this.helperTable.put("Integer", attrHelper);
        this.helperTable.put("int", attrHelper);
        attrHelper = new IntegerArrayAttrHelper(this.configHelper, this.nameCache, this._shell);
        this.helperTable.put("Integer*", attrHelper);
        this.helperTable.put("int*", attrHelper);
        attrHelper = new LongAttrHelper(this.configHelper, this.nameCache, this._shell);
        this.helperTable.put("Long", attrHelper);
        this.helperTable.put("long", attrHelper);
        attrHelper = new BooleanAttrHelper(this.configHelper, this.nameCache, this._shell);
        this.helperTable.put("Boolean", attrHelper);
        this.helperTable.put("boolean", attrHelper);
        this.helperTable.put("ENUM", new EnumAttrHelper(this.configHelper, this.nameCache, this._shell));
        this.helperTable.put("ENUM*", new EnumArrayAttrHelper(this.configHelper, this.nameCache, this._shell));
        this.helperTable.put("AttributeList", new ObjectAttrHelper(this.configHelper, this.nameCache, this._shell));
        this.helperTable.put("ArrayList", new ArrayListAttrHelper(this.configHelper, this.nameCache, this._shell));
        this.helperTable.put("ObjectName", new ObjectNameAttrHelper(this.configHelper, this.nameCache, this._shell));
        this.helperTable.put("ObjectName*", new ObjectNameArrayAttrHelper(this.configHelper, this.nameCache, this._shell));
        this.typeSpecificHelperTable = new Hashtable();
        this.typeSpecificHelperTable.put("WASTopicConnectionFactory", new WASTopicConnectionFactoryTSHelper(this, this._shell));
        this.typeSpecificHelperTable.put("MQTopicConnectionFactory", new WASTopicConnectionFactoryTSHelper(this, this._shell));
        this.typeSpecificHelperTable.put("Security", new SecurityTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("SSLConfig", new SSLConfigTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("SecureSocketLayer", new SecureSocketLayerTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("Property", new PropertyTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("TypedProperty", new PropertyTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("SOAPConnector", new SOAPConnectorTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("WebContainer", new WebContainerTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("HTTPTransport", new HTTPTransportTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("CommonSecureInterop", new CommonSecureInteropTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("SecurityProtocolConfig", new CommonSecureInteropTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("SecureAssociationService", new CommonSecureInteropTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("TransportLayer", new TransportLayerTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("IIOPTransport", new IIOPTransportTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("LDAPUserRegistry", new LDAPUserRegistryTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.levelMapper = new HashMap();
        this.levelMapper.put(SessionPropertyConstants.NO_VALIDATION, "NONE");
        this.levelMapper.put(SessionPropertyConstants.LOW_LEVEL_VALIDATION, "LOW");
        this.levelMapper.put(SessionPropertyConstants.MEDIUM_LEVEL_VALIDATION, "MEDIUM");
        this.levelMapper.put(SessionPropertyConstants.HIGH_LEVEL_VALIDATION, "HIGH");
        this.levelMapper.put(SessionPropertyConstants.HIGHEST_LEVEL_VALIDATION, "HIGHEST");
        this.validationOutputFileName = System.getProperty(VALIDATION_FILE_PROP);
        if (this.validationOutputFileName == null) {
            this.validationOutputFileName = VALIDATION_FILE_PROP_DEFAULT;
            String wasRoot = System.getProperty("server.root");
            if (wasRoot != null) {
                this.validationOutputFileName = wasRoot + File.separator + "logs" + File.separator + this.validationOutputFileName;
            }
        }
        if ((output = new File(this.validationOutputFileName)).exists() && !output.canWrite()) {
            this._shell.setAndThrowScriptingException("WASX7196E", "Cannot write to validation output file.", new Object[]{output.getAbsolutePath()});
        }
        FileOutputStream fos = null;
        try {
            if (!output.exists()) {
                output.createNewFile();
            }
            fos = new FileOutputStream(output);
        }
        catch (IOException ioe) {
            this._shell.setAndThrowScriptingException("WASX7197E", "IO error creating validation output file", new Object[]{this.validationOutputFileName, ioe.toString()});
        }
        OutputStreamWriter osw = new OutputStreamWriter(fos);
        this.validationWriter = new PrintWriter((Writer)new BufferedWriter(osw), true);
        String temp = System.getProperty(VALIDATION_LEVEL_PROP);
        if (temp == null) {
            this.validationLevel = VALIDATION_LEVEL_PROP_DEFAULT;
        } else {
            this.setValidationLevel(temp);
        }
        temp = System.getProperty(VALIDATION_CROSS_PROP);
        if (temp == null) {
            this.crossValidationEnabled = VALIDATION_CROSS_PROP_DEFAULT;
        } else {
            this.setCrossDocumentValidationEnabled(temp);
        }
        Tr.audit(tc, "WASX7208I", new Object[]{(String)this.levelMapper.get(this.validationLevel), this.crossValidationEnabled, this.validationOutputFileName});
        this.clusterTasks = new ServerClusterTasks(configServiceProxy);
        this.S_Attribute = _bundle.getString("HELP_STRING_ATTRIBUTE");
        this.S_Type = _bundle.getString("HELP_STRING_TYPE");
        this.S_Default = _bundle.getString("HELP_STRING_DEFAULT");
        validInstallRarOptions = new ArrayList();
        validInstallRarOptions.add("rar.name");
        validInstallRarOptions.add("rar.desc");
        validInstallRarOptions.add("rar.archivePath");
        validInstallRarOptions.add("rar.classpath");
        validInstallRarOptions.add("rar.nativePath");
        validInstallRarOptions.add("rar.threadPoolAlias");
        validInstallRarOptions.add("rar.propertiesSet");
        validInstallRarOptions.add("rar.isolatedClassLoader");
        validInstallRarOptions.add("rar.enableHASupport");
        validInstallRarOptions.add("rar.HACapability");
        validInstallRarOptions.add("endpoint");
        validInstallRarOptions.add("instance");
        validInstallRarOptions.add("no");
        validUninstallRarOptions = new ArrayList();
        validUninstallRarOptions.add("force");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AdminConfigClient");
        }
    }

    private void init() throws AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        if (_client == null) {
            if (this._shell.getConnectionType().equals("NONE")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating local config service");
                }
                Properties props = new Properties();
                props.put("location", "local");
                configServiceProxy = ConfigServiceFactory.getConfigService();
                if (configServiceProxy == null) {
                    configServiceProxy = ConfigServiceFactory.createConfigService(true, props);
                }
            } else {
                Tr.warning(tc, "WASX7198W", null);
                configServiceProxy = null;
            }
        } else {
            try {
                configServiceProxy = new ConfigServiceProxy(_client);
            }
            catch (InstanceNotFoundException mone) {
                Tr.warning(tc, "WASX7198W", null);
                configServiceProxy = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void doReconnect() throws AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doReconnect");
        }
        this.init();
        this.metaCache.reconnect();
        this.nameCache.reconnect();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doReconnect");
        }
    }

    public String help() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "help");
        }
        String msg = this._shell.getFormattedMessage("ADMINCONFIG_GENERAL_HELP", new Object[0], "no help available");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "help");
        }
        return msg;
    }

    public String help(String method2) {
        String key;
        String msg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "help - " + method2);
        }
        if ((msg = this._shell.getFormattedMessage(key = "ADMINCONFIG_HELP_" + method2.toUpperCase(), new Object[0], "No help available for " + method2)).startsWith("No help available")) {
            key = "WASX7084E";
            msg = this._shell.getFormattedMessage(key, new Object[]{method2}, "No help available for " + method2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "help");
        }
        return msg;
    }

    public String types(String pattern) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "types");
        }
        this._shell.setLastException(null);
        String ret = null;
        try {
            this.checkService();
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            HashSet<String> hs = new HashSet<String>();
            String[] sarray = this.metaCache.getTypes();
            if (sarray != null) {
                for (int i = 0; i < sarray.length; ++i) {
                    Tr.debug(tc, "sarray[i] " + sarray[i]);
                    if (pattern != null) {
                        try {
                            if (!sarray[i].matches(pattern) && !this.wildcardMatches(pattern, sarray[i])) continue;
                            Tr.debug(tc, "type matches pattern: " + sarray[i]);
                            hs.add(sarray[i]);
                        }
                        catch (PatternSyntaxException e) {
                            if (!this.wildcardMatches(pattern, sarray[i])) continue;
                            hs.add(sarray[i]);
                        }
                        continue;
                    }
                    hs.add(sarray[i]);
                }
            }
            ret = this._langutils.setToString(hs);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "types");
        }
        return ret;
    }

    public String types() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "types");
        }
        this._shell.setLastException(null);
        String ret = this.types(null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "types");
        }
        return ret;
    }

    public String listTemplates(String type) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listTemplates for type " + type);
        }
        String ret = this.listTemplates(type, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listTemplates for type " + type);
        }
        return ret;
    }

    public String listTemplates(String type, String match) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listTemplates", new Object[]{type, match});
        }
        this._shell.setLastException(null);
        String ret = null;
        this.checkService();
        try {
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            type = this.configHelper.cleanString(type);
            ObjectName[] oList = null;
            oList = configServiceProxy.queryTemplates(this.getCurrentSession(), type);
            HashSet<String> hs = new HashSet<String>();
            if (oList == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "oList is null!");
            }
            for (int i = 0; i < oList.length; ++i) {
                String dName = this.configHelper.getListingName(oList[i]);
                String objType = oList[i].getKeyProperty("_Websphere_Config_Data_Type");
                this.nameCache.add(dName, objType);
                if (match != null) {
                    String tmpName = null;
                    tmpName = dName.startsWith("\"") && dName.endsWith("\"") ? dName.substring(1, dName.length() - 1) : dName;
                    try {
                        if (dName.indexOf(match) < 0 && !tmpName.matches(match) && !this.wildcardMatches(match, tmpName)) continue;
                        hs.add(dName);
                    }
                    catch (PatternSyntaxException e) {
                        if (!this.wildcardMatches(match, tmpName)) continue;
                        hs.add(dName);
                    }
                    continue;
                }
                hs.add(dName);
            }
            ret = this._langutils.setToString(hs);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listTemplates");
        }
        return ret;
    }

    public String list(String type) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "list for type " + type);
        }
        this._shell.setLastException(null);
        type = this.configHelper.cleanString(type);
        String result = this.list(type, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "list for type " + type);
        }
        return result;
    }

    protected ObjectName[] internalList(String type, String scope, boolean resolve) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "internalList for type " + type + " in scope " + scope);
        }
        type = this.configHelper.cleanString(type);
        this.checkService();
        ObjectName[] oList = null;
        ObjectName typeON = null;
        ObjectName scopeON = null;
        Hashtable scopetable = null;
        if (scope != null) {
            scopetable = this.configHelper.parseObjectIdString(scope);
            String objectType = this.nameCache.getType(scope);
            if (objectType != null) {
                scopetable.put("_Websphere_Config_Data_Type", objectType);
            }
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        oList = null;
        table.put("_Websphere_Config_Data_Type", type);
        try {
            typeON = new ObjectName("WebSphere", table);
            if (scopetable != null) {
                scopeON = new ObjectName("WebSphere", scopetable);
            }
        }
        catch (MalformedObjectNameException ex) {
            Tr.event(tc, "Caught exception creating object name for " + type + "; exception: " + ex);
            String detail = ExceptionSupport.getMessage(ex, "WASX");
            if (detail == null) {
                detail = ex.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "About to call queryConfigObjects.");
        }
        oList = configServiceProxy.queryConfigObjects(this.getCurrentSession(), scopeON, typeON, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "back from call to queryConfigObjects.");
        }
        if (resolve) {
            Vector<ObjectName> newList = new Vector<ObjectName>();
            for (int i = 0; oList != null && i < oList.length; ++i) {
                ObjectName[] tList;
                ConfigDataId id = ConfigServiceHelper.getConfigDataId(oList[i]);
                if (id.isResolved()) {
                    newList.add(oList[i]);
                    continue;
                }
                if (type.equals(NODETYPE) && ("NodeAgent".equals(processType) || "ManagedProcess".equals(processType))) {
                    String displayName = oList[i].getKeyProperty("_Websphere_Config_Data_Display_Name");
                    AdminControlClient cl = AdminControlClient.getInstance();
                    String nodeName = cl.getNode();
                    if (!nodeName.equals(displayName)) {
                        if (!tc.isEventEnabled()) continue;
                        Tr.event(tc, "This is not the nodeAgent node; ignoring");
                        continue;
                    }
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Id is not resolved; need to make another call.");
                }
                if ((tList = configServiceProxy.queryConfigObjects(this.getCurrentSession(), null, oList[i], null)) == null || tList.length != 1) continue;
                newList.add(tList[0]);
            }
            oList = new ObjectName[newList.size()];
            oList = newList.toArray(oList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "internalList");
        }
        return oList;
    }

    protected String internalGetID(String configid) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "internalGetID", new Object[]{configid});
        }
        this.checkService();
        String id = new String();
        ObjectName trialON = null;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("_Websphere_Config_Data_Id", configid);
        try {
            trialON = new ObjectName("WebSphere", table);
        }
        catch (MalformedObjectNameException ex) {
            Tr.event(tc, "Caught exception creating object name for " + configid + "; exception: " + ex);
            String detail = ExceptionSupport.getMessage(ex, "WASX");
            if (detail == null) {
                detail = ex.toString();
            }
            throw new ScriptingException(detail);
        }
        ObjectName[] oList = null;
        try {
            oList = configServiceProxy.queryConfigObjects(this.getCurrentSession(), null, trialON, null);
        }
        catch (Exception ex) {
            Tr.audit(tc, "Caught exception in internalGetID: " + ex.toString());
        }
        if (oList != null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "size of list returned is " + oList.length);
            }
            if (oList.length > 1) {
                Tr.audit(tc, "Found " + oList.length + " objects; returning first.");
            }
            if (oList.length >= 1) {
                ConfigDataId cid = ConfigServiceHelper.getConfigDataId(oList[0]);
                if (!cid.isResolved()) {
                    ObjectName[] tList;
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Id is not resolved; need to make another call.");
                    }
                    if ((tList = configServiceProxy.queryConfigObjects(this.getCurrentSession(), null, oList[0], null)) != null && tList.length == 1) {
                        oList[0] = tList[0];
                    }
                }
                id = this.configHelper.getListingName(oList[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "internalGetID");
        }
        return id;
    }

    public String list(String type, String scope) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "list for type " + type + " in scope " + scope);
        }
        this._shell.setLastException(null);
        String ret = null;
        try {
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            String pattern = null;
            if (scope != null && scope.indexOf("*") >= 0) {
                Tr.debug(tc, "scope " + scope);
                pattern = scope;
                scope = null;
            }
            Tr.debug(tc, "pattern " + pattern);
            ObjectName[] oList = this.internalList(type, scope, true);
            HashSet<String> hs = new HashSet<String>();
            if (oList == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "oList is null!");
            }
            for (int i = 0; i < oList.length; ++i) {
                String dName = this.configHelper.getListingName(oList[i]);
                String objType = oList[i].getKeyProperty("_Websphere_Config_Data_Type");
                this.nameCache.add(dName, objType);
                if (pattern != null) {
                    String tmpName = null;
                    tmpName = dName.startsWith("\"") && dName.endsWith("\"") ? dName.substring(1, dName.length() - 1) : dName;
                    try {
                        if (!tmpName.matches(pattern) && !this.wildcardMatches(pattern, tmpName)) continue;
                        Tr.debug(tc, "Config name matches pattern " + dName);
                        hs.add(dName);
                    }
                    catch (PatternSyntaxException e) {
                        if (!this.wildcardMatches(pattern, tmpName)) continue;
                        hs.add(dName);
                    }
                    continue;
                }
                hs.add(dName);
            }
            ret = this._langutils.setToString(hs);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "list");
        }
        return ret;
    }

    public String attributes(String type) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributes for type " + type);
        }
        this._shell.setLastException(null);
        this.checkService();
        String ret = null;
        try {
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            HashSet<String> hs = new HashSet<String>();
            String[] sarray = this.metaCache.getAttributeNamesForType(type = this.configHelper.cleanString(type));
            if (sarray != null) {
                for (int i = 0; i < sarray.length; ++i) {
                    if (sarray[i].equals("trustFileFormat ENUM(JCEK, JKS, JCERACFKS, PKCS12)")) {
                        sarray[i] = "trustFileFormat ENUM(JCEK, JKS, JCERACFKS, JCE4758RACFKS, PKCS12)";
                    } else if (sarray[i].equals("keyFileFormat ENUM(JCEK, JKS, JCERACFKS, PKCS12)")) {
                        sarray[i] = "keyFileFormat ENUM(JCEK, JKS, JCERACFKS, JCE4758RACFKS, PKCS12)";
                    }
                    hs.add(sarray[i]);
                }
            }
            ret = this._langutils.setToString(hs);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributes for type " + type);
        }
        return ret;
    }

    public String defaults(String type) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributes for type " + type);
        }
        this._shell.setLastException(null);
        this.checkService();
        String ret = null;
        StringBuffer buf = new StringBuffer();
        try {
            type = this.configHelper.cleanString(type);
            Vector v = null;
            try {
                v = this.metaCache.getFlatAttributeMap(type);
            }
            catch (ScriptingException se) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No attrs for " + type);
                }
                v = new Vector();
            }
            HelpSupport.spaceit(buf, this.S_Attribute, 32);
            HelpSupport.spaceit(buf, this.S_Type, 32);
            buf.append(this.S_Default);
            for (int j = 0; j < v.size(); ++j) {
                buf.append(nl);
                AttrInfo ai = (AttrInfo)v.get(j);
                HelpSupport.spaceit(buf, ai.getName(), 32);
                HelpSupport.spaceit(buf, ai.getType(), 32);
                Object def = ai.defaultValue();
                if (def == null) continue;
                buf.append(def.toString());
            }
            ret = buf.toString();
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "defaults");
        }
        return ret;
    }

    public String parents(String type) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parents for type " + type);
        }
        this._shell.setLastException(null);
        this.checkService();
        String ret = null;
        try {
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            HashSet<String> hs = new HashSet<String>();
            String[] sarray = this.metaCache.getParentTypes(type = this.configHelper.cleanString(type));
            if (sarray != null) {
                for (int i = 0; i < sarray.length; ++i) {
                    hs.add(sarray[i]);
                }
            } else if (!type.equals("Cell")) {
                ret = this._shell.getFormattedMessage("WASX7351I", new Object[]{type}, "parents command not available for " + type);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "parents");
                }
                return ret;
            }
            ret = this._langutils.setToString(hs);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parents");
        }
        return ret;
    }

    public String contents(String type) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contains for type " + type);
        }
        this._shell.setLastException(null);
        this.checkService();
        String ret = null;
        try {
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            Properties kids = null;
            type = this.configHelper.cleanString(type);
            kids = this.metaCache.getContentTypes(type);
            ret = this._langutils.propertiesToString(kids);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contains");
        }
        return ret;
    }

    public String show(String configId) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "show for path " + configId);
        }
        this._shell.setLastException(null);
        configId = this.configHelper.cleanString(configId);
        String result = null;
        result = this.show(configId, (String)null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "show for path " + configId);
        }
        return result;
    }

    public String showAttribute(String configId, String attribute) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showAttribute", new Object[]{configId, attribute});
        }
        this._shell.setLastException(null);
        this.checkService();
        if (this.isValidValue(configId)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{configId, "config id", "showAttribute"});
        }
        String ret = null;
        String objectType = null;
        try {
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            configId = this.configHelper.cleanString(configId);
            ObjectName on = this.configHelper.stringToObjectName(configId);
            String[] attrArray = this._langutils.stringToStringArray(attribute);
            if (attrArray == null || attrArray.length != 1) {
                this._shell.setAndThrowScriptingException("WASX7328E", "A single attribute name must be specified for showAttribute; received: " + attribute, new Object[]{attribute});
            }
            if ((objectType = this.nameCache.getType(configId)) == null) {
                return null;
            }
            this.metaCache.attrNameValidityCheck(objectType, attrArray);
            AttributeList aList = configServiceProxy.getAttributes(this.getCurrentSession(), on, attrArray, false);
            Attribute attr = this.configHelper.getAttribute(aList, attrArray[0]);
            ret = this.attributeToString(attr, false, true);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (InvalidAttributeNameException iane) {
            String[] attrPath = iane.getAttributePath();
            this._shell.setAndThrowScriptingException("WASX7080E", "Invalid attributes specified.", new Object[]{objectType, attrPath.length > 0 ? attrPath[0] : attribute});
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "show");
        }
        return ret;
    }

    public String show(String configId, Object[] attrs) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "show");
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String attrString = this._langutils.objectArrayToString(attrs);
        String ret = this.show(configId, attrString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "show");
        }
        return ret;
    }

    public String show(String configId, String attrs) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "show for path " + configId);
        }
        this._shell.setLastException(null);
        this.checkService();
        if (this.isValidValue(configId)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{configId, "config id", "show"});
        }
        String ret = null;
        String objectType = null;
        try {
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            configId = this.configHelper.cleanString(configId);
            ObjectName on = this.configHelper.stringToObjectName(configId);
            String[] attrArray = this._langutils.stringToStringArray(attrs);
            objectType = this.nameCache.getType(configId);
            if (objectType == null) {
                return null;
            }
            this.metaCache.attrNameValidityCheck(objectType, attrArray);
            AttributeList aList = configServiceProxy.getAttributes(this.getCurrentSession(), on, attrArray, false);
            AttributeList realList = this.configHelper.stripSystemAttrs(aList);
            ret = this.attributeListToString(realList, false);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (InvalidAttributeNameException iane) {
            String[] attrPath = iane.getAttributePath();
            this._shell.setAndThrowScriptingException("WASX7080E", "Invalid attributes specified.", new Object[]{objectType, attrPath.length > 0 ? attrPath[0] : attrs});
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "show");
        }
        return ret;
    }

    public String showall(String configId) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "show for path " + configId);
        }
        this._shell.setLastException(null);
        configId = this.configHelper.cleanString(configId);
        String result = null;
        result = this.showall(configId, (String)null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "show for path " + configId);
        }
        return result;
    }

    public String showall(String configId, Object[] attrs) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showall");
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String attrString = this._langutils.objectArrayToString(attrs);
        String ret = this.showall(configId, attrString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showall");
        }
        return ret;
    }

    public String showall(String configId, String attrs) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showall for path " + configId);
        }
        this._shell.setLastException(null);
        this.checkService();
        if (this.isValidValue(configId)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{configId, "config id", "showall"});
        }
        String ret = null;
        String objectType = null;
        try {
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            configId = this.configHelper.cleanString(configId);
            ObjectName on = this.configHelper.stringToObjectName(configId);
            String[] attrArray = this._langutils.stringToStringArray(attrs);
            objectType = this.nameCache.getType(configId);
            if (objectType == null) {
                return null;
            }
            this.metaCache.attrNameValidityCheck(objectType, attrArray);
            AttributeList aList = configServiceProxy.getAttributes(this.getCurrentSession(), on, attrArray, true);
            AttributeList realList = this.configHelper.stripSystemAttrs(aList);
            ret = this.attributeListToString(realList, true);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (InvalidAttributeNameException iane) {
            String[] attrPath = iane.getAttributePath();
            this._shell.setAndThrowScriptingException("WASX7080E", "Invalid attributes specified.", new Object[]{objectType, attrPath.length > 0 ? attrPath[0] : attrs});
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showall");
        }
        return ret;
    }

    public String showdump(String configId) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "show for path " + configId);
        }
        configId = this.configHelper.cleanString(configId);
        String result = null;
        result = this.showdump(configId, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "show for path " + configId);
        }
        return result;
    }

    public String showdump(String configId, String attrs) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "show for path " + configId);
        }
        this.checkService();
        String ret = null;
        try {
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            configId = this.configHelper.cleanString(configId);
            ObjectName on = this.configHelper.stringToObjectName(configId);
            String[] attrArray = this._langutils.stringToStringArray(attrs);
            String objectType = this.nameCache.getType(configId);
            if (objectType == null) {
                return null;
            }
            this.metaCache.attrNameValidityCheck(objectType, attrArray);
            AttributeList aList = configServiceProxy.getAttributes(this.getCurrentSession(), on, attrArray, true);
            this.dumpAttributeList(aList, 0);
            AttributeList realList = this.configHelper.stripSystemAttrs(aList);
            ret = this.attributeListToString(realList, false);
        }
        catch (AdminException e) {
            this._shell.setLastException(e);
            throw e;
        }
        catch (ConnectorException e) {
            this._shell.setLastException(e);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "show");
        }
        return ret;
    }

    public void dumpAttributeList(AttributeList aList, int level) {
        for (int i = 0; i < aList.size(); ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "---------------------------------------------------------");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attribute number: " + level + "." + i);
            }
            Attribute a = (Attribute)aList.get(i);
            this.dumpAttribute(a, level);
        }
    }

    public void dumpAttribute(Attribute a, int level) {
        if (a == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  attribute is null.");
            }
            return;
        }
        String name = a.getName();
        Object val = a.getValue();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " name: " + name);
        }
        if (val == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  value is null.");
            }
        } else {
            Class<?> cl = val.getClass();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  type of value: " + cl.getName());
            }
            if (cl == AttributeList.class) {
                this.dumpAttributeList((AttributeList)val, level + 1);
            } else if (cl == ArrayList.class) {
                ArrayList aList = (ArrayList)val;
                for (int i = 0; i < aList.size(); ++i) {
                    Object o0;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "        ----------------------------------------------");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "        Array list element: " + level + "." + i);
                    }
                    if ((o0 = aList.get(i)) == null) continue;
                    cl = o0.getClass();
                    if (cl == AttributeList.class) {
                        this.dumpAttributeList((AttributeList)o0, level + 1);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "  list element value.toString is " + val.toString());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  value.toString is " + val.toString());
            }
        }
    }

    public String recshow(String configId) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "show for path " + configId);
        }
        this.checkService();
        String ret = null;
        try {
            configId = this.configHelper.cleanString(configId);
            ObjectName on = this.configHelper.stringToObjectName(configId);
            String[] attrArray = null;
            String objectType = this.nameCache.getType(configId);
            if (objectType == null) {
                return null;
            }
            this.metaCache.attrNameValidityCheck(objectType, attrArray);
            AttributeList aList = configServiceProxy.getAttributes(this.getCurrentSession(), on, attrArray, true);
            AttributeList realList = this.configHelper.stripSystemAttrs(aList);
            ret = this.attributeListToString(realList, true);
        }
        catch (AdminException e) {
            this._shell.setLastException(e);
            throw e;
        }
        catch (ConnectorException e) {
            this._shell.setLastException(e);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "show");
        }
        return ret;
    }

    public String modify(String configId, String attributes) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modify for path " + configId);
        }
        this._shell.setLastException(null);
        this.checkService();
        if (this.isValidValue(configId)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{configId, "config id", "modify"});
        }
        String objectType = null;
        try {
            TypeSpecificHelper tsh;
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            if ((objectType = this.nameCache.getType(configId = this.configHelper.cleanString(configId))) == null) {
                return null;
            }
            ObjectName on = this.configHelper.stringToObjectName(configId);
            attributes = this._langutils.cleanAttributeString(attributes);
            AttributeList aList = this._langutils.stringToAttributeList(attributes);
            Object tempList = null;
            AttributeList newList = null;
            if (tc.isDebugEnabled()) {
                this.dumpAttributeList(aList, 0);
            }
            newList = this.correctTypesInAttributeList(objectType, aList);
            if (tc.isDebugEnabled()) {
                this.dumpAttributeList(newList, 0);
            }
            if ((tsh = (TypeSpecificHelper)this.typeSpecificHelperTable.get(objectType)) != null) {
                newList = tsh.attributeListUpdate(newList, on, false);
            }
            if (tc.isDebugEnabled()) {
                this.dumpAttributeList(newList, 0);
            }
            AttributeList oldList = configServiceProxy.getAttributes(this.getCurrentSession(), on, null, true);
            if (tc.isDebugEnabled()) {
                this.dumpAttributeList(oldList, 0);
            }
            AttributeList mergedList = this.configHelper.merge(oldList, newList);
            if (tc.isDebugEnabled()) {
                this.dumpAttributeList(mergedList, 0);
            }
            configServiceProxy.setAttributes(this.getCurrentSession(), on, mergedList);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (InvalidAttributeNameException iane) {
            String[] attrPath = iane.getAttributePath();
            this._shell.setAndThrowScriptingException("WASX7080E", "Invalid attributes specified.", new Object[]{objectType, attrPath.length > 0 ? attrPath[0] : attributes});
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modify");
        }
        return new String();
    }

    public String modify(String configId, Object[] attributes) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modify");
        }
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String attrString = this._langutils.objectArrayToString(attributes);
        String ret = this.modify(configId, attrString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modify");
        }
        return ret;
    }

    public String createUsingTemplate(String type, String parent, Object[] attributes, String template) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createUsingTemplate");
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String attrString = this._langutils.objectArrayToString(attributes);
        String ret = this.createUsingTemplate(type, parent, attrString, template);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createUsingTemplate");
        }
        return ret;
    }

    public String createUsingTemplate(String type, String parent, String attributes, String template) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createUsingTemplate", new Object[]{type, parent, template});
        }
        this._shell.setLastException(null);
        String retval = null;
        template = this.configHelper.cleanString(template);
        retval = this.create(type, parent, attributes, null, template);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createUsingTemplate", new Object[]{retval});
        }
        return retval;
    }

    public String create(String type, String parent, String attributes) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create", new Object[]{type, parent, attributes});
        }
        this._shell.setLastException(null);
        String retval = this.create(type, parent, attributes, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
        return retval;
    }

    public String create(String type, String parent, Object[] attributes) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create");
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String attrString = this._langutils.objectArrayToString(attributes);
        String retval = this.create(type, parent, attrString, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
        return retval;
    }

    public String create(String type, String parent, String attributes, String nameInParent) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create", new Object[]{type, parent, nameInParent});
        }
        this._shell.setLastException(null);
        String retval = null;
        try {
            type = this.configHelper.cleanString(type);
            parent = this.configHelper.cleanString(parent);
            retval = this.create(type, parent, attributes, nameInParent, null);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
        return retval;
    }

    public String create(String type, String parent, Object[] attributes, String nameInParent) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create");
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String attrString = this._langutils.objectArrayToString(attributes);
        String retval = this.create(type, parent, attrString, nameInParent);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
        return retval;
    }

    public String create(String type, String parent, String attributes, String nameInParent, String template) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create for type " + type + " in " + parent + "; nameInParent is " + nameInParent);
        }
        this._shell.setLastException(null);
        this.checkService();
        if (this.isValidValue(parent)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{parent, "parent config id", "create"});
        }
        String dName = null;
        String parentType = null;
        try {
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            type = this.configHelper.cleanString(type);
            parentType = this.nameCache.getType(parent = this.configHelper.cleanString(parent));
            if (parentType == null) {
                this._shell.setAndThrowScriptingException("WASX7083E", "Cannot find config object", new Object[]{parent});
            }
            if (nameInParent == null) {
                nameInParent = this.metaCache.findContentNameForType(parentType, type);
            }
            nameInParent = this.configHelper.cleanString(nameInParent);
            attributes = this._langutils.cleanAttributeString(attributes);
            AttributeList aList = this._langutils.stringToAttributeList(attributes);
            AttributeList newList = null;
            newList = this.correctTypesInAttributeList(type, aList);
            ObjectName on = this.configHelper.stringToObjectName(parent);
            this.configHelper.OKToCreate(type, on, processType, connectedServer);
            TypeSpecificHelper tsh = (TypeSpecificHelper)this.typeSpecificHelperTable.get(type);
            if (tsh != null) {
                newList = tsh.attributeListUpdate(newList, on, true);
            }
            if (tc.isDebugEnabled()) {
                this.dumpAttributeList(newList, 0);
            }
            ObjectName templateON = this.configHelper.stringToObjectName(template);
            ObjectName newObj = configServiceProxy.createConfigDataByTemplate(this.getCurrentSession(), on, nameInParent, newList, templateON);
            dName = this.configHelper.getListingName(newObj);
            this.nameCache.add(dName, type);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (InvalidAttributeNameException iane) {
            try {
                this.metaCache.getCorrectError(parentType, type, nameInParent);
            }
            catch (Exception ae) {
                this._shell.setLastException(ae);
                String detail = ExceptionSupport.getMessage(ae, "WASX");
                if (detail == null) {
                    detail = ae.toString();
                }
                throw new ScriptingException(detail);
            }
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
        return dName;
    }

    public String remove(String configId) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove " + configId);
        }
        this._shell.setLastException(null);
        String msg = new String();
        this.checkService();
        if (this.isValidValue(configId)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{configId, "config id", "remove"});
        }
        try {
            String node;
            configId = this.configHelper.cleanString(configId);
            ObjectName on = this.configHelper.stringToObjectName(configId);
            configServiceProxy.deleteConfigData(this.getCurrentSession(), on);
            int index1 = configId.lastIndexOf("#");
            int index2 = configId.lastIndexOf("_");
            if (index1 != -1 && index2 != -1 && index2 > index1 && (node = configId.substring(index1 + 1, index2)).equals(NODETYPE)) {
                if ("UnManagedProcess".equals(processType)) {
                    Tr.audit(tc, "WASX7407I", new Object[0]);
                    msg = this._shell.getFormattedMessage("WASX7407I", new Object[0], "Node removal in base environment is not a recommended operation.");
                } else if ("DeploymentManager".equals(processType)) {
                    Tr.audit(tc, "WASX7408I", new Object[0]);
                    msg = this._shell.getFormattedMessage("WASX7408I", new Object[0], "Node removal in NetworkDeployment environment is not a recommended operation.");
                }
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "remove");
        }
        return msg;
    }

    public String relate(String source, String target, String rname) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "relate " + source + " to " + target + " via " + rname);
        }
        this.checkService();
        try {
            source = this.configHelper.cleanString(source);
            target = this.configHelper.cleanString(target);
            rname = this.configHelper.cleanString(rname);
            ObjectName sourceON = this.configHelper.stringToObjectName(source);
            ObjectName targetON = this.configHelper.stringToObjectName(target);
            AttributeList al = new AttributeList();
            Attribute a = new Attribute(rname, target);
            al.add(a);
            configServiceProxy.setAttributes(this.getCurrentSession(), sourceON, al);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (AdminException e) {
            this._shell.setLastException(e);
            throw e;
        }
        catch (ConnectorException e) {
            this._shell.setLastException(e);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "relate");
        }
        return new String();
    }

    public String dumpDebugInfo() {
        try {
            System.out.println("----------------------------------------------");
            System.out.println("TypeToAttributeCache");
            System.out.println("");
            this.metaCache.dumpTypeToAttributeCache();
            System.out.println("");
            System.out.println("----------------------------------------------");
            System.out.println("FlatAttributeCache");
            System.out.println("");
            this.metaCache.dumpFlatAttrCache();
            System.out.println("");
            System.out.println("----------------------------------------------");
            System.out.println("NameCache");
            System.out.println("");
            this.nameCache.dumpNameCache();
            System.out.println("");
            System.out.println("----------------------------------------------");
            System.out.println("ContainmentCache");
            System.out.println("");
            this.metaCache.dumpContainmentCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new String();
    }

    public void checkService() throws ScriptingException {
        if (configServiceProxy == null) {
            this._shell.setAndThrowScriptingException("CONFIG_NOT_AVAILABLE", "Config service not available", new Object[0]);
        }
    }

    public String getid(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getid - " + name);
        }
        this._shell.setLastException(null);
        String ret = null;
        this.checkService();
        try {
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            name = this.configHelper.cleanString(name);
            String id = this.configHelper.nameToResolveString(name);
            ObjectName[] oList = configServiceProxy.resolve(this.getCurrentSession(), id);
            HashSet<String> hs = new HashSet<String>();
            if (oList == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "oList is null!");
            }
            for (int i = 0; i < oList.length; ++i) {
                ConfigDataId cid = ConfigServiceHelper.getConfigDataId(oList[i]);
                if (!cid.isResolved()) {
                    ObjectName[] tList;
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Id is not resolved; need to make another call.");
                    }
                    if ((tList = configServiceProxy.queryConfigObjects(this.getCurrentSession(), null, oList[i], null)) != null && tList.length == 1) {
                        oList[i] = tList[0];
                    }
                }
                String dName = this.configHelper.getListingName(oList[i]);
                String objType = oList[i].getKeyProperty("_Websphere_Config_Data_Type");
                this.nameCache.add(dName, objType);
                hs.add(dName);
            }
            ret = this._langutils.setToString(hs);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getid");
        }
        return ret;
    }

    private String getStringValue(AttrHelper ah, Attribute attr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStringValue - " + attr.getName());
        }
        String result = null;
        Locale locale = Locale.getDefault();
        result = attr.getName().toLowerCase(locale).indexOf("password") >= 0 || attr.getName().equals(AdminControlClient.PRIVATE_KEY) || attr.getName().equals(AdminControlClient.PUBLIC_KEY) || attr.getName().equals(AdminControlClient.SHARED_KEY) ? (attr.getValue() == null ? ah.getStringValue(attr.getValue()) : "*****") : ah.getStringValue(attr.getValue());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStringValue - " + result);
        }
        return result;
    }

    public String attributeListToString(AttributeList alist, boolean recursive) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListToString");
        }
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        HashSet<String> hs = new HashSet<String>();
        for (int i = 0; i < alist.size(); ++i) {
            String one_attr = this.attributeToString((Attribute)alist.get(i), recursive, false);
            if (one_attr == null) continue;
            hs.add(one_attr);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListToString");
        }
        String ret = this._langutils.setToString(hs);
        return ret;
    }

    public String attributeToString(Attribute attr, boolean recursive, boolean valueOnly) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeToString", new Object[]{attr.getName()});
        }
        String result = null;
        Object o = attr.getValue();
        AttrHelper ah = null;
        String type = null;
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        if (o != null) {
            Object oo;
            int pos;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Type of value is " + o.getClass().getName());
            }
            if ((pos = (type = o.getClass().getName()).lastIndexOf(".")) >= 0) {
                type = type.substring(pos + 1);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type is " + type);
            }
            String lookupType = type;
            if (o instanceof List && o != null && ((List)o).size() > 0 && (oo = ((List)o).get(0)) instanceof String) {
                lookupType = "String*";
            }
            if (recursive && o instanceof List && !lookupType.equals("String*")) {
                StringBuffer buf = new StringBuffer();
                buf.append(this._langutils.getOpenNestedAttribute());
                ah = (AttrHelper)this.helperTable.get("String");
                if (type.equals("AttributeList")) {
                    AttributeList cleanList = this.configHelper.stripSystemAttrs((AttributeList)o);
                    String temp = this.attributeListToString(cleanList, recursive);
                    buf.append(temp);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nested attr: " + temp);
                    }
                } else if (type.equals("ArrayList")) {
                    ArrayList al = (ArrayList)o;
                    for (int j = 0; j < al.size(); ++j) {
                        String ln;
                        Object o1 = al.get(j);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "type of list member is " + o1.getClass().getName());
                        }
                        if (o1 instanceof AttributeList) {
                            AttributeList newAttrList = this.configHelper.stripSystemAttrs((AttributeList)o1);
                            String temp = this.attributeListToString(newAttrList, recursive);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "nested attr in collection: " + temp);
                            }
                            buf.append(this._langutils.getOpenNestedAttribute());
                            buf.append(temp);
                            buf.append(this._langutils.getCloseNestedAttribute());
                        } else if (o1 instanceof ObjectName) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "ObjectName");
                            }
                            ln = this.configHelper.getListingName((ObjectName)o1);
                            buf.append(ln);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "other; " + o1.getClass().getName());
                            }
                            ln = o1.toString();
                            buf.append(ln);
                        }
                        if (j >= al.size() - 1) continue;
                        buf.append(" ");
                    }
                }
                buf.append(this._langutils.getCloseNestedAttribute());
                Attribute tempAttr = new Attribute(attr.getName(), buf.toString());
                result = valueOnly ? this.getStringValue(ah, tempAttr) : ah.formDisplayString(tempAttr);
            } else {
                ah = (AttrHelper)this.helperTable.get(lookupType);
                if (ah == null) {
                    ah = (AttrHelper)this.helperTable.get("String");
                }
                result = valueOnly ? this.getStringValue(ah, attr) : ah.formDisplayString(attr);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeToString", new Object[]{result});
        }
        return result;
    }

    public AttributeList correctTypesInAttributeList(String type, AttributeList aList) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "correctTypesInAttributeList - " + type);
        }
        Vector v = this.metaCache.getFlatAttributeMap(type);
        StringBuffer bad = new StringBuffer();
        AttributeList retList = new AttributeList();
        boolean errors = false;
        for (int i = 0; i < aList.size(); ++i) {
            String aName = ((Attribute)aList.get(i)).getName();
            Object aVal = ((Attribute)aList.get(i)).getValue();
            String theSubtype = null;
            int colon = aName.indexOf(":");
            if (colon >= 0) {
                theSubtype = aName.substring(colon + 1);
                aName = aName.substring(0, colon);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "looking at name: " + aName + "; val: " + aVal.toString());
            }
            boolean found = false;
            for (int j = 0; j < v.size(); ++j) {
                AttrInfo ai = (AttrInfo)v.get(j);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matching with name " + ai.getName());
                }
                if (!aName.equals(ai.getName())) continue;
                String aType = ai.getType();
                AttrHelper ah = null;
                int pos = aType.lastIndexOf(".");
                if (pos >= 0) {
                    aType = aType.substring(pos + 1);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Type of value is " + aType);
                }
                if (ai.isCollection() && ai.isReference()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "type is collection of references");
                    }
                    ah = (AttrHelper)this.helperTable.get("ObjectName*");
                } else if (ai.isCollection()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "type is collection");
                    }
                    ah = (AttrHelper)this.helperTable.get(aType + "*");
                } else if (ai.isReference()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "type is reference");
                    }
                    ah = (AttrHelper)this.helperTable.get("ObjectName");
                } else {
                    ah = (AttrHelper)this.helperTable.get(aType);
                }
                Attribute a = null;
                if (ah != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Type of helper is " + ah.getClass().getName());
                    }
                    a = ah.formValidAttribute(ai, (Attribute)aList.get(i));
                } else {
                    if (theSubtype != null) {
                        aType = theSubtype;
                    }
                    if (ai.isCollection()) {
                        if (aVal instanceof ArrayList) {
                            ArrayList arlist = (ArrayList)aVal;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "This attribute (" + aName + ") is a collection");
                            }
                            for (int k = 0; k < arlist.size(); ++k) {
                                AttributeList tattrl = null;
                                try {
                                    tattrl = (AttributeList)arlist.get(k);
                                }
                                catch (ClassCastException cce) {
                                    this._shell.setAndThrowScriptingException("WASX7353E", "The attribute \"" + aName + "\" must be a collection of objects of type \"" + aType + "\"; an additional set of curly braces may be required to signify that this is a collection.", new Object[]{aName, aType});
                                }
                                AttributeList al = this.correctTypesInAttributeList(aType, tattrl);
                                arlist.set(k, al);
                            }
                            a = new Attribute(aName, arlist);
                        } else if (aVal instanceof String && ((String)aVal).length() == 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "type is collection, val is zero-length string");
                            }
                            a = new Attribute(aName, new ArrayList());
                        } else {
                            this._shell.setAndThrowScriptingException("WASX7353E", "The attribute \"" + aName + "\" must be a collection of objects of type \"" + aType + "\"; an additional set of curly braces may be required to signify that this is a collection.", new Object[]{aName, aType});
                        }
                    } else if (ai.isObject()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "type of aVal: " + aVal.getClass().getName());
                        }
                        if (aVal instanceof AttributeList) {
                            AttributeList al = this.correctTypesInAttributeList(aType, (AttributeList)aVal);
                            a = new Attribute(aName, al);
                        } else {
                            String stringVal;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "using aVal.toString() " + aVal.toString());
                            }
                            if ((stringVal = aVal.toString()).length() == 0) {
                                stringVal = null;
                                a = new Attribute(aName, stringVal);
                            } else {
                                this._shell.setAndThrowScriptingException("WASX7354E", "The attribute \"" + aName + "\" is an embedded object of type " + aType + "\"; an invalid value was supplied.", new Object[]{aName, aType});
                            }
                        }
                    } else {
                        this._shell.setAndThrowScriptingException("WASX7239E", "Trying to set bad attr " + aName, new Object[]{aName, aType, aVal.toString()});
                    }
                }
                if (theSubtype != null) {
                    Attribute existing = null;
                    for (int m = 0; m < retList.size(); ++m) {
                        Attribute temp = (Attribute)retList.get(m);
                        if (!temp.getName().equals(aName)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removing attr in pos " + m + " of retlist");
                        }
                        existing = (Attribute)retList.remove(m);
                        break;
                    }
                    if (existing != null) {
                        List existingMembers = (List)existing.getValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Members of existing list: " + existingMembers.size());
                        }
                        List newMembers = (List)a.getValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Members of new list: " + newMembers.size());
                        }
                        existingMembers.addAll(newMembers);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Members of merged list: " + existingMembers.size());
                        }
                        a = new Attribute(aName, existingMembers);
                    }
                }
                retList.add(a);
                found = true;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "found true");
                break;
            }
            if (found) continue;
            if (bad.length() > 0) {
                bad.append(" ");
            }
            bad.append(aName);
            errors = true;
        }
        if (errors) {
            this._shell.setAndThrowScriptingException("WASX7080E", "Invalid attributes specified.", new Object[]{type, bad.toString()});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding type to AttributeList: " + type);
        }
        retList.add(new Attribute("_Websphere_Config_Data_Type", type));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "correctTypesInAttributeList");
        }
        return retList;
    }

    public String save() throws ScriptingException {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "save");
            }
            this._shell.setLastException(null);
            this.checkService();
            try {
                boolean changes = this.hasChanges();
                configServiceProxy.save(this.getCurrentSession(), this.overwriteOnSave);
                if (!AdminHelper.getPlatformHelper().isZOS() || !this._shell.getConnectionType().equals("NONE") || !changes) break block6;
                String localNode = System.getProperty("local.node");
                String localCell = System.getProperty("local.cell");
                if (localNode != null && localCell != null) {
                    PlatformUtils platformUtils = (PlatformUtils)ImplFactory.loadImplFromKey("com.ibm.ws.management.util.PlatformUtils");
                    platformUtils.transform(localCell, localNode);
                    break block6;
                }
                throw new ConfigServiceException("Transformer needs system properties, local.cell and local.node");
            }
            catch (Exception ae) {
                this._shell.setLastException(ae);
                String detail = ExceptionSupport.getMessage(ae, "WASX");
                if (detail == null) {
                    detail = ae.toString();
                }
                throw new ScriptingException(detail);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save");
        }
        return new String();
    }

    public String reset() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        this._shell.setLastException(null);
        this.checkService();
        try {
            if (configServiceProxy != null) {
                configServiceProxy.discard(this.getCurrentSession());
            }
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
        return new String();
    }

    public boolean hasChanges() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasChanges");
        }
        String[] files = null;
        this.checkService();
        try {
            files = configServiceProxy.getUnsavedChanges(this.getCurrentSession());
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasChanges", new Object[]{files});
        }
        if (files == null) {
            return false;
        }
        return files.length > 0;
    }

    public String queryChanges() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryChanges");
        }
        this._shell.setLastException(null);
        String[] files = null;
        String msg = null;
        this.checkService();
        try {
            files = configServiceProxy.getUnsavedChanges(this.getCurrentSession());
            StringBuffer buf = new StringBuffer();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    buf.append(files[i]);
                    buf.append(nl);
                }
            }
            msg = buf.length() == 0 ? this._shell.getFormattedMessage("WASX7241I", new Object[0], "There are no unsaved changes in this workspace") : this._shell.getFormattedMessage("WASX7146I", new Object[]{buf.toString()}, "Unsaved changes in:\n" + buf.toString());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "queryChanges");
            }
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        return msg;
    }

    public String setSaveMode(String mode) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSaveMode");
        }
        this._shell.setLastException(null);
        if (mode.toLowerCase().equals("overwriteonconflict")) {
            this.overwriteOnSave = true;
        } else if (mode.toLowerCase().equals("rollbackonconflict")) {
            this.overwriteOnSave = false;
        } else {
            this._shell.setAndThrowScriptingException("WASX7119E", "Invalid option specified.", new Object[]{mode});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSaveMode");
        }
        return new String();
    }

    public String getSaveMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSaveMode");
        }
        String ret = this.setSaveMode();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSaveMode");
        }
        return ret;
    }

    public String setSaveMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSaveMode");
        }
        String ret = "rollbackOnConflict";
        if (this.overwriteOnSave) {
            ret = "overwriteOnConflict";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSaveMode");
        }
        return ret;
    }

    public String getValidationLevel() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setValidationLevel");
        }
        String msg = this.setValidationLevel();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setValidationLevel");
        }
        return msg;
    }

    public String setValidationLevel() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setValidationLevel");
        }
        String val = (String)this.levelMapper.get(this.validationLevel);
        String msg = this._shell.getFormattedMessage("WASX7189I", new Object[]{val}, "Validation level set to ");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setValidationLevel");
        }
        return msg;
    }

    public String setValidationLevel(String lvl) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setValidationLevel", new Object[]{lvl});
        }
        this._shell.setLastException(null);
        String level = lvl.toUpperCase();
        if (level.equals("NONE") || level.equals("0")) {
            this.validationLevel = SessionPropertyConstants.NO_VALIDATION;
        } else if (level.equals("LOW") || level.equals("1")) {
            this.validationLevel = SessionPropertyConstants.LOW_LEVEL_VALIDATION;
        } else if (level.equals("MEDIUM") || level.equals("2")) {
            this.validationLevel = SessionPropertyConstants.MEDIUM_LEVEL_VALIDATION;
        } else if (level.equals("HIGH") || level.equals("3")) {
            this.validationLevel = SessionPropertyConstants.HIGH_LEVEL_VALIDATION;
        } else if (level.equals("HIGHEST") || level.equals("4")) {
            this.validationLevel = SessionPropertyConstants.HIGHEST_LEVEL_VALIDATION;
        } else {
            this._shell.setAndThrowScriptingException("WASX7187E", "Invalid value specified.", new Object[]{lvl, "none, low, medium, high, highest"});
        }
        this.validationLevelChanged = true;
        String val = (String)this.levelMapper.get(this.validationLevel);
        String msg = this._shell.getFormattedMessage("WASX7189I", new Object[]{val}, "Validation level set to ");
        Tr.audit(tc, "WASX7208I", new Object[]{(String)this.levelMapper.get(this.validationLevel), this.crossValidationEnabled, this.validationOutputFileName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setValidationLevel");
        }
        return msg;
    }

    public String getCrossDocumentValidationEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCrossDocumentValidationEnabled");
        }
        String msg = this.setCrossDocumentValidationEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCrossDocumentValidationEnabled");
        }
        return msg;
    }

    public String setCrossDocumentValidationEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCrossDocumentValidationEnabled");
        }
        String msg = this._shell.getFormattedMessage("WASX7188I", new Object[]{this.crossValidationEnabled}, "Cross-document validation enablement set to ");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCrossDocumentValidationEnabled");
        }
        return msg;
    }

    public String setCrossDocumentValidationEnabled(String lvl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCrossDocumentValidationEnabled", new Object[]{lvl});
        }
        this.crossValidationEnabled = new Boolean(lvl);
        this.crossValidationEnabledChanged = true;
        String msg = this._shell.getFormattedMessage("WASX7188I", new Object[]{this.crossValidationEnabled}, "Cross-document validation enablement set to ");
        Tr.audit(tc, "WASX7208I", new Object[]{(String)this.levelMapper.get(this.validationLevel), this.crossValidationEnabled, this.validationOutputFileName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCrossDocumentValidationEnabled");
        }
        return msg;
    }

    public String getValidationSeverityResult(int sev) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setValidationResult");
        }
        String msg = sev > 9 ? this.getValidationSeverityResult() : Integer.toString(this.validationCounters[sev]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setValidationResult");
        }
        return msg;
    }

    public String validate() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        this._shell.setLastException(null);
        String res = null;
        try {
            res = this.validate(null, "validate");
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return res;
    }

    public String validate(String scope) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{scope});
        }
        this._shell.setLastException(null);
        ObjectName scopeON = null;
        Hashtable scopetable = null;
        String res = null;
        try {
            if (scope != null) {
                scopetable = this.configHelper.parseObjectIdString(scope);
                String objectType = this.nameCache.getType(scope);
                scopetable.put("_Websphere_Config_Data_Type", objectType);
                try {
                    if (scopetable != null) {
                        scopeON = new ObjectName("WebSphere", scopetable);
                    }
                }
                catch (MalformedObjectNameException ex) {
                    Tr.event(tc, "Caught exception creating object name for " + objectType + "; exception: " + ex);
                }
            }
            res = this.validate(scopeON, "validate");
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return res;
    }

    protected String validate(ObjectName scope, String action) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{scope, action});
        }
        this._shell.setLastException(null);
        String summary = null;
        this.checkService();
        try {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            if (this.validationLevelChanged) {
                temp.put("VALIDATION_LEVEL", this.validationLevel);
            }
            if (this.crossValidationEnabledChanged) {
                temp.put("ENABLE_CROSS_VALIDATION", this.crossValidationEnabled);
            }
            temp.put("LOCALE", Locale.getDefault());
            configServiceProxy.setProperties(this.getCurrentSession(), temp);
            ValidationResult results = configServiceProxy.validate(this.getCurrentSession(), scope);
            summary = this.writeValidationResults(results, action);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        this.crossValidationEnabledChanged = false;
        this.validationLevelChanged = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return summary;
    }

    protected String writeValidationResults(ValidationResult results, String action) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeValidationResults", new Object[]{action});
        }
        this._shell.setLastException(null);
        StringBuffer buf = new StringBuffer();
        Set docs = results.getDocuments();
        Tr.debug(tc, "There are " + docs.size() + " documents in the ValidationResult.");
        Iterator it = docs.iterator();
        int total = 0;
        for (int i = 0; i < this.validationCounters.length; ++i) {
            this.validationCounters[i] = 0;
        }
        String enabled = null;
        enabled = this.crossValidationEnabled != false ? this._shell.getFormattedMessage("WASX7191I", null, "enabled") : this._shell.getFormattedMessage("WASX7192I", null, "disabled");
        String msg = this._shell.getFormattedMessage("WASX7190I", new Object[]{(String)this.levelMapper.get(this.validationLevel), enabled, DateFormat.getDateTimeInstance(2, 2).format(new Date()), action}, "Validation messsages:");
        this.validationWriter.println(msg);
        while (it.hasNext()) {
            String doc = (String)it.next();
            Tr.debug(tc, "Document: " + doc);
            Set validators = results.getValidators(doc);
            Tr.debug(tc, "There are " + validators.size() + " validators for document " + doc);
            for (String validator : validators) {
                List msgs = results.getValidationMessages(doc, validator);
                Tr.debug(tc, "There are " + msgs.size() + " messages for validator " + validator);
                for (ValidationResult.ValidationMessage vmsg : msgs) {
                    ++total;
                    int sev = this.printValidationMessage(vmsg);
                    if (sev >= 10) continue;
                    int n = sev;
                    this.validationCounters[n] = this.validationCounters[n] + 1;
                }
            }
        }
        buf.append(this._shell.getFormattedMessage("WASX7193I", new Object[]{this.validationOutputFileName, new Integer(total)}, "Validation results are logged."));
        for (int i = 0; i < 10; ++i) {
            if (this.validationCounters[i] <= 0) continue;
            buf.append(nl);
            buf.append(this._shell.getFormattedMessage("WASX7194I", new Object[]{new Integer(i), new Integer(this.validationCounters[i])}, "Validation results are logged."));
        }
        this.validationWriter.println("");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeValidationResults");
        }
        return buf.toString();
    }

    protected int printValidationMessage(ValidationResult.ValidationMessage msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "printValidationMessage");
        }
        int sev = msg.getSeverity();
        String smsg = this._shell.getFormattedMessage("WASX7195I", new Object[]{new Integer(sev), new Integer(msg.getLineNo()), msg.getTargetObject(), msg.getMessage()}, "message: ");
        this.validationWriter.println(smsg);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "printValidationMessage", new Object[]{new Integer(sev)});
        }
        return sev;
    }

    public Session getCurrentSession() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentSession");
        }
        if (this._session == null) {
            this.createSession();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentSession");
        }
        return this._session;
    }

    private void createSession() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSession");
        }
        String id = Long.toHexString(System.currentTimeMillis());
        String user = ANONYMOUS + id;
        this._session = new Session(user, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSession");
        }
    }

    public String getObjectName(String configId) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName - " + configId);
        }
        this._shell.setLastException(null);
        if (this.isValidValue(configId)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{configId, "config id", "getObjectName"});
        }
        String ret = new String();
        try {
            AdminControlClient cl = AdminControlClient.getInstance();
            if (cl != null) {
                Hashtable ht = this.configHelper.parseObjectIdString(configId);
                String id = (String)ht.get("_Websphere_Config_Data_Id");
                id = id.replace('|', '/');
                String partial = "mbeanIdentifier=" + id + ",*";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "About to call completeObjectName for " + partial);
                }
                ret = cl.completeObjectName(partial);
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName - " + ret);
        }
        return ret;
    }

    public Object extract(String docURI, String extractedLocation) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extract", new Object[]{docURI, extractedLocation});
        }
        String ret = new String();
        ConfigRepository repository2 = null;
        DocumentDigest digest = null;
        this.checkService();
        try {
            boolean local;
            File t = new File(extractedLocation);
            if (t.exists() && !t.isFile()) {
                this._shell.setAndThrowScriptingException("WASX7296E", "Specified location is not a file name " + extractedLocation, new Object[]{extractedLocation});
            }
            if (t.exists() && !t.canWrite()) {
                this._shell.setAndThrowScriptingException("WASX7297E", "Cannot write to " + extractedLocation, new Object[]{extractedLocation});
            }
            if (local = this.isLocalMode()) {
                Properties lProp = new Properties();
                lProp.setProperty("location", "local");
                connectionProperties = lProp;
            } else {
                connectionProperties.setProperty("location", "remote");
            }
            repository2 = ConfigRepositoryClientFactory.getConfigRepositoryClient(connectionProperties);
            repository2.initialize(connectionProperties);
            DocumentContentSource source = repository2.extract(docURI);
            InputStream in = source.getSource();
            this.copyDocument(in, new FileOutputStream(t));
            digest = source.getDocument().getDigest();
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extract");
        }
        return digest;
    }

    public String checkin(String docURI, String extractedLocation, Object digest) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkin", new Object[]{docURI, extractedLocation});
        }
        String ret = new String();
        ConfigRepository repository2 = null;
        this.checkService();
        try {
            boolean local;
            File t = new File(extractedLocation);
            if (!(t.exists() && t.isFile() && t.canRead())) {
                this._shell.setAndThrowScriptingException("WASX7115E", "Cannot read input file " + extractedLocation, new Object[]{extractedLocation});
            }
            if (!this.existsDocument(docURI)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Document URI does not exist " + docURI);
                }
                throw new DocumentNotFoundException(docURI);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Document URI exist " + docURI);
            }
            if (local = this.isLocalMode()) {
                Properties lProp = new Properties();
                lProp.setProperty("location", "local");
                connectionProperties = lProp;
            } else {
                connectionProperties.setProperty("location", "remote");
            }
            repository2 = ConfigRepositoryClientFactory.getConfigRepositoryClient(connectionProperties);
            repository2.initialize(connectionProperties);
            Document d = new Document(docURI, (DocumentDigest)digest);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created document: " + d);
            }
            FileInputStream input = new FileInputStream(t);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created stream; available: " + input.available());
            }
            DocumentContentSource source = new DocumentContentSource(d, input);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created source: " + source);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "repository is  " + repository2);
            }
            DocumentDigest dig = repository2.modify(source);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        catch (Throwable t) {
            String detail = ExceptionSupport.getMessage(t, "WASX");
            if (detail == null) {
                detail = t.toString();
            }
            throw new ScriptingException(t.getCause(), detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkin");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDocument(InputStream from, OutputStream to) throws IOException {
        Tr.entry(tc, "copyDocument");
        try {
            byte[] data = new byte[4096];
            int bytesRead = from.read(data);
            while (bytesRead != -1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "writing " + bytesRead + " bytes to file");
                }
                to.write(data, 0, bytesRead);
                bytesRead = from.read(data);
            }
        }
        finally {
            try {
                to.flush();
                to.close();
                from.close();
            }
            catch (Exception e) {
                Tr.audit(tc, "Error while closing: " + e);
            }
        }
        Tr.exit(tc, "copyDocument");
    }

    public boolean existsDocument(String docURI) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "existsDocument", new Object[]{docURI});
        }
        ConfigRepository repository2 = null;
        boolean ret = false;
        this.checkService();
        try {
            boolean local = this.isLocalMode();
            if (local) {
                Properties lProp = new Properties();
                lProp.setProperty("location", "local");
                connectionProperties = lProp;
            } else {
                connectionProperties.setProperty("location", "remote");
            }
            repository2 = ConfigRepositoryClientFactory.getConfigRepositoryClient(connectionProperties);
            repository2.initialize(connectionProperties);
            String[] uris = new String[]{docURI};
            DocumentDigest[] digs = repository2.getDigest(uris);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "digs return size: " + digs.length);
            }
            if (digs.length > 0) {
                ret = true;
            }
        }
        catch (DocumentNotFoundException dnfe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception; return false");
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        catch (Throwable t) {
            String detail = ExceptionSupport.getMessage(t, "WASX");
            if (detail == null) {
                detail = t.toString();
            }
            throw new ScriptingException(t.getCause(), detail);
        }
        return ret;
    }

    public Object createDocument(String docURI, String extractedLocation) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDocument", new Object[]{docURI, extractedLocation});
        }
        ConfigRepository repository2 = null;
        DocumentDigest dig = null;
        this.checkService();
        try {
            boolean local;
            File t = new File(extractedLocation);
            if (!(t.exists() && t.isFile() && t.canRead())) {
                this._shell.setAndThrowScriptingException("WASX7115E", "Cannot read input file " + extractedLocation, new Object[]{extractedLocation});
            }
            if (local = this.isLocalMode()) {
                Properties lProp = new Properties();
                lProp.setProperty("location", "local");
                connectionProperties = lProp;
            } else {
                connectionProperties.setProperty("location", "remote");
            }
            repository2 = ConfigRepositoryClientFactory.getConfigRepositoryClient(connectionProperties);
            repository2.initialize(connectionProperties);
            Document d = new Document(docURI);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created document: " + d);
            }
            FileInputStream input = new FileInputStream(t);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created stream; available: " + input.available());
            }
            DocumentContentSource source = new DocumentContentSource(d, input);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created source: " + source);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "repository is  " + repository2);
            }
            dig = repository2.create(source);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        catch (Throwable t) {
            String detail = ExceptionSupport.getMessage(t, "WASX");
            if (detail == null) {
                detail = t.toString();
            }
            throw new ScriptingException(t.getCause(), detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDocument");
        }
        return dig;
    }

    public Object deleteDocument(String docURI) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDocument", new Object[]{docURI});
        }
        String ret = new String();
        ConfigRepository repository2 = null;
        this.checkService();
        try {
            boolean local = this.isLocalMode();
            if (local) {
                Properties lProp = new Properties();
                lProp.setProperty("location", "local");
                connectionProperties = lProp;
            } else {
                connectionProperties.setProperty("location", "remote");
            }
            repository2 = ConfigRepositoryClientFactory.getConfigRepositoryClient(connectionProperties);
            repository2.initialize(connectionProperties);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "repository is  " + repository2);
            }
            repository2.delete(docURI);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        catch (Throwable t) {
            String detail = ExceptionSupport.getMessage(t, "WASX");
            if (detail == null) {
                detail = t.toString();
            }
            throw new ScriptingException(t.getCause(), detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDocument");
        }
        return ret;
    }

    public String convertToCluster(String serverid, String clusterName) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToCluster", new Object[]{serverid, clusterName});
        }
        this._shell.setLastException(null);
        String ret = new String();
        this.checkService();
        if (this.isValidValue(serverid)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{serverid, "server id", "convertToCluster"});
        }
        try {
            serverid = this.configHelper.cleanString(serverid);
            ObjectName serverON = this.configHelper.stringToObjectName(serverid);
            String objectType = this.nameCache.getType(serverid);
            if (objectType == null) {
                return null;
            }
            if (!objectType.equals(SERVERTYPE)) {
                this._shell.setAndThrowScriptingException("WASX7283E", "This command requires an object of type Server, but the specified object " + serverid + " has type: " + objectType, new Object[]{SERVERTYPE, serverid, objectType});
            }
            ObjectName newObj = this.clusterTasks.convertToCluster(this.getCurrentSession(), serverON, clusterName);
            ret = this.configHelper.getListingName(newObj);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToCluster: " + ret);
        }
        return ret;
    }

    public String createClusterMember(String clusterid, String node, String attrs) throws ScriptingException {
        String ret = this.createClusterMember(clusterid, node, attrs, null);
        return ret;
    }

    public String createClusterMember(String clusterid, String node, Object[] attrs) throws ScriptingException {
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String attrString = this._langutils.objectArrayToString(attrs);
        String ret = this.createClusterMember(clusterid, node, attrString, null);
        return ret;
    }

    public String createClusterMember(String clusterid, String node, Object[] attrs, String template) throws ScriptingException {
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String attrString = this._langutils.objectArrayToString(attrs);
        String ret = this.createClusterMember(clusterid, node, attrString, template);
        return ret;
    }

    public String createClusterMember(String clusterid, String node, String attrs, String template) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClusterMember", new Object[]{clusterid, node, attrs, template});
        }
        this._shell.setLastException(null);
        String ret = new String();
        this.checkService();
        if (this.isValidValue(clusterid)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{clusterid, "cluster id", "createClusterMember"});
        }
        if (this.isValidValue(node)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{node, "node id", "createClusterMember"});
        }
        try {
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            clusterid = this.configHelper.cleanString(clusterid);
            ObjectName clusterON = this.configHelper.stringToObjectName(clusterid);
            attrs = this._langutils.cleanAttributeString(attrs);
            AttributeList aList = this._langutils.stringToAttributeList(attrs);
            AttributeList newList = null;
            newList = this.correctTypesInAttributeList(MEMBERTYPE, aList);
            String objectType = this.nameCache.getType(clusterid);
            if (objectType == null) {
                return null;
            }
            if (!objectType.equals(CLUSTERTYPE)) {
                this._shell.setAndThrowScriptingException("WASX7283E", "This command requires an object of type ServerCluster, but the specified object " + clusterid + " has type: " + objectType, new Object[]{CLUSTERTYPE, clusterid, objectType});
            }
            ObjectName nodeON = this.configHelper.stringToObjectName(node);
            objectType = this.nameCache.getType(node);
            if (objectType == null) {
                return null;
            }
            if (!objectType.equals(NODETYPE)) {
                this._shell.setAndThrowScriptingException("WASX7283E", "This command requires an object of type Node, but the specified object " + node + " has type: " + objectType, new Object[]{NODETYPE, node, objectType});
            }
            ObjectName templateON = null;
            if (template != null) {
                templateON = this.configHelper.stringToObjectName(template);
            }
            if (objectType == null) {
                return null;
            }
            ObjectName newObj = this.clusterTasks.createClusterMember(this.getCurrentSession(), clusterON, newList, nodeON, templateON);
            ret = this.configHelper.getListingName(newObj);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createClusterMember: " + ret);
        }
        return ret;
    }

    private Vector validateInstallRarOptions(Hashtable optProps) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateInstallRarOptions");
        }
        Vector<String> ret = new Vector<String>();
        Enumeration optNames = optProps.keys();
        while (optNames.hasMoreElements()) {
            String opt = (String)optNames.nextElement();
            if (validInstallRarOptions.contains(opt)) continue;
            ret.add(opt);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateInstallRarOptions");
        }
        return ret;
    }

    public String installResourceAdapter(String rarfile, String nodeName, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installResourceAdapter");
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String optionString = this._langutils.objectArrayToString(options);
        String ret = this.installResourceAdapter(rarfile, nodeName, optionString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installResourceAdapter");
        }
        return ret;
    }

    public String installResourceAdapter(String rarfile, String nodeName, String options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installResourceAdapter: ", new Object[]{rarfile, options, nodeName});
        }
        this._shell.setLastException(null);
        String dName = null;
        try {
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            if (configServiceProxy == null) {
                this._shell.setAndThrowScriptingException("WASX7459E", "The configuration service is not available. Target node's nodeagent may not be running", new Object[0]);
            }
            if ("ManagedProcess".equals(processType)) {
                this._shell.setAndThrowScriptingException("WASX7254E", "installResourceAdapter command not supported when connected to process type " + processType, new Object[]{"installResourceAdapter", processType});
            }
            rarfile = this._shell.normalizeFQPathName(rarfile);
            Hashtable optProps = this._langutils.optionsToHashtable(options);
            Vector badopts = this.validateInstallRarOptions(optProps);
            if (badopts.size() > 0) {
                this._shell.setAndThrowScriptingException("WASX7107E", "invalid options: " + badopts.toString() + "; valid options: " + validInstallRarOptions.toString(), new Object[]{badopts.toString(), validInstallRarOptions.toString()});
            }
            Enumeration keys = optProps.keys();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "optProps: " + optProps.toString());
            }
            optProps.put("app.client.locale", Locale.getDefault());
            InstallRARTask createRA = new InstallRARTask(configServiceProxy);
            ObjectName newObj = createRA.installResourceAdapter(this.getCurrentSession(), nodeName, rarfile, optProps);
            dName = this.configHelper.getListingName(newObj);
            this.nameCache.add(dName, "J2CResourceAdapter");
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installResourceAdapter");
        }
        return dName;
    }

    private Vector validateUninstallRarOptions(Hashtable optProps) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateUninstallRarOptions");
        }
        Vector<String> ret = new Vector<String>();
        Enumeration optNames = optProps.keys();
        while (optNames.hasMoreElements()) {
            String opt = (String)optNames.nextElement();
            if (validUninstallRarOptions.contains(opt)) continue;
            ret.add(opt);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateUninstallRarOptions");
        }
        return ret;
    }

    public void uninstallResourceAdapter(String configId) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstallResourceAdapter: ", new Object[]{configId});
        }
        this._shell.setLastException(null);
        this.uninstallResourceAdapter(configId, new String());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallResourceAdapter");
        }
    }

    public void uninstallResourceAdapter(String configId, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstallResourceAdapter");
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String optionString = this._langutils.objectArrayToString(options);
        this.uninstallResourceAdapter(configId, optionString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallResourceAdapter");
        }
    }

    public void uninstallResourceAdapter(String configId, String options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstallResourceAdapter: ", new Object[]{configId, options});
        }
        String ret = new String();
        List result = null;
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        if (this.isValidValue(configId)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{configId, "config id", "uninstallResourceAdapter"});
        }
        try {
            if (configServiceProxy == null) {
                this._shell.setAndThrowScriptingException("WASX7459E", "The configuration service is not available. Target node's nodeagent may not be running", new Object[0]);
            }
            if ("ManagedProcess".equals(processType)) {
                this._shell.setAndThrowScriptingException("WASX7254E", "uninstallResourceAdapter command not supported when connected to process type " + processType, new Object[]{"uninstallResourceAdapter", processType});
            }
            configId = this.configHelper.cleanString(configId);
            ObjectName on = this.configHelper.stringToObjectName(configId);
            Hashtable optProps = this._langutils.optionsToHashtable(options);
            Vector badopts = this.validateUninstallRarOptions(optProps);
            if (badopts.size() > 0) {
                this._shell.setAndThrowScriptingException("WASX7107E", "invalid options: " + badopts.toString() + "; valid options: " + validUninstallRarOptions.toString(), new Object[]{badopts.toString(), validUninstallRarOptions.toString()});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "optProps: " + optProps.toString());
            }
            optProps.put("app.client.locale", Locale.getDefault());
            UninstallRARTask removeRA = new UninstallRARTask(configServiceProxy);
            result = removeRA.uninstallResourceAdapter(this.getCurrentSession(), on, optProps);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (AppRefException ex) {
            this._shell.setLastException(ex);
            String detail = ExceptionSupport.getMessage(ex, "WASX");
            if (detail == null) {
                detail = ex.toString();
            }
            throw new ScriptingException(detail);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (result != null || !result.isEmpty()) {
            ret = this._langutils.setToString(result);
        }
        if (!ret.equals("")) {
            returnCode = this._shell.issueMessage(new Object[]{ret}, "WASX7397I", "List of configuration objects that is being removed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallResourceAdapter");
        }
    }

    public String required(String type) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "required - " + type);
        }
        this._shell.setLastException(null);
        this.checkService();
        String ret = null;
        StringBuffer buf = new StringBuffer();
        try {
            type = this.configHelper.cleanString(type);
            Vector v = null;
            try {
                v = this.metaCache.getFlatAttributeMap(type);
            }
            catch (ScriptingException se) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No attrs for " + type);
                }
                v = new Vector();
            }
            for (int j = 0; j < v.size(); ++j) {
                AttrInfo ai = (AttrInfo)v.get(j);
                if (!ai.isRequired()) continue;
                buf.append(nl);
                HelpSupport.spaceit(buf, ai.getName(), 32);
                buf.append(ai.getDecoratedType());
            }
            if (buf.toString().length() > 0) {
                StringBuffer columns = new StringBuffer();
                HelpSupport.spaceit(columns, this.S_Attribute, 32);
                columns.append(this.S_Type);
                columns.append(buf.toString());
                ret = columns.toString();
            } else {
                ret = this._shell.getFormattedMessage("WASX7361I", new Object[]{type}, "No required attribute for type {0}");
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "required");
        }
        return ret;
    }

    private boolean isLocalMode() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isLocalMode");
        }
        Properties connectionProperties = new Properties();
        boolean isLocal = this._shell.getConnectionType().equals("NONE");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isLocalMode - " + isLocal);
        }
        return isLocal;
    }

    private boolean isValidValue(String param) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidValue");
        }
        boolean isValidValue = false;
        if (param == null || param.trim().equals("") || param.trim().equals("''")) {
            isValidValue = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidValue - parameter value" + param);
        }
        return isValidValue;
    }

    private boolean wildcardMatches(String pattern, String text) {
        text = text + '\u0000';
        pattern = pattern + '\u0000';
        pattern = pattern.toLowerCase();
        text = text.toLowerCase();
        int N = pattern.length();
        boolean[] states = new boolean[N + 1];
        boolean[] oldStates = new boolean[N + 1];
        oldStates[0] = true;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            states = new boolean[N + 1];
            for (int j = 0; j < N; ++j) {
                char p = pattern.charAt(j);
                if (oldStates[j] && p == '*') {
                    oldStates[j + 1] = true;
                }
                if (oldStates[j] && p == c) {
                    states[j + 1] = true;
                }
                if (oldStates[j] && p == '.') {
                    states[j + 1] = true;
                }
                if (oldStates[j] && p == '*') {
                    states[j] = true;
                }
                if (!oldStates[j] || p != '*') continue;
                states[j + 1] = true;
            }
            oldStates = states;
        }
        return states[N];
    }

    public String getObjectType(String configId) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectType", new Object[]{configId});
        }
        this._shell.setLastException(null);
        this.checkService();
        if (this.isValidValue(configId)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{configId, "config id", "getObjectType"});
        }
        String objectType = null;
        try {
            configId = this.configHelper.cleanString(configId);
            objectType = this.nameCache.getType(configId);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectType");
        }
        return objectType;
    }

    public String unsetAttributes(String configId, Object[] attributes) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttributes", new Object[]{configId, attributes.toString()});
        }
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String attrString = this._langutils.objectArrayToString(attributes);
        String ret = this.unsetAttributes(configId, attrString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttributes");
        }
        return ret;
    }

    public String unsetAttributes(String configId, String attribute) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetAttributes", new Object[]{configId, attribute});
        }
        this._shell.setLastException(null);
        this.checkService();
        if (this.isValidValue(configId)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{configId, "config id", "showAttribute"});
        }
        String objectType = null;
        try {
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            configId = this.configHelper.cleanString(configId);
            ObjectName on = this.configHelper.stringToObjectName(configId);
            String[] attrArray = this._langutils.stringToStringArray(attribute);
            if (attrArray == null || attrArray.length < 1) {
                this._shell.setAndThrowScriptingException("WASX7470E", "One or more attributes must be specified for unsetAttributes; received: " + attribute, new Object[]{attribute});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attribute array is " + attrArray.toString());
            }
            if ((objectType = this.nameCache.getType(configId)) == null) {
                return null;
            }
            this.metaCache.attrNameValidityCheck(objectType, attrArray);
            configServiceProxy.unsetAttributes(this.getCurrentSession(), on, attrArray);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (InvalidAttributeNameException iane) {
            String[] attrPath = iane.getAttributePath();
            this._shell.setAndThrowScriptingException("WASX7080E", "Invalid attributes specified.", new Object[]{objectType, attrPath.length > 0 ? attrPath[0] : attribute});
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttributes");
        }
        return new String();
    }

    public String resetAttributes(String configId, Object[] attributes) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String attrString = this._langutils.objectArrayToString(attributes);
        String ret = this.resetAttributes(configId, attrString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
        return ret;
    }

    public String resetAttributes(String configId, String attributes) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetAttributes", new Object[]{configId, attributes});
        }
        this._shell.setLastException(null);
        this.checkService();
        if (this.isValidValue(configId)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{configId, "config id", "showAttribute"});
        }
        String objectType = null;
        try {
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            configId = this.configHelper.cleanString(configId);
            ObjectName on = this.configHelper.stringToObjectName(configId);
            attributes = this._langutils.cleanAttributeString(attributes);
            objectType = this.nameCache.getType(configId);
            if (objectType == null) {
                return null;
            }
            AttributeList attrList = this._langutils.stringToAttributeList(attributes);
            if (attrList.size() == 0 || attrList.isEmpty()) {
                this._shell.setAndThrowScriptingException("WASX7469E", "One or more attribute must be specified for resetAttributes; received: " + attributes, new Object[]{attributes});
            }
            if (tc.isDebugEnabled()) {
                this.dumpAttributeList(attrList, 0);
            }
            AttributeList newList = null;
            newList = this.correctTypesInAttributeList(objectType, attrList);
            if (tc.isDebugEnabled()) {
                this.dumpAttributeList(newList, 0);
            }
            configServiceProxy.resetAttributes(this.getCurrentSession(), on, newList);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (InvalidAttributeNameException iane) {
            String[] attrPath = iane.getAttributePath();
            this._shell.setAndThrowScriptingException("WASX7080E", "Invalid attributes specified.", new Object[]{objectType, attrPath.length > 0 ? attrPath[0] : attributes});
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
        return new String();
    }

    public String list() throws ScriptingException {
        this.helpInfo("list");
        return new String();
    }

    public String listTemplates() throws ScriptingException {
        this.helpInfo("listTemplates");
        return new String();
    }

    public String getObjectName() throws ScriptingException {
        this.helpInfo("getObjectName");
        return new String();
    }

    public String attributes() throws ScriptingException {
        this.helpInfo("attributes");
        return new String();
    }

    public String parents() throws ScriptingException {
        this.helpInfo("parents");
        return new String();
    }

    public String contents() throws ScriptingException {
        this.helpInfo("contents");
        return new String();
    }

    public String show() throws ScriptingException {
        this.helpInfo("show");
        return new String();
    }

    public String showAttribute() throws ScriptingException {
        this.helpInfo("showAttribute");
        return new String();
    }

    public String showAttribute(Object o) throws ScriptingException {
        this.helpInfo("showAttribute");
        return new String();
    }

    public String showall() throws ScriptingException {
        this.helpInfo("showall");
        return new String();
    }

    public String modify() throws ScriptingException {
        this.helpInfo("modify");
        return new String();
    }

    public String create() throws ScriptingException {
        this.helpInfo("create");
        return new String();
    }

    public String create(String x) throws ScriptingException {
        this.helpInfo("create");
        return new String();
    }

    public String create(String x, String y) throws ScriptingException {
        this.helpInfo("create");
        return new String();
    }

    public String createUsingTemplate() throws ScriptingException {
        this.helpInfo("createUsingTemplate");
        return new String();
    }

    public String createUsingTemplate(String x) throws ScriptingException {
        this.helpInfo("createUsingTemplate");
        return new String();
    }

    public String createUsingTemplate(String x, String y) throws ScriptingException {
        this.helpInfo("createUsingTemplate");
        return new String();
    }

    public String createClusterMember() throws ScriptingException {
        this.helpInfo("createClusterMember");
        return new String();
    }

    public String createClusterMember(String x) throws ScriptingException {
        this.helpInfo("createClusterMember");
        return new String();
    }

    public String createClusterMember(String x, String y) throws ScriptingException {
        this.helpInfo("createClusterMember");
        return new String();
    }

    public String convertToCluster() throws ScriptingException {
        this.helpInfo("convertToCluster");
        return new String();
    }

    public String convertToCluster(Object x) throws ScriptingException {
        this.helpInfo("convertToCluster");
        return new String();
    }

    public String remove() throws ScriptingException {
        this.helpInfo("remove");
        return new String();
    }

    public String getid() throws ScriptingException {
        this.helpInfo("getid");
        return new String();
    }

    public String checkin() throws ScriptingException {
        this.helpInfo("checkin");
        return new String();
    }

    public String checkin(Object x) throws ScriptingException {
        this.helpInfo("checkin");
        return new String();
    }

    public String checkin(Object x, Object y) throws ScriptingException {
        this.helpInfo("checkin");
        return new String();
    }

    public Object extract() throws ScriptingException {
        this.helpInfo("extract");
        return new String();
    }

    public Object extract(Object x) throws ScriptingException {
        this.helpInfo("extract");
        return new String();
    }

    public Object createDocument() throws ScriptingException {
        this.helpInfo("createDocument");
        return new String();
    }

    public Object createDocument(Object x) throws ScriptingException {
        this.helpInfo("createDocument");
        return new String();
    }

    public Object deleteDocument() throws ScriptingException {
        this.helpInfo("deleteDocument");
        return new String();
    }

    public Object existsDocument() throws ScriptingException {
        this.helpInfo("existsDocument");
        return new String();
    }

    public String getValidationSeverityResult() throws ScriptingException {
        this.helpInfo("getValidationSeverityResult");
        return new String();
    }

    public String getObjectType() throws ScriptingException {
        this.helpInfo("getObjectType");
        return new String();
    }

    public String installResourceAdapter() throws ScriptingException {
        this.helpInfo("installResourceAdapter");
        return new String();
    }

    public String installResourceAdapter(String x) throws ScriptingException {
        this.helpInfo("installResourceAdapter");
        return new String();
    }

    public String installResourceAdapter(String x, String y) throws ScriptingException {
        this.helpInfo("installResourceAdapter");
        return new String();
    }

    public String uninstallResourceAdapter() throws ScriptingException {
        this.helpInfo("uninstallResourceAdapter");
        return new String();
    }

    public String required() throws ScriptingException {
        this.helpInfo("required");
        return new String();
    }

    public String defaults() throws ScriptingException {
        this.helpInfo("defaults");
        return new String();
    }

    public String unsetAttributes() throws ScriptingException {
        this.helpInfo("unsetAttributes");
        return new String();
    }

    public String unsetAttributes(Object x) throws ScriptingException {
        this.helpInfo("unsetAttributes");
        return new String();
    }

    public String resetAttributes() throws ScriptingException {
        this.helpInfo("resetAttributes");
        return new String();
    }

    public String resetAttributes(Object x) throws ScriptingException {
        this.helpInfo("resetAttributes");
        return new String();
    }
}

