/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.deployment.deploywrapper.DeployOptions;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.AppManagementHelper;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentMessages;
import com.ibm.websphere.management.application.client.AppDeploymentProfile;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskMessages;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.filetransfer.client.TransferFailedException;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.DefaultBinding;
import com.ibm.ws.management.application.client.DefaultBindingHelper;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.management.fileservice.FileTransferFactory;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.AdminControlClient;
import com.ibm.ws.scripting.AppManagementProxy;
import com.ibm.ws.scripting.AppNotificationFilter;
import com.ibm.ws.scripting.CommonScriptingObject;
import com.ibm.ws.scripting.ExceptionSupport;
import com.ibm.ws.scripting.FileTools;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.util.ImplFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;

public class AdminAppClient
extends CommonScriptingObject
implements AppNotification.Listener {
    public static final String CUSTOMOPTION = "custom";
    private static TraceComponent tc = Tr.register(AdminAppClient.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static final String APPDEPLOYMENTOPTION = "AppDeploymentOptions";
    private static final String VERBOSEOPTION = "verbose";
    private static final String APPNAMEOPTION = "appname";
    private static final String APPEDITIONOPTION = "edition";
    private static final String APPEDITIONDESCOPTION = "edition.desc";
    private static final String CONTEXTROOTOPTION = "contextroot";
    private static final String INSTALLDIROPTION = "installdir";
    private static final String WASROOTOPTION = "was.install.root";
    private static final String CONFIGROOTOPTION = "configroot";
    private static final String CELLOPTION = "cell";
    private static final String NODEOPTION = "node";
    private static final String SERVEROPTION = "server";
    private static final String CLUSTEROPTION = "cluster";
    private static final String TARGETOPTION = "target";
    private static final String FILEPERMISSIONOPTION = "filepermission";
    private static final String EXPORTTOLOCALOPTION = "exportToLocal";
    private static final String INSTALLED_EAR_DESTINATION = "installed.ear.destination";
    private static final String DDLPREFIX = "ddlprefix";
    private static final String UPDATEOPTION = "update";
    private static final String UPDIGNORENEWOPTION = "update.ignore.new";
    private static final String UPDIGNOREOLDOPTION = "update.ignore.old";
    private static final String BACKENDIDOPTION = "BackendIdSelection";
    private static final String JNDINAMEOPTION = "JNDIName";
    private static final String SYSTEMAPP = "systemApp";
    private static final String SKIPPREP = "skipPreparation";
    private final String waitObject = "waitObject";
    private Properties waitProps = null;
    private String waitTarget = null;
    private long MAX_WAIT_TIME = 86400000L;
    private static final String SECURITY_WARNING_PROP = "com.ibm.ws.scripting.emitWarningForCustomSecurityPolicy";
    private static final String TEMPDIR_PROP = "com.ibm.ws.scripting.tempdir";
    private static final String NODE_PROP = "local.node";
    private static final String CELL_PROP = "local.cell";
    private static final String EJBDEPLOYOPTION = "EJBDeployOptions";
    private static final String WSDEPLOYOPTION = "WSDeployOptions";
    private static final String ALLOWFILTERPERMOPTION = "allowPermInFilterPolicy";
    private static final String VIEWTASKNAMEOPTION = "tasknames";
    private static final String UPDATE_URI = "contenturi";
    private static final String UPDATE_OPERATION = "operation";
    private static final String UPDATE_CONTENTS = "contents";
    private static final long UPDATE_MODULE_MODE = 0x110000L;
    private static final long UPDATE_ALL_MODE = 0x3111000L;
    private static final String CONTROLLER = "scripting.controller";
    private boolean successFlag = false;
    private String origFileName = null;
    private boolean zos = false;
    private static AdminAppClient _self = null;
    private static AppDeploymentTaskMessages appMessages = new AppDeploymentTaskMessages();
    private static Vector deprecatedOptions = null;
    private static Vector addonServerOptions = null;
    private static Vector clientOnlyOptions = null;
    private static Vector filterNoOptions = null;
    private static Properties nonTaskOptionMap = null;
    private static ArrayList taskFilter = null;
    private static Hashtable optionModes = null;
    private Vector deplOptions = null;
    private Vector hiddenOptions = null;
    private Vector deplEJBOptions = null;
    private Vector deplWSOptions = null;
    private ArrayList booleanDeplOptions = null;
    private ArrayList nonBooleanDeplOptions = null;
    private ArrayList otherListedDeplOptions = null;
    private String PROMPT_Task = null;
    private String PROMPT_Setting_To = null;
    private String PROMPT_Required_Field_Missing = null;
    private String PROMPT_Yes_or_No = null;
    private static AppManagementProxy appManagementProxy = null;
    private StringBuffer commandLine = null;
    private String cellName = null;
    private String UPLOADDIR = "upload";
    private String DOWNLOADDIR = "download";

    public static AdminAppClient getInstance() {
        return _self;
    }

    public AdminAppClient(AbstractShell shell) throws AdminException, ConnectorException {
        super(shell, null);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AdminAppClient");
        }
        if (_client == null) {
            Tr.warning(tc, "CONTROL_SERVICE_NOT_AVAILABLE", null);
        }
        _self = this;
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.zos = true;
        }
        int timeout = shell.getAppTimeout();
        Tr.debug(tc, "timeout " + timeout);
        this.MAX_WAIT_TIME = timeout;
        this.PROMPT_Task = _bundle.getString("WASX7135I");
        this.PROMPT_Setting_To = _bundle.getString("WASX7136I");
        this.PROMPT_Required_Field_Missing = _bundle.getString("WASX7137I");
        this.PROMPT_Yes_or_No = _bundle.getString("WASX7138I");
        this.getAllAppDeplOptions();
        this.booleanDeplOptions = new ArrayList();
        this.nonBooleanDeplOptions = new ArrayList();
        deprecatedOptions = new Vector();
        addonServerOptions = new Vector();
        clientOnlyOptions = new Vector();
        filterNoOptions = new Vector();
        clientOnlyOptions.addElement(new AppDeploymentProfile.DeplOption("usedefaultbindings", Boolean.FALSE, 0x111001L, 0x111001L, null));
        clientOnlyOptions.addElement(new AppDeploymentProfile.DeplOption("defaultbinding.datasource.jndi", "", 0x111001L, 0x111001L, null));
        clientOnlyOptions.addElement(new AppDeploymentProfile.DeplOption("defaultbinding.datasource.username", "", 0x111001L, 0x111001L, null));
        clientOnlyOptions.addElement(new AppDeploymentProfile.DeplOption("defaultbinding.datasource.password", "", 0x111001L, 0x111001L, null));
        clientOnlyOptions.addElement(new AppDeploymentProfile.DeplOption("defaultbinding.cf.jndi", "", 0x111001L, 0x111001L, null));
        clientOnlyOptions.addElement(new AppDeploymentProfile.DeplOption("defaultbinding.cf.resauth", "", 0x111001L, 0x111001L, null));
        clientOnlyOptions.addElement(new AppDeploymentProfile.DeplOption("defaultbinding.ejbjndi.prefix", "", 0x111001L, 0x111001L, null));
        clientOnlyOptions.addElement(new AppDeploymentProfile.DeplOption("defaultbinding.virtual.host", "", 0x111001L, 0x111001L, null));
        clientOnlyOptions.addElement(new AppDeploymentProfile.DeplOption("defaultbinding.force", Boolean.FALSE, 0x111001L, 0x111001L, null));
        clientOnlyOptions.addElement(new AppDeploymentProfile.DeplOption("defaultbinding.strategy.file", "", 0x111001L, 0x111001L, null));
        clientOnlyOptions.addElement(new AppDeploymentProfile.DeplOption(ALLOWFILTERPERMOPTION, Boolean.FALSE, 4097L, 4097L, null));
        clientOnlyOptions.addElement(new AppDeploymentProfile.DeplOption(VERBOSEOPTION, Boolean.FALSE, 0x8111111L, 0x8111111L, null));
        clientOnlyOptions.addElement(new AppDeploymentProfile.DeplOption(APPNAMEOPTION, "", 4096L, 4096L, null));
        clientOnlyOptions.addElement(new AppDeploymentProfile.DeplOption(VIEWTASKNAMEOPTION, Boolean.FALSE, 0x4000000L, 0x4000000L, null));
        addonServerOptions.addElement(new AppDeploymentProfile.DeplOption(FILEPERMISSIONOPTION, ".*\\.dll=755#.*\\.so=755#.*\\.a=755#.*\\.sl=755", 4113L, 4113L, null));
        addonServerOptions.addElement(new AppDeploymentProfile.DeplOption(TARGETOPTION, "", 0x8101001L, 0x8101001L, null));
        addonServerOptions.addElement(new AppDeploymentProfile.DeplOption(SERVEROPTION, "", 0x8101001L, 0x8101001L, null));
        addonServerOptions.addElement(new AppDeploymentProfile.DeplOption(NODEOPTION, "", 0x8101001L, 0x8101001L, null));
        addonServerOptions.addElement(new AppDeploymentProfile.DeplOption(CELLOPTION, "", 0x8101001L, 0x8101001L, null));
        addonServerOptions.addElement(new AppDeploymentProfile.DeplOption(CLUSTEROPTION, "", 0x8101001L, 0x8101001L, null));
        addonServerOptions.addElement(new AppDeploymentProfile.DeplOption(CONTEXTROOTOPTION, "", 0x101001L, 0x101001L, null));
        addonServerOptions.addElement(new AppDeploymentProfile.DeplOption(UPDATEOPTION, Boolean.FALSE, 4097L, 4097L, null));
        addonServerOptions.addElement(new AppDeploymentProfile.DeplOption(UPDIGNOREOLDOPTION, Boolean.FALSE, 69633L, 69633L, null));
        addonServerOptions.addElement(new AppDeploymentProfile.DeplOption(UPDIGNORENEWOPTION, Boolean.FALSE, 69633L, 69633L, null));
        addonServerOptions.addElement(new AppDeploymentProfile.DeplOption(CUSTOMOPTION, "", 0xB111001L, 0xB111001L, null));
        addonServerOptions.addElement(new AppDeploymentProfile.DeplOption(UPDATE_URI, "", 0x3111000L, 0x3111000L, null));
        addonServerOptions.addElement(new AppDeploymentProfile.DeplOption(UPDATE_CONTENTS, "", 0x3111000L, 0x3111000L, null));
        addonServerOptions.addElement(new AppDeploymentProfile.DeplOption(UPDATE_OPERATION, "", 0x3111000L, 0x3111000L, null));
        addonServerOptions.addElement(new AppDeploymentProfile.DeplOption(INSTALLED_EAR_DESTINATION, "", 0x3111111L, 0x3111111L, null));
        AppDeploymentProfile.DeplOption option = new AppDeploymentProfile.DeplOption("contenttype", "", 0x3111000L, 0x3111000L, null);
        option.setHidden(true);
        addonServerOptions.addElement(option);
        option = new AppDeploymentProfile.DeplOption(APPNAMEOPTION, "", 0x3110000L, 0x3110000L, null);
        option.setHidden(true);
        addonServerOptions.addElement(option);
        option = new AppDeploymentProfile.DeplOption(UPDATEOPTION, Boolean.FALSE, 0x3110000L, 0x3110000L, null);
        option.setHidden(true);
        addonServerOptions.addElement(option);
        option = new AppDeploymentProfile.DeplOption("app.original.uri", "", 0x3111111L, 0x3111111L, null);
        option.setHidden(true);
        addonServerOptions.addElement(option);
        option = new AppDeploymentProfile.DeplOption("app.client.locale", "", 0x3111111L, 0x3111111L, null);
        option.setHidden(true);
        addonServerOptions.addElement(option);
        deprecatedOptions.addElement(new AppDeploymentProfile.DeplOption(INSTALLDIROPTION, "", 4097L, 4097L, null));
        deprecatedOptions.addElement(new AppDeploymentProfile.DeplOption("depl.extension.reg", "", 4097L, 4097L, null));
        deprecatedOptions.addElement(new AppDeploymentProfile.DeplOption(CONFIGROOTOPTION, "", 0L, 0L, null));
        deprecatedOptions.addElement(new AppDeploymentProfile.DeplOption(WASROOTOPTION, "", 0L, 0L, null));
        filterNoOptions.addElement(UPDATEOPTION);
        filterNoOptions.addElement(UPDIGNOREOLDOPTION);
        filterNoOptions.addElement(UPDIGNORENEWOPTION);
        filterNoOptions.addElement(VERBOSEOPTION);
        filterNoOptions.addElement("defaultbinding.force");
        filterNoOptions.addElement("usedefaultbindings");
        filterNoOptions.addElement(VIEWTASKNAMEOPTION);
        nonTaskOptionMap = new Properties();
        nonTaskOptionMap.setProperty(FILEPERMISSIONOPTION, FILEPERMISSIONOPTION);
        nonTaskOptionMap.setProperty(TARGETOPTION, TARGETOPTION);
        nonTaskOptionMap.setProperty(SERVEROPTION, "server.name");
        nonTaskOptionMap.setProperty(CLUSTEROPTION, "cluster.name");
        nonTaskOptionMap.setProperty(CELLOPTION, "cell.name");
        nonTaskOptionMap.setProperty(NODEOPTION, "node.name");
        nonTaskOptionMap.setProperty(INSTALLDIROPTION, INSTALLED_EAR_DESTINATION);
        nonTaskOptionMap.setProperty(WASROOTOPTION, WASROOTOPTION);
        nonTaskOptionMap.setProperty(CONFIGROOTOPTION, "config.root");
        nonTaskOptionMap.setProperty(UPDATEOPTION, "redeploy");
        nonTaskOptionMap.setProperty(UPDIGNOREOLDOPTION, "redeploy.ignore.old");
        nonTaskOptionMap.setProperty(UPDIGNORENEWOPTION, "redeploy.ignore.new");
        nonTaskOptionMap.setProperty(CONTEXTROOTOPTION, CONTEXTROOTOPTION);
        taskFilter = new ArrayList();
        taskFilter.add("original.ear.location");
        taskFilter.add(INSTALLED_EAR_DESTINATION);
        taskFilter.add(EJBDEPLOYOPTION);
        taskFilter.add(WSDEPLOYOPTION);
        optionModes = new Hashtable();
        optionModes.put("installapp", new Long(1L));
        optionModes.put("editapp", new Long(16L));
        optionModes.put("editmodule", new Long(256L));
        optionModes.put("updateapp", new Long(4096L));
        optionModes.put("addmodule", new Long(0x100000L));
        optionModes.put("updatemodule", new Long(65536L));
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AdminAppClient");
        }
    }

    private static void dbg(Object o) {
        System.out.println(o);
    }

    private void init() throws AdminException, ConnectorException {
        if (_client == null) {
            if (!this._shell.getConnectionType().equals("NONE")) {
                Tr.warning(tc, "WASX7206W", null);
            }
            appManagementProxy = null;
            this.cellName = System.getProperty(CELL_PROP);
        } else {
            String processName = null;
            if (connectedServer != null) {
                processName = ObjectNameHelper.getProcessName(connectedServer);
                this.cellName = ObjectNameHelper.getCellName(connectedServer);
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "using process " + processName);
                }
                appManagementProxy = new AppManagementProxy(_client, processName);
            } else {
                if (!this._shell.getConnectionType().equals("NONE")) {
                    Tr.warning(tc, "WASX7206W", null);
                }
                appManagementProxy = null;
                this.cellName = System.getProperty(CELL_PROP);
            }
        }
    }

    public void doReconnect() throws AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doReconnect");
        }
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doReconnect");
        }
    }

    public String help() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "help");
        }
        String msg = this._shell.getFormattedMessage("WASX7095I", new Object[0], "no help available");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "help");
        }
        return msg;
    }

    public String help(String item) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "help - " + item);
        }
        String msg = null;
        try {
            String goalTitle = appMessages.getGoalTitle(item);
            if (!goalTitle.endsWith("goalTitle")) {
                StringBuffer buf = new StringBuffer();
                buf.append(nl);
                buf.append(item);
                buf.append(": ");
                buf.append(appMessages.getGoalTitle(item));
                buf.append(nl);
                buf.append(nl);
                buf.append(appMessages.getGoalMessage(item));
                buf.append(nl);
                buf.append(nl);
                msg = buf.toString();
            } else {
                if (item.startsWith("-")) {
                    item = item.substring(1);
                }
                String key = "ADMINAPP_HELP_" + item.toUpperCase();
                if (item.equalsIgnoreCase("deployejb.dbtype")) {
                    String[] dbtypes = DeployOptions.getDatabaseTypes();
                    StringBuffer types2 = new StringBuffer();
                    for (int i = 0; i < dbtypes.length; ++i) {
                        if (types2.length() > 0) {
                            types2.append(", ");
                        }
                        types2.append(dbtypes[i]);
                    }
                    msg = this._shell.getFormattedMessage(key, new Object[]{types2.toString()}, "No help available for " + item);
                } else {
                    msg = this._shell.getFormattedMessage(key, new Object[0], "No help available for " + item);
                }
                if (msg.startsWith("No help available")) {
                    key = "WASX7084E";
                    msg = this._shell.getFormattedMessage(key, new Object[]{item}, "No help available for " + item);
                }
            }
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "help");
        }
        return msg;
    }

    public String editInteractive() throws ScriptingException {
        this.helpInfo("editInteractive");
        return new String();
    }

    public String installInteractive() throws ScriptingException {
        this.helpInfo("installInteractive");
        return new String();
    }

    public String edit() throws ScriptingException {
        this.helpInfo("edit");
        return new String();
    }

    public String edit(String x) throws ScriptingException {
        this.helpInfo("edit");
        return new String();
    }

    public String install() throws ScriptingException {
        this.helpInfo("install");
        return new String();
    }

    public String update() throws ScriptingException {
        this.helpInfo(UPDATEOPTION);
        return new String();
    }

    public String update(String x) throws ScriptingException {
        this.helpInfo(UPDATEOPTION);
        return new String();
    }

    public String updateInteractive() throws ScriptingException {
        this.helpInfo("updateInteractive");
        return new String();
    }

    public String updateInteractive(String x) throws ScriptingException {
        this.helpInfo("updateInteractive");
        return new String();
    }

    public String uninstall() throws ScriptingException {
        this.helpInfo("uninstall");
        return new String();
    }

    public String taskInfo() throws ScriptingException {
        this.helpInfo("taskInfo");
        return new String();
    }

    public String export() throws ScriptingException {
        this.helpInfo("export");
        return new String();
    }

    public String export(String x) throws ScriptingException {
        this.helpInfo("export");
        return new String();
    }

    public String exportDDL() throws ScriptingException {
        this.helpInfo("exportDDL");
        return new String();
    }

    public String exportDDL(String x) throws ScriptingException {
        this.helpInfo("exportDDL");
        return new String();
    }

    public String exportFile() throws ScriptingException {
        this.helpInfo("exportFile");
        return new String();
    }

    public String exportFile(String x) throws ScriptingException {
        this.helpInfo("exportFile");
        return new String();
    }

    public String exportFile(String x, String y) throws ScriptingException {
        this.helpInfo("exportFile");
        return new String();
    }

    public String listModules() throws ScriptingException {
        this.helpInfo("listModules");
        return new String();
    }

    public String updateAccessIDs() throws ScriptingException {
        this.helpInfo("updateAccessIDs");
        return new String();
    }

    public String deleteUserAndGroupEntries() throws ScriptingException {
        this.helpInfo("deleteUserAndGroupEntries");
        return new String();
    }

    public String publishWSDL() throws ScriptingException {
        this.helpInfo("publishWSDL");
        return new String();
    }

    public String publishWSDL(String x) throws ScriptingException {
        this.helpInfo("publishWSDL");
        return new String();
    }

    public String view() throws ScriptingException {
        this.helpInfo("view");
        return new String();
    }

    public String searchJNDIReferences() throws ScriptingException {
        this.helpInfo("searchJNDIReferences");
        return new String();
    }

    public String searchJNDIReferences(String x) throws ScriptingException {
        this.helpInfo("searchJNDIReferences");
        return new String();
    }

    public String isAppReady() throws ScriptingException {
        this.helpInfo("isAppReady");
        return new String();
    }

    public String editInteractive(String appName) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "editInteractive: ", new Object[]{appName});
        }
        this._shell.setLastException(null);
        String ret = this.editInteractive(appName, new String());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "editInteractive");
        }
        return ret;
    }

    public String editInteractive(String appName, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "editInteractive: ", new Object[]{appName, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String strOptions = this._langutils.objectArrayToString(options);
        String ret = this.editInteractive(appName, strOptions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "editInteractive");
        }
        return ret;
    }

    public String editInteractive(String appName, String options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "editInteractive: ", new Object[]{appName, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        this.commandLine = new StringBuffer();
        if (this._shell.getLang().equalsIgnoreCase("jython")) {
            this.commandLine.append("AdminApp.");
            this.commandLine.append("edit(");
        } else {
            this.commandLine.append("$AdminApp ");
            this.commandLine.append("edit ");
        }
        this.commandLine.append(this._langutils.addQuotes());
        this.commandLine.append(appName);
        this.commandLine.append(this._langutils.addQuotes());
        if (this._shell.getLang().equalsIgnoreCase("jython")) {
            this.commandLine.append(", ");
        } else {
            this.commandLine.append(" ");
        }
        this.commandLine.append(this._langutils.addQuotes());
        this.commandLine.append(this._langutils.getOpenNestedAttribute());
        String data = new String(options);
        data = this._langutils.cleanAttributeString(data);
        data = this._langutils.removeQuotes(data);
        String ret = this.commonEdit(appName, options, true, true);
        this.commandLine.append(this._langutils.getCloseNestedAttribute());
        this.commandLine.append(this._langutils.addQuotes());
        if (this._shell.getLang().equalsIgnoreCase("jython")) {
            this.commandLine.append(")");
        }
        Tr.audit(tc, "WASX7278I", this.commandLine.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "EditInteractive");
        }
        return ret;
    }

    public String edit(String appName, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "edit: ", new Object[]{appName, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String strOptions = this._langutils.objectArrayToString(options);
        String ret = this.edit(appName, strOptions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "edit");
        }
        return ret;
    }

    public String edit(String appName, String options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "edit: ", new Object[]{appName, options});
        }
        this._shell.setLastException(null);
        String ret = this.commonEdit(appName, options, false, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "edit");
        }
        return ret;
    }

    public String installInteractive(String earfile) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installInteractive: ", new Object[]{earfile});
        }
        this._shell.setLastException(null);
        String ret = this.installInteractive(earfile, new String());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installInteractive");
        }
        return ret;
    }

    public String installInteractive(String earfile, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installInteractive: ", new Object[]{earfile, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String strOption = this._langutils.objectArrayToString(options);
        String ret = this.installInteractive(earfile, strOption);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installInteractive");
        }
        return ret;
    }

    public String installInteractive(String earfile, String options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installInteractive: ", new Object[]{earfile, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        this.commandLine = new StringBuffer();
        if (this._shell.getLang().equalsIgnoreCase("jython")) {
            this.commandLine.append("AdminApp.");
            this.commandLine.append("install(");
        } else {
            this.commandLine.append("$AdminApp ");
            this.commandLine.append("install ");
        }
        this.commandLine.append(this._langutils.addQuotes());
        this.commandLine.append(earfile);
        this.commandLine.append(this._langutils.addQuotes());
        if (this._shell.getLang().equalsIgnoreCase("jython")) {
            this.commandLine.append(", ");
        } else {
            this.commandLine.append(" ");
        }
        this.commandLine.append(this._langutils.addQuotes());
        this.commandLine.append(this._langutils.getOpenNestedAttribute());
        String data = new String(options);
        data = this._langutils.cleanAttributeString(data);
        data = this._langutils.removeQuotes(data);
        this.commandLine.append(data);
        this.commandLine.append(" ");
        this.doInstall(earfile, options, true);
        this.commandLine.append(this._langutils.getCloseNestedAttribute());
        this.commandLine.append(this._langutils.addQuotes());
        if (this._shell.getLang().equalsIgnoreCase("jython")) {
            this.commandLine.append(")");
        }
        Tr.audit(tc, "WASX7278I", this.commandLine.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installInteractive");
        }
        return new String();
    }

    public String install(String earfile) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "install: ", new Object[]{earfile});
        }
        this._shell.setLastException(null);
        String ret = this.install(earfile, new String());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "install");
        }
        return ret;
    }

    public String install(String earfile, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "install: ", new Object[]{earfile, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String strOptions = this._langutils.objectArrayToString(options);
        this.install(earfile, strOptions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "install");
        }
        return new String();
    }

    public String install(String earfile, String options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "install: ", new Object[]{earfile, options});
        }
        this._shell.setLastException(null);
        this.doInstall(earfile, options, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "install");
        }
        return new String();
    }

    public String update(String appName, String type, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, UPDATEOPTION, new Object[]{appName, type, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String strOptions = this._langutils.objectArrayToString(options);
        String ret = this.update(appName, type, strOptions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, UPDATEOPTION);
        }
        return ret;
    }

    public String update(String appName, String type, String options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, UPDATEOPTION, new Object[]{appName, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        Hashtable optProps = this._langutils.optionsToHashtable(options);
        optProps.put("contenttype", type);
        optProps.put(APPNAMEOPTION, appName);
        optProps.put(UPDATEOPTION, new String());
        this.validateUpdateOptions(optProps);
        String earFile = (String)optProps.get(UPDATE_CONTENTS);
        this.doInstall(earFile, optProps, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, UPDATEOPTION);
        }
        return new String();
    }

    public String updateInteractive(String appName, String type, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateInteractive", new Object[]{appName, type, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String strOptions = this._langutils.objectArrayToString(options);
        String ret = this.updateInteractive(appName, type, strOptions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateInteractive");
        }
        return ret;
    }

    public String updateInteractive(String appName, String type, String options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateInteractive", new Object[]{appName, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        Hashtable optProps = this._langutils.optionsToHashtable(options);
        String earFile = (String)optProps.get(UPDATE_CONTENTS);
        optProps.put("contenttype", type);
        optProps.put(APPNAMEOPTION, appName);
        optProps.put(UPDATEOPTION, new String());
        this.commandLine = new StringBuffer();
        if (this._shell.getLang().equalsIgnoreCase("jython")) {
            this.commandLine.append("AdminApp.");
            this.commandLine.append("update(");
        } else {
            this.commandLine.append("$AdminApp ");
            this.commandLine.append("update ");
        }
        this.commandLine.append(this._langutils.addQuotes());
        this.commandLine.append(appName);
        this.commandLine.append(this._langutils.addQuotes());
        if (this._shell.getLang().equalsIgnoreCase("jython")) {
            this.commandLine.append(", ");
            this.commandLine.append(this._langutils.addQuotes());
        } else {
            this.commandLine.append(" ");
        }
        this.commandLine.append(type);
        if (this._shell.getLang().equalsIgnoreCase("jython")) {
            this.commandLine.append(this._langutils.addQuotes());
            this.commandLine.append(", ");
        } else {
            this.commandLine.append(" ");
        }
        this.commandLine.append(this._langutils.addQuotes());
        this.commandLine.append(this._langutils.getOpenNestedAttribute());
        String data = new String(options);
        data = this._langutils.cleanAttributeString(data);
        data = this._langutils.removeQuotes(data);
        this.commandLine.append(data);
        this.commandLine.append(" ");
        this.validateUpdateOptions(optProps);
        this.doInstall(earFile, optProps, true);
        this.commandLine.append(this._langutils.getCloseNestedAttribute());
        this.commandLine.append(this._langutils.addQuotes());
        if (this._shell.getLang().equalsIgnoreCase("jython")) {
            this.commandLine.append(")");
        }
        Tr.audit(tc, "WASX7278I", this.commandLine.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateInteractive");
        }
        return new String();
    }

    public String uninstall(String appname) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstall: ", new Object[]{appname});
        }
        this._shell.setLastException(null);
        String ret = this.uninstall(appname, new String());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstall");
        }
        return ret;
    }

    public String export(String appname, String filename) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "export: ", new Object[]{appname, filename});
        }
        this._shell.setLastException(null);
        String ret = this.export(appname, filename, new String());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "export");
        }
        return ret;
    }

    public String export(String appname, String filename, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "export: ", new Object[]{appname, filename, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String strOptions = this._langutils.objectArrayToString(options);
        String ret = this.export(appname, filename, strOptions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "export");
        }
        return ret;
    }

    public String export(String appname, String filename, String options) throws ScriptingException {
        this._shell.setLastException(null);
        try {
            Hashtable optProps;
            boolean local;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "export: ", new Object[]{appname, filename, options});
            }
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            if (!this.alreadyInstalled(appname, local = this.isLocalMode(optProps = this._langutils.optionsToHashtable(options), true), optProps)) {
                this._shell.setAndThrowScriptingException("WASX7280E", "An application with name " + appname + " does not exist.", new Object[]{appname});
            }
            if (!local) {
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "This export mediated by MBean.");
                }
                this.checkService();
                boolean exportToLocal = optProps.containsKey(EXPORTTOLOCALOPTION);
                String exportPath = exportToLocal ? this.getDownloadStagingLocation(filename) : filename;
                appManagementProxy.exportApplication(appname, exportPath, new Hashtable(), this.getWorkspaceId());
                if (exportToLocal && !exportPath.equals(filename)) {
                    this.copyFromServer(exportPath, filename);
                }
            } else {
                this.warnIfConnected();
                AppManagement mgmt = null;
                ConfigRepositoryFactory.getConfigRepository().initialize(new Properties());
                mgmt = AppManagementFactory.createLocalAppManagementImpl();
                AdminConfigClient cfg = AdminConfigClient.getInstance();
                if (cfg.getConfigService() == null) {
                    mgmt.exportApplication(appname, filename, new Hashtable(), null);
                } else {
                    mgmt.exportApplication(appname, filename, new Hashtable(), this.getWorkspaceId());
                }
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "export");
        }
        return new String();
    }

    private String getDownloadStagingLocation(String filename) throws ConnectorException, ScriptingException, AdminException, MalformedObjectNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDownloadStagingLocation", new Object[]{filename});
        }
        String ret = filename;
        if ((this.isCellManager() || this.is60Standalone() || this.isAdminAgent()) && filename != null) {
            AdminControlClient controlClient = AdminControlClient.getInstance();
            String localInetAddressByName = controlClient.getHost() + "/" + AdminAppClient.getLocalHostAddress();
            String hostInetAddressByName = AdminAppClient.getHostInetAddressByName(controlClient.getHost());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "localInetAddressByName is " + localInetAddressByName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "hostInetAddressByName is " + hostInetAddressByName);
            }
            if (!(controlClient == null || controlClient.getHost().equals("localhost") || controlClient.getHost().equals(AppDeploymentInfo.getLocalHost()) || controlClient.getHost().equals(AdminAppClient.getLongLocalHost()) || controlClient.getHost().equals(AdminAppClient.getLocalHostAddress()) || hostInetAddressByName.equals(localInetAddressByName))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "upload files from " + AppDeploymentInfo.getLocalHost() + " to " + controlClient.getHost());
                }
                FileTransferClient transfer = FileTransferFactory.getFileTransferClient(_client);
                String remDir = transfer.getServerStagingLocation();
                File f = new File(filename);
                String sep = File.separator;
                if (remDir != null) {
                    sep = remDir.indexOf("/") >= 0 ? "/" : "\\";
                }
                String targetName = this.DOWNLOADDIR + sep + f.getName();
                if (!remDir.endsWith("/") && !remDir.endsWith("\\")) {
                    remDir = remDir + sep;
                }
                ret = remDir + targetName;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDownloadStagingLocation", new Object[]{ret});
        }
        return ret;
    }

    private void copyFromServer(String srcPath, String destFile) throws ScriptingException, AdminException, TransferFailedException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFromServer");
        }
        FileTransferClient transfer = FileTransferFactory.getFileTransferClient(_client);
        FileTransferOptions options = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
        options.setDeleteSourceOnCompletion(true);
        String transferHome = transfer.getServerStagingLocation();
        String srcUrl = srcPath.substring(transferHome.length());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "download files from " + AdminControlClient.getInstance().getHost() + " to " + AppDeploymentInfo.getLocalHost());
        }
        try {
            transfer.downloadFile(srcUrl, new File(destFile).getCanonicalFile(), options);
        }
        catch (IOException ioe) {
            this._shell.setLastException(ioe);
            throw ioe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFromServer");
        }
    }

    public String exportDDL(String appname, String dirname) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportDDL: ", new Object[]{appname, dirname});
        }
        this._shell.setLastException(null);
        String ret = this.exportDDL(appname, dirname, new String());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportDDL");
        }
        return ret;
    }

    public String exportDDL(String appname, String dirname, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportDDL: ", new Object[]{appname, dirname, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String strOptions = this._langutils.objectArrayToString(options);
        String ret = this.exportDDL(appname, dirname, strOptions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportDDL");
        }
        return ret;
    }

    public String exportDDL(String appname, String dirname, String options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportDDL: ", new Object[]{appname, dirname, options});
        }
        this._shell.setLastException(null);
        try {
            Hashtable optProps;
            boolean local;
            String ddlprefix = null;
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            if (!this.alreadyInstalled(appname, local = this.isLocalMode(optProps = this._langutils.optionsToHashtable(options), true), optProps)) {
                this._shell.setAndThrowScriptingException("WASX7280E", "An application with name " + appname + " does not exist.", new Object[]{appname});
            }
            if (optProps.containsKey(DDLPREFIX)) {
                ddlprefix = (String)optProps.get(DDLPREFIX);
            }
            if (!local) {
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "This exportDDL mediated by MBean.");
                }
                this.checkService();
                appManagementProxy.extractDDL(appname, ddlprefix, dirname, new Hashtable(), this.getWorkspaceId());
            } else {
                this.warnIfConnected();
                AppManagement mgmt = null;
                ConfigRepositoryFactory.getConfigRepository().initialize(new Properties());
                mgmt = AppManagementFactory.createLocalAppManagementImpl();
                AdminConfigClient cfg = AdminConfigClient.getInstance();
                if (cfg.getConfigService() == null) {
                    mgmt.extractDDL(appname, ddlprefix, dirname, new Hashtable(), null);
                } else {
                    mgmt.extractDDL(appname, ddlprefix, dirname, new Hashtable(), this.getWorkspaceId());
                }
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportDDL");
        }
        return new String();
    }

    public String exportFile(String appname, String uri, String fileName) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportFile: ", new Object[]{appname, uri, fileName});
        }
        this._shell.setLastException(null);
        String ret = this.exportFile(appname, uri, fileName, new Hashtable());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportFile");
        }
        return ret;
    }

    public String exportFile(String appname, String uri, String fileName, Hashtable prefs) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportFile: ", new Object[]{appname, uri, fileName, prefs});
        }
        this._shell.setLastException(null);
        FileOutputStream fos = null;
        try {
            File out;
            prefs.put("app.client.locale", Locale.getDefault());
            boolean local = this.isLocalMode(prefs, true);
            if (!this.alreadyInstalled(appname, local, prefs)) {
                this._shell.setAndThrowScriptingException("WASX7280E", "An application with name " + appname + " does not exist.", new Object[]{appname});
            }
            if ((out = new File(fileName)).exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "output file " + fileName + " is an existing file");
                }
                this._shell.setAndThrowScriptingException("WASX7475E", "Output file " + fileName + " already exists. Specify a non-existent output file name.", new Object[]{fileName});
            }
            byte[] fileContent = null;
            if (!local) {
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "This exportFile mediated by MBean.");
                }
                this.checkService();
                fileContent = appManagementProxy.getApplicationContents(appname, uri, prefs, this.getWorkspaceId());
            } else {
                this.warnIfConnected();
                AppManagement mgmt = null;
                ConfigRepositoryFactory.getConfigRepository().initialize(new Properties());
                mgmt = AppManagementFactory.createLocalAppManagementImpl();
                AdminConfigClient cfg = AdminConfigClient.getInstance();
                fileContent = cfg.getConfigService() == null ? mgmt.getApplicationContents(appname, uri, prefs, null) : mgmt.getApplicationContents(appname, uri, prefs, this.getWorkspaceId());
            }
            if (fileContent != null) {
                fos = new FileOutputStream(out);
                fos.write(fileContent);
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        finally {
            block22: {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ioex) {
                        if (!tc.isDebugEnabled()) break block22;
                        Tr.debug(tc, "IOException when closing outfile file");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportFile");
        }
        return new String();
    }

    public void doInstall(String earfile, String options, boolean interactive) throws ScriptingException {
        Hashtable optProps;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doInstall", new Object[]{earfile, options, new Boolean(interactive)});
        }
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        if ((optProps = this._langutils.optionsToHashtable(options)).containsKey(UPDATEOPTION)) {
            optProps.put("contenttype", "app");
            optProps.put(UPDATE_OPERATION, UPDATEOPTION);
        }
        this.doInstall(earfile, optProps, interactive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doInstall");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doInstall(String earfile, Hashtable optProps, boolean interactive) throws ScriptingException {
        block33: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "doInstall", new Object[]{earfile, optProps, new Boolean(interactive)});
            }
            try {
                File temp;
                if (earfile != null) {
                    earfile = this._shell.normalizeFQPathName(earfile);
                }
                String tempName = null;
                try {
                    Hashtable prefs;
                    Hashtable appO;
                    boolean local = this.isLocalMode(optProps, false);
                    if (!local) {
                        this.checkService();
                    }
                    if (earfile != null) {
                        optProps.put("app.original.uri", earfile);
                    }
                    String appName = (String)optProps.get(APPNAMEOPTION);
                    String editionName = (String)optProps.get(APPEDITIONOPTION);
                    if (editionName != null) {
                        optProps.put(APPEDITIONOPTION, editionName);
                    }
                    if (optProps.containsKey(APPNAMEOPTION) && !optProps.containsKey(UPDATEOPTION) && this.alreadyInstalled(appName, local, optProps)) {
                        this._shell.setAndThrowScriptingException("WASX7279E", "An application with name " + EditionHelper.getCompositeName(appName, editionName) + " already exists.  Please choose a different name.", new Object[]{EditionHelper.getCompositeName(appName, editionName)});
                    }
                    if (optProps.containsKey(UPDATEOPTION)) {
                        if (!optProps.containsKey(APPNAMEOPTION)) {
                            this._shell.setAndThrowScriptingException("WASX7336E", "The -appname option is required if update is specified.", new Object[]{APPNAMEOPTION, UPDATEOPTION});
                        } else if (!this.alreadyInstalled(appName, local, optProps)) {
                            this._shell.setAndThrowScriptingException("WASX7280E", "An application with name " + EditionHelper.getCompositeName(appName, editionName) + " does not exist.", new Object[]{EditionHelper.getCompositeName(appName, editionName)});
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking to see if earfile is null, earfile=" + earfile);
                    }
                    if (earfile != null) {
                        this.origFileName = new String(earfile);
                        File input = new File(earfile);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "input.getAbsolutePath()=" + input.getAbsolutePath());
                            Tr.debug(tc, "input.getPath()=" + input.getParent());
                        }
                        if (!input.isAbsolute()) {
                            earfile = earfile.indexOf("${") == -1 ? input.getAbsolutePath() : input.getPath();
                        }
                        if (optProps.containsKey(SYSTEMAPP) || optProps.containsKey(SKIPPREP)) {
                            tempName = earfile;
                        } else {
                            tempName = input.isDirectory() ? this.copyDirToTempDir(input) : this.copyToTempDir(input, (String)optProps.get("contenttype"));
                            tempName = this.wrapIfNeeded(tempName, optProps, earfile);
                        }
                    }
                    if ((appO = this.commonPrepare(tempName, optProps, prefs = this.createPreferences(tempName, optProps, interactive), interactive)) != null) {
                        if (appO.containsKey(CONTROLLER)) {
                            this.commonInstall(tempName, optProps, appO);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "null controller; pass in original ear: " + earfile);
                            }
                            this.commonInstall(tempName, optProps, appO);
                        }
                    }
                    if (tempName == null) break block33;
                    temp = new File(tempName);
                    if (tempName.equals(earfile)) break block33;
                }
                catch (Throwable throwable) {
                    if (tempName != null) {
                        File temp2 = new File(tempName);
                        if (!tempName.equals(earfile)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "install; removing temp file in finally clause: " + tempName);
                            }
                            boolean delete = temp2.delete();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "install; delete returned", delete);
                            }
                        }
                    }
                    throw throwable;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "install; removing temp file in finally clause: " + tempName);
                }
                boolean delete = temp.delete();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "install; delete returned", delete);
                }
            }
            catch (ScriptingException se) {
                throw se;
            }
            catch (Exception ae) {
                this._shell.setLastException(ae);
                String detail = ExceptionSupport.getMessage(ae, "WASX");
                if (detail == null) {
                    detail = ae.toString();
                }
                throw new ScriptingException(detail);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doInstall");
        }
    }

    public String commonEdit(String appName, String options, boolean interactive, boolean editFlag) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commonEdit: ", new Object[]{appName, options, new Boolean(interactive)});
        }
        StringBuffer buf = new StringBuffer();
        Hashtable prefs = new Hashtable();
        Vector tasks = null;
        AppManagement mgmt = null;
        AppDeploymentController ctrl = null;
        try {
            Vector badopts;
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            Hashtable optProps = this._langutils.optionsToHashtable(options);
            boolean local = this.isLocalMode(optProps, true);
            boolean isModule = false;
            String moduleURI = null;
            int hash = appName.indexOf("#");
            if (hash >= 0) {
                moduleURI = appName.substring(hash + 1);
                isModule = true;
                appName = appName.substring(0, hash);
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "Editing app " + appName + " and module " + moduleURI);
                }
            }
            long mode = editFlag ? (moduleURI == null ? 16L : 256L) : 0x4000000L;
            this.assignAppOptions(mode, true, true);
            ctrl = this.getControllerForEdit(optProps, appName, moduleURI);
            if (ctrl == null) {
                if (editFlag) {
                    this._shell.setAndThrowScriptingException("WASX7282E", "No editing tasks are available for application " + appName, new Object[]{appName});
                } else {
                    this._shell.setAndThrowScriptingException("WASX7405E", "No viewable tasks are available for appliation " + appName, new Object[]{appName});
                }
            }
            if (editFlag && (badopts = this.validateOptions(ctrl, optProps)).size() > 0) {
                this.assignAppOptions(mode, false, false);
                String opts = this.commonOptions(ctrl);
                this._shell.setAndThrowScriptingException("WASX7107E", "invalid options: " + badopts.toString() + "; valid options: " + opts, new Object[]{badopts.toString(), opts});
            }
            Object appO = null;
            boolean changed = false;
            AppDeploymentTask installTask = ctrl.getFirstTask();
            int num = 1;
            String[] cols = null;
            Vector<String> optionV = new Vector<String>();
            if (installTask.getName().equals(APPDEPLOYMENTOPTION)) {
                cols = installTask.getColumnNames();
                for (int j = 0; j < cols.length; ++j) {
                    optionV.add(cols[j]);
                }
            }
            boolean isAppDeployTask = false;
            if (!editFlag) {
                String[] taskNames = ctrl.getAppDeploymentTaskNames();
                Set keys = optProps.keySet();
                Iterator it = keys.iterator();
                boolean validOption = true;
                StringBuffer optionBuf = new StringBuffer();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    boolean localValidOption = false;
                    for (int i = 0; i < taskNames.length; ++i) {
                        if (optionV.contains(key)) {
                            localValidOption = true;
                            isAppDeployTask = true;
                            break;
                        }
                        if (!taskNames[i].equals(key) && !key.equals(VIEWTASKNAMEOPTION)) continue;
                        localValidOption = true;
                        break;
                    }
                    if (localValidOption) continue;
                    validOption = false;
                    optionBuf.append(key);
                    optionBuf.append("  ");
                }
                if (!validOption) {
                    this._shell.setAndThrowScriptingException("WASX7406E", "Invalid task name specified: " + optionBuf.toString(), new Object[]{optionBuf});
                }
            } else {
                this.fixupAppDeploymentOptions(optProps);
            }
            HashSet<String> tasknamesSet = new HashSet<String>();
            StringBuffer taskBuf = new StringBuffer();
            StringBuffer option2Buf = new StringBuffer();
            while (installTask != null) {
                if (editFlag && interactive) {
                    boolean updated = this.prepareInteractive(installTask, optProps, num);
                    if (updated) {
                        this.addToCommandLine(installTask);
                    }
                    changed |= updated;
                } else if (editFlag) {
                    changed |= this.prepare(installTask, optProps);
                } else if (!(editFlag || installTask.isTaskEmpty() || installTask.isTaskDisabled())) {
                    if (optProps.isEmpty()) {
                        option2Buf.append(this.displayAndSetTaskData(installTask, false, null));
                    } else {
                        String tName = installTask.getName();
                        if (optProps.containsKey(VIEWTASKNAMEOPTION) && !taskFilter.contains(tName)) {
                            tasknamesSet.add(tName);
                        }
                        if (optProps.containsKey(tName)) {
                            option2Buf.append(this.displayAndSetTaskData(installTask, false, null));
                        } else if (isAppDeployTask && tName.equals(APPDEPLOYMENTOPTION)) {
                            option2Buf.append(this.displayAndSetTaskData(installTask, false, optProps));
                        }
                    }
                }
                installTask = ctrl.getNextTask();
                ++num;
            }
            if (!editFlag) {
                if (!tasknamesSet.isEmpty()) {
                    Iterator tn = tasknamesSet.iterator();
                    while (tn.hasNext()) {
                        taskBuf.append(tn.next());
                        taskBuf.append(nl);
                    }
                }
                buf.append(taskBuf.toString());
                buf.append(nl);
                buf.append(option2Buf.toString());
            }
            if (changed) {
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "There have been changes; saving...");
                }
                ctrl.validate();
                tasks = ctrl.getAllTasks();
                if (!local) {
                    if (moduleURI == null) {
                        appManagementProxy.setApplicationInfo(appName, prefs, this.getWorkspaceId(), tasks);
                    } else {
                        appManagementProxy.setModuleInfo(appName, prefs, moduleURI, this.getWorkspaceId(), tasks);
                    }
                } else {
                    AdminConfigClient cfg = AdminConfigClient.getInstance();
                    mgmt = AppManagementFactory.createLocalAppManagementImpl();
                    if (moduleURI == null) {
                        if (cfg.getConfigService() == null) {
                            mgmt.setApplicationInfo(appName, prefs, null, tasks);
                        } else {
                            mgmt.setApplicationInfo(appName, prefs, this.getWorkspaceId(), tasks);
                        }
                    } else if (cfg.getConfigService() == null) {
                        mgmt.setModuleInfo(appName, prefs, moduleURI, null, tasks);
                    } else {
                        mgmt.setModuleInfo(appName, prefs, moduleURI, this.getWorkspaceId(), tasks);
                    }
                }
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commonEdit");
        }
        return buf.toString();
    }

    private AppDeploymentController getControllerForEdit(Hashtable optProps, String appName, String moduleURI) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getControllerForEdit", new Object[]{appName, moduleURI});
        }
        boolean local = this.isLocalMode(optProps, true);
        Hashtable prefs = new Hashtable();
        Vector tasks = null;
        AppManagement mgmt = null;
        AppDeploymentController ctrl = null;
        try {
            if (!this.alreadyInstalled(appName, local, optProps)) {
                this._shell.setAndThrowScriptingException("WASX7280E", "An application with name " + appName + " does not exist.", new Object[]{appName});
            }
            if (!local) {
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "This edit mediated by MBean.");
                }
                this.checkService();
                tasks = moduleURI == null ? appManagementProxy.getApplicationInfo(appName, prefs, this.getWorkspaceId()) : appManagementProxy.getModuleInfo(appName, prefs, moduleURI, this.getWorkspaceId());
            } else {
                AdminConfigClient cfg = AdminConfigClient.getInstance();
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "This edit is local.");
                }
                this.warnIfConnected();
                ConfigRepositoryFactory.getConfigRepository().initialize(new Properties());
                mgmt = AppManagementFactory.createLocalAppManagementImpl();
                tasks = moduleURI == null ? (cfg.getConfigService() == null ? mgmt.getApplicationInfo(appName, prefs, null) : mgmt.getApplicationInfo(appName, prefs, this.getWorkspaceId())) : (cfg.getConfigService() == null ? mgmt.getModuleInfo(appName, prefs, moduleURI, null) : mgmt.getModuleInfo(appName, prefs, moduleURI, this.getWorkspaceId()));
            }
            if (tasks != null) {
                ctrl = AppManagementFactory.readTasks(tasks, new Hashtable(), moduleURI);
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getControllerForEdit");
        }
        return ctrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String uninstall(String appName, String inputOptions) throws ScriptingException {
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "uninstall: ", new Object[]{appName});
            }
            this._shell.setLastException(null);
            try {
                Hashtable optProps;
                boolean local;
                this.successFlag = false;
                Object tempName = null;
                if (this._langutils != this._shell.getLangUtils()) {
                    this._langutils = this._shell.getLangUtils();
                }
                if (!(local = this.isLocalMode(optProps = this._langutils.optionsToHashtable(inputOptions), false))) {
                    this.checkService();
                }
                if (!this.alreadyInstalled(appName, local, optProps)) {
                    this._shell.setAndThrowScriptingException("WASX7280E", "An application with name " + appName + " does not exist.", new Object[]{appName});
                }
                this.assignAppOptions(0x8000000L, true, true);
                Vector badopts = this.validateOptions(null, optProps);
                Hashtable localOpts = new Hashtable();
                if (badopts.size() > 0) {
                    String opts = this.getLocalOpts();
                    this._shell.setAndThrowScriptingException("WASX7107E", "invalid options: " + badopts.toString() + "; valid options: " + opts, new Object[]{badopts.toString(), opts});
                }
                Hashtable options = new Hashtable();
                this.collectNonTaskOptions(options, optProps);
                if (local) {
                    block20: {
                        this.warnIfConnected();
                        if (tc.isDebugEnabled()) {
                            Tr.event(tc, "Performing a local-only uninstall");
                        }
                        AppManagement m = AppManagementFactory.createLocalAppManagementImpl();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "About to call AppManagement.uninstallApplication...");
                            Tr.debug(tc, "options: " + options);
                        }
                        AdminConfigClient cfg = AdminConfigClient.getInstance();
                        String string = "waitObject";
                        // MONITORENTER : "waitObject"
                        this.waitTarget = "UninstallApplication";
                        if (cfg.getConfigService() == null) {
                            m.uninstallApplicationLocal(appName, options, this, null);
                        } else {
                            m.uninstallApplicationLocal(appName, options, this, this.getWorkspaceId());
                        }
                        try {
                            "waitObject".wait(this.MAX_WAIT_TIME);
                        }
                        catch (InterruptedException ie) {
                            if (!tc.isDebugEnabled()) break block20;
                            Tr.debug(tc, "Interrupted; time to work.");
                        }
                    }
                    // MONITOREXIT : string
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Returned from call...");
                    }
                    if (!this.successFlag) {
                        this._shell.setAndThrowScriptingException("WASX7133E", "Application uninstall failed.", new Object[]{appName});
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "After uninstallApplication");
                    }
                    break block21;
                }
                this.invokeMBeanUninstall(appName, options);
            }
            catch (ScriptingException se) {
                throw se;
            }
            catch (Exception ae) {
                this._shell.setLastException(ae);
                String detail = ExceptionSupport.getMessage(ae, "WASX");
                if (detail != null) throw new ScriptingException(detail);
                detail = ae.toString();
                throw new ScriptingException(detail);
            }
        }
        if (!tc.isEntryEnabled()) return new String();
        Tr.exit(tc, "uninstall");
        return new String();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonInstall(String filename, Hashtable optProps, Hashtable appO) throws ConnectorException, AdminException, ScriptingException, TransferFailedException, MalformedObjectNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commonInstall: ", new Object[]{filename});
        }
        this.successFlag = false;
        String appName = (String)optProps.get(APPNAMEOPTION);
        boolean redeploy = false;
        if (optProps.containsKey(UPDATEOPTION)) {
            redeploy = true;
        }
        boolean local = this.isLocalMode(optProps, false);
        if (appName == null) {
            appName = (String)appO.get(APPNAMEOPTION);
            String editionName = (String)appO.get(APPEDITIONOPTION);
            if (editionName != null) {
                optProps.put(APPEDITIONOPTION, editionName);
            }
            if (this.alreadyInstalled(appName, local, optProps)) {
                this._shell.setAndThrowScriptingException("WASX7279E", "An application with name " + EditionHelper.getCompositeName(appName, editionName) + " already exists.  Please choose a different name.", new Object[]{EditionHelper.getCompositeName(appName, editionName)});
            }
        }
        if (local) {
            if (tc.isDebugEnabled()) {
                Tr.event(tc, "Performing a local-only install");
            }
            AppManagement m = AppManagementFactory.createLocalAppManagementImpl();
            AdminConfigClient cfg = AdminConfigClient.getInstance();
            try {
                String string = "waitObject";
                synchronized ("waitObject") {
                    block28: {
                        if (redeploy) {
                            this.waitTarget = ((String)optProps.get("contenttype")).equals("app") ? "InstallApplication" : "UpdateApplication";
                            String uri = (String)optProps.get(UPDATE_URI);
                            String operation = (String)optProps.get(UPDATE_OPERATION);
                            String contextRoot = (String)optProps.get(CONTEXTROOTOPTION);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "uri: " + uri);
                                Tr.debug(tc, "operation: " + operation);
                                Tr.debug(tc, "contextroot: " + contextRoot);
                                Tr.debug(tc, "appO: " + appO);
                                Tr.debug(tc, "About to call AppManagement.updateApplication ...");
                            }
                            if (cfg.getConfigService() == null) {
                                m.updateApplicationLocal(appName, uri, filename, operation, appO, this, null);
                            } else {
                                m.updateApplicationLocal(appName, uri, filename, operation, appO, this, this.getWorkspaceId());
                            }
                        } else {
                            this.waitTarget = "InstallApplication";
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "appO: " + appO);
                                Tr.debug(tc, "About to call AppManagement.installApplication ...");
                            }
                            if (cfg.getConfigService() == null) {
                                m.installApplicationLocal(filename, appName, appO, this, null);
                            } else {
                                m.installApplicationLocal(filename, appName, appO, this, this.getWorkspaceId());
                            }
                        }
                        try {
                            "waitObject".wait(this.MAX_WAIT_TIME);
                        }
                        catch (InterruptedException ie) {
                            if (!tc.isDebugEnabled()) break block28;
                            Tr.debug(tc, "Interrupted; time to work.");
                        }
                    }
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Returned from call...");
                    }
                }
            }
            catch (AdminException ade) {
                this._shell.setLastException(ade);
                throw ade;
            }
            {
                if (!this.successFlag) {
                    if (redeploy) {
                        this._shell.setAndThrowScriptingException("WASX7418E", "Application update failed.", new Object[]{appName});
                    } else {
                        this._shell.setAndThrowScriptingException("WASX7132E", "Application install failed.", new Object[]{this.origFileName});
                    }
                }
            }
        } else {
            this.checkService();
            this.invokeMBeanInstall(filename, appO, redeploy);
        }
        {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commonInstall");
            }
            return;
        }
    }

    private Hashtable createPreferences(String filename, Hashtable optProps, boolean interactive) throws ScriptingException, IOException, AppDeploymentException {
        Object ext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPreferences");
        }
        Hashtable prefs = new Hashtable();
        if (optProps.containsKey("depl.extension.reg") && (ext = optProps.get("depl.extension.reg")) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting extensions to : " + ext.toString());
            }
            prefs.put("depl.extension.reg", ext);
        }
        boolean bBindings = false;
        if (optProps.containsKey("defaultbinding.datasource.jndi") || optProps.containsKey("defaultbinding.datasource.username") || optProps.containsKey("defaultbinding.datasource.password") || optProps.containsKey("defaultbinding.cf.jndi") || optProps.containsKey("defaultbinding.cf.resauth") || optProps.containsKey("defaultbinding.ejbjndi.prefix") || optProps.containsKey("defaultbinding.virtual.host") || optProps.containsKey("defaultbinding.strategy.file")) {
            bBindings = true;
        }
        if (bBindings && !optProps.containsKey("usedefaultbindings")) {
            Tr.warning(tc, "WASX7436W", null);
            String msg = this._shell.getFormattedMessage("WASX7436W", null, null);
            AdminAppClient.dbg(msg);
        }
        if (filename != null && optProps.containsKey("usedefaultbindings") && !"partialapp".equals(optProps.get("contenttype")) && !"file".equals(optProps.get("contenttype")) && !optProps.containsKey(SKIPPREP)) {
            if (optProps.containsKey("defaultbinding.force")) {
                optProps.put("defaultbinding.force", "AppDeploymentOption.Yes");
            }
            optProps.put("app.client.locale", Locale.getDefault());
            DefaultBindingHelper helper = new DefaultBindingHelper(optProps);
            DefaultBinding task = (DefaultBinding)helper.createTask(null);
            helper.prepareTask(filename, (AppDeploymentTask)task);
            if (interactive) {
                this.displayAndSetTaskData(task, true, null);
            }
            helper.completeTask(null, task);
            Preferences dbPrefs = DefaultBindingHelper.getPreferences(task);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Preferences for default bindings: " + dbPrefs);
            }
            prefs.put("usedefaultbindings", dbPrefs);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting locale to " + Locale.getDefault().getDisplayName());
        }
        prefs.put("app.client.locale", Locale.getDefault());
        if (!this.isLocalMode(optProps, false)) {
            prefs.put("DeleteSourceEar", Boolean.TRUE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPreferences");
        }
        return prefs;
    }

    private Hashtable commonPrepare(String earfile, Hashtable optProps, Hashtable prefs, boolean interactive) throws IOException, AppDeploymentException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commonPrepare: ", new Object[]{earfile});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Calling prepare with file " + earfile);
        }
        if (this.isLocalMode(optProps, false)) {
            this.warnIfConnected();
        }
        Hashtable appO = new Hashtable();
        AppDeploymentController flowController = this.getController(earfile, prefs, optProps);
        this.booleanDeplOptions = new ArrayList();
        this.nonBooleanDeplOptions = new ArrayList();
        long optionMode = 0L;
        if (optProps.containsKey(UPDATEOPTION)) {
            String operation = (String)optProps.get(UPDATE_OPERATION);
            String contenttype = (String)optProps.get("contenttype");
            if ("app".equals(contenttype)) {
                optionMode = 4096L;
            } else if ("modulefile".equals(contenttype)) {
                if ("add".equals(operation)) {
                    optionMode = 0x100000L;
                } else if (UPDATEOPTION.equals(operation)) {
                    optionMode = 65536L;
                } else if ("addupdate".equals(operation)) {
                    optionMode = 0x110000L;
                }
            }
        } else {
            optionMode = 1L;
        }
        this.assignAppOptions(optionMode, true, true);
        if (flowController != null) {
            Vector badopts = this.validateOptions(flowController, optProps);
            if (!this.compareSecurityPolicy(flowController, optProps, interactive)) {
                return null;
            }
            this.fixupAppDeploymentOptions(optProps);
            Hashtable applOptions = flowController.getAppOptions();
            this.collectNonTaskOptions(applOptions, optProps);
            if (badopts.size() > 0) {
                String[] taskNames = flowController.getAppDeploymentTaskNames();
                Vector<String> temp = new Vector<String>();
                for (int i = 0; i < taskNames.length; ++i) {
                    temp.add(taskNames[i]);
                }
                this.assignAppOptions(optionMode, false, false);
                String opts = this.commonOptions(flowController);
                this._shell.setAndThrowScriptingException("WASX7107E", "invalid options: " + badopts.toString() + "; valid options: " + opts, new Object[]{badopts.toString(), opts});
            }
            AppDeploymentTask installTask = null;
            try {
                installTask = flowController.getFirstTask();
                int num = 1;
                while (installTask != null) {
                    if (interactive) {
                        boolean updated = this.prepareInteractive(installTask, optProps, num);
                        if (updated) {
                            this.addToCommandLine(installTask);
                        }
                    } else {
                        this.prepare(installTask, optProps);
                    }
                    installTask = flowController.getNextTask();
                    ++num;
                }
                appO = this.saveAndClose(flowController);
                appO.put(CONTROLLER, "");
            }
            catch (ScriptingException se) {
                throw se;
            }
            catch (AppDeploymentException ade) {
                this._shell.setLastException(ade);
                throw ade;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "flow controller is null");
            }
            if (optProps.containsKey(UPDATEOPTION)) {
                this.ignoreNonUpdateOptions(optProps);
            }
            this.collectNonTaskOptions(appO, optProps);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commonPrepare");
        }
        return appO;
    }

    private boolean prepare(AppDeploymentTask installTask, Hashtable optProps) throws AppDeploymentException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare");
        }
        boolean changed = true;
        if (!installTask.isTaskEmpty() && !installTask.isTaskDisabled()) {
            int i;
            StringBuffer buf;
            String[] messages;
            Object o = optProps.get(installTask.getName());
            if (o != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "class of object is " + o.getClass().getName());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found options for task " + installTask.getName() + "; options: " + o.toString());
                }
                changed = installTask.getName().equals(APPDEPLOYMENTOPTION) ? (changed |= this.applyNonTaskChanges(installTask, (List)o)) : (changed |= this.applyChanges(installTask, (List)o));
                messages = installTask.validate();
                if (messages != null) {
                    buf = new StringBuffer();
                    for (i = 0; i < messages.length; ++i) {
                        buf.append(nl);
                        buf.append(messages[i]);
                    }
                    this._shell.setAndThrowScriptingException("WASX7108E", "Invalid data for install task: \"" + installTask.getName() + "\" -- errors:" + buf.toString() + "\"", new Object[]{installTask.getName(), buf.toString()});
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found NO options for task " + installTask.getName());
            }
            if (!installTask.isSufficientlyDone() && (messages = installTask.validate()) != null) {
                buf = new StringBuffer();
                for (i = 0; i < messages.length; ++i) {
                    buf.append(nl);
                    buf.append(messages[i]);
                }
                StringBuffer buf2 = new StringBuffer();
                buf2.append(installTask.getName());
                buf2.append(nl);
                buf2.append(buf.toString());
                this._shell.setAndThrowScriptingException("WASX7109E", "Insufficient data for install task: \"" + installTask.getName() + "\" -- errors:" + buf.toString() + "\"", new Object[]{buf2.toString()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepare " + changed);
        }
        return changed;
    }

    private boolean prepareInteractive(AppDeploymentTask installTask, Hashtable optProps, int num) throws IOException, AppDeploymentException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareInteractive");
        }
        boolean changed = false;
        StringBuffer header = new StringBuffer();
        header.append(nl);
        header.append(nl);
        AppDeploymentMessages appM = installTask.getTaskMessages();
        if (appM == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not get a messages object!");
            }
            appM = appMessages;
        }
        String s = appM.getGoalTitle(installTask.getName());
        header.append(MessageFormat.format(this.PROMPT_Task, new Integer(num), s));
        header.append(nl);
        header.append(nl);
        header.append(appM.getGoalMessage(installTask.getName()));
        header.append(nl);
        if (installTask.getName().equals("DataSourceFor20CMPBeans") || installTask.getName().equals("DataSourceFor20EJBModules")) {
            header.append(this._shell.getFormattedMessage("WASX7349I", new Object[0], "Possible value for resource authorization is container or per connection factory"));
        }
        boolean verbose = false;
        if (optProps.containsKey(VERBOSEOPTION)) {
            verbose = true;
        }
        if (installTask.isTaskEmpty()) {
            if (verbose) {
                AdminAppClient.dbg(header.toString());
                AdminAppClient.dbg(appM.getEmptyTaskMessage(installTask.getName()));
            }
        } else {
            AdminAppClient.dbg(header.toString());
            if (installTask.isTaskDisabled()) {
                AdminAppClient.dbg("...." + appM.getDisableTaskMessage(installTask.getName()));
            } else {
                Object o = optProps.get(installTask.getName());
                if (o != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "class of object is " + o.getClass().getName());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found options for task " + installTask.getName() + "; options: " + o.toString());
                    }
                    changed = installTask.getName().equals(APPDEPLOYMENTOPTION) ? (changed |= this.applyNonTaskChanges(installTask, (List)o)) : (changed |= this.applyChanges(installTask, (List)o));
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found NO options for task " + installTask.getName());
                }
                String ret = this.displayAndSetTaskData(installTask, true, null);
                if (ret.equals("true")) {
                    changed = true;
                }
                if (ret.equals("false")) {
                    boolean bl = changed ? true : (changed = false);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareInteractive " + changed);
        }
        return changed;
    }

    private boolean applyNonTaskChanges(AppDeploymentTask installTask, List options) throws AppDeploymentException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "applyNonTaskChanges");
        }
        String[][] taskData = installTask.getTaskData();
        boolean changed = false;
        block2: for (int i = 0; i < options.size(); ++i) {
            List row = (List)options.get(i);
            String opt = (String)row.get(0);
            for (int rowix = 0; rowix < taskData[0].length; ++rowix) {
                if (!taskData[0][rowix].equals(opt)) continue;
                String val = (String)row.get(1);
                if (taskData[1][rowix].equals(val)) continue block2;
                changed = true;
                taskData[1][rowix] = val;
                continue block2;
            }
        }
        try {
            if (changed) {
                installTask.setTaskData(taskData);
            }
        }
        catch (AppDeploymentException ade) {
            this._shell.setLastException(ade);
            throw ade;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "applyNonTaskChanges " + changed);
        }
        return changed;
    }

    private boolean applyChanges(AppDeploymentTask installTask, List options) throws AppDeploymentException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "applyChanges");
        }
        String[] cols = installTask.getColumnNames();
        boolean[] ismutable = installTask.getMutableColumns();
        boolean[] isrequired = installTask.getRequiredColumns();
        int numcolumns = cols.length;
        int nonHiddenColumns = 0;
        boolean[] ishidden = new boolean[numcolumns];
        for (int i = 0; i < cols.length; ++i) {
            if (!installTask.isHiddenColumn(i)) {
                ++nonHiddenColumns;
                ishidden[i] = false;
                continue;
            }
            ishidden[i] = true;
        }
        boolean[] userMutable = new boolean[nonHiddenColumns];
        int userIndex = 0;
        for (int i = 0; i < cols.length; ++i) {
            if (ishidden[i]) continue;
            userMutable[userIndex] = ismutable[i];
            ++userIndex;
        }
        String[][] taskData = installTask.getTaskData();
        String[] keys = new String[taskData.length - 1];
        for (int rowidx = 0; rowidx < keys.length; ++rowidx) {
            StringBuffer buf = new StringBuffer();
            for (int colidx = 0; colidx < numcolumns; ++colidx) {
                if (ismutable[colidx] || ishidden[colidx]) continue;
                buf.append(taskData[rowidx + 1][colidx]);
                buf.append(" ");
            }
            keys[rowidx] = buf.toString().trim();
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "constructed task data key: " + keys[rowidx] + " for row " + rowidx);
        }
        boolean changed = false;
        for (int i = 0; i < options.size(); ++i) {
            List row = (List)options.get(i);
            if (row.size() > nonHiddenColumns) {
                this._shell.setAndThrowScriptingException("WASX7110E", "Wrong number of elements in option: " + row.toString() + "; for task: " + installTask.getName() + "; should be " + nonHiddenColumns, new Object[]{row.toString(), installTask.getName(), new Integer(nonHiddenColumns)});
            }
            StringBuffer buf = new StringBuffer();
            for (int idx = 0; idx < nonHiddenColumns; ++idx) {
                if (!userMutable[idx]) {
                    buf.append(row.get(idx));
                }
                buf.append(" ");
            }
            String rowkey = buf.toString().trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructed rowkey: " + rowkey);
            }
            int match = -1;
            for (int tdidx = 0; tdidx < keys.length; ++tdidx) {
                String fixRowkey = rowkey.replaceAll("[{}]+", "\\\\p{Punct}");
                if (keys[tdidx].matches(fixRowkey)) {
                    match = tdidx;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found match at position: " + match);
                }
                int rowidx = -1;
                if (match < 0) continue;
                for (int idx = 0; idx < numcolumns; ++idx) {
                    if (!ishidden[idx]) {
                        ++rowidx;
                    }
                    if (!ismutable[idx] || ishidden[idx]) continue;
                    if (rowidx < row.size()) {
                        if (taskData[match + 1][idx] == null || !taskData[match + 1][idx].equals(row.get(rowidx))) {
                            AppDeploymentMessages appM;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Changing \"" + taskData[match + 1][idx] + "\" to \"" + row.get(rowidx) + "\"");
                            }
                            if (taskData[match + 1][idx] != null && (taskData[match + 1][idx].equals("AppDeploymentOption.Yes") || taskData[match + 1][idx].equals("AppDeploymentOption.No"))) {
                                appM = installTask.getTaskMessages();
                                if (((String)row.get(rowidx)).equalsIgnoreCase(appM.getMessage("AppDeploymentOption.Yes")) || ((String)row.get(rowidx)).equalsIgnoreCase("YES")) {
                                    taskData[match + 1][idx] = "AppDeploymentOption.Yes";
                                    changed = true;
                                    continue;
                                }
                                if (((String)row.get(rowidx)).equalsIgnoreCase(appM.getMessage("AppDeploymentOption.No")) || ((String)row.get(rowidx)).equalsIgnoreCase("NO")) {
                                    taskData[match + 1][idx] = "AppDeploymentOption.No";
                                    changed = true;
                                    continue;
                                }
                                taskData[match + 1][idx] = (String)row.get(rowidx);
                                changed = true;
                                continue;
                            }
                            if (taskData[0][idx].equals("resAuth")) {
                                appM = installTask.getTaskMessages();
                                if (((String)row.get(rowidx)).equalsIgnoreCase(appM.getMessage("cmpBinding.perConnectionFactory"))) {
                                    taskData[match + 1][idx] = "cmpBinding.perConnectionFactory";
                                    changed = true;
                                }
                                if (((String)row.get(rowidx)).equalsIgnoreCase(appM.getMessage("cmpBinding.container"))) {
                                    taskData[match + 1][idx] = "cmpBinding.container";
                                    changed = true;
                                    continue;
                                }
                                taskData[match + 1][idx] = (String)row.get(rowidx);
                                changed = true;
                                continue;
                            }
                            taskData[match + 1][idx] = (String)row.get(rowidx);
                            changed = true;
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "no change for value: " + row.get(rowidx));
                        continue;
                    }
                    if (!isrequired[idx] || taskData[match + 1][idx] != null) continue;
                    this._shell.setAndThrowScriptingException("WASX7110E", "Wrong number of elements in option: " + row.toString() + "; for task: " + installTask.getName() + "; should be " + nonHiddenColumns, new Object[]{row.toString(), installTask.getName(), new Integer(nonHiddenColumns)});
                }
                try {
                    if (!changed) continue;
                    installTask.setTaskData(taskData);
                    continue;
                }
                catch (AppDeploymentException ade) {
                    this._shell.setLastException(ade);
                    throw ade;
                }
            }
            if (match >= 0) continue;
            this._shell.setAndThrowScriptingException("WASX7111E", "Cannot find a match for supplied option: " + row.toString() + "; for task: " + installTask.getName(), new Object[]{row.toString(), installTask.getName()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "applyChanges " + changed);
        }
        return changed;
    }

    public String browseTasks(String earfile) throws AppDeploymentException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "browseTasks: " + earfile);
        }
        AppDeploymentController flowController = this.getController(earfile, null, new Hashtable());
        AppDeploymentTask installTask = null;
        try {
            installTask = flowController.getFirstTask();
            int num = 1;
            while (installTask != null) {
                String s = installTask.getName();
                System.out.println("Task[" + num++ + "]: " + s);
                if (installTask.isTaskEmpty()) {
                    System.out.println("\tis empty");
                }
                if (installTask.isTaskDisabled()) {
                    System.out.println("\tis disabled");
                }
                if (installTask.isSufficientlyDone()) {
                    System.out.println("\tis sufficiently done");
                }
                installTask = flowController.getNextTask();
                ++num;
            }
        }
        catch (AppDeploymentException ade) {
            this._shell.setLastException(ade);
            throw ade;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "browseTasks");
        }
        return new String();
    }

    public String options() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "options");
        }
        StringBuffer buf = new StringBuffer();
        String msg = this._shell.getFormattedMessage("WASX7105I", new Object[0], "The following options are valid for any ear file:");
        buf.append(msg);
        buf.append(nl);
        this.assignAppOptions(1L, false, false);
        String temp = this.getLocalOpts();
        buf.append(temp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "options");
        }
        return buf.toString();
    }

    public String options(String earfile) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "options: " + earfile);
        }
        this._shell.setLastException(null);
        Vector apps = this.getAppList(new Hashtable(), null);
        String ret = apps.contains(earfile) ? this.options(earfile, "editapp") : (earfile.indexOf("#") >= 0 ? this.options(earfile, "editmodule") : this.options(earfile, "installapp"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "options");
        }
        return ret;
    }

    public String options(String earfile, String mode) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "options", new Object[]{earfile, mode});
        }
        String ret = "";
        this._shell.setLastException(null);
        if (optionModes.containsKey(mode.toLowerCase())) {
            ret = this.options(earfile, (Long)optionModes.get(mode.toLowerCase()));
        } else {
            this._shell.setAndThrowScriptingException("WASX7358E", "Ivalid option specified: " + mode, new Object[]{mode});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "options");
        }
        return ret;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String options(String earfile, Long longMode) throws ScriptingException {
        File temp;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "options", new Object[]{earfile, longMode});
        }
        this._shell.setLastException(null);
        StringBuffer buf = new StringBuffer();
        AppDeploymentController flowController = null;
        String tempName = null;
        long mode = longMode;
        this.assignAppOptions(mode, false, false);
        try {
            if ((mode & 0x10L) != 0L || (mode & 0x100L) != 0L) {
                boolean isModule = false;
                String moduleURI = null;
                String appName = earfile;
                int hash = appName.indexOf("#");
                if (hash >= 0) {
                    moduleURI = appName.substring(hash + 1);
                    isModule = true;
                    appName = appName.substring(0, hash);
                    if (tc.isDebugEnabled()) {
                        Tr.event(tc, "app " + appName + " and module " + moduleURI);
                    }
                }
                this.assignAppOptions(mode, false, false);
                flowController = this.getControllerForEdit(new Hashtable(), appName, moduleURI);
            } else {
                File input = new File(earfile);
                tempName = input.isDirectory() ? this.copyDirToTempDir(input) : this.copyToTempDir(input, null);
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put(CONTEXTROOTOPTION, "");
                tempName = this.wrapIfNeeded(tempName, props, earfile);
                flowController = this.getController(tempName, null, new Hashtable());
            }
            String msg = this._shell.getFormattedMessage("WASX7112I", new Object[]{earfile}, "The following options are valid for " + earfile);
            buf.append(msg);
            buf.append(nl);
            buf.append(this.commonOptions(flowController));
            if (tempName == null) return buf.toString();
            temp = new File(tempName);
            if (tempName.equals(earfile)) return buf.toString();
        }
        catch (ScriptingException se) {
            if (se.toString().indexOf("WASX7281E") <= 0) {
                throw se;
            }
            this._shell.setAndThrowScriptingException("WASX7302E", "WASX7302E: Cannot get tasks using file {0}. Please ensure that this file exists and is readable.", new Object[]{earfile});
            if (tempName == null) return buf.toString();
            File temp2 = new File(tempName);
            if (tempName.equals(earfile)) return buf.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "options; removing temp file in finally clause: " + tempName);
            }
            boolean delete = temp2.delete();
            if (!tc.isDebugEnabled()) return buf.toString();
            Tr.debug(tc, "options; delete returned ", delete);
            return buf.toString();
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail != null) throw new ScriptingException(detail);
            detail = ae.toString();
            throw new ScriptingException(detail);
            {
                catch (Throwable throwable) {
                    if (tempName == null) throw throwable;
                    File temp3 = new File(tempName);
                    if (tempName.equals(earfile)) throw throwable;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "options; removing temp file in finally clause: " + tempName);
                    }
                    boolean delete = temp3.delete();
                    if (!tc.isDebugEnabled()) throw throwable;
                    Tr.debug(tc, "options; delete returned ", delete);
                    throw throwable;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "options; removing temp file in finally clause: " + tempName);
        }
        boolean delete = temp.delete();
        if (!tc.isDebugEnabled()) return buf.toString();
        Tr.debug(tc, "options; delete returned ", delete);
        return buf.toString();
    }

    public String commonOptions(AppDeploymentController flowController) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commonOptions");
        }
        this._shell.setLastException(null);
        StringBuffer buf = new StringBuffer();
        try {
            if (flowController != null) {
                AppDeploymentTask installTask = flowController.getFirstTask();
                int num = 1;
                while (installTask != null) {
                    String taskName;
                    if (!(installTask.isTaskEmpty() || (taskName = installTask.getName()).equals(APPDEPLOYMENTOPTION) || taskFilter.contains(taskName))) {
                        buf.append(taskName);
                        buf.append(nl);
                    }
                    installTask = flowController.getNextTask();
                    ++num;
                }
            }
            String temp = this.getLocalOpts();
            buf.append(temp);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commonOptions");
        }
        return buf.toString();
    }

    private String getLocalOpts() {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalOpts");
        }
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < this.booleanDeplOptions.size(); ++i) {
            if (this.isOptionInOptionTable((String)this.booleanDeplOptions.get(i), deprecatedOptions, false)) continue;
            buf.append(this.booleanDeplOptions.get(i));
            buf.append(nl);
        }
        for (i = 0; i < this.nonBooleanDeplOptions.size(); ++i) {
            if (this.isOptionInOptionTable((String)this.nonBooleanDeplOptions.get(i), deprecatedOptions, false)) continue;
            buf.append(this.nonBooleanDeplOptions.get(i));
            buf.append(nl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalOpts");
        }
        return buf.toString();
    }

    /*
     * Unable to fully structure code
     */
    public String taskInfo(String earfile, String task) throws AppDeploymentException, ScriptingException {
        block37: {
            if (AdminAppClient.tc.isEntryEnabled()) {
                Tr.entry(AdminAppClient.tc, "taskInfo: " + earfile + " " + task);
            }
            this._shell.setLastException(null);
            buf = new StringBuffer();
            tempName = null;
            optProps = new Hashtable<String, String>();
            try {
                input = new File(earfile);
                tempName = input.isDirectory() != false ? this.copyDirToTempDir(input) : this.copyToTempDir(input, null);
                if (tempName.toLowerCase().endsWith(".war")) {
                    if (AdminAppClient.tc.isDebugEnabled()) {
                        Tr.debug(AdminAppClient.tc, "using default ContextRoot");
                    }
                    optProps.put("contextroot", "/");
                }
                tempName = this.wrapIfNeeded(tempName, optProps, earfile);
                helper = new DefaultBindingHelper();
                bindingTask = (DefaultBinding)helper.createTask(null);
                helper.prepareTask(tempName, (AppDeploymentTask)bindingTask);
                helper.completeTask(null, bindingTask);
                dbPrefs = DefaultBindingHelper.getPreferences(bindingTask);
                if (AdminAppClient.tc.isDebugEnabled()) {
                    Tr.debug(AdminAppClient.tc, "Preferences for default bindings: " + dbPrefs);
                }
                prefs = new Hashtable<String, Preferences>();
                prefs.put("usedefaultbindings", dbPrefs);
                flowController = this.getController(tempName, prefs, optProps);
                installTask = null;
                try {
                    installTask = flowController.getTaskByName(task);
                }
                catch (AppDeploymentException ade) {
                    // empty catch block
                }
                if (installTask == null) {
                    taskNames = flowController.getAppDeploymentTaskNames();
                    temp = new Vector<String>();
                    for (i = 0; i < taskNames.length; ++i) {
                        temp.add(taskNames[i]);
                    }
                    this._shell.setAndThrowScriptingException("WASX7113E", "Task not valid: " + task + "; valid tasks: ", new Object[]{task, temp.toString()});
                }
                appM = installTask.getTaskMessages();
                buf.append(this.getGeneralTaskInfo(installTask));
                if (!installTask.isTaskEmpty() && !installTask.isTaskDisabled()) {
                    taskData = installTask.getTaskData();
                    ishidden = new boolean[taskData[0].length];
                    nonHiddenColumns = 0;
                    for (i = 0; i < taskData[0].length; ++i) {
                        if (!installTask.isHiddenColumn(i)) {
                            ++nonHiddenColumns;
                            ishidden[i] = false;
                            continue;
                        }
                        if (installTask.getName().equals("BackendIdSelection") && taskData[0][i].equals("BackendIds")) {
                            ++nonHiddenColumns;
                            ishidden[i] = false;
                            continue;
                        }
                        ishidden[i] = true;
                    }
                    arg1 = new StringBuffer();
                    arg2 = new StringBuffer();
                    arg3 = new StringBuffer();
                    arg4 = new StringBuffer();
                    for (i = 0; i < taskData[0].length; ++i) {
                        if (ishidden[i]) continue;
                        columnName = taskData[0][i];
                        arg1.append("\"");
                        arg1.append(appM.getColumnName(columnName, installTask.getName()));
                        if (i < taskData[0].length - 1) {
                            arg1.append("\", ");
                            continue;
                        }
                        arg1.append("\".");
                    }
                    for (i = 0; i < taskData[0].length; ++i) {
                        if (installTask.getMutableColumns(i) || ishidden[i]) continue;
                        columnName = taskData[0][i];
                        arg2.append("\"");
                        arg2.append(appM.getColumnName(columnName, installTask.getName()));
                        arg2.append("\" ");
                    }
                    for (i = 0; i < taskData[0].length; ++i) {
                        if (!installTask.getRequiredColumns(i) || ishidden[i]) continue;
                        columnName = taskData[0][i];
                        arg3.append("\"");
                        arg3.append(appM.getColumnName(columnName, installTask.getName()));
                        arg3.append("\" ");
                    }
                    for (i = 1; i < taskData.length; ++i) {
                        for (j = 0; j < taskData[0].length; ++j) {
                            if (ishidden[j]) continue;
                            arg4.append(appM.getColumnName(taskData[0][j], installTask.getName()));
                            arg4.append(": ");
                            arg4.append(taskData[i][j]);
                            arg4.append(AdminAppClient.nl);
                        }
                        arg4.append(AdminAppClient.nl);
                    }
                    msg = this._shell.getFormattedMessage("ADMINAPP_TASKINFO", new Object[]{task, Integer.toString(nonHiddenColumns), arg1, arg2, arg3, arg4}, "Each element of the {0} task consists of the following {1} fields: {2}\nOf these fields, the following are required and used as keys to locate the rows in the task: {3}\nand the following may be assigned new values {4}\n\nThe current contents of the task after running default bindings are: {5}");
                    buf.append(msg);
                }
                if (tempName == null) break block37;
                temp = new File(tempName);
                ** if (tempName.equals((Object)earfile)) goto lbl-1000
            }
            catch (ScriptingException se) {
                if (se.toString().indexOf("WASX7281E") <= 0) {
                    throw se;
                }
                this._shell.setAndThrowScriptingException("WASX7301E", "WASX7301E: Cannot get the task info for {0} using file {1}. Please ensure that this file exists and is readable.", new Object[]{task, earfile});
                if (tempName == null) break block37;
                temp = new File(tempName);
                ** if (tempName.equals((Object)earfile)) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    if (AdminAppClient.tc.isDebugEnabled()) {
                        Tr.debug(AdminAppClient.tc, "taskInfo; removing temp file in finally clause: " + tempName);
                    }
                    delete = temp.delete();
                    if (AdminAppClient.tc.isDebugEnabled()) {
                        Tr.debug(AdminAppClient.tc, "taskInfo; delete returned ", delete);
                    }
                }
lbl-1000:
                // 4 sources

                {
                }
            }
            catch (Exception ae) {
                this._shell.setLastException(ae);
                detail = ExceptionSupport.getMessage(ae, "WASX");
                if (detail == null) {
                    detail = ae.toString();
                }
                throw new ScriptingException(detail);
                {
                    catch (Throwable var23_34) {
                        if (tempName != null) {
                            temp = new File(tempName);
                            if (!tempName.equals(earfile)) {
                                if (AdminAppClient.tc.isDebugEnabled()) {
                                    Tr.debug(AdminAppClient.tc, "taskInfo; removing temp file in finally clause: " + tempName);
                                }
                                delete = temp.delete();
                                if (AdminAppClient.tc.isDebugEnabled()) {
                                    Tr.debug(AdminAppClient.tc, "taskInfo; delete returned ", delete);
                                }
                            }
                        }
                        throw var23_34;
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                if (AdminAppClient.tc.isDebugEnabled()) {
                    Tr.debug(AdminAppClient.tc, "taskInfo; removing temp file in finally clause: " + tempName);
                }
                delete = temp.delete();
                if (AdminAppClient.tc.isDebugEnabled()) {
                    Tr.debug(AdminAppClient.tc, "taskInfo; delete returned ", delete);
                }
            }
lbl-1000:
            // 4 sources

            {
            }
        }
        if (AdminAppClient.tc.isEntryEnabled()) {
            Tr.exit(AdminAppClient.tc, "taskInfo");
        }
        return buf.toString();
    }

    private String getGeneralTaskInfo(AppDeploymentTask installTask) {
        AppDeploymentMessages appM;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGeneralTaskInfo");
        }
        if ((appM = installTask.getTaskMessages()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not get a messages object!");
            }
            appM = appMessages;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(nl);
        if (!installTask.getName().equals(APPDEPLOYMENTOPTION)) {
            buf.append(installTask.getName());
            buf.append(": ");
        }
        buf.append(appM.getGoalTitle(installTask.getName()));
        buf.append(nl);
        buf.append(nl);
        buf.append(appM.getGoalMessage(installTask.getName()));
        buf.append(nl);
        buf.append(nl);
        if (installTask.isTaskEmpty()) {
            buf.append(appM.getEmptyTaskMessage(installTask.getName()));
        } else if (installTask.isTaskDisabled()) {
            buf.append("...." + appM.getDisableTaskMessage(installTask.getName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGeneralTaskInfo");
        }
        return buf.toString();
    }

    private Vector validateOptions(AppDeploymentController flowController, Hashtable optProps) throws ScriptingException {
        Object val;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateOptions");
        }
        Vector<String> ret = new Vector<String>();
        Vector<String> ignoreOptions = new Vector<String>();
        Vector<String> deprecateOptions = new Vector<String>();
        String[] taskNames = null;
        if (flowController != null) {
            taskNames = flowController.getAppDeploymentTaskNames();
        }
        Enumeration optNames = optProps.keys();
        while (optNames.hasMoreElements()) {
            String opt = (String)optNames.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "input option: " + opt);
            }
            this.throwIfMissingArg(opt, optProps.get(opt));
            boolean found = false;
            if (taskNames != null) {
                for (int i = 0; i < taskNames.length; ++i) {
                    if (!opt.equals(taskNames[i]) || taskFilter.contains(opt)) continue;
                    found = true;
                    break;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found: " + found);
                }
            }
            if (!(found || this.booleanDeplOptions.contains(opt) || this.nonBooleanDeplOptions.contains(opt))) {
                if (this.otherListedDeplOptions.contains(opt)) {
                    ignoreOptions.add(opt);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "adding to return vector: " + opt);
                    }
                    ret.add(opt);
                }
            }
            if (!this.isOptionInOptionTable(opt, deprecatedOptions, false)) continue;
            deprecateOptions.add(opt);
        }
        if (optProps.containsKey("reloadInterval") && (val = optProps.get("reloadInterval")) instanceof String) {
            try {
                Integer.parseInt((String)val);
            }
            catch (NumberFormatException nfe) {
                this._shell.setAndThrowScriptingException("WASX7359E", "Incorrect value specified for reloadInterval option: {0}. reloadInterval option requires an integer value", new Object[]{val});
            }
        }
        if (ret.size() == 0 && ignoreOptions.size() > 0) {
            System.out.println(this._shell.getFormattedMessage("WASX7411W", new Object[]{ignoreOptions.toString()}, "Ignoring the following provided option: " + ignoreOptions.toString()));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring the following provided options: " + ignoreOptions.toString());
            }
        }
        if (ret.size() == 0 && deprecateOptions.size() > 0) {
            System.out.println(this._shell.getFormattedMessage("WASX7434W", new Object[]{deprecateOptions.toString()}, "Found the following deprecated options: " + deprecateOptions.toString()));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deprecated options found in the command: " + deprecateOptions.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateOptions");
        }
        return ret;
    }

    private void ignoreNonUpdateOptions(Hashtable optProps) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ignoreNonUpdateOptions", new Object[]{optProps});
        }
        if (((String)optProps.get("contenttype")).equals("file")) {
            this.assignAppOptions(0x1000000L, false, true);
        } else if (((String)optProps.get("contenttype")).equals("partialapp")) {
            this.assignAppOptions(0x2000000L, false, true);
        } else if (((String)optProps.get(UPDATE_OPERATION)).equals("delete")) {
            this.assignAppOptions(0x2000000L, false, true);
        }
        Vector<String> ret = new Vector<String>();
        Vector<String> deprecated = new Vector<String>();
        Enumeration optNames = optProps.keys();
        while (optNames.hasMoreElements()) {
            String opt = (String)optNames.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "input option: " + opt);
            }
            if (!this.booleanDeplOptions.contains(opt) && !this.nonBooleanDeplOptions.contains(opt)) {
                ret.add(opt);
            }
            if (!this.isOptionInOptionTable(opt, deprecatedOptions, false)) continue;
            deprecated.add(opt);
        }
        if (ret.size() > 0) {
            System.out.println(this._shell.getFormattedMessage("WASX7411W", new Object[]{ret.toString()}, "Ignoring option provided with the update command: " + ret.toString()));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring the following provided options: " + ret.toString());
            }
        }
        if (deprecated.size() > 0) {
            System.out.println(this._shell.getFormattedMessage("WASX7434W", new Object[]{deprecated.toString()}, "Found the following deprecated options: " + deprecated.toString()));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deprecated options found in the command: " + deprecated.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ignoreNonUpdateOptions");
        }
    }

    private void validateUpdateOptions(Hashtable optProps) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateUpdateOptions", new Object[]{optProps});
        }
        if (optProps.containsKey(UPDATEOPTION)) {
            String missingOption = null;
            String operation = (String)optProps.get(UPDATE_OPERATION);
            String uri = (String)optProps.get(UPDATE_URI);
            String type = (String)optProps.get("contenttype");
            String contents = (String)optProps.get(UPDATE_CONTENTS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "operation: " + operation);
                Tr.debug(tc, "uri: " + uri);
                Tr.debug(tc, "type: " + type);
                Tr.debug(tc, "contents: " + contents);
            }
            if (type == null) {
                missingOption = "contenttype";
            } else if (!(type.equals("file") || type.equals("modulefile") || type.equals("partialapp") || type.equals("app"))) {
                this._shell.setAndThrowScriptingException("WASX7412E", "Invalid content type value: " + type, new Object[]{type});
            }
            if (missingOption == null) {
                if (type.equals("partialapp") || type.equals("app")) {
                    if (contents == null || contents.trim().length() == 0) {
                        missingOption = UPDATE_CONTENTS;
                    } else {
                        if (uri != null) {
                            System.out.println(this._shell.getFormattedMessage("WASX7414W", new Object[]{UPDATE_URI, type}, "Ignoring uri option when " + type + " type is specified"));
                        }
                        if (operation == null) {
                            if (type.equals("app")) {
                                missingOption = UPDATE_OPERATION;
                            }
                        } else if (type.equals("partialapp")) {
                            System.out.println(this._shell.getFormattedMessage("WASX7414W", new Object[]{UPDATE_OPERATION, type}, "Ignoring operation option when " + type + " type is specified"));
                        }
                    }
                }
                if (missingOption == null && type.equals("file") || type.equals("modulefile")) {
                    if (operation == null || operation.trim().length() == 0) {
                        missingOption = UPDATE_OPERATION;
                    } else if (!(operation.equals("add") || operation.equals(UPDATEOPTION) || operation.equals("addupdate") || operation.equals("delete"))) {
                        this._shell.setAndThrowScriptingException("WASX7413E", "Invalid operation value: " + operation, new Object[]{operation});
                    } else if (uri == null || uri.trim().length() == 0) {
                        missingOption = UPDATE_URI;
                    } else if (contents == null || contents.trim().length() == 0) {
                        if (!operation.equals("delete")) {
                            missingOption = UPDATE_CONTENTS;
                        }
                    } else if (operation.equals("delete")) {
                        System.out.println(this._shell.getFormattedMessage("WASX7415W", new Object[]{UPDATE_CONTENTS, operation}, "Ignoring contents option when " + operation + " operation is specified"));
                        optProps.remove(UPDATE_CONTENTS);
                    }
                }
            }
            if (missingOption != null) {
                if (missingOption.equals(UPDATE_OPERATION) || type.equals("partialapp") || type.equals("app")) {
                    this._shell.setAndThrowScriptingException("WASX7416E", missingOption + " option is required when " + type + " content type is specified", new Object[]{missingOption, type, operation});
                } else {
                    this._shell.setAndThrowScriptingException("WASX7417E", missingOption + " option is required when " + type + " content type and " + operation + " operation are sepecified", new Object[]{missingOption, type, operation});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateUpdateOptions");
        }
    }

    private void collectNonTaskOptions(Hashtable outputTable, Hashtable inputTable) {
        String sName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "collectNonTaskOptions");
        }
        Hashtable tbl = null;
        Hashtable wstbl = null;
        if (inputTable.containsKey("deployejb")) {
            outputTable.put("deployejb", Boolean.TRUE);
        }
        tbl = (Hashtable)outputTable.get("deployejb.options");
        if (inputTable.containsKey("deployws")) {
            outputTable.put("deployws", Boolean.TRUE);
        }
        wstbl = (Hashtable)outputTable.get("deployws.options");
        Enumeration keys = inputTable.keys();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "inputTable: " + inputTable.toString());
        }
        while (keys.hasMoreElements()) {
            String opt = (String)keys.nextElement();
            if ((this.nonBooleanDeplOptions.contains(opt) || this.booleanDeplOptions.contains(opt)) && (this.isOptionInOptionTable(opt, addonServerOptions, true) || this.isOptionInOptionTable(opt, addonServerOptions, false) || this.isOptionInOptionTable(opt, this.hiddenOptions, true) || this.isOptionInOptionTable(opt, deprecatedOptions, false))) {
                String key = opt;
                if (nonTaskOptionMap.containsKey(opt)) {
                    key = nonTaskOptionMap.getProperty(opt);
                }
                if (key == null) continue;
                Object val = inputTable.get(opt);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key " + key + " and value " + val + " to controller opts.");
                }
                if (key.equals(CUSTOMOPTION)) {
                    Vector customValues = (Vector)val;
                    for (int i = 0; i < customValues.size(); ++i) {
                        String aCustomVal = (String)customValues.get(i);
                        int index = aCustomVal.indexOf("=");
                        if (index >= 0) {
                            outputTable.put(aCustomVal.substring(0, index), aCustomVal.substring(index + 1));
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Adding custom option key " + aCustomVal.substring(0, index) + " and value " + aCustomVal.substring(index + 1));
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Invalue custom option value: " + aCustomVal);
                    }
                    continue;
                }
                outputTable.put(key, val);
                continue;
            }
            if (this.nonBooleanDeplOptions.contains(opt) && opt.startsWith("deployejb")) {
                tbl.put(opt, inputTable.get(opt));
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "using deploy EJB option " + opt);
                continue;
            }
            if (!this.nonBooleanDeplOptions.contains(opt) || !opt.startsWith("deployws")) continue;
            wstbl.put(opt, inputTable.get(opt));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "using deploy WS option " + opt);
        }
        if (!inputTable.containsKey(CELLOPTION)) {
            outputTable.put("cell.name", this.cellName);
        }
        if (!inputTable.containsKey(NODEOPTION)) {
            if (connectedServer != null) {
                String nName = ObjectNameHelper.getNodeName(connectedServer);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting node.name to " + nName);
                }
                if (nName != null) {
                    outputTable.put("node.name", nName);
                }
            } else {
                String temp = System.getProperty(NODE_PROP);
                if (temp != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting node.name to " + temp);
                    }
                    outputTable.put("node.name", temp);
                }
            }
        }
        if (!inputTable.containsKey(SERVEROPTION) && connectedServer != null && (sName = ObjectNameHelper.getProcessName(connectedServer)) != null && !sName.equals("adminagent")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting server.name to " + sName);
            }
            outputTable.put("server.name", sName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectNonTaskOptions " + outputTable);
        }
    }

    private void fixupAppDeploymentOptions(Hashtable optProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupAppDeploymentOptions");
        }
        ArrayList appDepProp = new ArrayList();
        boolean foundOne = false;
        Enumeration keys = optProps.keys();
        while (keys.hasMoreElements()) {
            String opt = (String)keys.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "looking at hashtable key " + opt);
            }
            String value = null;
            ArrayList<String> entry = new ArrayList<String>();
            if (this.booleanDeplOptions.contains(opt) && this.isOptionInOptionTable(opt, this.deplOptions, false)) {
                if (opt.equals("deployejb") || opt.equals("deployws")) continue;
                foundOne = true;
                String yesNo = "AppDeploymentOption.Yes";
                optProps.remove(opt);
                if (opt.startsWith("no")) {
                    opt = opt.substring(2);
                    yesNo = "AppDeploymentOption.No";
                }
                entry.add(opt);
                entry.add(yesNo);
            } else {
                if (!this.nonBooleanDeplOptions.contains(opt) || !this.isOptionInOptionTable(opt, this.deplOptions, false)) continue;
                foundOne = true;
                Object o = opt.equals(APPNAMEOPTION) ? optProps.get(opt) : optProps.remove(opt);
                value = o.toString();
                entry.add(opt);
                entry.add(value);
            }
            appDepProp.add(entry);
        }
        if (foundOne) {
            optProps.put(APPDEPLOYMENTOPTION, appDepProp);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupAppDeploymentOptions");
        }
    }

    private AppDeploymentController getController(String earfile, Hashtable prefs, Hashtable optProps) throws AppDeploymentException, ScriptingException {
        File test;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getController", new Object[]{earfile, optProps});
        }
        if (!(earfile == null || optProps.containsKey(SYSTEMAPP) || optProps.containsKey(SKIPPREP) || (test = new File(earfile)).exists() && test.canRead())) {
            this._shell.setAndThrowScriptingException("WASX7281E", "Cannot install application using file " + earfile + ".  Please ensure that this file exists and is readable.", new Object[]{earfile});
        }
        AppDeploymentController flowController = null;
        if (prefs == null) {
            prefs = new Hashtable<String, ConfigService>();
        }
        if (AdminConfigClient.getConfigService() != null) {
            prefs.put("configservice", AdminConfigClient.getConfigService());
        }
        if (AdminControlClient.getInstance().getAdminClient() != null) {
            prefs.put("adminclient", (ConfigService)((Object)AdminControlClient.getInstance().getAdminClient()));
        }
        if (AdminConfigClient.getInstance().getCurrentSession() != null) {
            prefs.put("configsession", (ConfigService)((Object)AdminConfigClient.getInstance().getCurrentSession()));
        }
        if (optProps.containsKey("app.original.uri")) {
            prefs.put("app.original.uri", (ConfigService)optProps.get("app.original.uri"));
        }
        try {
            boolean local = this.isLocalMode(optProps, false);
            String appName = (String)optProps.get(APPNAMEOPTION);
            String editionName = (String)optProps.get(APPEDITIONOPTION);
            if (optProps.containsKey(UPDATEOPTION)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "in update mode");
                }
                if (optProps.get(UPDIGNORENEWOPTION) != null) {
                    prefs.put("redeploy.ignore.new", (ConfigService)optProps.get(UPDIGNORENEWOPTION));
                } else if (optProps.get(UPDIGNOREOLDOPTION) != null) {
                    prefs.put("redeploy.ignore.old", (ConfigService)optProps.get(UPDIGNOREOLDOPTION));
                }
                String uri = (String)optProps.get(UPDATE_URI);
                String operation = (String)optProps.get(UPDATE_OPERATION);
                String type = (String)optProps.get("contenttype");
                prefs.put("contenttype", (ConfigService)((Object)type));
                Vector tasks = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "type: " + type);
                    Tr.debug(tc, "prefs: " + prefs);
                }
                if ((type.equals("modulefile") || type.equals("app")) && !optProps.containsKey(SKIPPREP)) {
                    tasks = this.getOldAppTasks(local, EditionHelper.getCompositeName(appName, editionName));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "calling readArchiveForUpdate");
                    }
                    flowController = AppManagementFactory.readArchiveForUpdate(earfile, uri, operation, prefs, tasks);
                } else if (optProps.containsKey(SKIPPREP) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "The -skipPreparation option is passed, flowController will not be created.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "flowController: " + flowController);
                }
            } else {
                if (optProps.get(SYSTEMAPP) != null) {
                    prefs.put(SYSTEMAPP, (ConfigService)optProps.get(SYSTEMAPP));
                }
                if (optProps.get(SKIPPREP) != null) {
                    prefs.put(SKIPPREP, (ConfigService)optProps.get(SKIPPREP));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prefs: " + prefs);
                }
                flowController = AppManagementFactory.readArchive(earfile, prefs);
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (AppDeploymentException ade) {
            this._shell.setLastException(ade);
            throw ade;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getController");
        }
        return flowController;
    }

    private Vector getOldAppTasks(boolean local, String appName) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOldAppTasks");
        }
        Vector tasks = null;
        try {
            if (local) {
                AdminAppClient.dbg("Getting tasks for: " + appName);
                AppManagement m = AppManagementFactory.createLocalAppManagementImpl();
                AdminConfigClient cfg = AdminConfigClient.getInstance();
                tasks = cfg.getConfigService() == null ? m.getApplicationInfo(appName, new Hashtable(), null) : m.getApplicationInfo(appName, new Hashtable(), this.getWorkspaceId());
            } else {
                tasks = appManagementProxy.getApplicationInfo(appName, new Hashtable(), this.getWorkspaceId());
            }
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOldAppTasks");
        }
        return tasks;
    }

    private String displayAndSetTaskData(AppDeploymentTask installTask, boolean editFlag, Hashtable optProps) throws AppDeploymentException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "displayAndsetTaskData");
        }
        String[][] taskData = installTask.getTaskData();
        StringBuffer buf = new StringBuffer();
        String ret = new String();
        if (tc.isDebugEnabled()) {
            for (int ii = 0; ii < taskData.length; ++ii) {
                for (int jj = 0; jj < taskData[ii].length; ++jj) {
                    if (taskData[0][jj].equals("password")) {
                        Tr.debug(tc, "data[" + ii + "][" + jj + "]: " + "******");
                        continue;
                    }
                    Tr.debug(tc, "data[" + ii + "][" + jj + "]: " + taskData[ii][jj]);
                }
            }
        }
        boolean changed = false;
        AppDeploymentMessages appM = installTask.getTaskMessages();
        if (appM == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not get a messages object!");
            }
            appM = appMessages;
        }
        if (taskData != null) {
            if (!editFlag && optProps == null) {
                buf.append(this.getGeneralTaskInfo(installTask));
            }
            for (int i = 1; i < taskData.length; ++i) {
                try {
                    for (int j = 0; j < taskData[i].length; ++j) {
                        String data = null;
                        if (optProps == null) {
                            data = appM.getColumnName(taskData[0][j], installTask.getName()) + ":  ";
                        } else if (optProps != null && optProps.containsKey(taskData[0][j])) {
                            data = appM.getColumnName(taskData[0][j], installTask.getName()) + ":  ";
                        }
                        if (!(!installTask.isHiddenColumn(j) || installTask.getName().equals(BACKENDIDOPTION) && taskData[0][j].equals("BackendIds"))) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "column hidden: " + j);
                            }
                            if (j != taskData[i].length - 1 || i == taskData.length - 1) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Printing a newline for the last column of a hidden column.");
                            }
                            System.out.println("\n");
                            continue;
                        }
                        if (installTask.getMutableColumns(j) && editFlag) {
                            data = data + "[";
                        }
                        if (data != null) {
                            data = taskData[i][j] != null && (taskData[i][j].equals("AppDeploymentOption.Yes") || taskData[i][j].equals("AppDeploymentOption.No") || taskData[i][j].equals("cmpBinding.container") || taskData[i][j].equals("cmpBinding.perConnectionFactory")) ? data + appM.getMessage(taskData[i][j]) : (taskData[0][j].equals("password") && taskData[i][j] != null && taskData[i][j].trim().length() != 0 ? data + "******" : data + taskData[i][j]);
                        }
                        if (installTask.getMutableColumns(j) && editFlag) {
                            data = data + "]: ";
                        }
                        if (data != null) {
                            buf.append(data);
                            buf.append(nl);
                        }
                        if (!editFlag) continue;
                        if (installTask.getMutableColumns(j)) {
                            String input = this.promptInput(installTask.getRequiredColumns(j), taskData[i][j], data, taskData[0][j]);
                            if (input != null) {
                                boolean okFlag = false;
                                if (taskData[0][j].equals(FILEPERMISSIONOPTION)) {
                                    okFlag = this.validateFilePermissionString(input);
                                    while (!okFlag) {
                                        input = this.promptInput(installTask.getRequiredColumns(j), taskData[i][j], data, taskData[0][j]);
                                        okFlag = this.validateFilePermissionString(input);
                                    }
                                }
                                String tmpInput = input;
                                if (input.equals("AppDeploymentOption.Yes")) {
                                    tmpInput = "Yes";
                                } else if (input.equals("AppDeploymentOption.No")) {
                                    tmpInput = "No";
                                }
                                AdminAppClient.dbg(MessageFormat.format(this.PROMPT_Setting_To, appM.getColumnName(taskData[0][j], installTask.getName()), tmpInput));
                                taskData[i][j] = input;
                                changed = true;
                            }
                        } else {
                            AdminAppClient.dbg(data);
                        }
                        if (j != taskData[i].length - 1 || i == taskData.length - 1) continue;
                        System.out.println("\n");
                    }
                    buf.append(nl);
                    ret = buf.toString();
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    this._shell.setLastException(ex);
                    throw ex;
                }
            }
        }
        if (changed) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Saving changes to task " + installTask.getName());
            }
            installTask.setTaskData(taskData);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No change to task " + installTask.getName());
        }
        if (editFlag) {
            ret = changed ? "true" : "false";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "displayAndsetTaskData " + changed);
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String promptInput(boolean isRequired, String taskData, String data, String columnName) throws IOException {
        String answer = null;
        InputStreamReader in = null;
        if (this.zos) {
            String inputEncoding = System.getProperty("ws.input.encoding");
            if (inputEncoding != null) {
                try {
                    in = new InputStreamReader(System.in, inputEncoding);
                }
                catch (IOException ioe) {
                    this._shell.setLastException(ioe);
                    throw ioe;
                }
            } else {
                in = new InputStreamReader(System.in);
            }
        } else {
            in = new InputStreamReader(System.in);
        }
        BufferedReader console = new BufferedReader(in);
        try {
            while (true) {
                System.out.print(data);
                answer = console.readLine();
                if (answer.trim().startsWith("[") && answer.trim().endsWith("]") && !answer.trim().equals("[]")) {
                    answer = answer.substring(1, answer.length() - 1);
                }
                if (isRequired && (answer == null || answer != null && answer.trim().length() == 0) && (taskData == null || taskData != null && taskData.length() == 0)) {
                    AdminAppClient.dbg(MessageFormat.format(this.PROMPT_Required_Field_Missing, new Object[0]));
                    continue;
                }
                if (answer != null) {
                    if (isRequired) {
                        if (answer.trim().length() == 0) return null;
                    }
                    if (!isRequired && answer.length() == 0) {
                        return null;
                    }
                }
                if (answer == null) return answer;
                if (taskData != null && (taskData.equals("AppDeploymentOption.Yes") || taskData.equals("AppDeploymentOption.No"))) {
                    if (answer.equalsIgnoreCase(appMessages.getMessage("AppDeploymentOption.No"))) return "AppDeploymentOption.No";
                    if (answer.equalsIgnoreCase("NO")) {
                        return "AppDeploymentOption.No";
                    }
                    if (answer.equalsIgnoreCase(appMessages.getMessage("AppDeploymentOption.Yes"))) return "AppDeploymentOption.Yes";
                    if (answer.equalsIgnoreCase("YES")) {
                        return "AppDeploymentOption.Yes";
                    }
                    AdminAppClient.dbg(MessageFormat.format(this.PROMPT_Yes_or_No, new Object[0]));
                    continue;
                }
                if (!columnName.equals("resAuth")) return answer;
                if (answer.trim().equalsIgnoreCase("container")) {
                    return "cmpBinding.container";
                }
                if (answer.trim().equalsIgnoreCase("per connection factory")) {
                    return "cmpBinding.perConnectionFactory";
                }
                if (answer.trim().equals("")) return answer;
                AdminAppClient.dbg(_bundle.getString("WASX7350E"));
            }
        }
        catch (IOException ex) {
            this._shell.setLastException(ex);
            throw ex;
        }
    }

    private Hashtable saveAndClose(AppDeploymentController flowController) throws AppDeploymentException {
        flowController.saveAndClose();
        Hashtable savedResults = flowController.getAppDeploymentSavedResults();
        return savedResults;
    }

    private void printOptions(Hashtable appO) {
        AdminAppClient.dbg("*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_");
        Enumeration keys = appO.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            AdminAppClient.dbg("");
            AdminAppClient.dbg(key + " ----> " + appO.get(key));
        }
        AdminAppClient.dbg("*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_");
    }

    private String copyToTempDir(File input, String type) throws AppDeploymentException, ScriptingException {
        String filename = input.getAbsolutePath();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyToTempDir " + filename);
        }
        if (type == null || type.equals("partialapp") || !type.equals("file")) {
            // empty if block
        }
        String ret = null;
        String temp = System.getProperty(TEMPDIR_PROP);
        File tmpDir = null;
        if (temp != null) {
            tmpDir = new File(temp);
        }
        File tempFile = null;
        if (!input.canRead()) {
            this._shell.setAndThrowScriptingException("WASX7115E", "Cannot read input file: " + filename, new Object[]{filename});
        }
        try {
            String suffix = null;
            suffix = filename.lastIndexOf(".") > 0 ? filename.substring(filename.lastIndexOf(".")) : null;
            tempFile = File.createTempFile("app", suffix, tmpDir);
            ret = tempFile.getCanonicalPath();
            boolean delete = tempFile.delete();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copyToTempDir delete file ", tempFile);
                Tr.debug(tc, "copyToTempDir delete file returned ", delete);
            }
        }
        catch (IOException ioe) {
            String dir = null;
            if (tmpDir != null) {
                dir = tmpDir.toString();
            }
            this._shell.setAndThrowScriptingException("WASX7114E", "Cannot create temporary file in directory " + dir, new Object[]{dir});
        }
        try {
            FileTools.copyFile(tempFile, input);
        }
        catch (FileNotFoundException fnfe) {
            this._shell.setAndThrowScriptingException("WASX7116E", "Cannot copy files.", new Object[]{input.toString(), tempFile.toString()});
        }
        catch (IOException ioe) {
            this._shell.setAndThrowScriptingException("WASX7116E", "Cannot copy files.", new Object[]{input.toString(), tempFile.toString()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyToTempDir " + ret);
        }
        return ret;
    }

    private String copyDirToTempDir(File input) throws AppDeploymentException, ScriptingException {
        File tmpDir;
        File tempFile;
        boolean created;
        String filename = input.getAbsolutePath();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyDirToTempDir " + filename);
        }
        if (AppManagementHelper.isSystemApp(filename)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This is a system app dir.");
            }
            return filename;
        }
        String ret = null;
        String temp = System.getProperty(TEMPDIR_PROP);
        if (temp == null) {
            temp = System.getProperty("java.io.tmpdir");
        }
        if (!(created = (tempFile = new File(tmpDir = new File(temp), "app" + Long.toHexString(System.currentTimeMillis()) + ".ear")).mkdirs())) {
            this._shell.setAndThrowScriptingException("WASX7323E", "Cannot create directory " + tempFile.getAbsolutePath(), new Object[]{tempFile.getAbsolutePath()});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "created temp dir " + tempFile.getAbsolutePath());
        }
        if (!input.canRead()) {
            this._shell.setAndThrowScriptingException("WASX7115E", "Cannot read input file: " + filename, new Object[]{filename});
        }
        try {
            FileTools.copyDirectory(tempFile, input);
        }
        catch (IOException ioe) {
            Object dir = null;
            this._shell.setAndThrowScriptingException("WASX7324E", "Cannot copy directory " + input.getName() + " to directory " + tempFile.getAbsolutePath(), new Object[]{input.getName(), tempFile.getAbsolutePath()});
        }
        if (filename.toLowerCase().endsWith(".jar") || filename.toLowerCase().endsWith(".war")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expanded war/jar; ignore.");
            }
            ret = tempFile.getAbsolutePath();
        } else {
            ResourceBundle resBundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", Locale.getDefault());
            try {
                EARFile archive = AppInstallHelper.getEarFile(tempFile.getAbsolutePath(), false, resBundle);
                archive.saveNoReopen();
                archive.close();
                ret = archive.getURI();
            }
            catch (Exception ae) {
                this._shell.setLastException(ae);
                String detail = ExceptionSupport.getMessage(ae, "WASX");
                if (detail == null) {
                    detail = ae.toString();
                }
                throw new ScriptingException(detail);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyDirToTempDir " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String wrapIfNeeded(String filename, Hashtable optProps, String origfile) throws AppDeploymentException, ScriptingException {
        String ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "wrapIfNeeded ", new Object[]{filename, origfile});
        }
        if ((ret = filename).toLowerCase().endsWith(".ear")) {
            return ret;
        }
        String contextRoot = (String)optProps.get(CONTEXTROOTOPTION);
        if (ret.length() > 4) {
            if (ret.toLowerCase().endsWith(".war")) {
                String operation = (String)optProps.get(UPDATE_OPERATION);
                if (contextRoot == null && ret.toLowerCase().endsWith(".war")) {
                    if (operation != null && operation.equals("add")) {
                        this._shell.setAndThrowScriptingException("WASX7134E", "contextroot must be specified for war install.", new Object[]{CONTEXTROOTOPTION});
                    }
                } else if (contextRoot != null && ret.toLowerCase().endsWith(".war") && operation != null && (operation.equals(UPDATEOPTION) || operation.equals("addupdate"))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Ignoring contextroot option");
                    }
                    System.out.println(this._shell.getFormattedMessage("WASX7428W", new Object[0], "contextroot option will be ignored if module exists"));
                }
            }
            if (!optProps.containsKey(UPDATEOPTION) || optProps.containsKey(UPDATEOPTION) && ((String)optProps.get("contenttype")).equals("app")) {
                String tempFileName = filename;
                File delete = new File(tempFileName);
                try {
                    String appName = (String)optProps.get(APPNAMEOPTION);
                    File f = new File(origfile);
                    String origURI = f.getName();
                    if (appName != null) {
                        appName = delete.getParent() + File.separator + appName + Long.toHexString(System.currentTimeMillis());
                    } else if (!delete.isDirectory()) {
                        appName = delete.getParent() + File.separator + origURI + Long.toHexString(System.currentTimeMillis());
                    }
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Creating an earfile from " + tempFileName);
                    }
                    ret = AppInstallHelper.createEarWrapper(tempFileName, appName + ".ear", origURI, contextRoot);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "earfile created is " + ret);
                    }
                }
                finally {
                    if (delete.isDirectory()) {
                        FileTools.removeDirectory(delete);
                    } else {
                        delete.delete();
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "wrapIfNeeded " + ret);
        }
        return ret;
    }

    private String copyToServer(String filename) throws ConnectorException, ScriptingException, AdminException, TransferFailedException, MalformedObjectNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyToServer", new Object[]{filename});
        }
        String ret = filename;
        if ((this.isCellManager() || this.is60Standalone() || this.isAdminAgent()) && filename != null) {
            AdminControlClient controlClient = AdminControlClient.getInstance();
            String localInetAddressByName = controlClient.getHost() + "/" + AdminAppClient.getLocalHostAddress();
            String hostInetAddressByName = AdminAppClient.getHostInetAddressByName(controlClient.getHost());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "localInetAddressByName is " + localInetAddressByName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "hostInetAddressByName is " + hostInetAddressByName);
            }
            if (!(controlClient == null || controlClient.getHost().equals("localhost") || controlClient.getHost().equals(AppDeploymentInfo.getLocalHost()) || controlClient.getHost().equals(AdminAppClient.getLongLocalHost()) || controlClient.getHost().equals(AdminAppClient.getLocalHostAddress()) || hostInetAddressByName.equals(localInetAddressByName))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "upload files from " + AppDeploymentInfo.getLocalHost() + " to " + controlClient.getHost());
                }
                Properties props = _client.getConnectorProperties();
                FileTransferClient transfer = FileTransferFactory.getFileTransferClient(_client);
                String remDir = transfer.getServerStagingLocation();
                File f = new File(filename);
                String sep = File.separator;
                if (remDir != null) {
                    sep = remDir.indexOf("/") >= 0 ? "/" : "\\";
                }
                String targetName = this.UPLOADDIR + sep + f.getName();
                transfer.uploadFile(f, targetName);
                if (!remDir.endsWith("/") && !remDir.endsWith("\\")) {
                    remDir = remDir + sep;
                }
                ret = remDir + targetName;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyToServer", new Object[]{ret});
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeMBeanInstall(String filename, Hashtable opts, boolean redeploy) throws AdminException, ConnectorException, ScriptingException, TransferFailedException, MalformedObjectNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeMBeanInstall", new Object[]{filename, opts});
        }
        this.successFlag = false;
        String appname = (String)opts.get(APPNAMEOPTION);
        String newname = null;
        newname = !opts.containsKey(SYSTEMAPP) || !AppManagementHelper.isSystemApp(filename) ? this.copyToServer(filename) : filename;
        String editionname = (String)opts.get(APPEDITIONOPTION);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "appname is " + appname);
        }
        String id = "Install:" + appname;
        String handbackId = Long.toHexString(System.currentTimeMillis());
        AppNotificationFilter myFilter = new AppNotificationFilter(appname, "websphere.admin.appmgmt", handbackId);
        appManagementProxy.addNotificationListener(this, myFilter, id);
        if (filename != null && !filename.equals(newname)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding APPDEPL_DELETE_SRC_EAR key to opts to delete \n\t uploadfile: " + newname + "\n\t originalfile: " + filename);
            }
            opts.put("DeleteSourceEar", Boolean.TRUE);
        }
        try {
            String string = "waitObject";
            synchronized ("waitObject") {
                block21: {
                    if (redeploy) {
                        this.waitTarget = ((String)opts.get("contenttype")).equals("app") ? "InstallApplication" : "UpdateApplication";
                        String uri = (String)opts.get(UPDATE_URI);
                        String operation = (String)opts.get(UPDATE_OPERATION);
                        String appName = (String)opts.get(APPNAMEOPTION);
                        opts.put("HandBackForClient", handbackId);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "uri: " + uri);
                            Tr.debug(tc, "operation: " + operation);
                            Tr.debug(tc, "opts: " + opts);
                            Tr.debug(tc, "About to call AppManagement.updateApplication ...");
                        }
                        appManagementProxy.updateApplication(appName, uri, newname, operation, opts, this.getWorkspaceId());
                    } else {
                        this.waitTarget = "InstallApplication";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "opts: " + opts);
                            Tr.debug(tc, "About to call AppManagement.installApplication ...");
                        }
                        appManagementProxy.installApplication(newname, appname, opts, this.getWorkspaceId());
                    }
                    try {
                        "waitObject".wait(this.MAX_WAIT_TIME);
                    }
                    catch (InterruptedException ie) {
                        if (!tc.isDebugEnabled()) break block21;
                        Tr.debug(tc, "Interrupted; time to work.");
                    }
                }
                // ** MonitorExit[var10_10] (shouldn't be in output)
            }
        }
        finally {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing notif list. in finally");
            }
            appManagementProxy.removeNotificationListener(this);
        }
        {
            if (!this.successFlag) {
                if (redeploy) {
                    this._shell.setAndThrowScriptingException("WASX7418E", "Application update failed.", new Object[]{appname});
                } else {
                    this._shell.setAndThrowScriptingException("WASX7132E", "Application install failed.", new Object[]{this.origFileName});
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invokeMBeanInstall");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeMBeanUninstall(String appName, Hashtable opts) throws AdminException, ConnectorException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeMBeanUninstall");
        }
        this.successFlag = false;
        String id = "Uninstall:" + appName;
        AppNotificationFilter myFilter = new AppNotificationFilter(appName, "websphere.admin.appmgmt", null);
        appManagementProxy.addNotificationListener(this, myFilter, id);
        try {
            String string = "waitObject";
            synchronized ("waitObject") {
                block12: {
                    this.waitTarget = "UninstallApplication";
                    appManagementProxy.uninstallApplication(appName, opts, this.getWorkspaceId());
                    try {
                        "waitObject".wait(this.MAX_WAIT_TIME);
                    }
                    catch (InterruptedException ie) {
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug(tc, "Interrupted; time to work.");
                    }
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        finally {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing notif list. in finally");
            }
            appManagementProxy.removeNotificationListener(this);
        }
        {
            if (!this.successFlag) {
                this._shell.setAndThrowScriptingException("WASX7133E", "Application uninstall failed.", new Object[]{appName});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invokeMBeanUninstall");
            }
            return;
        }
    }

    public void handleNotification(Notification notf, Object handback) {
        if (notf == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMX event Recd: (handback obj= " + handback + "): " + "Notification object is null");
            }
            return;
        }
        Object ud = notf.getUserData();
        if (tc.isEventEnabled()) {
            Tr.event(tc, "JMX event Recd: (handback obj= " + handback + "): " + ud);
        }
        if (ud instanceof AppNotification) {
            this.appEventReceived((AppNotification)ud);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void appEventReceived(AppNotification ev) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Received event: " + ev);
        }
        String msg = ev.message;
        System.out.println(msg);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "taskname: " + ev.taskName);
            Tr.debug(tc, "waitTarget: " + this.waitTarget);
            Tr.debug(tc, "props: " + ev.toString());
        }
        if ((!ev.taskName.equals(this.waitTarget) || !ev.taskStatus.equals("Completed")) && !ev.taskStatus.equals("Failed")) return;
        String string = "waitObject";
        synchronized ("waitObject") {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got STATUS_COMPLETED");
            }
            this.successFlag = ev.taskStatus.equals("Completed");
            this.waitTarget = null;
            this.waitProps = ev.props;
            "waitObject".notify();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public String list() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "list");
        }
        this._shell.setLastException(null);
        String ret = this.list(new String(), null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "list");
        }
        return ret;
    }

    public String list(String target) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "list" + target);
        }
        this._shell.setLastException(null);
        String ret = this.list(new String(), target);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "list");
        }
        return ret;
    }

    public String list(String options, String target) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "list");
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        Hashtable optProps = this._langutils.optionsToHashtable(options);
        Vector apps = this.getAppList(optProps, target);
        String ret = this._langutils.setToString(apps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "list");
        }
        return ret;
    }

    private Vector getAppList(Hashtable optProps, String target) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppList");
        }
        Vector apps = null;
        try {
            boolean local = this.isLocalMode(optProps, true);
            if (!local) {
                this.checkService();
            }
            Hashtable prefs = this.createPreferences(null, optProps, false);
            if (!local) {
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "This list mediated by MBean.");
                }
                apps = target != null ? appManagementProxy.listApplications(target, prefs, this.getWorkspaceId()) : appManagementProxy.listApplications(prefs, this.getWorkspaceId());
            } else {
                this.warnIfConnected();
                AppManagement mgmt = null;
                ConfigRepositoryFactory.getConfigRepository().initialize(new Properties());
                mgmt = AppManagementFactory.createLocalAppManagementImpl();
                AdminConfigClient cfg = AdminConfigClient.getInstance();
                String workspaceId = null;
                if (cfg.getConfigService() != null) {
                    workspaceId = this.getWorkspaceId();
                }
                apps = target != null ? mgmt.listApplications(target, prefs, workspaceId) : mgmt.listApplications(prefs, workspaceId);
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppList");
        }
        return apps;
    }

    public String listModules(String appname) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listModules", new Object[]{appname});
        }
        this._shell.setLastException(null);
        String ret = this.listModules(appname, new String());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listModules");
        }
        return ret;
    }

    public String listModules(String appname, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listModules", new Object[]{appname, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String strOptions = this._langutils.objectArrayToString(options);
        String ret = this.listModules(appname, strOptions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listModules");
        }
        return ret;
    }

    public String listModules(String appname, String options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listModules", new Object[]{appname, options});
        }
        this._shell.setLastException(null);
        StringBuffer buf = new StringBuffer();
        try {
            Hashtable optProps;
            boolean local;
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            if (!(local = this.isLocalMode(optProps = this._langutils.optionsToHashtable(options), true))) {
                this.checkService();
            }
            Hashtable prefs = this.createPreferences(null, optProps, false);
            AppDeploymentTask lmTask = null;
            if (!local) {
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "This listModules mediated by MBean.");
                }
                lmTask = appManagementProxy.listModules(appname, prefs, this.getWorkspaceId());
            } else {
                this.warnIfConnected();
                AppManagement mgmt = null;
                ConfigRepositoryFactory.getConfigRepository().initialize(new Properties());
                mgmt = AppManagementFactory.createLocalAppManagementImpl();
                AdminConfigClient cfg = AdminConfigClient.getInstance();
                lmTask = cfg.getConfigService() == null ? (AppDeploymentTask)mgmt.listModules(appname, prefs, null) : (AppDeploymentTask)mgmt.listModules(appname, prefs, this.getWorkspaceId());
            }
            String[][] taskData = lmTask.getTaskData();
            int numrows = taskData.length;
            int numcols = taskData[0].length;
            String appHash = appname + "#";
            for (int rowidx = 1; rowidx < numrows; ++rowidx) {
                buf.append(appHash);
                buf.append(taskData[rowidx][1]);
                if (optProps.containsKey(SERVEROPTION)) {
                    buf.append("#");
                    buf.append(taskData[rowidx][2]);
                }
                if (rowidx >= numrows - 1) continue;
                buf.append(nl);
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listModules");
        }
        return buf.toString();
    }

    public void updateAccessIDs(String appname, Boolean bAll) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAccessIDs: " + appname);
        }
        this._shell.setLastException(null);
        this.updateAccessIDs(appname, bAll, new String());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateAccessIDs");
        }
    }

    public void updateAccessIDs(String appname, Boolean bAll, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAccessIDs");
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String strOptions = this._langutils.objectArrayToString(options);
        this.updateAccessIDs(appname, bAll, strOptions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateAccessIDs");
        }
    }

    public void updateAccessIDs(String appname, Boolean bAll, String options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAccessIDs");
        }
        this._shell.setLastException(null);
        try {
            Hashtable optProps;
            boolean local;
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            if (!(local = this.isLocalMode(optProps = this._langutils.optionsToHashtable(options), true))) {
                this.checkService();
            }
            Hashtable prefs = this.createPreferences(null, optProps, false);
            if (!local) {
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "MBean: updateAccessIDs");
                }
                appManagementProxy.updateAccessIDs(appname, bAll, prefs, this.getWorkspaceId());
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateAccessIDs");
        }
    }

    public void deleteUserAndGroupEntries(String appname) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteUserAndGroupEntries: " + appname);
        }
        this._shell.setLastException(null);
        this.deleteUserAndGroupEntries(appname, new String());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteUserAndGroupEntries");
        }
    }

    public void deleteUserAndGroupEntries(String appname, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteUserAndGroupEntries");
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String strOptions = this._langutils.objectArrayToString(options);
        this.deleteUserAndGroupEntries(appname, strOptions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteUserAndGroupEntries");
        }
    }

    public void deleteUserAndGroupEntries(String appname, String options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteUserAndGroupEntries");
        }
        this._shell.setLastException(null);
        try {
            Hashtable optProps;
            boolean local;
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            if (!(local = this.isLocalMode(optProps = this._langutils.optionsToHashtable(options), true))) {
                this.checkService();
            }
            Hashtable prefs = this.createPreferences(null, optProps, false);
            if (!local) {
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "MBean: deleteUserAndGroupEntries");
                }
                appManagementProxy.deleteUserAndGroupEntries(appname, prefs, this.getWorkspaceId());
            } else {
                this.warnIfConnected();
                AppManagement mgmt = null;
                ConfigRepositoryFactory.getConfigRepository().initialize(new Properties());
                mgmt = AppManagementFactory.createLocalAppManagementImpl();
                AdminConfigClient cfg = AdminConfigClient.getInstance();
                if (cfg.getConfigService() == null) {
                    mgmt.deleteUserAndGroupEntries(appname, prefs, null);
                } else {
                    mgmt.deleteUserAndGroupEntries(appname, prefs, this.getWorkspaceId());
                }
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteUserAndGroupEntries");
        }
    }

    public String publishWSDL(String appname, String filename) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publishWSDL: ", new Object[]{appname, filename});
        }
        this._shell.setLastException(null);
        String ret = this.publishWSDL(appname, filename, new String());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "publishWSDL");
        }
        return ret;
    }

    public String publishWSDL(String appname, String filename, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publishWSDL: ", new Object[]{appname, filename, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String strOptions = this._langutils.objectArrayToString(options);
        String ret = this.publishWSDL(appname, filename, strOptions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "publishWSDL");
        }
        return ret;
    }

    public String publishWSDL(String appname, String filename, String options) throws ScriptingException {
        this._shell.setLastException(null);
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "publishWSDL: ", new Object[]{appname, filename, options});
            }
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            AttributeList prefixes = this._langutils.stringToAttributeList(options);
            Hashtable<String, Cloneable> optProps = new Hashtable<String, Cloneable>();
            optProps.put("PREFIXES", prefixes);
            optProps.put("app.client.locale", Locale.getDefault());
            boolean local = this.isLocalMode(optProps, true);
            if (!this.alreadyInstalled(appname, local, optProps)) {
                this._shell.setAndThrowScriptingException("WASX7280E", "An application with name " + appname + " does not exist.", new Object[]{appname});
            }
            if (!local) {
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "This publishWSDLmediated by MBean.");
                }
                this.checkService();
                appManagementProxy.publishWSDL(appname, filename, optProps, this.getWorkspaceId());
            } else {
                this.warnIfConnected();
                AppManagement mgmt = null;
                ConfigRepositoryFactory.getConfigRepository().initialize(new Properties());
                mgmt = AppManagementFactory.createLocalAppManagementImpl();
                AdminConfigClient cfg = AdminConfigClient.getInstance();
                mgmt.publishWSDL(appname, filename, optProps, this.getWorkspaceId());
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "publishWSDL");
        }
        return new String();
    }

    public String getWorkspaceId() {
        String ret = null;
        AdminConfigClient cfg = AdminConfigClient.getInstance();
        if (cfg != null) {
            ret = cfg.getCurrentSession().toString();
        }
        return ret;
    }

    public void checkService() throws ScriptingException {
        if (appManagementProxy == null || !appManagementProxy.isRunning()) {
            this._shell.setAndThrowScriptingException("WASX7206W", "Application management service not available", new Object[0]);
        }
    }

    public void warnIfConnected() throws ScriptingException {
        if (appManagementProxy != null && appManagementProxy.isRunning()) {
            String node = null;
            String processName = null;
            if (connectedServer != null) {
                node = ObjectNameHelper.getNodeName(connectedServer);
                processName = ObjectNameHelper.getProcessName(connectedServer);
            }
            this._shell.setAndThrowScriptingException("WASX7220E", "Using -local option, but connected to server.", new Object[]{processName, node});
        }
    }

    public void throwIfMissingArg(String option, Object arg) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "throwIfMissingArg", new Object[]{option, arg});
        }
        if (this.nonBooleanDeplOptions.contains(option) && arg.toString().length() == 0) {
            this._shell.setAndThrowScriptingException("WASX7347E", "An argument is required for option " + option + ".", new Object[]{option});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "throwIfMissingArg");
        }
    }

    private boolean compareSecurityPolicy(AppDeploymentController flow, Hashtable optProps, boolean interactive) throws IOException, ScriptingException {
        String wasPolicy;
        boolean ret;
        Vector retVal;
        block24: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "compareSecurityPolicy");
            }
            retVal = null;
            ret = true;
            wasPolicy = null;
            try {
                wasPolicy = flow.getSecurityPolicyData();
                String policyWarning = flow.getSecurityPolicyWarning();
                if (policyWarning != null && !policyWarning.trim().equals("")) {
                    System.out.println(policyWarning);
                }
                if (wasPolicy == null || wasPolicy.trim().length() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "compareSecurityPolicy; null policy");
                    }
                    return ret;
                }
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "Checking filter.policy on server ..");
                }
                if (this.isLocalMode(optProps, false)) {
                    AppManagement m = AppManagementFactory.createLocalAppManagementImpl();
                    AdminConfigClient cfg = AdminConfigClient.getInstance();
                    retVal = cfg.getConfigService() == null ? m.compareSecurityPolicy(wasPolicy, new Hashtable(), null) : m.compareSecurityPolicy(wasPolicy, new Hashtable(), this.getWorkspaceId());
                } else {
                    retVal = appManagementProxy.compareSecurityPolicy(wasPolicy, new Hashtable(), this.getWorkspaceId());
                }
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "returned from running compareSecurityPolicy.");
                }
            }
            catch (Exception ae) {
                if (optProps.containsKey(ALLOWFILTERPERMOPTION)) {
                    System.out.println(_bundle.getString("WASX7392W"));
                }
                if (!interactive || optProps.containsKey("noallowPermInFilterPolicy")) {
                    this._shell.setLastException(ae);
                    String detail = ExceptionSupport.getMessage(ae, "WASX");
                    if (detail == null) {
                        detail = ae.toString();
                    }
                    throw new ScriptingException(detail);
                }
                StringBuffer buf = new StringBuffer();
                buf.append(_bundle.getString("WASX7391W"));
                buf.append("[");
                buf.append(appMessages.getMessage("AppDeploymentOption.No"));
                buf.append("]");
                String input = this.promptInput(true, "AppDeploymentOption.No", buf.toString(), "");
                if (input != null && !input.equals("AppDeploymentOption.No")) break block24;
                ret = false;
                return ret;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.event(tc, "retVal: " + retVal);
        }
        if (retVal != null) {
            boolean emitWarning = true;
            String temp = System.getProperty(SECURITY_WARNING_PROP);
            if (temp != null) {
                emitWarning = Boolean.getBoolean(temp.toLowerCase());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using value from property: " + emitWarning);
                }
            }
            for (int i = 0; i < retVal.size(); ++i) {
                if (emitWarning) {
                    System.out.println(retVal.elementAt(i));
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Warning off; ignoring " + retVal.elementAt(i).toString());
            }
        }
        if (wasPolicy != null) {
            if (interactive) {
                StringBuffer buf = new StringBuffer();
                buf.append(_bundle.getString("WASX7266I"));
                buf.append("[");
                buf.append(appMessages.getMessage("AppDeploymentOption.No"));
                buf.append("]");
                String input = this.promptInput(true, "AppDeploymentOption.No", buf.toString(), "");
                if (input != null && input.equals("AppDeploymentOption.Yes")) {
                    String msg = this._shell.getFormattedMessage("WASX7327I", new Object[]{wasPolicy}, "Contents of was.policy: \n " + wasPolicy);
                    AdminAppClient.dbg(msg);
                }
            } else {
                String msg = this._shell.getFormattedMessage("WASX7327I", new Object[]{wasPolicy}, "Contents of was.policy: \n " + wasPolicy);
                AdminAppClient.dbg(msg);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compareSecurityPolicy");
        }
        return ret;
    }

    private void addToCommandLine(AppDeploymentTask task) throws IOException, ScriptingException {
        AppDeploymentMessages appM;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToCommandLine");
        }
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        if ((appM = task.getTaskMessages()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not get a messages object!");
            }
            appM = appMessages;
        }
        String name = task.getName();
        String[][] taskData = task.getTaskData();
        if (name.equals(APPDEPLOYMENTOPTION) || name.equals(EJBDEPLOYOPTION)) {
            for (int i = 1; i < taskData.length; ++i) {
                for (int j = 0; j < taskData[0].length; ++j) {
                    String opt = taskData[0][j];
                    String val = taskData[i][j];
                    if (val.equals("AppDeploymentOption.No")) {
                        this.commandLine.append(" -");
                        this.commandLine.append("no");
                        this.commandLine.append(opt);
                        continue;
                    }
                    if (val.equals("AppDeploymentOption.Yes")) {
                        this.commandLine.append(" -");
                        this.commandLine.append(opt);
                        continue;
                    }
                    if (val.trim().equals("")) continue;
                    this.commandLine.append(" -");
                    this.commandLine.append(opt);
                    this.commandLine.append(" ");
                    this.commandLine.append(val);
                }
            }
        } else {
            int i;
            this.commandLine.append(" -");
            this.commandLine.append(name);
            this.commandLine.append(" ");
            this.commandLine.append(this._langutils.getOpenNestedAttribute());
            boolean[] ishidden = new boolean[taskData[0].length];
            int nonHiddenColumns = 0;
            for (i = 0; i < taskData[0].length; ++i) {
                if (!task.isHiddenColumn(i)) {
                    ++nonHiddenColumns;
                    ishidden[i] = false;
                    continue;
                }
                ishidden[i] = true;
            }
            for (i = 1; i < taskData.length; ++i) {
                this.commandLine.append(this._langutils.getOpenNestedAttribute());
                for (int j = 0; j < taskData[0].length; ++j) {
                    if (ishidden[j]) continue;
                    String data = taskData[i][j];
                    if (data != null && data.indexOf(" ") >= 0 && !this._langutils.isStringWithQuotes(data)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "adding quotes to \"" + data + "\"");
                        }
                        data = "\"" + data + "\"";
                    }
                    if (data != null && data.trim().equals("")) {
                        data = "\"" + data + "\"";
                    }
                    this.commandLine.append(data);
                    if (j >= taskData[0].length - 1) continue;
                    this.commandLine.append(" ");
                }
                this.commandLine.append(this._langutils.getCloseNestedAttribute());
                if (i >= taskData.length - 1) continue;
                this.commandLine.append(" ");
            }
            this.commandLine.append(this._langutils.getCloseNestedAttribute());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToCommandLine: " + this.commandLine.toString());
        }
    }

    private boolean alreadyInstalled(String appName, boolean local, Hashtable optProps) throws ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alreadyInstalled " + appName);
        }
        boolean ret = false;
        Hashtable ht = new Hashtable();
        if (optProps.containsKey("cell.name")) {
            ht.put("cell.name", optProps.get("cell.name"));
        } else if (optProps.containsKey(CELLOPTION)) {
            ht.put("cell.name", optProps.get(CELLOPTION));
        } else {
            ht.put("cell.name", this.cellName);
        }
        if (optProps.containsKey(NODEOPTION)) {
            ht.put("node.name", optProps.get(NODEOPTION));
        } else if (optProps.containsKey("node.name")) {
            ht.put("node.name", optProps.get("node.name"));
        }
        if (optProps.containsKey(SERVEROPTION)) {
            ht.put("server.name", optProps.get(SERVEROPTION));
        } else if (optProps.containsKey("server.name")) {
            ht.put("server.name", optProps.get("server.name"));
        }
        if (optProps.containsKey(CLUSTEROPTION)) {
            ht.put("cluster.name", optProps.get(CLUSTEROPTION));
        } else if (optProps.containsKey("cluster.name")) {
            ht.put("cluster.name", optProps.get("cluster.name"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "hashtable: " + ht);
        }
        String editionName = (String)optProps.get(APPEDITIONOPTION);
        String compositeName = EditionHelper.getCompositeName(appName, editionName);
        if (local) {
            AppManagement m = AppManagementFactory.createLocalAppManagementImpl();
            AdminConfigClient cfg = AdminConfigClient.getInstance();
            ret = cfg.getConfigService() == null ? m.checkIfAppExists(compositeName, ht, null) : m.checkIfAppExists(compositeName, ht, this.getWorkspaceId());
        } else {
            this.checkService();
            Boolean exists = appManagementProxy.checkIfAppExists(compositeName, ht, this.getWorkspaceId());
            ret = exists;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alreadyInstalled " + ret);
        }
        return ret;
    }

    private boolean isLocalMode(Hashtable optProps, boolean error) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isLocalMode - " + error);
        }
        if (optProps.containsKey("local") && error) {
            this._shell.setAndThrowScriptingException("WASX7358E", "Invalid option: {0}", new Object[]{"-local"});
        }
        boolean isLocal = this._shell.getConnectionType().equals("NONE");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isLocalMode - " + isLocal);
        }
        return isLocal;
    }

    public String view(String appName) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "view: ", new Object[]{appName});
        }
        this._shell.setLastException(null);
        String ret = this.view(appName, new String());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "view");
        }
        return ret;
    }

    public String view(String appName, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "view: ", new Object[]{appName, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String strOptions = this._langutils.objectArrayToString(options);
        String ret = this.view(appName, strOptions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "view");
        }
        return ret;
    }

    public String view(String appName, String taskNames) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "view: ", new Object[]{appName, taskNames});
        }
        String ret = new String();
        try {
            ret = this.commonEdit(appName, taskNames, false, false);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "view");
        }
        return ret;
    }

    public String searchJNDIReferences(Object[] nodes, String options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchJNDIReferences: ", new Object[]{nodes, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String strNodes = this._langutils.objectArrayToString(nodes);
        String ret = this.searchJNDIReferences(options, strNodes);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchJNDIReferences");
        }
        return ret;
    }

    public String searchJNDIReferences(String nodes, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchJNDIReferences: ", new Object[]{nodes, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String strOptions = this._langutils.objectArrayToString(options);
        String ret = this.searchJNDIReferences(nodes, strOptions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchJNDIReferences");
        }
        return ret;
    }

    public String searchJNDIReferences(Object[] nodes, Object[] options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchJNDIReferences: ", new Object[]{nodes, options});
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String strNodes = this._langutils.objectArrayToString(nodes);
        String strOptions = this._langutils.objectArrayToString(options);
        String ret = this.searchJNDIReferences(strNodes, strOptions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchJNDIReferences");
        }
        return ret;
    }

    public String searchJNDIReferences(String nodes, String options) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchJNDIReferences: ", new Object[]{nodes, options});
        }
        AppManagement mgmt = null;
        ArrayList jndiList = new ArrayList();
        Hashtable appList = new Hashtable();
        Hashtable<String, Locale> prefs = new Hashtable<String, Locale>();
        StringBuffer buf = new StringBuffer();
        String ret = new String();
        boolean flag = true;
        int end = 0;
        int index = 0;
        int cellIndex = 0;
        int nodeIndex = 0;
        try {
            this._shell.setLastException(null);
            if (this._langutils != this._shell.getLangUtils()) {
                this._langutils = this._shell.getLangUtils();
            }
            while (flag) {
                buf.append("WebSphere:");
                index = cellIndex;
                cellIndex = nodes.indexOf("cells/", index);
                if (cellIndex != -1) {
                    end = nodes.indexOf(47, cellIndex += 6);
                    if (end != -1) {
                        String cellName = nodes.substring(cellIndex, end);
                        buf.append("cell=");
                        buf.append(cellName);
                        nodeIndex = nodes.indexOf("nodes/", cellIndex);
                        if (nodeIndex != -1) {
                            end = nodes.indexOf(124, nodeIndex += 6);
                            if (end != -1) {
                                String nodeName = nodes.substring(nodeIndex, end);
                                buf.append(",");
                                buf.append("node=");
                                buf.append(nodeName);
                                cellIndex = nodes.indexOf("cells/", nodeIndex);
                                if (cellIndex == -1) {
                                    flag = false;
                                    continue;
                                }
                                buf.append("+");
                                continue;
                            }
                            this._shell.setAndThrowScriptingException("WASX7083E", "Cannot find config object", new Object[]{nodes});
                            continue;
                        }
                        this._shell.setAndThrowScriptingException("WASX7083E", "Cannot find config object", new Object[]{nodes});
                        continue;
                    }
                    this._shell.setAndThrowScriptingException("WASX7083E", "Cannot find config object", new Object[]{nodes});
                    continue;
                }
                this._shell.setAndThrowScriptingException("WASX7083E", "Cannot find config object", new Object[]{nodes});
            }
            Hashtable optProps = this._langutils.optionsToHashtable(options);
            Object jndi = optProps.get(JNDINAMEOPTION);
            jndiList.add(jndi);
            boolean local = this.isLocalMode(optProps, true);
            prefs.put("app.client.locale", Locale.getDefault());
            this._shell.issueMessage(new Object[0], "WASX7430W", "This operation may takes longer depending on how many application installed.");
            if (!local) {
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "This searchJNDIReferences mediated by MBean.");
                }
                this.checkService();
                appList = appManagementProxy.searchJNDIReferences(buf.toString(), jndiList, prefs, this.getWorkspaceId());
            } else {
                this.warnIfConnected();
                ConfigRepositoryFactory.getConfigRepository().initialize(new Properties());
                mgmt = AppManagementFactory.createLocalAppManagementImpl();
                AdminConfigClient cfg = AdminConfigClient.getInstance();
                appList = cfg.getConfigService() == null ? mgmt.searchJNDIReferences(jndiList, buf.toString(), prefs, null) : mgmt.searchJNDIReferences(jndiList, buf.toString(), prefs, this.getWorkspaceId());
            }
            boolean verbose = false;
            if (optProps.containsKey(VERBOSEOPTION)) {
                verbose = true;
            }
            ret = this._langutils.hashtableToString(appList, verbose);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchJNDIReferences");
        }
        return ret;
    }

    private void getAllAppDeplOptions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllAppDeplOptions");
        }
        this.deplOptions = AppDeploymentProfile.getProfile(0x111111L);
        this.hiddenOptions = AppDeploymentProfile.getHidden(0x111111L);
        this.deplEJBOptions = AppDeploymentProfile.getDeployEJBProfile();
        this.deplWSOptions = AppDeploymentProfile.getDeployWSProfile();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllAppDeplOptions");
        }
    }

    private void assignAppOptions(long mode, boolean includeDeprecated, boolean includeHidden) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "assignAppOptions - " + mode + " " + includeDeprecated + " " + includeHidden);
        }
        this.booleanDeplOptions = new ArrayList();
        this.nonBooleanDeplOptions = new ArrayList();
        this.otherListedDeplOptions = new ArrayList();
        this.buildOptionsForInputMode(mode, this.deplOptions, includeHidden);
        this.buildOptionsForInputMode(mode, clientOnlyOptions, includeHidden);
        this.buildOptionsForInputMode(mode, addonServerOptions, includeHidden);
        if (includeDeprecated) {
            this.buildOptionsForInputMode(mode, deprecatedOptions, includeHidden);
        }
        if (includeHidden) {
            this.buildOptionsForInputMode(mode, this.hiddenOptions, includeHidden);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "assignAppOptions");
        }
    }

    private void buildOptionsForInputMode(long mode, Vector inputOptions, boolean includeHidden) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildOptionsForInputMode - " + mode + " " + includeHidden);
        }
        boolean deployEJBEnabled = false;
        boolean deployWSEnabled = false;
        if (inputOptions != null) {
            Enumeration vEnum = inputOptions.elements();
            while (vEnum.hasMoreElements()) {
                AppDeploymentProfile.DeplOption deplOption = (AppDeploymentProfile.DeplOption)vEnum.nextElement();
                if (!includeHidden && deplOption.bHidden) continue;
                if ((mode & deplOption.applicability) != 0L) {
                    if (deplOption.type.getName().equals("java.lang.Boolean")) {
                        this.booleanDeplOptions.add(deplOption.name);
                        if (!filterNoOptions.contains(deplOption.name)) {
                            this.booleanDeplOptions.add("no" + deplOption.name);
                        }
                    } else {
                        this.nonBooleanDeplOptions.add(deplOption.name);
                    }
                    if (deplOption.name.equals("deployejb")) {
                        deployEJBEnabled = true;
                    }
                    if (!deplOption.name.equals("deployws")) continue;
                    deployWSEnabled = true;
                    continue;
                }
                if (this.otherListedDeplOptions.contains(deplOption.name)) continue;
                if (deplOption.type.getName().equals("java.lang.Boolean")) {
                    this.otherListedDeplOptions.add(deplOption.name);
                    if (filterNoOptions.contains(deplOption.name)) continue;
                    this.otherListedDeplOptions.add("no" + deplOption.name);
                    continue;
                }
                this.otherListedDeplOptions.add(deplOption.name);
            }
            if (deployEJBEnabled) {
                this.buildOptionsForInputMode(mode, this.deplEJBOptions, includeHidden);
            }
            if (deployWSEnabled) {
                this.buildOptionsForInputMode(mode, this.deplWSOptions, includeHidden);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "booleanDeplOptions: " + this.booleanDeplOptions);
            Tr.debug(tc, "nonBooleanDeplOptions: " + this.nonBooleanDeplOptions);
            Tr.debug(tc, "otherListedDeplOptions: " + this.otherListedDeplOptions);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildOptionsForInputMode");
        }
    }

    private boolean isOptionInOptionTable(String option, Vector optionTable, boolean isHiddenOption) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isOptionInOptionTable", new Object[]{option, new Boolean(isHiddenOption)});
        }
        boolean ret = false;
        if (optionTable != null) {
            Enumeration vEnum = optionTable.elements();
            while (vEnum.hasMoreElements()) {
                AppDeploymentProfile.DeplOption deplOption = (AppDeploymentProfile.DeplOption)vEnum.nextElement();
                if (deplOption.bHidden != isHiddenOption || !deplOption.name.equals(option) && !("no" + deplOption.name).equals(option)) continue;
                ret = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isOptionInOptionTable - " + ret);
        }
        return ret;
    }

    protected boolean is60Standalone() throws MalformedObjectNameException, ConnectorException {
        String version;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "is60Standalone");
        }
        boolean ret = false;
        if ("UnManagedProcess".equals(processType) && connectedServer != null && !(version = connectedServer.getKeyProperty("version")).startsWith("5.")) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "is60Standalone", new Object[]{new Boolean(ret)});
        }
        return ret;
    }

    public static String getLongLocalHost() {
        String host;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getLongLocalHost");
            }
            host = null;
            try {
                host = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException ex) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception in getting long local host name: " + ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLongLocalHost - " + host);
        }
        return host;
    }

    public static String getLocalHostAddress() {
        String host;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getLocalHostAddress");
            }
            host = null;
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException ex) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception in getting local host address: " + ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalHostAddress - " + host);
        }
        return host;
    }

    public static String getHostInetAddressByName(String hostName) {
        String host;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getHostInetAddressByName");
            }
            host = null;
            try {
                host = InetAddress.getByName(hostName).toString();
            }
            catch (UnknownHostException ex) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception in getting host inet address: " + ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHostInetAddressByName - " + host);
        }
        return host;
    }

    public String isAppReady(String appname) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAppReady", new Object[]{appname});
        }
        String ret = this.isAppReady(appname, "true");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAppReady");
        }
        return ret;
    }

    public String isAppReady(String appname, String ignoreUnknownState) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAppReady", new Object[]{appname, ignoreUnknownState});
        }
        String ret = "true";
        Hashtable<String, Locale> prefs = new Hashtable<String, Locale>();
        prefs.put("app.client.locale", Locale.getDefault());
        boolean local = this.isLocalMode(prefs, true);
        if (!local) {
            this.checkService();
        }
        String answer = null;
        try {
            if (!this.alreadyInstalled(appname, local, prefs)) {
                this._shell.setAndThrowScriptingException("WASX7280E", "An application with name " + appname + " does not exist.", new Object[]{appname});
            }
            if (local) {
                String method2 = "isAppReady";
                this._shell.setAndThrowScriptingException("METHOD_NOT_SUPPORTED", method2 + "method is not supported when connecting to local mode", new Object[]{method2});
            } else {
                answer = this.invokeMBeanDistrib(appname, prefs);
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "answer = " + answer);
        }
        if (answer == null || "".equals(answer.trim())) {
            ret = "false";
        } else {
            String[] s = answer.split("\\+");
            int i = 0;
            int count = 0;
            try {
                for (i = 0; i < s.length; ++i) {
                    ObjectName on = new ObjectName(s[i]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing: " + on);
                    }
                    if ("false".equals(on.getKeyProperty("distribution")) || "false".equals(ignoreUnknownState) && "unknown".equals(on.getKeyProperty("distribution"))) {
                        ret = "false";
                        break;
                    }
                    if (!"true".equals(on.getKeyProperty("distribution"))) continue;
                    ++count;
                }
                if (count == 0) {
                    ret = "false";
                }
            }
            catch (MalformedObjectNameException monef) {
                ret = "false";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bad ON format = " + s[i]);
                }
                this._shell.setLastException(monef);
                String detail = ExceptionSupport.getMessage(monef, "WASX");
                if (detail == null) {
                    detail = monef.toString();
                }
                throw new ScriptingException(detail);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAppReady: " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String invokeMBeanDistrib(String appName, Hashtable opts) throws AdminException, ConnectorException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeMBeanDistrib");
        }
        this.successFlag = false;
        String id = "Distribution:" + appName;
        AppNotificationFilter myFilter = new AppNotificationFilter(appName, "websphere.admin.appmgmt", null);
        appManagementProxy.addNotificationListener(this, myFilter, id);
        try {
            String string = "waitObject";
            synchronized ("waitObject") {
                block13: {
                    this.waitTarget = "AppDistributionNode";
                    appManagementProxy.isAppReady(appName, opts, this.getWorkspaceId());
                    try {
                        "waitObject".wait(this.MAX_WAIT_TIME);
                    }
                    catch (InterruptedException ie) {
                        if (!tc.isDebugEnabled()) break block13;
                        Tr.debug(tc, "Interrupted; time to work.");
                    }
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        finally {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing notif list. in finally");
            }
            appManagementProxy.removeNotificationListener(this);
        }
        {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "waitProps = " + this.waitProps);
            }
            if (!this.successFlag) {
                this._shell.setAndThrowScriptingException("WASX7439E", "Failure in getting application distribution status.", new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invokeMBeanDistrib");
            }
            return this.waitProps != null ? this.waitProps.getProperty("AppDistributionAll") : null;
        }
    }

    public String getDeployStatus() throws ScriptingException {
        this.helpInfo("getDeployStatus");
        return new String();
    }

    public String getDeployStatus(String appname) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeployStatus", appname);
        }
        Hashtable<String, Locale> prefs = new Hashtable<String, Locale>();
        prefs.put("app.client.locale", Locale.getDefault());
        boolean local = this.isLocalMode(prefs, true);
        if (!local) {
            this.checkService();
        }
        String answer = null;
        try {
            if (!this.alreadyInstalled(appname, local, prefs)) {
                this._shell.setAndThrowScriptingException("WASX7280E", "An application with name " + appname + " does not exist.", new Object[]{appname});
            }
            if (local) {
                String method2 = "getDeployStatus";
                this._shell.setAndThrowScriptingException("METHOD_NOT_SUPPORTED", method2 + " method is not supported when connecting to local mode", new Object[]{method2});
            } else {
                answer = this.invokeMBeanDistrib(appname, prefs);
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            String detail = ExceptionSupport.getMessage(ae, "WASX");
            if (detail == null) {
                detail = ae.toString();
            }
            throw new ScriptingException(detail);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "answer = " + answer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeployStatus", answer);
        }
        return answer;
    }

    private boolean validateFilePermissionString(String fp) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateFilePermission " + fp);
        }
        boolean ret = false;
        try {
            boolean temp = AppUtils.validateFilePermissionString(fp);
            if (temp) {
                ret = true;
            }
        }
        catch (Exception e) {
            System.out.println(this._shell.getFormattedMessage("WASX7458E", new Object[]{e}, "Invalid file permission string: " + e));
            ret = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFilePermission");
        }
        return ret;
    }
}

