/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.IOUtils;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.util.UtilsClient;
import com.ibm.ws.scripting.AdminControlClient;
import com.ibm.ws.scripting.ExceptionSupport;
import com.ibm.ws.scripting.JaclUtilities;
import com.ibm.ws.scripting.JythonUtilities;
import com.ibm.ws.scripting.LanguageUtilities;
import com.ibm.ws.scripting.ReconnectSupport;
import com.ibm.ws.scripting.ScriptingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AbstractShell {
    private static TraceComponent tc = Tr.register(AbstractShell.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static final String CONN_TYPE_PROP = "com.ibm.ws.scripting.connectionType";
    private static final String HOST_PROP = "com.ibm.ws.scripting.host";
    private static final String PORT_PROP = "com.ibm.ws.scripting.port";
    private static final String DEFAULT_LANG_PROP = "com.ibm.ws.scripting.defaultLang";
    private static final String CLASSPATH_PROP = "com.ibm.ws.scripting.classpath";
    private static final String IPCHOST_PROP = "com.ibm.ws.scripting.ipchost";
    private String APPTIMEOUT_PROP = "com.ibm.ws.scripting.apptimeout";
    protected static int returnCode = 0;
    protected static int maxSavedMessages = 5;
    protected static List savedMessages = new ArrayList(maxSavedMessages);
    protected ArrayList commands = new ArrayList(3);
    protected ArrayList propfiles = new ArrayList(3);
    protected ArrayList loadedPropfiles = new ArrayList();
    protected ArrayList scriptParms = new ArrayList();
    protected String lang = null;
    protected ArrayList profiles = new ArrayList(3);
    protected String targetScript = null;
    protected String connectionType = null;
    protected String argHost = null;
    protected String argPort = null;
    protected String argUser = null;
    protected String argPassword = null;
    protected String argClasspath = null;
    protected String saveClasspath = null;
    protected String argIPCHost = null;
    protected boolean inScript = false;
    protected boolean zos = false;
    protected String jobid = null;
    protected String logfile = null;
    protected String appendtrace = null;
    protected ResourceBundle bundle = null;
    protected String prompt = null;
    protected LanguageUtilities langUtils = null;
    protected Vector reconnectors = new Vector();
    Properties connProps = null;
    protected Vector scriptLibFiles = new Vector();
    Vector scriptLibList = new Vector();
    protected Exception _lastException = null;
    protected BSFManager mgr = null;

    public AbstractShell() {
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.zos = true;
        }
    }

    public static AbstractShell getShell() {
        return null;
    }

    protected abstract boolean parseAndValidateInput(String[] var1);

    protected abstract boolean declareBeans(Object var1);

    protected abstract void executeProfiles();

    protected abstract void showHelp();

    protected abstract String getTargetScript();

    protected abstract void initializePropFileSet();

    protected abstract int retcodeFromMessage(String var1);

    protected abstract void setTrace();

    protected abstract void welcome();

    public abstract Object executeCommand(String var1);

    protected abstract boolean timeToGo();

    protected abstract void leaving(boolean var1);

    public String getUser() {
        return this.argUser;
    }

    public void registerForReconnect(ReconnectSupport object) {
        this.reconnectors.add(object);
    }

    public void manageReconnect() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "manageReconnect");
        }
        Enumeration vEnum = this.reconnectors.elements();
        boolean except = false;
        Vector<String> failed = new Vector<String>();
        WsException exp = null;
        while (vEnum.hasMoreElements()) {
            ReconnectSupport reconnector = (ReconnectSupport)vEnum.nextElement();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "about to request reconnect for object with class: " + reconnector.getClass().getName());
            }
            try {
                reconnector.doReconnect();
            }
            catch (ConnectorException cnae) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "caught ConnectorException for reconnect; object: " + reconnector.getClass().getName());
                }
                except = true;
                exp = cnae;
                failed.add(reconnector.getClass().getName());
            }
            catch (AdminException ae) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "caught AdminException for reconnect; object: " + reconnector.getClass().getName());
                }
                except = true;
                exp = ae;
                failed.add(reconnector.getClass().getName());
            }
        }
        if (except) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < failed.size(); ++i) {
                buf.append((String)failed.get(i));
                if (i >= failed.size() - 1) continue;
                buf.append(", ");
            }
            returnCode = this.logAndIssueMessage(new Object[]{buf.toString()}, "RECONNECT_FAILED", "Attempt to reconnect to the server failed for the following objects: " + buf.toString() + "; server may no longer be running.", exp);
        } else {
            String type = this.connProps.getProperty("type");
            String host = this.connProps.getProperty("host");
            this.issueMessage(new Object[]{type, host}, "RECONNECT_COMPLETE", "Reconnect of " + type + " connector to host " + host + " completed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "manageReconnect");
        }
    }

    public LanguageUtilities getLangUtils() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLangUtils");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLangUtils");
        }
        return this.langUtils;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public String getLang() {
        return this.lang;
    }

    public int getAppTimeout() {
        int timeout = 86400;
        String timeoutValue = System.getProperty(this.APPTIMEOUT_PROP);
        if (timeoutValue != null) {
            timeout = Integer.parseInt(timeoutValue.trim());
        }
        return timeout * 1000;
    }

    protected void determineLanguage() {
        String temp;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "determineLanguage");
        }
        if (this.lang == null) {
            String script = this.getTargetScript();
            try {
                if (script != null) {
                    this.lang = BSFManager.getLangFromFilename(script);
                }
            }
            catch (BSFException bsfe) {
                returnCode = this.issueMessage(new Object[]{script}, "CANNOT_FIND_LANG", "Cannot determine scripting language for file: \"" + script + "\" -- please specify \"-lang\" option on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "determineLanguage -- lang not found");
                }
                return;
            }
        }
        if (this.lang == null && this.profiles.size() > 0) {
            for (int i = 0; i < this.profiles.size(); ++i) {
                String profileName = (String)this.profiles.get(i);
                try {
                    this.lang = BSFManager.getLangFromFilename(profileName);
                    continue;
                }
                catch (BSFException bsfe) {
                    returnCode = this.issueMessage(new Object[]{profileName}, "CANNOT_FIND_LANG", "Cannot determine scripting language for file: \"" + profileName + "\" -- please specify \"-lang\" option on the command line.");
                    return;
                }
            }
        }
        if (this.lang == null && (temp = System.getProperty(DEFAULT_LANG_PROP)) != null) {
            if (!temp.equalsIgnoreCase("jacl") && !temp.equalsIgnoreCase("jython")) {
                returnCode = this.issueMessage(new Object[]{temp}, "LANGUAGE_NOT_SUPPORTED", "Language \"" + temp + "\" is not supported.");
            } else if (BSFManager.isLanguageRegistered(temp)) {
                this.lang = temp;
            } else {
                returnCode = this.issueMessage(new Object[]{temp}, "LANGUAGE_NOT_REGISTERED", "Language \"" + temp + "\" is not registered to BSF.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "determineLanguage");
        }
    }

    protected LanguageUtilities getUtilitiesForLanguage() {
        if (this.lang == null) {
            return new LanguageUtilities(this.bundle);
        }
        if (this.lang.equalsIgnoreCase("jacl")) {
            return new JaclUtilities(this.bundle);
        }
        if (this.lang.equalsIgnoreCase("jython")) {
            return new JythonUtilities(this.bundle);
        }
        return new LanguageUtilities(this.bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPropertiesFiles() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadPropertiesFiles");
        }
        this.initializePropFileSet();
        if (this.propfiles.size() > 0) {
            for (int i = 0; i < this.propfiles.size(); ++i) {
                String this1 = (String)this.propfiles.get(i);
                try {
                    File propFile = new File(this1);
                    System.getProperties().load(new FileInputStream(propFile));
                    this.loadedPropfiles.add(this1);
                    continue;
                }
                catch (FileNotFoundException fnfe) {
                    returnCode = this.issueMessage(new Object[]{this1}, "FILE_NOT_FOUND", "Cannot find file " + this1);
                    continue;
                }
                catch (Exception e) {
                    returnCode = this.issueMessage(new Object[]{this1, e}, "EXCEPTION_LOADING_PROPERTIES_FILE", "Exception received while loading properties file " + this1 + "; exception information: " + e);
                    continue;
                }
                finally {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "loadPropertiesFiles");
                    }
                }
            }
        }
    }

    protected void logPropertiesFilesLoaded() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logPropertiesFilesLoaded");
        }
        if (this.loadedPropfiles.size() > 0) {
            for (int i = 0; i < this.loadedPropfiles.size(); ++i) {
                String this1 = (String)this.loadedPropfiles.get(i);
                Tr.audit(tc, "WASX7326I", new Object[]{this1});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logPropertiesFilesLoaded");
        }
    }

    protected void setupTempDir() {
        String tempDir;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTempDir");
        }
        if ((tempDir = System.getProperty("com.ibm.ws.scripting.tempdir")) != null && !tempDir.equals("")) {
            System.setProperty("java.io.tempdir", tempDir);
        } else {
            Tr.debug(tc, "Property com.ibm.ws.scripting was invalid: " + tempDir);
        }
        Tr.debug(tc, "Property java.io.tempdir is: " + System.getProperty("java.io.tempdir"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTempDir");
        }
    }

    protected void setJythonPath() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJythonPath");
        }
        String wasInstallRoot = System.getProperty("was.install.root");
        String systemClasspath = System.getProperty("ws.ext.dirs");
        String jythonPath = wasInstallRoot + File.separator + "optionalLibraries" + File.separator + "jython" + File.separator + "jython.jar";
        String jythonLibPath = wasInstallRoot + File.separator + "optionalLibraries" + File.separator + "jython" + File.separator + "Lib";
        if (systemClasspath != null && systemClasspath.contains(jythonPath)) {
            Tr.debug(tc, "jython path already loaded.");
        } else {
            systemClasspath = systemClasspath + System.getProperty("path.separator") + jythonPath + System.getProperty("path.separator") + jythonLibPath;
            System.setProperty("ws.ext.dirs", systemClasspath);
        }
        Tr.debug(tc, "system class path: " + System.getProperty("ws.ext.dirs"));
        ClassLoader ecl = Thread.currentThread().getContextClassLoader();
        if (ecl instanceof ExtClassLoader) {
            ExtClassLoader loader = (ExtClassLoader)ecl;
            loader.addPath(systemClasspath);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setJythonPath");
        }
    }

    protected void setClasspath() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClasspath");
        }
        if (this.argClasspath == null) {
            this.argClasspath = System.getProperty(CLASSPATH_PROP);
        }
        if (this.lang != null && this.lang.equalsIgnoreCase("jython")) {
            if (System.getProperty("python.cachedir") == null) {
                String userInstallRoot = System.getProperty("user.install.root");
                String cachedir = userInstallRoot + File.separator + "temp" + File.separator + "cachedir";
                System.setProperty("python.cachedir", cachedir);
            }
            this.saveClasspath = System.getProperty("java.class.path");
            String pluginPath = this.getPluginPath();
            System.setProperty("was.plugin.path", pluginPath);
            System.setProperty("python.packages.directories", "java.ext.dirs,ws.ext.dirs,was.plugin.path");
            String systemClasspath = System.getProperty("ws.ext.dirs");
            String completeClasspath = this.saveClasspath + System.getProperty("path.separator") + systemClasspath + System.getProperty("path.separator") + pluginPath;
            System.setProperty("java.class.path", completeClasspath);
            if (this.argClasspath != null) {
                this.saveClasspath = System.getProperty("java.class.path");
                String newClasspath = this.saveClasspath + System.getProperty("path.separator") + this.argClasspath;
                System.setProperty("java.class.path", newClasspath);
            }
        }
        if (this.argClasspath != null) {
            this.argClasspath = this.normalizeFQPathName(this.argClasspath);
            ClassLoader ecl = Thread.currentThread().getContextClassLoader();
            if (ecl instanceof ExtClassLoader) {
                ExtClassLoader loader = (ExtClassLoader)ecl;
                loader.addPath(this.argClasspath);
            } else {
                System.out.println("Context classloader is not ExtClassloader");
                System.out.println("Ignoring argument class_path: " + this.argClasspath);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClasspath");
        }
    }

    protected void setupConnectionType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupConnectionType");
        }
        if (this.connectionType == null) {
            this.connectionType = System.getProperty(CONN_TYPE_PROP);
        }
        if (this.connectionType == null) {
            this.connectionType = "SOAP";
        }
        if (this.connectionType.equalsIgnoreCase("NONE")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setupConnectionType - NONE");
            }
            System.out.println(this.getString("WASX7357I", "The scripting client is not connected to any server. Operations will be available in local mode"));
            Tr.audit(tc, "WASX7357I");
        }
        if (this.connectionType.equalsIgnoreCase("NULL")) {
            this.connProps = new Properties();
            this.connProps.setProperty("type", "NULL");
            this.connProps.setProperty("host", "localhost");
            this.connProps.setProperty("port", "0");
        } else if (this.connectionType.equalsIgnoreCase("SOAP")) {
            if (this.argHost == null) {
                this.argHost = System.getProperty(HOST_PROP);
            }
            if (this.argHost == null) {
                try {
                    this.argHost = AdminHelper.getInstance().getHostName();
                }
                catch (UnknownHostException uhe) {
                    // empty catch block
                }
            }
            if (this.argHost == null) {
                returnCode = this.issueMessage(new Object[]{"SOAP"}, "CONN_REQUIRES_HOST", "The \"SOAP\" connection type requires that a host be specified in a properties file or with \"-host\" on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupConnectionType");
                }
                return;
            }
            if (this.argPort == null) {
                this.argPort = System.getProperty(PORT_PROP);
            }
            if (this.argPort == null) {
                returnCode = this.issueMessage(new Object[]{"SOAP"}, "CONN_REQUIRES_PORT", "The \"SOAP\" connection type requires that a port be specified in a properties file or with \"-port\" on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupConnectionType");
                }
                return;
            }
            try {
                this.connProps = new Properties();
                int SOAPPort = Integer.parseInt(this.argPort);
                this.connProps.setProperty("type", "SOAP");
                this.connProps.setProperty("host", this.argHost);
                this.connProps.setProperty("port", Integer.toString(SOAPPort));
            }
            catch (NumberFormatException nfe) {
                returnCode = this.logAndIssueMessage(new Object[]{"SOAP", this.argPort}, "CONN_REQUIRES_INTEGER_PORT", "SOAP connection type requires an integer port; found: \"" + this.argPort + "\"", nfe);
            }
            if (this.argUser != null) {
                this.connProps.setProperty("username", this.argUser);
            }
            if (this.argPassword != null) {
                this.connProps.setProperty("password", this.argPassword);
            }
            if (this.argUser != null || this.argPassword != null) {
                this.connProps.setProperty("securityEnabled", "true");
            }
        } else if (this.connectionType.equalsIgnoreCase("RMI")) {
            if (this.argHost == null) {
                this.argHost = System.getProperty(HOST_PROP);
            }
            if (this.argHost == null) {
                try {
                    this.argHost = AdminHelper.getInstance().getHostName();
                }
                catch (UnknownHostException uhe) {
                    // empty catch block
                }
            }
            if (this.argHost == null) {
                returnCode = this.issueMessage(new Object[]{"RMI"}, "CONN_REQUIRES_HOST", "The \"RMI\" connection type requires that a host be specified in a properties file or with \"-host\" on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupConnectionType");
                }
                return;
            }
            if (this.argPort == null) {
                this.argPort = System.getProperty(PORT_PROP);
            }
            if (this.argPort == null) {
                returnCode = this.issueMessage(new Object[]{"RMI"}, "CONN_REQUIRES_PORT", "The \"RMI\" connection type requires that a port be specified in a properties file or with \"-port\" on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupConnectionType");
                }
                return;
            }
            int RMIPort = 0;
            try {
                RMIPort = Integer.parseInt(this.argPort);
            }
            catch (NumberFormatException nfe) {
                returnCode = this.logAndIssueMessage(new Object[]{"RMI", this.argPort}, "CONN_REQUIRES_INTEGER_PORT", "RMI connection type requires an integer port; found: \"" + this.argPort + "\"", nfe);
            }
            this.connProps = new Properties();
            this.connProps.setProperty("type", "RMI");
            this.connProps.setProperty("host", this.argHost);
            this.connProps.setProperty("port", Integer.toString(RMIPort));
            if (this.argUser != null || this.argPassword != null) {
                this.connProps.setProperty("securityEnabled", "true");
                this.connProps.setProperty("username", this.argUser);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "user: " + this.argUser);
                }
                if (this.argPassword == null) {
                    this.argPassword = "";
                }
                this.connProps.setProperty("password", this.argPassword);
            }
        } else if (this.connectionType.equalsIgnoreCase("IPC")) {
            if (this.argHost != null && this.argIPCHost == null) {
                this.argIPCHost = this.argHost;
            }
            if (this.argIPCHost == null) {
                this.argIPCHost = System.getProperty(IPCHOST_PROP);
            }
            if (this.argIPCHost == null) {
                try {
                    this.argIPCHost = AdminHelper.getInstance().getHostName();
                }
                catch (UnknownHostException uhe) {
                    // empty catch block
                }
            }
            if (this.argIPCHost == null) {
                returnCode = this.issueMessage(new Object[]{"IPC"}, "CONN_REQUIRES_HOST", "The \"IPC\" connection type requires that a host be specified in a properties file or with \"-ipchost\" on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupConnectionType");
                }
                return;
            }
            if (this.argPort == null) {
                this.argPort = System.getProperty(PORT_PROP);
            }
            if (this.argPort == null) {
                returnCode = this.issueMessage(new Object[]{"IPC"}, "CONN_REQUIRES_PORT", "The \"IPC\" connection type requires that a port be specified in a properties file or with \"-port\" on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupConnectionType");
                }
                return;
            }
            try {
                this.connProps = new Properties();
                int IPCPort = Integer.parseInt(this.argPort);
                this.connProps.setProperty("type", "IPC");
                this.connProps.setProperty("host", this.argIPCHost);
                this.connProps.setProperty("port", Integer.toString(IPCPort));
            }
            catch (NumberFormatException nfe) {
                returnCode = this.logAndIssueMessage(new Object[]{"IPC", this.argPort}, "CONN_REQUIRES_INTEGER_PORT", "IPC connection type requires an integer port; found: \"" + this.argPort + "\"", nfe);
            }
            if (this.argUser != null) {
                this.connProps.setProperty("username", this.argUser);
            }
            if (this.argPassword != null) {
                this.connProps.setProperty("password", this.argPassword);
            }
            if (this.argUser != null || this.argPassword != null) {
                this.connProps.setProperty("securityEnabled", "true");
            }
        } else if (this.connectionType.equalsIgnoreCase("JSR160RMI")) {
            if (this.argHost == null) {
                this.argHost = System.getProperty(HOST_PROP);
            }
            if (this.argHost == null) {
                try {
                    this.argHost = AdminHelper.getInstance().getHostName();
                }
                catch (UnknownHostException uhe) {
                    // empty catch block
                }
            }
            if (this.argHost == null) {
                returnCode = this.issueMessage(new Object[]{"JSR160RMI"}, "CONN_REQUIRES_HOST", "The \"JSR160RMI\" connection type requires that a host be specified in a properties file or with \"-host\" on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupConnectionType");
                }
                return;
            }
            if (this.argPort == null) {
                this.argPort = System.getProperty(PORT_PROP);
            }
            if (this.argPort == null) {
                returnCode = this.issueMessage(new Object[]{"JSR160RMI"}, "CONN_REQUIRES_PORT", "The \"JSR160RMI\" connection type requires that a port be specified in a properties file or with \"-port\" on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupConnectionType");
                }
                return;
            }
            try {
                this.connProps = new Properties();
                int JSR160RMIPort = Integer.parseInt(this.argPort);
                this.connProps.setProperty("type", "JSR160RMI");
                this.connProps.setProperty("host", this.argHost);
                this.connProps.setProperty("port", Integer.toString(JSR160RMIPort));
            }
            catch (NumberFormatException nfe) {
                returnCode = this.logAndIssueMessage(new Object[]{"JSR160RMI", this.argPort}, "CONN_REQUIRES_INTEGER_PORT", "JSR160RMI connection type requires an integer port; found: \"" + this.argPort + "\"", nfe);
            }
            if (this.argUser != null) {
                this.connProps.setProperty("username", this.argUser);
            }
            if (this.argPassword != null) {
                this.connProps.setProperty("password", this.argPassword);
            }
            if (this.argUser != null || this.argPassword != null) {
                this.connProps.setProperty("securityEnabled", "true");
            }
        } else if (this.connectionType.equalsIgnoreCase("JMS")) {
            // empty if block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupConnectionType");
        }
    }

    protected void executeCommands() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeCommands");
        }
        if (this.commands.size() == 0) {
            return;
        }
        if (this.lang == null) {
            returnCode = this.issueMessage(new Object[0], "CANNOT_FIND_LANG_FOR_COMMANDS", "Cannot determine scripting language for command invocation -- please specify \"-lang\" option on the command line.");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeCommands -- lang not found");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "using language: " + this.lang);
        }
        if (this.scriptParms.size() > 0) {
            this.scriptParms = this.checkScriptParamPassword(this.scriptParms);
            String msg = this.getFormattedMessage("WASX7411W", new Object[]{this.scriptParms}, "Ignoring the following provided option: ." + this.scriptParms);
            System.out.println(msg);
            Tr.audit(tc, "WASX7411W", new Object[]{this.scriptParms});
        }
        boolean badFlag = false;
        if (this.commands.size() > 0) {
            for (int i = 0; i < this.commands.size(); ++i) {
                String command = (String)this.commands.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing command: " + command);
                }
                try {
                    if (command.toLowerCase().indexOf("password") >= 0 || command.toLowerCase().indexOf("pwd") >= 0 || command.toLowerCase().indexOf("passwd") >= 0) {
                        Tr.audit(tc, "WASX7092I");
                    } else {
                        Tr.audit(tc, "WASX7090I", new Object[]{command});
                    }
                    if (command.startsWith("source")) {
                        if (this.lang != null && !this.lang.equalsIgnoreCase("jacl")) {
                            this.lang = "jacl";
                            this.inScript = true;
                        }
                    } else if (command.startsWith("execfile") && this.lang != null && !this.lang.equalsIgnoreCase("jython")) {
                        this.lang = "jython";
                    }
                    if (command.startsWith("source ") || command.startsWith("execfile")) {
                        this.inScript = true;
                        command = this.convertWindowsPath(command);
                    }
                    if (command.trim().equals("AdminLibHelp()") || command.trim().equals("print AdminLibHelp()")) {
                        command = "print AdminLibHelp.help()";
                    } else {
                        String libraryName = null;
                        if (command.trim().startsWith("AdminLibHelp.")) {
                            libraryName = command.substring(13, command.length());
                        }
                        if (command.trim().startsWith("print AdminLibHelp.")) {
                            libraryName = command.substring(19, command.length());
                        }
                        if (libraryName != null) {
                            if (libraryName.endsWith("()")) {
                                libraryName = libraryName.substring(0, libraryName.length() - 2);
                            }
                            if (this.scriptLibList.contains(libraryName)) {
                                command = "print AdminLibHelp.help(\"" + libraryName + "\")";
                            }
                        }
                    }
                    this._lastException = null;
                    if (this.lang.equalsIgnoreCase("jython")) {
                        this.SystemExitCheck(command);
                        this.mgr.iexec(this.lang, command, 0, 0, command);
                    } else {
                        Object o = this.mgr.eval(this.lang, command, 0, 0, command);
                        if (o != null) {
                            System.out.println(o.toString());
                        }
                    }
                    this.inScript = false;
                    continue;
                }
                catch (BSFException bsfe) {
                    badFlag = true;
                    this.checkException(command, bsfe);
                }
            }
        }
        if (badFlag) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not do auto save because something wrong");
            }
            this.leaving(false);
        } else {
            this.leaving(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeCommands");
        }
    }

    protected void executeScript(String target) {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "executeScript");
            }
            InputStreamReader in = null;
            String scriptLang = null;
            try {
                scriptLang = BSFManager.getLangFromFilename(target);
            }
            catch (BSFException bsfe) {
                if (this.lang == null) {
                    String msg = this.getStringFromException(bsfe);
                    this.logException(bsfe, msg);
                    returnCode = this.issueMessage(new Object[]{target}, "CANNOT_FIND_LANG", "Cannot determine scripting language for file: \"" + target + "\" -- please specify \"-lang\" option on the command line.");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "executeScript -- lang not found");
                    }
                    return;
                }
                scriptLang = this.lang;
            }
            if (this.lang == null) {
                this.lang = scriptLang;
            } else if (!this.lang.equalsIgnoreCase(scriptLang)) {
                this.lang = scriptLang;
                this.langUtils = this.getUtilitiesForLanguage();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using language: " + this.lang);
            }
            try {
                String scriptEncoding;
                String echo = System.getProperty("com.ibm.ws.scripting.echoparams");
                if (echo == null || echo.trim().equalsIgnoreCase("true")) {
                    if (this.scriptParms.size() > 0) {
                        this.scriptParms = this.checkScriptParamPassword(this.scriptParms);
                        String msg = this.getFormattedMessage("WASX7303I", new Object[]{this.scriptParms}, "The following options are passed to the scripting environment and are available as argv: ." + this.scriptParms);
                        System.out.println(msg);
                        Tr.audit(tc, "WASX7303I", new Object[]{this.scriptParms});
                    }
                } else {
                    Tr.debug(tc, "Not output parameters");
                }
                in = this.zos ? ((scriptEncoding = System.getProperty("script.encoding")) != null ? new InputStreamReader((InputStream)new FileInputStream(target), scriptEncoding) : new FileReader(target)) : new FileReader(target);
                this._lastException = null;
                Tr.audit(tc, "WASX7091I", new Object[]{target});
                String scriptString = this.getSanitizedScriptString(in);
                this.mgr.exec(this.lang, target, 0, 0, scriptString);
                this.leaving(false);
            }
            catch (FileNotFoundException fnfe) {
                returnCode = this.logAndIssueMessage(new Object[]{target}, "FILE_NOT_FOUND", "Cannot find file \"" + target + "\"", fnfe);
            }
            catch (IOException ioe) {
                returnCode = this.logAndIssueMessage(new Object[]{target, ioe}, "ERROR_READING_FILE", "Cannot read file \"" + target + "\"", ioe);
            }
            catch (BSFException bsfe) {
                String msg = this.getStringFromException(bsfe);
                returnCode = this.issueMessage(new Object[]{target, msg}, "ERROR_RUNNING_FILE", "Problem running file \"" + target + "\"");
                int trial = this.retcodeFromMessage(msg);
                if (trial <= 0) break block17;
                returnCode = trial;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeScript");
        }
    }

    protected String getSanitizedScriptString(Reader in) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSanitizedScriptString");
        }
        String scriptString = IOUtils.getStringFromReader(in);
        String osName = System.getProperty("os.name");
        if (this.lang.equalsIgnoreCase("jacl") && osName != null && osName.startsWith("Windows")) {
            int crlfIndex;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "fixing up Windows CRLF");
            }
            while ((crlfIndex = scriptString.indexOf("\r\n")) != -1) {
                StringBuffer strBuf = new StringBuffer(scriptString);
                strBuf.replace(crlfIndex, crlfIndex + 2, "\n");
                scriptString = strBuf.toString();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSanitizedScriptString");
        }
        return scriptString;
    }

    protected AdminControlClient createControlClient() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createControlClient");
        }
        AdminControlClient wrapper = null;
        wrapper = new AdminControlClient(this, this.connProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createControlClient");
        }
        return wrapper;
    }

    protected void interactive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "interactive");
        }
        InputStreamReader in = null;
        if (this.zos) {
            String inputEncoding = System.getProperty("ws.input.encoding");
            if (inputEncoding != null) {
                try {
                    in = new InputStreamReader(System.in, inputEncoding);
                }
                catch (IOException ioe) {
                    this.issueMessage(new Object[]{ioe}, "ERROR_RUNNING_COMMAND", "Unsupported System.in encoding \"" + inputEncoding + "\"");
                }
            } else {
                in = new InputStreamReader(System.in);
            }
        } else {
            in = new InputStreamReader(System.in);
        }
        BufferedReader br = new BufferedReader(in);
        String command = null;
        if (this.lang == null) {
            returnCode = this.issueMessage(new Object[0], "CANNOT_FIND_LANG_INTERACTIVE", "Cannot determine scripting language to use in interactive mode -- please specify \"-lang\" option on the command line.");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "interactive -- no language");
            }
            return;
        }
        String savedCommand = null;
        while (true) {
            if (savedCommand == null) {
                command = this.getCommand(br, System.out);
            } else {
                command = savedCommand;
                savedCommand = null;
            }
            if (command == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "interactive -- null");
                }
                return;
            }
            if (!command.equals("quit")) {
                try {
                    if (command.length() > 0 || command.length() == 0 && this.lang.equalsIgnoreCase("jython")) {
                        this._lastException = null;
                        if (command.toLowerCase().indexOf("password") >= 0 || command.toLowerCase().indexOf("pwd") >= 0 || command.toLowerCase().indexOf("passwd") >= 0) {
                            Tr.audit(tc, "WASX7092I");
                        } else {
                            Tr.audit(tc, "WASX7090I", new Object[]{command});
                        }
                        if (command.startsWith("source ")) {
                            if (!this.lang.equalsIgnoreCase("jacl")) {
                                this.lang = "jacl";
                            }
                        } else if (command.startsWith("execfile") && !this.lang.equalsIgnoreCase("jython")) {
                            this.lang = "jython";
                        }
                        if (command.startsWith("source ") || command.startsWith("execfile")) {
                            this.inScript = true;
                            command = this.convertWindowsPath(command);
                        }
                        if (command.trim().equals("AdminLibHelp()") || command.trim().equals("print AdminLibHelp()")) {
                            command = "print AdminLibHelp.help()";
                        } else {
                            String libraryName = null;
                            if (command.trim().startsWith("AdminLibHelp.")) {
                                libraryName = command.substring(13, command.length());
                            }
                            if (command.trim().startsWith("print AdminLibHelp.")) {
                                libraryName = command.substring(19, command.length());
                            }
                            if (libraryName != null) {
                                if (libraryName.endsWith("()")) {
                                    libraryName = libraryName.substring(0, libraryName.length() - 2);
                                }
                                if (this.scriptLibList.contains(libraryName)) {
                                    command = "print AdminLibHelp.help(\"" + libraryName + "\")";
                                }
                            }
                        }
                        if (this.lang.equalsIgnoreCase("jython")) {
                            this.mgr.iexec(this.lang, command, 0, 0, command);
                        } else {
                            Object o = this.mgr.eval(this.lang, command, 0, 0, command);
                            if (o != null) {
                                System.out.println(o.toString());
                            }
                        }
                        this.inScript = false;
                    }
                    command = this.checkPassword(command);
                    Tr.debug(tc, "Command -- " + command);
                }
                catch (BSFException bsfe) {
                    this.checkException(command, bsfe);
                }
                catch (Exception e) {
                    returnCode = this.issueMessage(new Object[]{command, e}, "EXCEPTION_RUNNING_COMMAND", "Exception running command: " + command + "; exception information: " + e);
                }
                command = null;
                continue;
            }
            if (this.timeToGo()) break;
            String msg = this.getFormattedMessage("WASX7118I", new Object[0], "Unsaved changes exist: enter \"quit\" or \"exit\" to quit without save.");
            System.out.println(msg);
            command = this.getCommand(br, System.out);
            if (command.equals("quit")) break;
            savedCommand = new String(command);
        }
        this.leaving(false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "interactive");
        }
    }

    protected String convertWindowsPath(String command) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertWindowsPath " + command);
        }
        String osName = System.getProperty("os.name");
        String newcommand = null;
        StringBuffer buf = new StringBuffer();
        String path = null;
        String tokens = null;
        tokens = this.lang.equalsIgnoreCase("jython") ? "()" : " ";
        try {
            if (osName != null && osName.startsWith("Windows")) {
                if (command != null) {
                    String lasttoken = null;
                    StringTokenizer tok = new StringTokenizer(command, tokens, true);
                    if (tok.countTokens() > 2) {
                        buf.append(tok.nextToken());
                        buf.append(tok.nextToken());
                        StringBuffer pathbaf = new StringBuffer();
                        while (tok.hasMoreTokens()) {
                            String temptok = tok.nextToken();
                            if (!tok.hasMoreTokens() && tokens.indexOf(temptok) != -1) {
                                lasttoken = temptok;
                                continue;
                            }
                            pathbaf.append(temptok);
                        }
                        path = pathbaf.toString().trim();
                    }
                    if (path.length() > 2 && path.startsWith("\"") && path.endsWith("\"") || path.startsWith("'") && path.endsWith("'")) {
                        String tempPath = path.substring(1, path.length() - 1).trim();
                        path = path.startsWith("\"") ? "\"" + tempPath + "\"" : "'" + tempPath + "'";
                    }
                    if (File.separatorChar != '/') {
                        path = path.replace(File.separatorChar, '/');
                    }
                    buf.append(path);
                    if (lasttoken != null) {
                        buf.append(lasttoken);
                    }
                    newcommand = buf.toString();
                    Tr.debug(tc, "newcommand: " + newcommand);
                }
            } else {
                newcommand = command;
            }
        }
        catch (Exception ex) {
            Tr.debug(tc, "convertWidownsPath failed with the exception " + ex);
            newcommand = command;
        }
        Tr.exit(tc, "convertWindowsPath");
        return newcommand;
    }

    protected String getCommand(BufferedReader in, PrintStream out) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommand");
        }
        String command = null;
        StringBuffer commandBuf = new StringBuffer();
        String newline = System.getProperty("line.separator");
        if (out != null) {
            out.print(this.prompt);
        }
        try {
            command = in.readLine();
            if (command != null) {
                commandBuf.append(command + newline);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (command == null) {
            commandBuf.setLength(0);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommand -- null");
            }
            return null;
        }
        if (this.lang.equalsIgnoreCase("jython")) {
            this.SystemExitCheck(command);
        }
        if (command.equals("exit") || command.equals("quit")) {
            commandBuf.setLength(0);
            if (tc.isEntryEnabled()) {
                if (command.toLowerCase().indexOf("password") == -1 && command.toLowerCase().indexOf("pwd") == -1 && command.toLowerCase().indexOf("passwd") == -1) {
                    Tr.exit(tc, "getCommand -- " + command);
                } else {
                    String tmpCommand = this.checkPassword(command);
                    Tr.exit(tc, "getCommand -- " + tmpCommand);
                }
            }
            return "quit";
        }
        command = commandBuf.toString();
        if (this.lang.equalsIgnoreCase("jython")) {
            while (command.endsWith(" ") || command.endsWith("\n") || command.endsWith("\r")) {
                command = command.substring(0, command.length() - 1);
            }
        } else {
            command = command.trim();
        }
        if (tc.isEntryEnabled()) {
            if (command.toLowerCase().indexOf("password") == -1 && command.toLowerCase().indexOf("pwd") == -1 && command.toLowerCase().indexOf("passwd") == -1) {
                Tr.exit(tc, "getCommand -- " + command);
            } else {
                String tmpCommand = this.checkPassword(command);
                Tr.exit(tc, "getCommand -- " + tmpCommand);
            }
        }
        return command;
    }

    public String getFormattedMessage(String key, Object[] args, String defaultString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFormattedMessage");
        }
        if (key == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage - default");
            }
            return defaultString;
        }
        try {
            String result = this.bundle.getString(key);
            result = this.escapeSingleQuotes(result);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage");
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage - default");
            }
            return MessageFormat.format(defaultString, args);
        }
        catch (NullPointerException npe) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage - default");
            }
            return defaultString;
        }
    }

    protected String escapeSingleQuotes(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "escapeSingleQuotes");
        }
        if (string == null || string.indexOf(39) < 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "escapeSingleQuotes");
            }
            return string;
        }
        int n = string.length();
        StringBuffer sb = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char ch = string.charAt(i);
            if (ch == '\'') {
                sb.append('\'');
            }
            sb.append(ch);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "escapeSingleQuotes");
        }
        return sb.toString();
    }

    public String getString(String key, String defaultString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getString");
        }
        try {
            String result = this.bundle.getString(key);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getString");
            }
            return result;
        }
        catch (MissingResourceException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getString - default");
            }
            return defaultString;
        }
        catch (NullPointerException npe) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getString - default");
            }
            return defaultString;
        }
    }

    protected int issueMessage(Object[] args, String key, String inputmsg) {
        String msg = this.getFormattedMessage(key, args, inputmsg);
        System.out.println(msg);
        Tr.audit(tc, "WASX7093I", new Object[]{msg});
        this.addToSavedMessage(msg);
        return this.retcodeFromMessage(msg);
    }

    protected int logAndIssueMessage(Object[] args, String key, String inputmsg, Exception exp) {
        int retcode = this.issueMessage(args, key, inputmsg);
        this.logException(exp);
        return retcode;
    }

    protected int processConnType(String[] argv, int i) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processConnType");
        }
        if (argv[i].regionMatches(true, 0, "SOAP", 0, argv[i].length())) {
            Tr.event(tc, "Processing SOAP connection type.");
            this.connectionType = "SOAP";
        } else if (argv[i].regionMatches(true, 0, "RMI", 0, argv[i].length())) {
            Tr.event(tc, "Processing RMI connection type.");
            this.connectionType = "RMI";
        } else if (argv[i].regionMatches(true, 0, "IPC", 0, argv[i].length())) {
            Tr.event(tc, "Processing IPC connection type.");
            this.connectionType = "IPC";
        } else if (argv[i].regionMatches(true, 0, "JSR160RMI", 0, argv[i].length())) {
            Tr.event(tc, "Processing JSR160RMI connection type.");
            this.connectionType = "JSR160RMI";
        } else if (argv[i].regionMatches(true, 0, "NONE", 0, argv[i].length())) {
            Tr.event(tc, "Processing no connection type.");
            this.connectionType = "NONE";
        } else if (argv[i].regionMatches(true, 0, "NULL", 0, argv[i].length())) {
            Tr.event(tc, "Processing null connection type.");
            this.connectionType = "NULL";
        } else {
            returnCode = this.issueMessage(new Object[]{argv[i]}, "INVALID_CONNECTION_TYPE", "Invalid connection type " + argv[i]);
            i = -1;
        }
        return i;
    }

    public void setLastException(Exception e) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLastException");
        }
        if (this.inScript) {
            String msg;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "in script mode; not saving exception");
            }
            if (e == null) {
                return;
            }
            String text = ExceptionSupport.getMessage(e, "WASX");
            if (text == null) {
                text = e.toString();
            }
            if ((msg = ExceptionSupport.getDiagnosticInfo(e)) == null) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                msg = sw.toString();
            }
            this._lastException = e;
            Tr.error(tc, "WASX7120E", new Object[]{text, msg});
        } else {
            this._lastException = e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLastException");
        }
    }

    public void setAndThrowScriptingException(String key, String defaultMsg, Object[] args) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAndThrowScriptingException", new Object[]{key, defaultMsg});
        }
        String msg = this.getFormattedMessage(key, args, defaultMsg);
        ScriptingException se = new ScriptingException(msg);
        this.setLastException(se);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAndThrowScriptingException");
        }
        throw se;
    }

    protected String getStringFromException(BSFException bsfe) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStringFromException");
        }
        String msg = null;
        msg = ExceptionSupport.getMessage(this._lastException, "WASX");
        try {
            if (msg == null && bsfe != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "using message from BSFException");
                }
                msg = bsfe.toString();
                Throwable t = bsfe.getTargetException();
                if (t != null) {
                    if (msg != null && t.getMessage() != null) {
                        if (msg.indexOf(t.getMessage()) >= 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "target exception redundant");
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "using message from BSFException.getTargetException()");
                            }
                            msg = msg + "; " + t.getMessage();
                        }
                    } else if (t.toString().equals("tcl.lang.TclException") && t.getMessage() == null) {
                        msg = bsfe.toString().substring(0, bsfe.toString().indexOf("expression:") + 11);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStringFromException");
        }
        return msg;
    }

    protected void logException(BSFException bsfe, String text) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logException");
        }
        String msg = null;
        msg = ExceptionSupport.getDiagnosticInfo(this._lastException);
        if (msg == null && bsfe != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using message from BSFException");
            }
            StringWriter sw = new StringWriter();
            bsfe.printStackTrace(new PrintWriter(sw));
            msg = sw.toString();
        }
        Tr.error(tc, "WASX7120E", new Object[]{text, msg});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logException");
        }
    }

    public void logException(Exception e) {
        String msg;
        String text;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logException");
        }
        if ((text = ExceptionSupport.getMessage(e, "WASX")) == null) {
            text = e.toString();
        }
        if ((msg = ExceptionSupport.getDiagnosticInfo(this._lastException)) == null) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            msg = sw.toString();
        }
        Tr.error(tc, "WASX7120E", new Object[]{text, msg});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logException");
        }
    }

    protected void setupCmdLineArgs() {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setupCmdLineArgs");
            }
            if (this.lang == null) {
                returnCode = this.issueMessage(new Object[0], "CANNOT_FIND_LANG_FOR_COMMANDS", "Cannot determine scripting language for command invocation -- please specify \"-lang\" option on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupCmdLineArgs -- lang not found");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using language: " + this.lang);
            }
            ArrayList tempScriptParms = this.checkScriptParamPassword(this.scriptParms);
            String[] tempCommands = this.langUtils.createArgSettingCommands(tempScriptParms);
            String[] commands = this.langUtils.createArgSettingCommands(this.scriptParms);
            int attempted = 0;
            try {
                for (int i = 0; i < commands.length; ++i) {
                    this._lastException = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "processing command: " + tempCommands[i]);
                    }
                    attempted = i;
                    this.mgr.exec(this.lang, commands[i], 0, 0, commands[i]);
                }
            }
            catch (BSFException bsfe) {
                String msg = this.getStringFromException(bsfe);
                this.logException(bsfe, msg);
                returnCode = this.issueMessage(new Object[]{commands[attempted], msg}, "ERROR_RUNNING_COMMAND", "Problem running command \"" + commands[attempted] + "\" -- exception information: " + bsfe);
                int trial = this.retcodeFromMessage(msg);
                if (trial <= 0) break block9;
                returnCode = trial;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupCmdLineArgs");
        }
    }

    public String normalizeFQPathName(String path) {
        char pathSep;
        char otherPathSep;
        char othersep;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "normalizeFQPathName - " + path);
        }
        String ret = path;
        char sep = File.separatorChar;
        char c = othersep = sep == '/' ? (char)'\\' : '/';
        if (path.indexOf(othersep) >= 0) {
            ret = path.replace(othersep, sep);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "path after converting separator: " + ret);
        }
        char c2 = otherPathSep = (pathSep = File.pathSeparatorChar) == ';' ? (char)':' : ';';
        if (ret.indexOf(otherPathSep) >= 0) {
            String ret3;
            if (pathSep == ';') {
                StringBuffer ret2 = new StringBuffer();
                int searchIndex = 0;
                while (searchIndex != -1) {
                    int index = ret.indexOf(otherPathSep, searchIndex);
                    if (index > -1) {
                        if (index + 2 < path.length() && ret.substring(index, index + 2).equals(":\\")) {
                            if (index - 2 < 0 || ret.substring(index - 2, index - 1).equals(":") || ret.substring(index - 2, index - 1).equals(";")) {
                                ret2.append(ret.substring(searchIndex, index + 2));
                                searchIndex = index + 2;
                            } else {
                                ret2.append(ret.substring(searchIndex, index));
                                ret2.append(pathSep);
                                searchIndex = index + 1;
                            }
                        } else {
                            ret2.append(ret.substring(searchIndex, index));
                            ret2.append(pathSep);
                            searchIndex = index + 1;
                        }
                        if (searchIndex < ret.length()) continue;
                        searchIndex = -1;
                        continue;
                    }
                    ret2.append(ret.substring(searchIndex, ret.length()));
                    searchIndex = -1;
                }
                ret3 = ret2.toString();
            } else {
                ret3 = ret.replace(otherPathSep, pathSep);
            }
            ret = ret3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "normalizeFQPathName - " + ret);
        }
        return ret;
    }

    public void run(String[] argv) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run", argv);
        }
        returnCode = 0;
        savedMessages.clear();
        ExceptionSupport.setBundle(this.bundle);
        if (this.parseAndValidateInput(argv)) {
            AdminControlClient controlClient;
            this.loadPropertiesFiles();
            this.setTrace();
            this.setJythonPath();
            if (this.jobid != null) {
                Tr.audit(tc, "JobID=" + this.jobid);
            }
            if (returnCode == 0) {
                this.determineLanguage();
            }
            if (returnCode == 0) {
                this.setClasspath();
            }
            if (returnCode == 0) {
                this.setupConnectionType();
            }
            if (returnCode == 0 && this.zos) {
                this.setupTempDir();
            }
            if (returnCode != 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run -> " + returnCode);
                }
                return;
            }
            this.langUtils = this.getUtilitiesForLanguage();
            this.logPropertiesFilesLoaded();
            this.mgr = new BSFManager();
            this.mgr.setClassLoader(ExtClassLoader.getInstance());
            if (this.lang.equalsIgnoreCase("jython")) {
                String jythondebug = System.getProperty("jython.debug");
                try {
                    if (jythondebug != null) {
                        Tr.debug(tc, "jython debug is enabled");
                        this.mgr.exec("jython", "", -1, -1, "from org.python.core import imp");
                        this.mgr.exec("jython", "", -1, -1, "main = imp.addModule('__main__')");
                        this.mgr.exec("jython", "", -1, -1, "main.__dict__ = globals()");
                        this.mgr.exec("jython", "", -1, -1, "__name__ = '__main__'");
                    } else {
                        this.mgr.exec("jython", "", -1, -1, "from org.python.core import imp");
                        this.mgr.exec("jython", "", -1, -1, "main = imp.addModule('__main__')");
                        this.mgr.exec("jython", "", -1, -1, "__name__ = '__main__'");
                    }
                }
                catch (Exception e) {
                    Tr.debug(tc, "fail to load _main_ module");
                }
            }
            if (!this.declareBeans(controlClient = this.createControlClient())) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run -> " + returnCode);
                }
                return;
            }
            try {
                this.checkVersionCompatibility(controlClient);
            }
            catch (ScriptingException se) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run -> " + returnCode);
                }
                return;
            }
            this.setupCmdLineArgs();
            if (this.lang.equalsIgnoreCase("jython")) {
                this.loadWsadminScriptLibraries();
                this.importScriptLibraries(this.scriptLibFiles);
            }
            this.executeProfiles();
            this.executeCommands();
            if (this.targetScript != null) {
                this.inScript = true;
                Tr.debug(tc, "executeScript " + this.targetScript);
                this.executeScript(this.targetScript);
            } else if (this.commands.isEmpty()) {
                if (this.scriptParms.size() > 0) {
                    this.scriptParms = this.checkScriptParamPassword(this.scriptParms);
                    String msg = this.getFormattedMessage("WASX7411W", new Object[]{this.scriptParms}, "Ignoring the following provided option: ." + this.scriptParms);
                    System.out.println(msg);
                    Tr.audit(tc, "WASX7411W", new Object[]{this.scriptParms});
                }
                this.welcome();
                this.interactive();
            }
            this.commands.clear();
            this.propfiles.clear();
            this.profiles.clear();
            this.scriptParms.clear();
            this.loadedPropfiles.clear();
            this.targetScript = null;
        } else if (returnCode == 0) {
            returnCode = -1;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run -> " + returnCode);
        }
    }

    public int getReturnCode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReturnCode");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReturnCode - " + returnCode);
        }
        return returnCode;
    }

    public List getSavedMessages() {
        return savedMessages;
    }

    protected void addToSavedMessage(String msg) {
        savedMessages.add(msg);
        if (savedMessages.size() > maxSavedMessages) {
            savedMessages.remove(0);
        }
    }

    protected void clearSavedMessages() {
        savedMessages.clear();
    }

    public void checkException(String command, BSFException bsfe) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkException");
        }
        String msg = null;
        boolean flag = false;
        command.trim();
        if (this.lang.equalsIgnoreCase("jython")) {
            int printIndex = command.indexOf("print");
            if (printIndex >= 0) {
                command = command.substring(printIndex + 6, command.length());
                command.trim();
            }
            if (command.equals("AdminConfig()") || command.equals("AdminControl()") || command.equals("AdminApp()") || command.equals("AdminTask()") || command.equals("Help()")) {
                flag = true;
                String cmd = command.substring(0, command.length() - 2);
                this.printHelp(cmd);
            }
        } else if (this.lang.equalsIgnoreCase("jacl") && (command.equals("$AdminConfig") || command.equals("$AdminControl") || command.equals("$AdminApp") || command.equals("$AdminTask") || command.equals("$Help"))) {
            flag = true;
            String cmd = command.substring(1, command.length());
            this.printHelp(cmd);
        }
        command = this.checkPassword(command);
        Tr.debug(tc, "command -- " + command);
        if (!flag) {
            msg = this.getStringFromException(bsfe);
            this.logException(bsfe, msg);
            returnCode = this.issueMessage(new Object[]{command, msg}, "EXCEPTION_RUNNING_COMMAND", "Exception running command: " + command + "; exception information: " + bsfe);
            int trial = this.retcodeFromMessage(msg);
            if (trial > 0) {
                returnCode = trial;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "returnCode - " + returnCode);
        }
    }

    private String getPluginPath() {
        String path = "";
        String wasInstallRoot = System.getProperty("was.install.root");
        if (wasInstallRoot != null) {
            File eclipseDir = new File(wasInstallRoot + File.separator + "plugins");
            path = AbstractShell.searchPlugins(eclipseDir);
        } else {
            System.out.println("WARNING: system property was.install.root is not set.  Websphere classes may not be found.");
        }
        String jythonPackagePath = System.getProperty("jython.package.path");
        if (jythonPackagePath != null) {
            path = path + ";" + jythonPackagePath;
        }
        return path;
    }

    private static String searchPlugins(File directory) {
        String path = new String();
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return path;
        }
        File[] jarsAndZips = directory.listFiles(new JarZipFilter());
        if (jarsAndZips != null && jarsAndZips.length > 0) {
            for (int i = 0; i < jarsAndZips.length; ++i) {
                String file = jarsAndZips[i].toString();
                if (file.indexOf("runtime") != -1) {
                    path = !path.equals("") ? path + File.pathSeparator + file : file;
                }
                if (file.indexOf("admin") == -1) continue;
                path = !path.equals("") ? path + File.pathSeparator + file : file;
            }
        }
        return path;
    }

    public void printHelp(String command) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "printHelp - " + command);
        }
        if (command.equals("AdminConfig")) {
            System.out.println(this.getFormattedMessage("ADMINCONFIG_GENERAL_HELP", new Object[0], "no help available"));
        } else if (command.equals("AdminControl")) {
            System.out.println(this.getFormattedMessage("ADMINCONTROL_GENERAL_HELP", new Object[0], "no help available"));
        } else if (command.equals("AdminApp")) {
            System.out.println(this.getFormattedMessage("WASX7095I", new Object[0], "no help available"));
        } else if (command.equals("Help")) {
            System.out.println(this.getFormattedMessage("HELP_GENERAL_HELP", new Object[0], "no help available"));
        } else if (command.equals("AdminTask")) {
            System.out.println(this.getFormattedMessage("WASX8001I", new Object[0], "no help available"));
        }
    }

    private void SystemExitCheck(String command) {
        Tr.entry(tc, "SystemExitCheck " + command);
        String returnString = null;
        if (command.indexOf("sys.exit(") >= 0 || command.indexOf("SystemExit(") >= 0) {
            if (command.indexOf("\"") < 0 && command.indexOf("'") < 0) {
                if (command.indexOf("sys.exit()") >= 0 || command.indexOf("SystemExit()") >= 0) {
                    returnCode = this.getReturnCode();
                } else {
                    returnString = command.substring(command.indexOf("(") + 1, command.indexOf(")"));
                    if (returnString != null && !returnString.equals("")) {
                        returnCode = Integer.parseInt(returnString);
                    }
                }
                System.exit(returnCode);
            } else {
                String errorMsg = command.indexOf("\"") >= 0 ? command.substring(command.indexOf("\"") + 1, command.lastIndexOf("\"")) : command.substring(command.indexOf("'") + 1, command.lastIndexOf("'"));
                command = "print \"" + errorMsg + "\"";
                try {
                    this.mgr.iexec(this.lang, command, 0, 0, command);
                    System.exit(1);
                }
                catch (BSFException bsfe) {
                    this.checkException(command, bsfe);
                }
            }
        }
    }

    private void checkVersionCompatibility(AdminControlClient controlClient) throws ScriptingException {
        String serverNodeVersion = null;
        String clientVersion = null;
        Session session = null;
        ConfigServiceProxy configService = null;
        Tr.entry(tc, "checkVersionCompatibility ");
        try {
            if (!this.connectionType.equalsIgnoreCase("NONE")) {
                clientVersion = UtilsClient.getProductVersion();
                Tr.debug(tc, "clientVersion " + clientVersion);
                String[] clientVerArray = null;
                if (clientVersion != null) {
                    clientVerArray = clientVersion.split("\\.");
                }
                int clientMajor = Integer.parseInt((String)clientVerArray[0]);
                int clientMinor = Integer.parseInt(clientVerArray[1]);
                session = controlClient.isAlive();
                AdminClient _client = controlClient.getAdminClient();
                configService = new ConfigServiceProxy(_client);
                String node = controlClient.getNode();
                Tr.debug(tc, "node " + node);
                CommandMgr cmdMgr = CommandMgr.getCommandMgr(_client);
                AdminCommand cmd = cmdMgr.createCommand("getNodeBaseProductVersion");
                cmd.setConfigSession(session);
                cmd.setParameter("nodeName", node);
                cmd.execute();
                CommandResult cmdResult = cmd.getCommandResult();
                serverNodeVersion = cmdResult.getResult().toString();
                Tr.debug(tc, "serverNodeversion " + serverNodeVersion);
                String[] serverVerArray = null;
                if (serverNodeVersion != null) {
                    serverVerArray = serverNodeVersion.split("\\.");
                }
                int serverMajor = Integer.parseInt((String)serverVerArray[0]);
                int serverMinor = Integer.parseInt(serverVerArray[1]);
                if (clientMajor > serverMajor || clientMajor == serverMajor && clientMinor > serverMinor) {
                    this.setAndThrowScriptingException("WASX8021E", "The wsadmin with version " + clientVersion + " connected to an incompatible server or deployment manager with node version " + serverNodeVersion + " , which is not supported. ", new Object[]{clientVersion, serverNodeVersion});
                }
                configService.discard(session);
            }
        }
        catch (ScriptingException se) {
            if (se.toString().indexOf("WASX8021E") > 0) {
                returnCode = this.issueMessage(new Object[]{se}, "INCOMPATIBLE_NODE", "Incompatible node version; Exception Information: " + se);
                return;
            }
        }
        catch (Exception e) {
            Tr.debug(tc, "e " + e);
        }
    }

    private void loadWsadminScriptLibraries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadWsadminScriptLibraries");
        }
        try {
            char sep = File.separatorChar;
            Tr.debug(tc, "char separator is " + sep);
            String scriptLibrariesPath = System.getProperty("wsadmin.script.libraries");
            Tr.debug(tc, "Script library path: " + scriptLibrariesPath);
            scriptLibrariesPath = this.getScriptLibrariesPath(scriptLibrariesPath);
            Tr.debug(tc, "Script libraries path after search: " + scriptLibrariesPath);
            if (scriptLibrariesPath != null) {
                File scriptLibFiles = new File(scriptLibrariesPath);
                String fixPath = scriptLibFiles.toString();
                fixPath = scriptLibrariesPath.replace(sep, '/');
                String[] scriptLibArray = fixPath.split(File.pathSeparator);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Fixed script libraries path is " + fixPath);
                    Tr.debug(tc, "Script libraries array is " + scriptLibArray.toString());
                }
                for (int i = 0; i < scriptLibArray.length; ++i) {
                    String path = scriptLibArray[i];
                    this.mgr.exec("jython", "import sys", 0, 0, "import sys");
                    this.mgr.exec("jython", "", -1, -1, "sys.path.append('" + path + "')");
                }
            }
        }
        catch (Exception e) {
            Tr.debug(tc, "Failed to append the script path to sys.path", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadWsadminScriptLibraries");
        }
    }

    private String getScriptLibrariesPath(String scriptLibPath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScriptLibrariesPath");
        }
        String path = "";
        String wasInstallRoot = System.getProperty("was.install.root");
        Vector pathV = new Vector();
        Vector fileV = new Vector();
        Vector newPathV = new Vector();
        Vector newFileV = new Vector();
        Vector scriptLibPaths = new Vector();
        Vector wsadminScriptLibPaths = new Vector();
        if (scriptLibPath != null) {
            File libDir = null;
            if (scriptLibPath.indexOf(";") > 0) {
                StringTokenizer tok = new StringTokenizer(scriptLibPath, ";");
                while (tok.hasMoreTokens()) {
                    String scriptPath = tok.nextToken();
                    libDir = new File(scriptPath);
                    scriptLibPaths = this.fileSearch(libDir, pathV, fileV);
                }
            } else {
                libDir = new File(scriptLibPath);
                scriptLibPaths = this.fileSearch(libDir, pathV, fileV);
            }
        }
        if (wasInstallRoot != null) {
            File scriptLibDir = new File(wasInstallRoot + File.separator + "scriptLibraries");
            if (scriptLibDir == null || !scriptLibDir.exists() || !scriptLibDir.isDirectory()) {
                return path;
            }
            wsadminScriptLibPaths = this.fileSearch(scriptLibDir, newPathV, newFileV);
            scriptLibPaths = this.fileSearch(scriptLibDir, pathV, fileV);
            for (int i = 0; i < scriptLibPaths.size(); ++i) {
                String libPath = scriptLibPaths.get(i).toString();
                path = !path.equals("") ? path + File.pathSeparator + libPath : libPath;
            }
            for (int j = 0; j < newFileV.size(); ++j) {
                String scriptFile = newFileV.get(j).toString();
                char sep = File.separatorChar;
                scriptFile = scriptFile.substring(scriptFile.lastIndexOf(sep) + 1, scriptFile.length() - 3);
                this.scriptLibList.add(scriptFile);
            }
        } else {
            System.out.println("WARNING: system property was.install.root is not set.  Websphere classes may not be found.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScriptLibrariesPath");
        }
        return path;
    }

    private Vector fileSearch(File directory, Vector pathV, Vector fileV) {
        Vector libPaths = new Vector();
        File[] files = directory.listFiles();
        String dirPath = directory.getAbsolutePath();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.fileSearch(files[i], pathV, fileV);
                    continue;
                }
                if (!files[i].getName().endsWith(".py")) continue;
                String path = dirPath;
                String file = dirPath + File.separator + files[i].getName();
                Tr.debug(tc, "Script library file name " + file);
                pathV.add(path);
                fileV.add(file);
            }
            for (int j = 0; j < pathV.size(); ++j) {
                if (libPaths.contains(pathV.get(j))) continue;
                libPaths.add(pathV.get(j));
            }
            for (int k = 0; k < fileV.size(); ++k) {
                if (this.scriptLibFiles.contains(fileV.get(k))) continue;
                this.scriptLibFiles.add(fileV.get(k));
            }
        }
        return libPaths;
    }

    private void importScriptLibraries(Vector scriptLibFiles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importScriptLibraries");
        }
        for (int i = 0; i < scriptLibFiles.size(); ++i) {
            String file = (String)scriptLibFiles.get(i);
            if (file == null || !file.endsWith(".py")) continue;
            char sep = File.separatorChar;
            String command = "import " + file.substring(file.lastIndexOf(sep) + 1, file.length() - 3);
            Tr.debug(tc, "Command: " + command);
            try {
                this.mgr.exec("jython", command, 0, 0, command);
                continue;
            }
            catch (Exception s) {
                Tr.debug(tc, "Failed to import script libraries modules", s);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importScriptLibraries");
        }
    }

    private String checkPassword(String command) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkPassword");
        }
        if (command.toLowerCase().indexOf("password") != -1 || command.toLowerCase().indexOf("pwd") != -1 || command.toLowerCase().indexOf("passwd") != -1) {
            String[] commandArray = command.split(" ");
            StringBuffer buf = new StringBuffer();
            boolean passwordFlag = false;
            for (int i = 0; i < commandArray.length; ++i) {
                String temp = commandArray[i];
                if (!(temp.toLowerCase().indexOf("password") == -1 && temp.toLowerCase().indexOf("pwd") == -1 && temp.toLowerCase().indexOf("passwd") == -1 || passwordFlag)) {
                    passwordFlag = true;
                    buf.append(temp);
                } else if (passwordFlag) {
                    buf.append("*****");
                    if (this.lang.equalsIgnoreCase("jacl") && temp.indexOf("}") != -1) {
                        buf.append(temp.substring(temp.indexOf("}"), temp.length()));
                    } else if (this.lang.equalsIgnoreCase("jython") && temp.indexOf("]") != -1) {
                        buf.append(temp.substring(temp.indexOf("]"), temp.length()));
                    }
                    passwordFlag = false;
                } else {
                    buf.append(temp);
                }
                buf.append(" ");
            }
            command = buf.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkPassword");
        }
        return command;
    }

    private ArrayList checkScriptParamPassword(ArrayList params) {
        Tr.entry(tc, "checkScriptParamPassword");
        ArrayList<String> tempScriptParms = params;
        String paramNumbers = System.getProperty("com.ibm.ws.scripting.noechoParamNo");
        if (paramNumbers != null) {
            String[] tempArray = new String[params.size() + 1];
            for (int i = 0; i < params.size(); ++i) {
                tempArray[i] = (String)params.get(i);
            }
            if (paramNumbers.indexOf(",") > 0) {
                StringTokenizer tok = new StringTokenizer(paramNumbers, ",");
                while (tok.hasMoreTokens()) {
                    String n = tok.nextToken();
                    int number = Integer.parseInt(n.trim());
                    tempArray[number - 1] = "*****";
                }
            } else {
                int nu = Integer.parseInt(paramNumbers);
                tempArray[nu - 1] = "*****";
            }
            tempScriptParms = new ArrayList<String>();
            for (int j = 0; j < tempArray.length - 1; ++j) {
                tempScriptParms.add(tempArray[j]);
            }
        }
        Tr.exit(tc, "checkScriptParamPassword");
        return tempScriptParms;
    }

    private static class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }

    private static class JarZipFilter
    implements FileFilter {
        private JarZipFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".jar") || pathname.getName().endsWith(".zip");
        }
    }
}

