/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.jms.JMSResourceRefBuilder;
import com.ibm.ejs.jms.JMSResourceRefBuilderFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.binder.JMSBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.ws.runtime.service.Server;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.Properties;
import javax.naming.Referenceable;

public class WASQueueBinder
extends JMSBinder {
    private static TraceComponent tc = Tr.register(WASQueueBinder.class, "ResourceBinders", "com.ibm.ejs.jms.messaging");

    public boolean isUsedFor(ConfigObject resource) {
        return resource.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.internalmessaging.xmi", "WASQueue");
    }

    public Object getBindingObject(ConfigObject resource) throws ResourceBindingException {
        int intValueExpiry;
        Number specifiedProp;
        int intValuePriority;
        Integer property;
        int intValuePersistence;
        Properties jmsProps = new Properties();
        ConfigObject jmsProvider = resource.getParent();
        try {
            Server server = WsServiceRegistry.getService(this, Server.class);
            this.setProperty(jmsProps, "CELL", server.getCellName(), true);
        }
        catch (Throwable e) {
            Tr.audit(tc, "Exception getting Server Service", e);
        }
        this.addPropertySet(jmsProps, resource.getObject("propertySet"), true);
        this.addPropertySet(jmsProps, jmsProvider.getObject("propertySet"), true);
        String name = resource.getString("name", "__null__");
        if (name == null || name.length() <= 0) {
            throw new ResourceBindingException("WASQueue can not be bound as no name has been specified.");
        }
        this.setProperty(jmsProps, "NAME", name, true);
        this.setProperty(jmsProps, "DESC", resource.getString("description", "__null__"), true);
        String stringValue = resource.getString("persistence", "APPLICATION_DEFINED");
        if (stringValue.equals("APPLICATION_DEFINED")) {
            intValuePersistence = -2;
        } else if (stringValue.equals("NONPERSISTENT")) {
            intValuePersistence = 1;
        } else if (stringValue.equals("PERSISTENT")) {
            intValuePersistence = 2;
        } else {
            throw new IllegalStateException(stringValue);
        }
        Integer n = property = resource.isSet("persistence") ? Integer.valueOf(intValuePersistence) : null;
        if (property != null) {
            this.setProperty(jmsProps, "PER", intValuePersistence, true);
        } else {
            this.setProperty(jmsProps, "PER", new Integer(-2), true);
        }
        stringValue = resource.getString("priority", "APPLICATION_DEFINED");
        if (stringValue.equals("APPLICATION_DEFINED")) {
            intValuePriority = -2;
        } else if (stringValue.equals("SPECIFIED")) {
            intValuePriority = -3;
        } else {
            throw new IllegalStateException(stringValue);
        }
        Integer n2 = property = resource.isSet("priority") ? Integer.valueOf(intValuePriority) : null;
        if (property != null) {
            if (stringValue.equals("APPLICATION_DEFINED")) {
                this.setProperty(jmsProps, "PRI", new Integer(intValuePriority), true);
            } else {
                specifiedProp = resource.isSet("specifiedPriority") ? new Integer(resource.getInt("specifiedPriority", 0)) : null;
                this.checkRequiredProperty(specifiedProp, "WASQueue " + name + " can not be bound as specifiedPriority is required if priority=SPECIFIED.");
                this.setProperty(jmsProps, "PRI", specifiedProp, true);
            }
        } else {
            this.setProperty(jmsProps, "PRI", new Integer(-2), true);
        }
        stringValue = resource.getString("expiry", "APPLICATION_DEFINED");
        if (stringValue.equals("APPLICATION_DEFINED")) {
            intValueExpiry = -2;
        } else if (stringValue.equals("SPECIFIED")) {
            intValueExpiry = -3;
        } else if (stringValue.equals("UNLIMITED")) {
            intValueExpiry = 0;
        } else {
            throw new IllegalStateException(stringValue);
        }
        Integer n3 = property = resource.isSet("expiry") ? Integer.valueOf(intValueExpiry) : null;
        if (property != null) {
            if (intValueExpiry == -2 || intValueExpiry == 0) {
                this.setProperty(jmsProps, "EXP", new Long(intValueExpiry), true);
            } else {
                specifiedProp = resource.isSet("specifiedExpiry") ? new Long(resource.getString("priority", "APPLICATION_DEFINED")) : null;
                this.checkRequiredProperty(specifiedProp, "WASQueue " + name + " can not be bound as specifiedExpiry is required if expiry=SPECIFIED.");
                this.setProperty(jmsProps, "EXP", specifiedProp, true);
            }
        } else {
            this.setProperty(jmsProps, "EXP", new Integer(-2), true);
        }
        JMSResourceRefBuilder refBuilder = JMSResourceRefBuilderFactory.createJMSResourceRefBuilder();
        Referenceable ref = null;
        try {
            ref = refBuilder.createEmbeddedQueueReferenceable(jmsProps);
        }
        catch (ResourceBindingException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.component.binder.WASQueueBinder.getBindingObject", "125", this);
            throw e;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.runtime.component.binder.WASQueueBinder.getBindingObject", "130", this);
            throw new ResourceBindingException(t.toString());
        }
        return ref;
    }
}

