/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.component.ContainerHelper;
import com.ibm.ws.runtime.config.ConfigLocatorAdapter;
import com.ibm.ws.runtime.provisioning.ComponentMetaDataMgr;
import com.ibm.ws.runtime.service.ComponentManager;
import com.ibm.ws.runtime.service.impl.BundleContextMap;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.runtime.component.WsComponent;
import com.ibm.wsspi.runtime.config.ConfigLocator;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;
import java.beans.beancontext.BeanContextServices;
import java.beans.beancontext.BeanContextServicesListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerImpl
extends ComponentImpl
implements BeanContextServices {
    private static final TraceComponent tc = Tr.register(ContainerImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    protected List components = Collections.EMPTY_LIST;
    private List<Object> applicationComponents = Collections.EMPTY_LIST;
    protected ArrayList bcmListeners;
    protected ArrayList children;
    protected ArrayList bcsListeners;
    protected HashMap services;
    private ContainerHelper helper = new ContainerHelper(this);

    public ContainerImpl() {
        this.children = new ArrayList(3);
        this.bcmListeners = new ArrayList(1);
        this.bcsListeners = new ArrayList(1);
        this.services = new HashMap(3);
    }

    protected BeanContextServices getOuterBCS() {
        return this.getBeanContextServices();
    }

    @Override
    public Object instantiateChild(String beanName) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getResourceAsStream(String name, BeanContextChild bcc) throws IllegalArgumentException {
        return bcc.getClass().getClassLoader().getResourceAsStream(name);
    }

    @Override
    public URL getResource(String name, BeanContextChild bcc) throws IllegalArgumentException {
        return bcc.getClass().getClassLoader().getResource(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBeanContextMembershipListener(BeanContextMembershipListener bcml) {
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            if (!this.bcmListeners.contains(bcml)) {
                this.bcmListeners.add(bcml);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBeanContextMembershipListener(BeanContextMembershipListener bcml) {
        BeanContextMembershipListener beanContextMembershipListener = bcml;
        synchronized (beanContextMembershipListener) {
            this.bcmListeners.remove(bcml);
        }
    }

    public void revokeService(Class serviceClass, BeanContextServiceProvider serviceProvider, boolean revokeCurrentServicesNow) {
        Object o = this.services.remove(serviceClass);
        if (o != null) {
            this.fireServiceRevoked(new BeanContextServiceRevokedEvent(this, serviceClass, revokeCurrentServicesNow));
        }
    }

    public boolean hasService(Class serviceClass) {
        if (this.services.get(serviceClass) == null) {
            BeanContextServices bcs = this.getBeanContextServices();
            return bcs == null ? false : bcs.hasService(serviceClass);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(BeanContextChild child, Object requestor, Class serviceClass, Object serviceSelector, BeanContextServiceRevokedListener bcsrl) throws TooManyListenersException {
        BeanContextServiceProvider bcsp = null;
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            bcsp = (BeanContextServiceProvider)this.services.get(serviceClass);
        }
        if (bcsp != null) {
            return bcsp.getService(this, requestor, serviceClass, serviceSelector);
        }
        BeanContextServices bcs = this.getBeanContextServices();
        if (bcs != null) {
            return bcs.getService(this, requestor, serviceClass, serviceSelector, bcsrl);
        }
        return null;
    }

    @Override
    public void releaseService(BeanContextChild child, Object requestor, Object service) {
        BeanContextServices bcs;
        if (this.services.get(service) == null && (bcs = this.getBeanContextServices()) != null) {
            bcs.releaseService(this, requestor, service);
        }
    }

    public Iterator getCurrentServiceClasses() {
        return this.services.keySet().iterator();
    }

    public Iterator getCurrentServiceSelectors(Class serviceClass) {
        BeanContextServiceProvider bcsp = (BeanContextServiceProvider)this.services.get(serviceClass);
        return bcsp == null ? null : bcsp.getCurrentServiceSelectors(this, serviceClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBeanContextServicesListener(BeanContextServicesListener bcsl) {
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            if (!this.bcsListeners.contains(bcsl)) {
                this.bcsListeners.add(bcsl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBeanContextServicesListener(BeanContextServicesListener bcsl) {
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            this.bcsListeners.remove(bcsl);
        }
    }

    @Override
    public void serviceAvailable(BeanContextServiceAvailableEvent bcsae) {
        if (this.services.containsKey(bcsae.getServiceClass())) {
            return;
        }
        this.fireServiceAdded(bcsae);
        for (int i = 0; i < this.children.size(); ++i) {
            Object c = this.children.get(i);
            if (!(c instanceof BeanContextServicesListener)) continue;
            ((BeanContextServicesListener)c).serviceAvailable(bcsae);
        }
    }

    @Override
    public void serviceRevoked(BeanContextServiceRevokedEvent bcsre) {
        if (this.services.containsKey(bcsre.getServiceClass())) {
            return;
        }
        this.fireServiceRevoked(bcsre);
        for (int i = 0; i < this.children.size(); ++i) {
            Object c = this.children.get(i);
            if (!(c instanceof BeanContextServicesListener)) continue;
            ((BeanContextServicesListener)c).serviceRevoked(bcsre);
        }
    }

    @Override
    public boolean needsGui() {
        return false;
    }

    @Override
    public void dontUseGui() {
    }

    @Override
    public void okToUseGui() {
    }

    @Override
    public boolean avoidingGui() {
        return true;
    }

    @Override
    public void setDesignTime(boolean dTime) {
    }

    @Override
    public boolean isDesignTime() {
        return false;
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public boolean contains(Object child) {
        return this.children.contains(child);
    }

    @Override
    public Iterator iterator() {
        return this.children.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.children.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.children.toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            if (this.children.contains(o)) {
                return false;
            }
            this.children.add(o);
        }
        if (o instanceof BeanContextChild) {
            BeanContextChild bcc = (BeanContextChild)o;
            try {
                bcc.setBeanContext(this);
            }
            catch (PropertyVetoException e) {
                ArrayList arrayList2 = this.children;
                synchronized (arrayList2) {
                    this.children.remove(o);
                }
                throw new IllegalStateException();
            }
        }
        this.fireChildrenAdded(new BeanContextMembershipEvent((BeanContext)this, new Object[]{o}));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            if (!this.children.contains(o)) {
                return false;
            }
        }
        if (o instanceof BeanContextChild) {
            BeanContextChild bcc = (BeanContextChild)o;
            try {
                bcc.setBeanContext(null);
            }
            catch (PropertyVetoException e) {
                throw new IllegalStateException();
            }
        }
        arrayList = this.children;
        synchronized (arrayList) {
            this.children.remove(o);
        }
        this.fireChildrenRemoved(new BeanContextMembershipEvent((BeanContext)this, new Object[]{o}));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection c) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            return this.children.containsAll(c);
        }
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    protected void fireServiceAdded(BeanContextServiceAvailableEvent bcsae) {
        BeanContextServicesListener[] bcsls = new BeanContextServicesListener[this.bcsListeners.size()];
        this.bcsListeners.toArray(bcsls);
        for (int i = 0; i < bcsls.length; ++i) {
            bcsls[i].serviceAvailable(bcsae);
        }
    }

    protected void fireServiceRevoked(BeanContextServiceRevokedEvent bcsre) {
        BeanContextServicesListener[] bcsls = new BeanContextServicesListener[this.bcsListeners.size()];
        this.bcsListeners.toArray(bcsls);
        for (int i = 0; i < bcsls.length; ++i) {
            bcsls[i].serviceRevoked(bcsre);
        }
    }

    protected void fireChildrenAdded(BeanContextMembershipEvent bcme) {
        BeanContextMembershipListener[] bcmls = new BeanContextMembershipListener[this.bcmListeners.size()];
        this.bcmListeners.toArray(bcmls);
        for (int i = 0; i < bcmls.length; ++i) {
            bcmls[i].childrenAdded(bcme);
        }
    }

    protected void fireChildrenRemoved(BeanContextMembershipEvent bcme) {
        BeanContextMembershipListener[] bcmls = new BeanContextMembershipListener[this.bcmListeners.size()];
        this.bcmListeners.toArray(bcmls);
        for (int i = 0; i < bcmls.length; ++i) {
            bcmls[i].childrenRemoved(bcme);
        }
    }

    @Override
    public void destroy() {
        this.destroyComponents();
    }

    protected void destroyComponents() {
        this.helper.destroyComponents(this.components, this.applicationComponents);
    }

    @Override
    public void start() throws RuntimeError, RuntimeWarning {
        this.startComponents();
    }

    protected void startComponents() throws RuntimeWarning, RuntimeError {
        this.helper.startComponents(this.components);
    }

    @Override
    public void stop() {
        this.stopComponents();
    }

    protected void stopComponents() {
        this.helper.stopComponents(this.components, this.applicationComponents);
    }

    protected List loadComponents(String pluginName) throws ConfigurationError {
        String hostID;
        String epid;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadComponents", new Object[]{pluginName, this});
        }
        String start = "META-INF/ws-";
        int startIx = pluginName.indexOf(start);
        String pluginId = pluginName;
        if (startIx == 0) {
            pluginId = pluginName.substring(start.length());
        }
        if (pluginId.endsWith(".xml")) {
            pluginId = pluginId.substring(0, pluginId.length() - 4);
        }
        pluginId = pluginId.replaceFirst("recovery-mode-", "");
        pluginId = pluginId.replaceFirst("control-region-", "");
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + "." + pluginId);
        if (extensionPoint == null && (hostID = this.getHostingBundleId()) != null) {
            epid = hostID + "." + pluginId;
        }
        List componentList = ComponentMetaDataMgr.instance().getComponentsByExtensionPoint(epid, this);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadedComponents " + componentList.size(), this);
            for (int i = 0; i < componentList.size(); ++i) {
                Tr.debug(tc, " component " + i, componentList.get(i));
            }
        }
        return componentList;
    }

    private String getHostingBundleId() {
        String result = null;
        BundleContext bc = BundleContextMap.instance().get(this.getClass().getClassLoader());
        if (bc != null) {
            result = bc.getBundle().getSymbolicName();
        }
        return result;
    }

    private ConfigLocatorAdapter[] createConfigLocatorAdapters(Object[] locators) {
        return this.helper.createConfigLocatorAdapters(locators);
    }

    protected void initializeComponents(ConfigObject rootConfig, ConfigLocator[] locators) throws ConfigurationWarning, ConfigurationError {
        this.initializeComponents((Object)rootConfig, this.createConfigLocatorAdapters(locators));
    }

    protected void initializeComponents(EObject rootConfig, com.ibm.ws.runtime.config.ConfigLocator[] locators) throws ConfigurationWarning, ConfigurationError {
        this.initializeComponents((Object)rootConfig, this.createConfigLocatorAdapters(locators));
    }

    private void initializeComponents(Object rootConfig, ConfigLocatorAdapter[] locators) throws ConfigurationWarning, ConfigurationError {
        List loadedComponents = Collections.synchronizedList(new ArrayList());
        try {
            this.helper.initializeComponents(rootConfig, locators, this.components, loadedComponents);
        }
        catch (ConfigurationWarning e) {
            throw e;
        }
        finally {
            this.components = loadedComponents;
        }
    }

    protected void initializeComponent(String implementationClass, Object configurationObject, EObject notUsed, ComponentManager componentManager, Map loadedConfigs, List loadedComponents, com.ibm.ws.runtime.config.ConfigLocator[] locators) throws ConfigurationWarning, ConfigurationError {
        this.initializeComponent(implementationClass, configurationObject, componentManager, loadedConfigs, loadedComponents, locators);
    }

    protected void initializeComponent(String implementationClass, Object configurationObject, ComponentManager componentManager, Map loadedConfigs, List loadedComponents, com.ibm.ws.runtime.config.ConfigLocator[] locators) throws ConfigurationWarning, ConfigurationError {
        this.initializeComponent(implementationClass, configurationObject, componentManager, loadedConfigs, loadedComponents, locators, null);
    }

    protected void initializeComponent(String implementationClass, Object configurationObject, ComponentManager componentManager, Map loadedConfigs, List loadedComponents, com.ibm.ws.runtime.config.ConfigLocator[] locators, ComponentStartup metaData) throws ConfigurationWarning, ConfigurationError {
        this.helper.initializeComponent(implementationClass, configurationObject, componentManager, loadedConfigs, loadedComponents, this.createConfigLocatorAdapters(locators), metaData);
    }

    public ContainerHelper getContainerHelper() {
        return this.helper;
    }

    public void addActivatedComponents(List<Object> activatedComponents) {
        if (this.applicationComponents == Collections.EMPTY_LIST) {
            this.applicationComponents = new ArrayList<Object>(3);
        }
        this.helper.addActivatedComponents(activatedComponents, this.applicationComponents);
    }

    public static class ComponentStartup {
        public static final String EMF = "emf";
        public static final String RCS = "rcs";
        public int order = Integer.MAX_VALUE;
        public String type = null;
        public String clazz = null;
        public String platforms = null;
        public String processtypes = null;
        public String recoverytypes = null;
        public boolean configurationDataRequired = true;
        public boolean asyncStart = false;
        public boolean asyncInitialize = false;
        public boolean inhibitAsynchronousBehavior = false;
        public String configurationData = null;
        public boolean injectDependencies = false;
        public static final String DEFAULT_VERSION = "0.0.0";
        public static final int PRIMORDIAL = 0;
        public static final int IMMEDIATE = 1;
        public static final int DEPENDENCY = 2;
        public String componentId = null;
        public String version = "0.0.0";
        public int startupMode = 1;
        public String configAnalyzer = null;
        public String initMethod = null;
        public String startMethod = null;
        public String stopMethod = null;
        public String destroyMethod = null;
        public List dependencies = Collections.EMPTY_LIST;
        public List injectionDependants = null;
        public List services = Collections.EMPTY_LIST;
        public String hostingBundleId = null;
        public static final int NOT_ANALYZED = 0;
        public static final int READY_TO_INITIALIZE = 1;
        public static final int ANALYZING = 2;
        public static final int INITIALIZED = 3;
        public static final int DISABLED = 4;
        public static final int PERM_FAILED = 6;
        public int state = 0;
        public boolean activeDependency = false;
        public Object componentInstance = null;
        public WsComponent container = null;
        public String containerExtensionPoint = null;
        public int globalOrder = Integer.MAX_VALUE;
        public boolean inActivationPlan = false;

        public boolean isRootComponent() {
            return this.startupMode == 1 && this.componentId != null || this.inActivationPlan;
        }

        public String getState() {
            switch (this.state) {
                case 0: {
                    return "NOT_ANALYZED";
                }
                case 1: {
                    return "READY_TO_INITIALIZE";
                }
                case 3: {
                    return "INITIALIZED";
                }
                case 2: {
                    return "ANALYZING";
                }
                case 4: {
                    return "DISABLED";
                }
                case 6: {
                    return "PERM_FAILED";
                }
            }
            return Integer.toString(this.state);
        }

        public String getShortName() {
            if (this.componentId != null) {
                return this.componentId;
            }
            if (this.clazz != null) {
                return this.clazz;
            }
            return this.type;
        }

        public String toString() {
            String ret_value = (this.componentId != null ? this.componentId + " " : "") + (this.type != null ? this.type : this.clazz) + " [" + this.order + "]" + (this.asyncInitialize ? " asynch-init" : "") + (this.asyncStart ? " asynch-start" : "");
            if (this.platforms != null) {
                ret_value = ret_value + " [platforms:" + this.platforms + "]";
            }
            if (this.processtypes != null) {
                ret_value = ret_value + " [processtypes:" + this.processtypes + "]";
            }
            if (this.recoverytypes != null) {
                ret_value = ret_value + " [recoverytypes:" + this.recoverytypes + "]";
            }
            return ret_value;
        }

        public boolean equals(Object o) {
            if (o instanceof ComponentStartup) {
                boolean b2;
                boolean b;
                ComponentStartup cs2 = (ComponentStartup)o;
                boolean bl = this.type == null ? this.type == cs2.type : (b = this.type.equals(cs2.type));
                boolean bl2 = this.clazz == null ? this.clazz == cs2.clazz : (b2 = this.clazz.equals(cs2.clazz));
                boolean b3 = this.componentId == null ? this.componentId == cs2.componentId : this.componentId.equals(cs2.componentId);
                return b && b2 & b3;
            }
            return false;
        }

        public String getName() {
            if (this.componentId != null) {
                return this.componentId;
            }
            if (this.type != null) {
                return this.type;
            }
            return this.clazz;
        }

        public Class loadClass(String className) throws ClassNotFoundException {
            if (this.hostingBundleId != null) {
                Bundle bundle = Platform.getBundle((String)this.hostingBundleId);
                if (bundle != null) {
                    return bundle.loadClass(className);
                }
                throw new ClassNotFoundException("Cannot obtain bundle: " + this.hostingBundleId);
            }
            return ExtClassLoader.getInstance().loadClass(className);
        }
    }
}

