/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.wire;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.ws.pmi.wire.WpdCollection;
import com.ibm.ws.pmi.wire.WpdData;
import java.util.ArrayList;

public class WpdCollectionImpl
implements WpdCollection,
PmiConstants {
    private static final long serialVersionUID = -3280621639331246909L;
    public String name;
    public int type;
    public int instrumentationLevel = -1;
    public ArrayList dataMembers;
    public ArrayList subCollections;

    public WpdCollectionImpl(String name, int type) {
        this(name, type, -1, null, null);
    }

    public WpdCollectionImpl(String name, int type, int level) {
        this(name, type, level, null, null);
    }

    public WpdCollectionImpl(String name, int type, int level, ArrayList dataMembers, ArrayList subCollections) {
        if (name == null) {
            name = "Undefined";
        }
        this.name = name;
        this.type = type == 11 || type == 12 || type == 13 ? type : 17;
        this.instrumentationLevel = level;
        this.dataMembers = dataMembers;
        this.subCollections = subCollections;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public int getLevel() {
        return this.instrumentationLevel;
    }

    public void setLevel(int level) {
        this.instrumentationLevel = level;
    }

    public String toXML() {
        int i;
        String result = null;
        String endTag = null;
        if (this.type == 11) {
            result = "<PerfNode";
            endTag = "</PerfNode>\n";
        } else if (this.type == 12) {
            result = "<PerfServer";
            endTag = "</PerfServer>\n";
        } else if (this.type == 13) {
            result = "<PerfModule";
            endTag = "</PerfModule>\n";
        } else {
            result = "PerfCollection";
            endTag = "</PerfCollection>\n";
        }
        result = result + " name=\"" + this.name + "\">\n";
        if (this.dataMembers != null) {
            for (i = 0; i < this.dataMembers.size(); ++i) {
                result = result + ((WpdData)this.dataMembers.get(i)).toXML();
            }
        }
        if (this.subCollections != null) {
            for (i = 0; i < this.subCollections.size(); ++i) {
                result = result + ((WpdCollection)this.subCollections.get(i)).toXML();
            }
        }
        result = result + endTag;
        return result;
    }

    public void setDataMembers(ArrayList dataMembers) {
        this.dataMembers = dataMembers;
    }

    public void setSubcollections(ArrayList subCollections) {
        this.subCollections = subCollections;
    }

    public ArrayList dataMembers() {
        return this.dataMembers;
    }

    public ArrayList subCollections() {
        return this.subCollections;
    }

    public synchronized boolean add(WpdData newMember) {
        if (this.dataMembers == null) {
            this.dataMembers = new ArrayList();
        }
        if (newMember == null) {
            return false;
        }
        this.dataMembers.add(newMember);
        return true;
    }

    public synchronized boolean add(WpdCollection newMember) {
        if (this.subCollections == null) {
            this.subCollections = new ArrayList();
        }
        if (newMember == null) {
            return false;
        }
        this.subCollections.add(newMember);
        return true;
    }

    public synchronized boolean remove(int dataId) {
        if (this.dataMembers == null || this.dataMembers.size() <= 0) {
            return false;
        }
        for (int i = this.dataMembers.size() - 1; i >= 0; --i) {
            if (((WpdData)this.dataMembers.get(i)).getId() != dataId) continue;
            this.dataMembers.remove(i);
            return true;
        }
        return false;
    }

    public synchronized boolean remove(String name) {
        if (this.subCollections == null || this.subCollections.size() <= 0) {
            return false;
        }
        for (int i = this.subCollections.size() - 1; i >= 0; --i) {
            WpdCollection collection = (WpdCollection)this.subCollections.get(i);
            if (!collection.getName().equals(name)) continue;
            this.subCollections.remove(i);
            return true;
        }
        return false;
    }

    public WpdData getData(int dataId) {
        if (this.dataMembers == null || this.dataMembers.size() <= 0) {
            return null;
        }
        for (int i = 0; i < this.dataMembers.size(); ++i) {
            WpdData data = (WpdData)this.dataMembers.get(i);
            if (data.getId() != dataId) continue;
            return data;
        }
        return null;
    }

    public WpdCollection getSubcollection(String name) {
        if (this.subCollections == null || this.subCollections.size() <= 0) {
            return null;
        }
        for (int i = 0; i < this.subCollections.size(); ++i) {
            WpdCollection collection = (WpdCollection)this.subCollections.get(i);
            if (!collection.getName().equals(name)) continue;
            return collection;
        }
        return null;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        int i;
        String myIndent = indent + "  ";
        String typeString = null;
        switch (this.type) {
            case 10: {
                typeString = "PMIROOT";
                break;
            }
            case 11: {
                typeString = "NODE";
                break;
            }
            case 12: {
                typeString = "SERVER";
                break;
            }
            case 13: {
                typeString = "MODULE";
                break;
            }
            case 15: {
                typeString = "SUBMODULE";
                break;
            }
            case 14: {
                typeString = "INSTANCE";
                break;
            }
            case 16: {
                typeString = "SUBINSTANCE";
                break;
            }
            case 17: {
                typeString = "COLLECTION";
                break;
            }
            default: {
                typeString = "WRONG_TYPE";
            }
        }
        String res = indent + "WpdCollection name=" + this.name + " type=" + typeString + "\n";
        if (this.dataMembers != null) {
            for (i = 0; i < this.dataMembers.size(); ++i) {
                WpdData data = (WpdData)this.dataMembers.get(i);
                res = res + myIndent + data.toString() + "\n";
            }
        }
        if (this.subCollections != null) {
            for (i = 0; i < this.subCollections.size(); ++i) {
                WpdCollection col = (WpdCollection)this.subCollections.get(i);
                res = res + col.toString(myIndent);
            }
        }
        return res;
    }
}

