/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.ws.pmi.component.PMIImpl;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.io.Serializable;

public abstract class StatisticImpl
implements SPIStatistic,
Serializable {
    static final long serialVersionUID = 1358353157061734347L;
    protected int id;
    long startTime = 0L;
    long lastSampleTime = 0L;
    protected transient boolean enabled = true;
    transient boolean sync = false;
    transient PmiDataInfo dataInfo = null;
    protected static final int TYPE = 0;

    public int getStatisticType() {
        return 0;
    }

    public StatisticImpl(int id) {
        this.id = id;
        this.lastSampleTime = this.startTime = System.currentTimeMillis();
    }

    public StatisticImpl(int id, String name, String unit, String description, long startTime, long lastSampleTime) {
        this.id = id;
        this.startTime = startTime;
        this.lastSampleTime = lastSampleTime;
        startTime = System.currentTimeMillis();
    }

    public String getName() {
        if (this.dataInfo != null) {
            return this.dataInfo.getName();
        }
        return null;
    }

    public String getUnit() {
        if (this.dataInfo != null) {
            return this.dataInfo.getUnit();
        }
        return null;
    }

    public String getDescription() {
        if (this.dataInfo != null) {
            return this.dataInfo.getDescription();
        }
        return null;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastSampleTime() {
        return this.lastSampleTime;
    }

    public void enable(int level) {
        this.sync = level >= 15 ? true : PMIImpl.getSynchronizedUpdate();
        if (!this.enabled) {
            this.enabled = true;
            this.reset();
        }
    }

    public void disable() {
        this.enabled = false;
        this.sync = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void reset() {
        this.lastSampleTime = this.startTime = System.currentTimeMillis();
    }

    public void setDataInfo(PmiModuleConfig config) {
        if (config != null) {
            this.dataInfo = config.getDataInfo(this.id);
        }
    }

    public void setDataInfo(PmiDataInfo info) {
        this.dataInfo = info;
    }

    public void setLastSampleTime(long lastSampleTime) {
        this.lastSampleTime = lastSampleTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public int getId() {
        return this.id;
    }

    public PmiDataInfo getDataInfo() {
        return this.dataInfo;
    }

    public String toXML() {
        StringBuffer res = new StringBuffer();
        res.append("<Statistic id=\"");
        res.append(this.id);
        res.append("\" name=\"");
        res.append(this.getName());
        res.append("\" description=\"");
        res.append(this.getDescription());
        res.append("\" unit=\"");
        res.append(this.getUnit());
        res.append("\" startTime=\"");
        res.append(this.startTime);
        res.append("\" lastSampleTime=\"");
        res.append(this.lastSampleTime);
        res.append("</Statistic>");
        return res.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuffer str = new StringBuffer();
        str.append("name=").append(this.getName());
        str.append(", ID=").append(this.id);
        str.append(", description=").append(this.getDescription());
        str.append(", unit=").append(this.getUnit());
        return str.toString();
    }

    public abstract void update(WSStatistic var1);

    public abstract WSStatistic delta(WSStatistic var1);

    public abstract WSStatistic rateOfChange(WSStatistic var1);

    public abstract WSStatistic copy();

    public abstract void combine(WSStatistic var1);

    public abstract void resetOnClient(WSStatistic var1);

    public abstract void reset(boolean var1);
}

