/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.system;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.pmi.server.PmiRegistry;
import java.util.Calendar;
import java.util.Date;

public class SystemData {
    private byte[] dataStats = new byte[1024];
    private static String jobAndPoolInfo;
    private static int[] poolInfo;
    private static final TraceComponent tc;
    private static long lasttime;
    private static int lastcpu;
    private static Date curdate;
    CpuUtilization cpuUtilization = null;
    FreeMemory freeMemory;

    private static synchronized native String initialize();

    protected static synchronized native int[] poolInts();

    public static synchronized native void setVerbose(int var0);

    public static synchronized int[] getPoolInfo() {
        poolInfo = SystemData.poolInts();
        return poolInfo;
    }

    public static synchronized int getLastPoolSize() {
        return poolInfo[0];
    }

    public static synchronized int getLastReserved() {
        return poolInfo[1];
    }

    public static synchronized int getLastPoolId() {
        return poolInfo[2];
    }

    public static synchronized int getLastMainMem() {
        return poolInfo[3];
    }

    public static synchronized int getPoolLessReserved() {
        return poolInfo[0] - poolInfo[1];
    }

    public static String getLatestJobAndPoolInfo() {
        return jobAndPoolInfo;
    }

    public static String getJobName() {
        return jobAndPoolInfo.substring(0, 10).trim();
    }

    public static String getUserName() {
        return jobAndPoolInfo.substring(10, 20).trim();
    }

    public static String getJobNumber() {
        return jobAndPoolInfo.substring(20, 26).trim();
    }

    public static String getPoolName() {
        return jobAndPoolInfo.substring(26, 36).trim();
    }

    public static String getSubSystemName() {
        return jobAndPoolInfo.substring(36, 46).trim();
    }

    private native int initStats(byte[] var1);

    private native int finalizeStats(byte[] var1);

    public SystemData() {
        if (!PmiRegistry.Z) {
            this.initStats(this.dataStats);
            this.cpuUtilization = new CpuUtilization();
            this.cpuUtilization.get();
        }
    }

    protected void finalize() throws Throwable {
        this.finalizeStats(this.dataStats);
    }

    private native int initCpuUtilization(byte[] var1, byte[] var2);

    private native int getCpuUtilization(byte[] var1, byte[] var2);

    private native int finalizeCpuUtilization(byte[] var1, byte[] var2);

    synchronized native int initProcessCPUUtilization();

    synchronized native int getProcessCPUUtilization();

    synchronized native int getAverageProcessCPUUtilization();

    synchronized native void setNumProcessors(int var1);

    synchronized native int finalizeProcessCPUUtilization();

    public static native void setDebug(int var0);

    public int getCpuUtilization() {
        curdate = Calendar.getInstance().getTime();
        long curtime = curdate.getTime();
        if (curtime - lasttime > 1000L) {
            if (null == this.cpuUtilization) {
                this.cpuUtilization = new CpuUtilization();
            }
            lasttime = curtime;
            lastcpu = this.cpuUtilization.get();
            return lastcpu;
        }
        return lastcpu;
    }

    private native int initFreeMemory(byte[] var1, byte[] var2);

    private native int getFreeMemory(byte[] var1, byte[] var2);

    private native int finalizeFreeMemory(byte[] var1, byte[] var2);

    public int getFreeMemory() {
        if (null == this.freeMemory) {
            this.freeMemory = new FreeMemory();
        }
        return this.freeMemory.get();
    }

    public static void main(String[] args) {
        SystemData stats = new SystemData();
        while (true) {
            try {
                while (true) {
                    System.out.println("CPU Utilization       Free Memory");
                    System.out.println("=================================");
                    for (int k = 0; k < 50; ++k) {
                        System.out.println(stats.getCpuUtilization() + "         " + stats.getFreeMemory());
                        Thread.sleep(1000L);
                    }
                    System.out.println("sleeping for 10 sec...");
                    Thread.sleep(10000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    static {
        tc = Tr.register(SystemData.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
        if (System.getProperty("os.name").equals("OS/400")) {
            System.load("/QSYS.LIB/" + System.getProperty("was.install.library") + ".LIB/QWASSYSDTA.SRVPGM");
            if (null != System.getProperty("SYSDATA.VERBOSE")) {
                SystemData.setVerbose(1);
            }
            jobAndPoolInfo = SystemData.initialize();
            poolInfo = SystemData.poolInts();
        } else {
            int bitmode;
            String CurrentBitmode = System.getProperty("com.ibm.vm.bitmode");
            if (CurrentBitmode == null || CurrentBitmode.length() < 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "System property com.ibm.vm.bitmode is null.Defaulting to 32 bitmode");
                }
                CurrentBitmode = "32";
            }
            if ((bitmode = Integer.parseInt(CurrentBitmode)) == 64 && System.getProperty("os.name").equals("z/OS")) {
                System.loadLibrary("SystemData64");
            } else {
                System.loadLibrary("SystemData");
            }
        }
        lasttime = 0L;
        lastcpu = 0;
        curdate = null;
    }

    private class FreeMemory {
        byte[] data = new byte[1024];

        FreeMemory() {
            SystemData.this.initFreeMemory(SystemData.this.dataStats, this.data);
        }

        int get() {
            return SystemData.this.getFreeMemory(SystemData.this.dataStats, this.data);
        }

        protected void finalize() throws Throwable {
            SystemData.this.finalizeFreeMemory(SystemData.this.dataStats, this.data);
        }
    }

    private class CpuUtilization {
        byte[] data = new byte[1024];

        CpuUtilization() {
            SystemData.this.initCpuUtilization(SystemData.this.dataStats, this.data);
        }

        int get() {
            return SystemData.this.getCpuUtilization(SystemData.this.dataStats, this.data);
        }

        protected void finalize() throws Throwable {
            SystemData.this.finalizeCpuUtilization(SystemData.this.dataStats, this.data);
        }
    }
}

