/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.WebServicesPerf;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.wsspi.pmi.stat.SPIAverageStatistic;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;
import java.util.Hashtable;

public class WebServicesModule
extends PmiAbstractModule
implements WebServicesPerf {
    private static final long serialVersionUID = -764242698796089589L;
    private static TraceComponent tc = Tr.register(WebServicesModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public static final String moduleID = "webServicesModule";
    public static final int defaultLevel = 0;
    private SPICountStatistic numLoadedServices = null;
    public static final int PMI_ID_NUMBER_LOADED_SERVICES = 1;
    private Hashtable serviceData = new Hashtable();
    private int alreadyLoaded = 0;

    public static final String buildInstanceName(String appName, String modName) {
        return appName + "." + modName;
    }

    public WebServicesModule(String appName, String modName) {
        this(WebServicesModule.buildInstanceName(appName, modName));
    }

    public WebServicesModule(String instanceName) {
        super(moduleID, instanceName);
        this.registerModule(this);
        new ModuleAggregate(moduleID, instanceName, "webServicesModule.services");
    }

    public void onServiceLoad(String serviceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onServiceLoad(" + serviceName + ")");
        }
        new ServicePMIModule(this.instanceName, serviceName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onServiceLoad()");
        }
    }

    public void onServiceUnload(String serviceName) {
        ServicePMIModule data;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onServiceUnload(" + serviceName + ")");
        }
        if ((data = (ServicePMIModule)this.serviceData.get(serviceName)) != null) {
            data.destroy();
        } else {
            Tr.warning(tc, "PMI9999E", "serviceName not found");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onServiceUnload()");
        }
    }

    public WebServicesPerf.ServicePerf getService(String serviceName) {
        ServicePMIModule data;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getService(" + serviceName + ")");
        }
        if ((data = (ServicePMIModule)this.serviceData.get(serviceName)) == null) {
            Tr.warning(tc, "PMI9999E", "onServiceLoad(" + serviceName + ") should have been called already!");
            data = new ServicePMIModule(this.instanceName, serviceName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getService()");
        }
        return data;
    }

    protected boolean longCreated(SpdLong data) {
        switch (data.getId()) {
            case 1: {
                this.numLoadedServices = (SPICountStatistic)((Object)data.getStatistic());
                this.numLoadedServices.increment(this.alreadyLoaded);
                this.alreadyLoaded = 0;
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    private final void loadService(String name, ServicePMIModule module) {
        this.serviceData.put(name, module);
        if (this.numLoadedServices != null) {
            this.numLoadedServices.increment();
        } else {
            ++this.alreadyLoaded;
        }
    }

    private final void unloadService(String name) {
        this.serviceData.remove(name);
        if (this.numLoadedServices != null) {
            this.numLoadedServices.increment(-1L);
        } else {
            --this.alreadyLoaded;
        }
    }

    class ServicePMIModule
    extends PmiAbstractModule
    implements WebServicesPerf.ServicePerf {
        private static final long serialVersionUID = 3050417530052021410L;
        SPICountStatistic numberReceived;
        SPICountStatistic numberDispatched;
        SPICountStatistic numberSuccessfull;
        SPITimeStatistic responseTime;
        SPITimeStatistic requestResponseTime;
        SPITimeStatistic dispatchResponseTime;
        SPITimeStatistic replyResponseTime;
        SPIAverageStatistic size;
        SPIAverageStatistic requestSize;
        SPIAverageStatistic replySize;
        public static final int PMI_ID_SERVICES = 10;
        public static final int PMI_ID_NUMBER_RECEIVED = 11;
        public static final int PMI_ID_NUMBER_DISPATCHED = 12;
        public static final int PMI_ID_NUMBER_SUCCESSFULL = 13;
        public static final int PMI_ID_AVERAGE_RESPONSE_TIME = 14;
        public static final int PMI_ID_AVERAGE_REQUEST_RESPONSE_TIME = 15;
        public static final int PMI_ID_AVERAGE_DISPATCH_RESPONSE_TIME = 16;
        public static final int PMI_ID_AVERAGE_REPLY_RESPONSE_TIME = 17;
        public static final int PMI_ID_AVERAGE_SIZE = 18;
        public static final int PMI_ID_AVERAGE_REQUEST_SIZE = 19;
        public static final int PMI_ID_AVERAGE_REPLY_SIZE = 20;

        public ServicePMIModule(String webAppFullName, String serviceName) {
            super(WebServicesModule.moduleID, webAppFullName);
            this.numberReceived = null;
            this.numberDispatched = null;
            this.numberSuccessfull = null;
            this.responseTime = null;
            this.requestResponseTime = null;
            this.dispatchResponseTime = null;
            this.replyResponseTime = null;
            this.size = null;
            this.requestSize = null;
            this.replySize = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ServicePMIModule(" + webAppFullName + "," + serviceName + ")");
            }
            this.submoduleName = "webServicesModule.services";
            this.subinstanceName = serviceName;
            this.type = 16;
            this.registerModule(this);
            WebServicesModule.this.loadService(this.subinstanceName, this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ServicePMIModule()");
            }
        }

        public final boolean isStatisticEnabled(int statisticID) {
            return this.isEnabled(statisticID);
        }

        public void destroy() {
            this.currentLevel = 0;
            Tr.entry(tc, "destroy()");
            this.numberReceived = null;
            this.numberDispatched = null;
            this.numberSuccessfull = null;
            this.responseTime = null;
            this.requestResponseTime = null;
            this.dispatchResponseTime = null;
            this.replyResponseTime = null;
            this.size = null;
            this.requestSize = null;
            this.replySize = null;
            WebServicesModule.this.unloadService(this.subinstanceName);
            this.unregisterModule(this);
            Tr.exit(tc, "destroy()");
        }

        public void onServerReceiveRequest() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.subinstanceName + ".onServerReceiveRequest()");
            }
            this.incrementReceived();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.subinstanceName + ".onServerReceiveRequest()");
            }
        }

        public void onServerForwardRequestToPort(long requestResponseTime) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.subinstanceName + ".onServerForwardRequestToPort()");
            }
            this.incrementDispatched();
            if (requestResponseTime > -1L) {
                this.addRequestResponseTime(requestResponseTime);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.subinstanceName + ".onServerForwardRequestToPort()");
            }
        }

        public void onServerReceiveReplyFromPort(long dispatchResponseTime) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.subinstanceName + ".onServerReceiveReplyFromPort()");
            }
            this.addDispatchResponseTime(dispatchResponseTime);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.subinstanceName + ".onServerReceiveReplyFromPort()");
            }
        }

        public void onServerReturnReply(boolean success, long requestPayloadSize, long replyPayloadSize, long replyResponseTime, long responseTime) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.subinstanceName + ".onServerReturnReply()");
            }
            if (success) {
                this.incrementSuccessfull();
            }
            this.addRequestPayloadSize(requestPayloadSize);
            this.addReplyPayloadSize(replyPayloadSize);
            this.addPayloadSize(requestPayloadSize + replyPayloadSize);
            if (replyResponseTime > -1L) {
                this.addReplyResponseTime(replyResponseTime);
            }
            if (responseTime > -1L) {
                this.addResponseTime(responseTime);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.subinstanceName + ".onServerReturnReply()");
            }
        }

        private final void increment(String name, SPICountStatistic num) {
            if (num != null) {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "increment(" + name + ")");
                }
                num.increment();
                Tr.exit(tc, "increment()");
            }
        }

        private final void add(String name, SPIAverageStatistic stat, long t) {
            if (stat != null) {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "add(" + name + ", time=" + t + ")");
                }
                stat.add(t * 1L);
                Tr.exit(tc, "add()");
            }
        }

        private void incrementReceived() {
            this.increment("numberReceived", this.numberReceived);
        }

        private void incrementDispatched() {
            this.increment("numberDispatched", this.numberDispatched);
        }

        private void incrementSuccessfull() {
            this.increment("numberSuccessfull", this.numberSuccessfull);
        }

        private void addResponseTime(long execTime) {
            this.add("responseTime", this.responseTime, execTime);
        }

        private void addRequestResponseTime(long execTime) {
            this.add("requestResponseTime", this.requestResponseTime, execTime);
        }

        private void addDispatchResponseTime(long execTime) {
            this.add("dispatchResponseTime", this.dispatchResponseTime, execTime);
        }

        private void addReplyResponseTime(long execTime) {
            this.add("replyResponseTime", this.replyResponseTime, execTime);
        }

        private void addPayloadSize(long payloadSize) {
            this.add("payloadSize", this.size, payloadSize);
        }

        private void addRequestPayloadSize(long requestPayloadSize) {
            this.add("requestPayloadSize", this.requestSize, requestPayloadSize);
        }

        private void addReplyPayloadSize(long replyPayloadSize) {
            this.add("replyPayloadSize", this.replySize, replyPayloadSize);
        }

        protected boolean longCreated(SpdLong data) {
            switch (data.getId()) {
                case 11: {
                    this.numberReceived = (SPICountStatistic)((Object)data.getStatistic());
                    return true;
                }
                case 12: {
                    this.numberDispatched = (SPICountStatistic)((Object)data.getStatistic());
                    return true;
                }
                case 13: {
                    this.numberSuccessfull = (SPICountStatistic)((Object)data.getStatistic());
                    return true;
                }
            }
            return false;
        }

        protected boolean statCreated(SpdStat data) {
            switch (data.getId()) {
                case 14: {
                    this.responseTime = (SPITimeStatistic)((Object)data.getStatistic());
                    return true;
                }
                case 16: {
                    this.dispatchResponseTime = (SPITimeStatistic)((Object)data.getStatistic());
                    return true;
                }
                case 15: {
                    this.requestResponseTime = (SPITimeStatistic)((Object)data.getStatistic());
                    return true;
                }
                case 17: {
                    this.replyResponseTime = (SPITimeStatistic)((Object)data.getStatistic());
                    return true;
                }
                case 18: {
                    this.size = (SPIAverageStatistic)((Object)data.getStatistic());
                    return true;
                }
                case 19: {
                    this.requestSize = (SPIAverageStatistic)((Object)data.getStatistic());
                    return true;
                }
                case 20: {
                    this.replySize = (SPIAverageStatistic)((Object)data.getStatistic());
                    return true;
                }
            }
            return false;
        }

        public String getModuleID() {
            return WebServicesModule.moduleID;
        }

        public int getDefaultLevel() {
            return 0;
        }
    }
}

