/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.jvmpi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdLongExternalValue;
import com.ibm.websphere.pmi.server.SpdStatExternalValue;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.server.data.SpdLongExternal;
import com.ibm.ws.pmi.server.data.SpdStatExternal;
import com.ibm.ws.pmi.server.jvmpi.JvmpiGroup;
import com.ibm.ws.pmi.server.jvmpi.JvmpiJni;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import com.ibm.wsspi.pmi.stat.SPIStatistic;

public class JvmpiInfo
implements PmiConstants {
    private int dataId;
    private int dataType;
    private int code;
    private int level;
    protected SpdData pmiData = null;
    static final int DATAID_OFFSET = 10;
    static final int INT = 0;
    static final int LONG = 1;
    static final int DOUBLE = 2;
    static final int STAT = 3;
    protected static TraceComponent tc = Tr.register(JvmpiInfo.class, null, "com.ibm.ws.pmi.properties.PMIMessages");

    public JvmpiInfo(int dataId, int dataType, int code, int level) {
        this.dataId = dataId;
        this.dataType = dataType;
        this.code = code;
        this.level = 15;
        switch (dataType) {
            case 1: {
                this.pmiData = new SpdLongExternal(dataId, new JvmpiLongData(code));
                this.pmiData.disable();
                break;
            }
            case 3: {
                this.pmiData = new SpdStatExternal(dataId, new JvmpiTimeStatistic(code));
                this.pmiData.disable();
                break;
            }
        }
    }

    public void setLevel(int newLevel) {
        if (newLevel >= this.level) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void disable() {
        if (this.pmiData == null) {
            return;
        }
        this.pmiData.disable();
    }

    public void enable() {
        if (this.pmiData != null) {
            this.pmiData.enable(this.level);
            return;
        }
        switch (this.dataType) {
            case 1: {
                this.pmiData = new SpdLongExternal(this.dataId, new JvmpiLongData(this.code));
                break;
            }
            case 3: {
                this.pmiData = new SpdStatExternal(this.dataId, new JvmpiTimeStatistic(this.code));
                break;
            }
        }
    }

    class JvmpiTimeStatistic
    implements SpdStatExternalValue {
        private int code;
        private long startTime = 0L;
        private TimeStatisticImpl jvmpiData;

        public JvmpiTimeStatistic(int code) {
            this.code = code;
            this.startTime = PmiUtil.currentTime();
            this.jvmpiData = new TimeStatisticImpl(code);
        }

        public SPIStatistic getStatValue() {
            this.updateTimeStat(JvmpiJni.getStatData(this.code));
            return this.jvmpiData;
        }

        public void updateStatistic() {
            this.updateTimeStat(JvmpiJni.getStatData(this.code));
        }

        private void updateTimeStat(long[] d) {
            if (d != null) {
                this.jvmpiData.set(d[0], d[1], d[2], d[3], d[4], this.startTime, PmiUtil.currentTime());
            } else {
                this.jvmpiData.set(-1L, -1L, -1L, -1L, -1.0, -1L, -1L);
            }
        }
    }

    class JvmpiLongData
    implements SpdLongExternalValue {
        private int code;
        private CountStatisticImpl jvmpiData;

        public JvmpiLongData(int code) {
            this.code = code;
            this.jvmpiData = new CountStatisticImpl(code);
        }

        public SPIStatistic getLongValue() {
            return this.jvmpiData;
        }

        public void updateStatistic() {
            if (tc.isDebugEnabled()) {
                if (JvmpiGroup.jvmpiDebug == 0) {
                    Tr.debug(tc, "Enabling JVMPI native debug");
                    JvmpiJni.setDebug(1);
                    JvmpiGroup.jvmpiDebug = 1;
                }
            } else if (JvmpiGroup.jvmpiDebug == 1) {
                Tr.debug(tc, "Disabling JVMPI native debug");
                JvmpiJni.setDebug(0);
                JvmpiGroup.jvmpiDebug = 0;
            }
            this.jvmpiData.setCount(JvmpiJni.getLong(this.code));
        }
    }
}

