/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.data;

import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.ws.pmi.server.data.SpdDataImpl;
import com.ibm.ws.pmi.stat.AverageStatisticImpl;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;

public class SpdStatImpl
extends SpdDataImpl
implements SpdStat {
    private static final long serialVersionUID = -109459667146296521L;
    private AverageStatisticImpl stat = null;

    public SpdStatImpl(PmiModuleConfig moduleConfig, String name) {
        super(moduleConfig, name);
        this.stat = new TimeStatisticImpl(this.dataId);
    }

    public SpdStatImpl(int dataId) {
        super(dataId);
        this.stat = new TimeStatisticImpl(dataId);
    }

    public SpdStatImpl(int type, int dataId) {
        super(dataId);
        this.stat = type == 6 ? new AverageStatisticImpl(dataId) : new TimeStatisticImpl(dataId);
    }

    public void add(double val) {
        this.stat.add((long)val);
    }

    public void reset(boolean resetAll) {
        this.stat.reset(resetAll);
    }

    public StatisticImpl getStatistic() {
        return this.stat;
    }

    public void combine(SpdStat other) {
        if (other == null) {
            return;
        }
        if (this.stat.isEnabled() && other.isEnabled()) {
            this.stat.combine(other.getStatistic());
        }
    }

    public void enable(int level) {
        super.enable(level);
        this.stat.enable(level);
    }

    public void disable() {
        super.disable();
        this.stat.disable();
    }

    public boolean isEnabled() {
        return this.stat.isEnabled();
    }
}

