/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiJmxMapper;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.extutils.AdminUtil;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.StatLevelSpec;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.collaborator.PmiJmxBridge;
import com.ibm.ws.pmi.component.PMIImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.server.PmiConfigManager;
import com.ibm.ws.pmi.server.PmiJmxMapParser;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.stat.StatsConfigHelper;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.ws.pmi.wire.WpdCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.management.ObjectName;

public class PmiRegistry
implements PmiConstants {
    public static final String COPYRIGHT = "Product 5639-D57,  (C) COPYRIGHT International Business Machines Corp., 2000, 2004\nAll Rights Reserved * Licensed Materials - Property of IBM\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String MSG_BUNDLE = "com.ibm.ws.pmi.properties.PMIMessages";
    public static final boolean Z = AdminHelper.getPlatformHelper().isZOS();
    public static final String PLATFORM = PmiRegistry.initPlatform();
    private static boolean disabled = true;
    private static boolean initialized = false;
    private static boolean allLevelNone = true;
    private static boolean beanMethodDisabled = true;
    public static String nodeName = "mynode";
    public static String serverName = "myserver";
    private static ModuleItem moduleRoot;
    private static int[] rootEnabled;
    private static Hashtable moduleAggregates;
    private static HashMap mbeanToModuleMap;
    private static PerfLevelDescriptor[] _plds;
    private static final TraceComponent tc;
    public static PmiJmxMapper jmxMapper;
    private static ObjectName serverMBean;
    private static final String beanMethodWccmType = "beanModule#beanModule.methods";

    private static String initPlatform() {
        if (Z) {
            return "zos";
        }
        return "distributed";
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        moduleRoot = new ModuleItem();
        try {
            jmxMapper = new PmiJmxMapper(null, null, true);
        }
        catch (Exception adminex) {
            Tr.warning(tc, "PMI0004W", adminex.getMessage());
            disabled = true;
        }
        PmiJmxMapParser parser2 = new PmiJmxMapParser(jmxMapper);
        parser2.parse("/com/ibm/websphere/pmi/xml/pmiJmxMapper.xml");
        parser2.parseExtensions();
        AdminUtil adminUtil = jmxMapper.getAdminUtil();
        disabled = adminUtil == null;
    }

    public static boolean isDisabled() {
        return disabled;
    }

    public static void disable() {
        disabled = true;
    }

    public static void enable() {
        disabled = false;
    }

    public static boolean isAllLevelNone() {
        System.out.println("PmiRegistry.isAllLevelNone()");
        new Exception().fillInStackTrace().printStackTrace();
        return allLevelNone;
    }

    public static boolean isBeanMethodDisabled() {
        if (moduleRoot != null) {
            beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
            return beanMethodDisabled;
        }
        return beanMethodDisabled;
    }

    public static void setAllLevelNone(boolean allNone) {
        allLevelNone = allNone;
    }

    public static synchronized ModuleItem registerModule(PmiModule instance) {
        if (disabled) {
            return null;
        }
        if (!PmiRegistry.validateModule(instance)) {
            Tr.entry(tc, "registerModule");
            Tr.exit(tc, "registerModule - module is null");
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerModule: " + instance.getModuleID() + ", " + instance.getName());
        }
        String[] path = instance.getPath();
        ModuleItem parent = null;
        if (path == null || path.length == 0) {
            Tr.warning(tc, "PMI0001W", instance.getName());
            return null;
        }
        if (path.length == 1) {
            parent = moduleRoot;
        } else {
            String[] parentPath = PmiRegistry.getParentPath(path);
            parent = moduleRoot.add(parentPath, 0);
        }
        if (!PMIImpl.isCustomSet()) {
            instance.setInstrumentationBySet(PMIImpl.getStatisticSet());
        } else {
            int parentLevel;
            int[][] fgSpec = PmiConfigManager.getSpec(instance.getPath());
            if (fgSpec != null) {
                if (fgSpec[0] != null) {
                    instance.setInstrumentationLevel(fgSpec[0][0]);
                } else {
                    instance.setFineGrainedInstrumentation(fgSpec[1], fgSpec[2]);
                }
            } else if (path.length == 1) {
                parentLevel = PmiRegistry.moduleRoot.level;
                if (parentLevel == -2) {
                    instance.setFineGrainedInstrumentation(rootEnabled, new int[0]);
                } else {
                    instance.setInstrumentationLevel(parentLevel);
                }
            } else {
                parentLevel = parent.getInstance().getInstrumentationLevel();
                if (parentLevel == -2) {
                    ModuleItem aggParent = PmiRegistry._getAggregateParent(parent);
                    if (aggParent != null) {
                        instance.setFineGrainedInstrumentation(aggParent.getInstance().getEnabled(), aggParent.getInstance().getEnabledSync());
                        int[] enabled = instance.getEnabled();
                        if (enabled == null || enabled.length == 0) {
                            ModuleItem aggConfigParent = PmiRegistry._getAggregateParent(parent);
                            fgSpec = null;
                            while (aggConfigParent != null && fgSpec == null) {
                                if (aggConfigParent != null && aggConfigParent.getInstance() instanceof ModuleAggregate) {
                                    fgSpec = PmiConfigManager.getSpec(aggConfigParent.getInstance().getPath());
                                }
                                if (fgSpec != null) continue;
                                aggConfigParent = aggConfigParent.getParent();
                            }
                            if (fgSpec != null) {
                                if (fgSpec[0] != null) {
                                    instance.setInstrumentationLevel(fgSpec[0][0]);
                                } else {
                                    instance.setFineGrainedInstrumentation(fgSpec[1], fgSpec[2]);
                                }
                            }
                        }
                    } else if (PmiRegistry.moduleRoot.level == -2 && rootEnabled != null && rootEnabled.length > 0 && rootEnabled[0] == -3) {
                        instance.setFineGrainedInstrumentation(rootEnabled, new int[0]);
                    } else {
                        instance.setInstrumentationLevel(parentLevel);
                    }
                } else {
                    instance.setInstrumentationLevel(parentLevel);
                }
            }
        }
        ModuleItem retItem = new ModuleItem(instance);
        if (!parent.add(retItem)) {
            Tr.warning(tc, "PMI0023W", instance.getName());
            if (tc.isDebugEnabled()) {
                String p = "root";
                if (parent.getInstance() != null) {
                    p = parent.getInstance().getName();
                }
                StringBuffer b = new StringBuffer("Current entries under: " + p);
                ModuleItem[] c = parent.children();
                if (c != null) {
                    for (int k = 0; k < c.length; ++k) {
                        PmiModule pm = c[k].getInstance();
                        if (pm == null) continue;
                        b.append("\r\n").append(pm.getName());
                    }
                }
                Tr.debug(tc, b.toString());
            }
            retItem = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerModule");
        }
        return retItem;
    }

    private static ModuleItem _getAggregateParent(ModuleItem mi) {
        ModuleItem p = mi;
        do {
            if (p.getInstance() == null) {
                return null;
            }
            if (!(p.getInstance() instanceof ModuleAggregate)) continue;
            return p;
        } while ((p = p.getParent()) != null);
        return null;
    }

    public static synchronized void unregisterModule(PmiModule instance) {
        if (disabled) {
            return;
        }
        if (instance == null) {
            return;
        }
        String[] path = instance.getPath();
        if (path == null || path.length == 0) {
            return;
        }
        for (int k = 0; k < path.length; ++k) {
            if (path[k] != null) continue;
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterModule: " + instance.getModuleID() + ", " + instance.getName());
        }
        String[] parentPath = new String[path.length - 1];
        System.arraycopy(path, 0, parentPath, 0, parentPath.length);
        ModuleItem parent = moduleRoot.find(parentPath, 0);
        if (parent != null) {
            String[] mypath;
            parent.remove(parent.find(path[path.length - 1]));
            if (instance.isCustomModule()) {
                return;
            }
            if (!(parent.children != null && parent.children.size() != 0 || parent.getInstance() == null || (mypath = parent.getInstance().getPath()).length == 2 && mypath[0].equals("webServicesModule"))) {
                parent.getInstance().unregister();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterModule");
        }
    }

    private static boolean validateModule(PmiModule instance) {
        return instance != null;
    }

    private static String[] getParentPath(String[] path) {
        if (path == null || path.length <= 1) {
            return null;
        }
        String[] parentPath = new String[path.length - 1];
        System.arraycopy(path, 0, parentPath, 0, parentPath.length);
        return parentPath;
    }

    public static synchronized boolean addModuleInfo(String moduleID, String modulePrefix) {
        return PerfModules.addModuleInfo(modulePrefix + moduleID) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ModuleAggregate getModuleAggregate(String moduleID) {
        ModuleAggregate aggregate = (ModuleAggregate)moduleAggregates.get(moduleID);
        if (aggregate != null) {
            return aggregate;
        }
        Hashtable hashtable = moduleAggregates;
        synchronized (hashtable) {
            aggregate = (ModuleAggregate)moduleAggregates.get(moduleID);
            if (aggregate != null) {
                return aggregate;
            }
            PmiModuleConfig config = PmiRegistry.getConfig(moduleID);
            if (config == null) {
                return null;
            }
            aggregate = new ModuleAggregate(moduleID);
            moduleAggregates.put(moduleID, aggregate);
            return aggregate;
        }
    }

    public static PmiModuleConfig getConfig(String moduleID) {
        if (disabled) {
            return null;
        }
        return StatsConfigHelper.getTranslatedStatsConfig(moduleID);
    }

    public static PmiModuleConfig[] getConfigs() {
        return PmiRegistry.getConfigs(null);
    }

    public static PmiModuleConfig[] getConfigs(Locale l) {
        if (disabled) {
            return null;
        }
        PmiModuleConfig[] allConfigs = PerfModules.getConfigs();
        for (int i = 0; i < allConfigs.length; ++i) {
            if (allConfigs[i].getMbeanType() == null) {
                String mbeanType = jmxMapper.getMBeanType(allConfigs[i].getShortName());
                allConfigs[i].setMbeanType(mbeanType);
            }
            StatsConfigHelper.translateAndCache(allConfigs[i], l);
        }
        return StatsConfigHelper.getAllConfigs(null);
    }

    public static PmiModule findPmiModule(MBeanStatDescriptor msd) {
        if (disabled) {
            return null;
        }
        ModuleItem item = PmiRegistry.findModuleItem(msd);
        if (item == null) {
            return null;
        }
        return item.getInstance();
    }

    public static PmiModule findPmiModule(DataDescriptor dd) {
        if (disabled) {
            return null;
        }
        ModuleItem item = PmiRegistry.findModuleItem(dd);
        if (item == null) {
            return null;
        }
        return item.getInstance();
    }

    public static ModuleItem findModuleItem(ObjectName mbeanName) {
        DataDescriptor dd;
        if (disabled) {
            return null;
        }
        if (mbeanName == null) {
            return null;
        }
        if (!PmiRegistry.isSameNodeAndServer(mbeanName)) {
            return null;
        }
        MBeanStatDescriptor mbsd = new MBeanStatDescriptor(mbeanName);
        String key = mbsd.getIdentifier();
        ModuleItem item = (ModuleItem)mbeanToModuleMap.get(key);
        if (item != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "findModuleItem() for: " + key);
            }
            return item;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, key);
        }
        if ((dd = jmxMapper.getDataDescriptor(mbeanName, null)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0002W", mbeanName.toString());
            }
            return null;
        }
        item = PmiRegistry.findModuleItem(dd);
        if (item == null) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0002W", dd.toString());
            }
            return null;
        }
        PmiRegistry.setMBeanToModuleMap(item, mbsd);
        return item;
    }

    public static ModuleItem findModuleItem(MBeanStatDescriptor msd) {
        if (disabled) {
            return null;
        }
        if (msd == null) {
            return null;
        }
        if (!PmiRegistry.isSameNodeAndServer(msd.getObjectName())) {
            return null;
        }
        String key = msd.getIdentifier();
        if (key == null) {
            return null;
        }
        ModuleItem item = (ModuleItem)mbeanToModuleMap.get(key);
        if (item != null) {
            return item;
        }
        DataDescriptor targetDD = PmiRegistry.mBeanToDataDescriptor(msd);
        if (targetDD == null) {
            return null;
        }
        if (targetDD.getPath() == null) {
            return moduleRoot;
        }
        ModuleItem targetMI = PmiRegistry.findModuleItem(targetDD);
        if (targetMI == null) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0002W", targetDD.toString());
            }
            return null;
        }
        PmiRegistry.setMBeanToModuleMap(targetMI, msd);
        return targetMI;
    }

    public static ModuleItem findModuleItem(String[] path) {
        if (disabled) {
            return null;
        }
        if (path == null || path[0].equals("pmi")) {
            return moduleRoot;
        }
        return moduleRoot.find(path, 0);
    }

    public static ModuleItem findModuleItem(DataDescriptor dd) {
        if (disabled) {
            return null;
        }
        if (dd == null || dd.getModuleName().equals("pmi")) {
            return moduleRoot;
        }
        return moduleRoot.find(dd.getPath(), 0);
    }

    private static ModuleItem findParentModuleItem(DataDescriptor dd) {
        String[] path = dd.getPath();
        String[] parentPath = new String[path.length - 1];
        System.arraycopy(path, 0, parentPath, 0, parentPath.length);
        return PmiRegistry.findModuleItem(new DataDescriptor(parentPath));
    }

    private static boolean isSameNodeAndServer(ObjectName mName) {
        String processName = mName.getKeyProperty("process");
        String nodeName = mName.getKeyProperty("node");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isSameNodeAndServer: " + mName.toString());
        }
        if (processName != null && !processName.equals(serverName)) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0002W", mName.toString() + ", expected process name is " + serverName);
            }
            return false;
        }
        if (nodeName != null && !nodeName.equals(PmiRegistry.nodeName)) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0002W", mName.toString() + ", expected node name is " + PmiRegistry.nodeName);
            }
            return false;
        }
        return true;
    }

    public static DataDescriptor[] listMembers() {
        if (disabled) {
            return null;
        }
        ModuleItem[] modItems = moduleRoot.children();
        if (modItems == null) {
            return null;
        }
        DataDescriptor[] res = new DataDescriptor[modItems.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new DataDescriptor(new String[]{modItems[i].getInstance().getName()});
        }
        return res;
    }

    public static DataDescriptor[] listMembers(DataDescriptor dd) {
        if (disabled) {
            return null;
        }
        if (dd == null || dd.getPath() == null) {
            return PmiRegistry.listMembers();
        }
        if (dd.getType() == -1) {
            return null;
        }
        ModuleItem module = PmiRegistry.findModuleItem(dd);
        if (module == null) {
            return null;
        }
        return module.listMembers(dd, false);
    }

    public static MBeanStatDescriptor[] listStatMembers(ObjectName oname) {
        if (disabled) {
            return null;
        }
        if (oname == null) {
            return null;
        }
        return PmiRegistry.listStatMembers(new MBeanStatDescriptor(oname));
    }

    public static MBeanStatDescriptor[] listStatMembers(MBeanStatDescriptor msd) {
        if (disabled) {
            return null;
        }
        ModuleItem module = PmiRegistry.findModuleItem(msd);
        if (module == null) {
            return null;
        }
        ModuleItem[] miChildren = module.children();
        if (miChildren == null || miChildren.length == 0) {
            return null;
        }
        MBeanStatDescriptor[] retMsds = new MBeanStatDescriptor[miChildren.length];
        for (int i = 0; i < miChildren.length; ++i) {
            retMsds[i] = miChildren[i].getInstance().getMBeanStatDescriptor();
        }
        return retMsds;
    }

    public static StatDescriptor[] listStatMembers(StatDescriptor sd, boolean recursive) {
        if (disabled) {
            return null;
        }
        ModuleItem module = null;
        module = sd == null ? moduleRoot : PmiRegistry.findModuleItem(sd.getPath());
        if (module == null) {
            return null;
        }
        ArrayList list = module.listChildStatDescriptors(recursive);
        int n = list.size();
        StatDescriptor[] ret = new StatDescriptor[n];
        for (int k = 0; k < n; ++k) {
            ret[k] = (StatDescriptor)list.get(k);
        }
        return ret;
    }

    public static WpdCollection get(DataDescriptor dd, boolean recursive) {
        if (disabled) {
            return null;
        }
        return PmiRegistry.getStats(PmiRegistry.findModuleItem(dd), recursive);
    }

    public static WpdCollection[] gets(DataDescriptor[] dds, boolean recursive) {
        if (disabled) {
            return null;
        }
        WpdCollection[] ret = new StatsImpl[dds.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = PmiRegistry.getStats(PmiRegistry.findModuleItem(dds[i]), recursive);
        }
        return ret;
    }

    private static StatsImpl getStats(ModuleItem moduleItem, boolean recursive) {
        if (moduleItem == null) {
            return null;
        }
        return moduleItem.getStats(recursive);
    }

    public static StatsImpl getStats(DataDescriptor dd, boolean recursive) {
        if (disabled) {
            return null;
        }
        return PmiRegistry.getStats(PmiRegistry.findModuleItem(dd), recursive);
    }

    public static StatsImpl[] getStats(DataDescriptor[] dd, boolean recursive) {
        if (disabled) {
            return null;
        }
        StatsImpl[] stats = new StatsImpl[dd.length];
        for (int i = 0; i < dd.length; ++i) {
            stats[i] = PmiRegistry.getStats(dd[i], recursive);
        }
        return stats;
    }

    public static StatsImpl[] getStats(StatDescriptor[] dd, boolean recursive) {
        if (disabled) {
            return null;
        }
        StatsImpl[] stats = new StatsImpl[dd.length];
        for (int i = 0; i < dd.length; ++i) {
            stats[i] = PmiRegistry.getStats(PmiRegistry.findModuleItem(dd[i].getPath()), recursive);
        }
        return stats;
    }

    public static StatsImpl getStats(MBeanStatDescriptor msd, boolean recursive) {
        if (disabled) {
            return null;
        }
        if (msd == null) {
            return null;
        }
        return PmiRegistry.getStats(PmiRegistry.findModuleItem(msd), recursive);
    }

    public static StatsImpl[] getStats(MBeanStatDescriptor[] msds, boolean recursive) {
        if (disabled) {
            return null;
        }
        StatsImpl[] collections = new StatsImpl[msds.length];
        for (int i = 0; i < msds.length; ++i) {
            collections[i] = PmiRegistry.getStats(msds[i], recursive);
        }
        return collections;
    }

    public static StatsImpl[] getStats(ObjectName[] oname, boolean recursive) {
        if (disabled) {
            return null;
        }
        StatsImpl[] collections = new StatsImpl[oname.length];
        for (int i = 0; i < oname.length; ++i) {
            collections[i] = PmiRegistry.getStats(PmiRegistry.findModuleItem(oname[i]), recursive);
        }
        return collections;
    }

    public static MBeanLevelSpec[] getMBeanLevelSpecs(ObjectName mName, StatDescriptor sd, boolean recursive) {
        if (disabled) {
            return null;
        }
        if (mName == null) {
            return null;
        }
        ModuleItem item = PmiRegistry.findModuleItem(new MBeanStatDescriptor(mName, sd));
        if (item == null) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0002W", mName.toString());
            }
            return null;
        }
        if (!recursive) {
            if (item.getInstance() != null) {
                int level = item.getInstance().getInstrumentationLevel();
                MBeanLevelSpec mls = new MBeanLevelSpec(mName, sd, level);
                if (level == -2) {
                    mls.setEnabled(item.getInstance().getEnabled());
                }
                return new MBeanLevelSpec[]{mls};
            }
            return null;
        }
        ArrayList res = item.getPerfLevelDescriptors(true);
        MBeanLevelSpec[] retArray = new MBeanLevelSpec[res.size()];
        for (int i = 0; i < retArray.length; ++i) {
            retArray[i] = (MBeanLevelSpec)res.get(i);
        }
        return retArray;
    }

    public static StatLevelSpec[] getInstrumentationLevel(StatDescriptor sd, boolean recursive) {
        if (disabled) {
            return null;
        }
        ModuleItem item = PmiRegistry.findModuleItem(sd.getPath());
        if (item == null) {
            return null;
        }
        if (!recursive) {
            StatLevelSpec[] pld = new StatLevelSpec[1];
            PmiModule instance = item.getInstance();
            if (instance != null) {
                pld[0] = new StatLevelSpec(sd.getPath(), instance.getEnabled());
                return pld;
            }
            return null;
        }
        ArrayList res = item.getStatLevelSpec(recursive);
        StatLevelSpec[] pld = new StatLevelSpec[res.size()];
        for (int i = 0; i < pld.length; ++i) {
            pld[i] = (StatLevelSpec)res.get(i);
        }
        return pld;
    }

    public static PerfLevelDescriptor[] getInstrumentationLevel(DataDescriptor dd, boolean recursive) {
        if (disabled) {
            return null;
        }
        ModuleItem item = PmiRegistry.findModuleItem(dd);
        if (item == null) {
            return null;
        }
        if (!recursive) {
            PerfLevelDescriptor[] pld = new PerfLevelDescriptor[1];
            String[] path = item.getInstance().getPath();
            PmiModule instance = item.getInstance();
            pld[0] = new PerfLevelDescriptor(instance.getPath(), instance.getInstrumentationLevel(), instance.getModuleID());
            return pld;
        }
        ArrayList res = item.getPerfLevelDescriptors(false);
        PerfLevelDescriptor[] pld = new PerfLevelDescriptor[res.size()];
        for (int i = 0; i < pld.length; ++i) {
            pld[i] = (PerfLevelDescriptor)res.get(i);
        }
        return pld;
    }

    public static int getInstrumentationLevel(String[] path) {
        if (disabled) {
            return -1;
        }
        DataDescriptor dd = new DataDescriptor(path);
        ModuleItem item = PmiRegistry.findModuleItem(dd);
        if (item == null) {
            return -1;
        }
        return item.getInstance().getInstrumentationLevel();
    }

    public static PerfLevelDescriptor[] getAllInstrumentationLevels() {
        if (disabled) {
            return null;
        }
        ArrayList res = moduleRoot.getPerfLevelDescriptors(false);
        PerfLevelDescriptor[] retArray = new PerfLevelDescriptor[res.size()];
        for (int i = 0; i < retArray.length; ++i) {
            retArray[i] = (PerfLevelDescriptor)res.get(i);
        }
        return retArray;
    }

    public static String getInstrumentationLevelString() {
        if (disabled) {
            return null;
        }
        Map modules = PmiRegistry.moduleRoot.children;
        if (modules == null) {
            return "";
        }
        PerfLevelDescriptor[] plds = new PerfLevelDescriptor[modules.size()];
        Iterator values = modules.values().iterator();
        int i = 0;
        while (values.hasNext()) {
            PmiModule instance = ((ModuleItem)values.next()).getInstance();
            plds[i++] = new PerfLevelDescriptor(instance.getPath(), instance.getInstrumentationLevel(), instance.getModuleID());
        }
        return PmiUtil.getStringFromPerfLevelSpecs(plds);
    }

    public static String getInstrumentationLevelString60() {
        StatLevelSpec[] specs = PmiRegistry.getInstrumentationLevel(new StatDescriptor(null), true);
        if (specs == null || specs.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(specs[0].toString());
        for (int k = 1; k < specs.length; ++k) {
            buf.append(":").append(specs[k].toString());
        }
        return buf.toString();
    }

    public static void setInstrumentationLevel(StatLevelSpec[] plds, boolean recursive) {
        if (disabled) {
            return;
        }
        for (int i = 0; i < plds.length; ++i) {
            ModuleItem item;
            if (plds[i] == null || (item = PmiRegistry.findModuleItem(plds[i].getPath())) == null) continue;
            if (item.getInstance() == null) {
                int[] e = plds[i].getEnabled();
                if (e == null || e.length <= 0 || e[0] != -3) continue;
                item.setInstanceLevel(e, new int[0], -2, recursive);
                continue;
            }
            item.setInstanceLevel(plds[i].getEnabled(), new int[0], -2, recursive);
        }
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    public static void setInstrumentationLevel(PerfLevelDescriptor pld, boolean recursive) {
        if (disabled) {
            return;
        }
        PmiRegistry.setLevel(pld, recursive);
        allLevelNone = PmiRegistry.checkAllLevelNone(moduleRoot);
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    public static void setInstrumentationLevel(PerfLevelDescriptor[] plds, boolean recursive) {
        if (disabled) {
            return;
        }
        for (int i = 0; i < plds.length; ++i) {
            PmiRegistry.setLevel(plds[i], recursive);
        }
        allLevelNone = PmiRegistry.checkAllLevelNone(moduleRoot);
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    private static void setLevel(PerfLevelDescriptor pld, boolean recursive) {
        if (pld == null) {
            return;
        }
        String[] path = pld.getPath();
        ModuleItem item = null;
        if (path == null) {
            Tr.warning(tc, "PMI0001W", "PmiRegistry.setLevel");
            return;
        }
        if (path.length == 1 && path[0].equals("pmi")) {
            item = moduleRoot;
        } else if (path[0].equals("pmi")) {
            String[] thisPath = new String[path.length - 1];
            System.arraycopy(path, 1, thisPath, 0, thisPath.length);
            item = PmiRegistry.findModuleItem(new DataDescriptor(thisPath));
        }
        if (item != null) {
            item.setInstanceLevel(null, null, pld.getLevel(), recursive);
        }
    }

    public static void setMBeanLevel(MBeanLevelSpec mls, boolean recursive) {
        if (disabled) {
            return;
        }
        if (mls == null) {
            return;
        }
        PmiRegistry.setLevel(mls, recursive);
        allLevelNone = PmiRegistry.checkAllLevelNone(moduleRoot);
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    public static void setMBeanLevel(MBeanLevelSpec[] mlss, boolean recursive) {
        if (disabled) {
            return;
        }
        if (mlss == null || mlss.length == 0) {
            return;
        }
        for (int i = 0; i < mlss.length; ++i) {
            if (mlss[i] == null) continue;
            PmiRegistry.setLevel(mlss[i], recursive);
        }
        allLevelNone = PmiRegistry.checkAllLevelNone(moduleRoot);
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    public static void setInstrumentationLevel(String statisticSet) {
        if (statisticSet != null && !statisticSet.equals(PMIImpl.getStatisticSet()) && PmiConfigManager.isValidStatisticSet(statisticSet)) {
            moduleRoot.setInstanceLevel_Set(statisticSet, true);
        }
    }

    private static void setLevel(MBeanLevelSpec mls, boolean recursive) {
        if (mls == null) {
            return;
        }
        MBeanStatDescriptor msd = new MBeanStatDescriptor(mls.getObjectName(), mls.getStatDescriptor());
        ModuleItem item = PmiRegistry.findModuleItem(msd);
        if (item != null) {
            item.setInstanceLevel(mls.getEnabled(), new int[0], mls.getLevel(), recursive);
        } else if (tc.isDebugEnabled()) {
            Tr.warning(tc, "PMI0002W", mls.toString());
        }
    }

    private static boolean checkAllLevelNone(ModuleItem item) {
        if (item.instance != null && item.instance.getInstrumentationLevel() != 0) {
            return false;
        }
        if (item.children == null) {
            return true;
        }
        ModuleItem child2 = null;
        for (ModuleItem child2 : item.children.values()) {
            if (PmiRegistry.checkAllLevelNone(child2)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkBeanMethodDisabled(ModuleItem item) {
        if (item.instance != null && !item.instance.getModuleID().equals("beanModule")) {
            return true;
        }
        if (item.instance != null) {
            int[] en;
            int inLevel = item.instance.getInstrumentationLevel();
            if (inLevel >= 7) {
                return false;
            }
            if (inLevel == -2 && item.instance.getModuleID().equals("beanModule") && (en = item.instance.getEnabled()) != null && en.length > 0) {
                return false;
            }
        }
        if (item.children == null) {
            return true;
        }
        ModuleItem child2 = null;
        for (ModuleItem child2 : item.children.values()) {
            if (!child2.getInstance().getModuleID().equals("beanModule") || PmiRegistry.checkBeanMethodDisabled(child2)) continue;
            return false;
        }
        return true;
    }

    private static int retrieveLevel(String[] path) {
        if (_plds == null) {
            return -1;
        }
        boolean isRoot = false;
        String[] fullPath = null;
        if (path == null || path.length == 0) {
            fullPath = new String[]{"pmi"};
            isRoot = true;
        } else {
            fullPath = new String[path.length + 1];
            fullPath[0] = "pmi";
            System.arraycopy(path, 0, fullPath, 1, path.length);
        }
        for (int i = 0; i < _plds.length; ++i) {
            if (_plds[i].comparePath(fullPath) != 0) continue;
            return _plds[i].getLevel();
        }
        return -1;
    }

    public static void restorePmiLevel() {
        if (disabled) {
            return;
        }
        PmiRegistry.moduleRoot.level = -2;
        int[][] rootLevel = PmiConfigManager.getSpec(new String[]{"pmi"});
        if (rootLevel == null) {
            return;
        }
        if (rootLevel[0] != null) {
            PmiRegistry.moduleRoot.level = rootLevel[0][0];
        } else if (rootLevel[1] != null && rootLevel[1].length > 1 || rootLevel[2] != null && rootLevel[2].length > 1) {
            PmiRegistry.moduleRoot.level = 0;
        } else if (rootLevel[1] != null && rootLevel[1].length != 0) {
            if (rootLevel[1][0] == -3) {
                rootEnabled = new int[1];
                PmiRegistry.rootEnabled[0] = -3;
                PmiRegistry.moduleRoot.level = -2;
            }
        } else if (rootLevel[2] != null && rootLevel[2].length != 0 && rootLevel[2][0] == -3) {
            rootEnabled = new int[1];
            PmiRegistry.rootEnabled[0] = -3;
            PmiRegistry.moduleRoot.level = -2;
        }
        allLevelNone = true;
        beanMethodDisabled = true;
    }

    public static void enableData(DataDescriptor[] dds, boolean recursive) {
        if (disabled) {
            return;
        }
        PmiRegistry.turnOnOffData(dds, true, recursive);
    }

    public static void disableData(DataDescriptor[] dds, boolean recursive) {
        if (disabled) {
            return;
        }
        PmiRegistry.turnOnOffData(dds, false, recursive);
    }

    private static void turnOnOffData(DataDescriptor[] dds, boolean on, boolean recursive) {
        for (int i = 0; i < dds.length; ++i) {
            ModuleItem item = PmiRegistry.findModuleItem(dds[i]);
            if (item == null) continue;
            int[] dataIds = dds[i].getDataIds();
            if (dataIds == null) {
                item.turnOnOffData(-3, on, recursive);
                continue;
            }
            for (int j = 0; j < dataIds.length; ++j) {
                item.turnOnOffData(dataIds[j], on, recursive);
            }
        }
    }

    public static PerfLevelDescriptor[] getDefaultPerfLevelSpecs() {
        String[] existingModules = PerfModules.moduleIDs;
        PerfLevelDescriptor[] ret = new PerfLevelDescriptor[existingModules.length + 1];
        ret[0] = new PerfLevelDescriptor(null, 0);
        for (int i = 0; i < existingModules.length; ++i) {
            ret[i + 1] = new PerfLevelDescriptor(new String[]{existingModules[i]}, 0);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setMBeanToModuleMap(ModuleItem moduleItem, MBeanStatDescriptor msd) {
        if (moduleItem == null || msd == null) {
            return false;
        }
        HashMap hashMap = mbeanToModuleMap;
        synchronized (hashMap) {
            ModuleItem prevVal = mbeanToModuleMap.put(msd.getIdentifier(), moduleItem);
            if (moduleItem.getInstance() != null) {
                moduleItem.getInstance().setMBeanName(msd.getObjectName(), msd.getStatDescriptor());
            }
            if (prevVal != null && tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0024W", prevVal.getInstance().getName());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setMBeanToModuleMap(): " + msd.getIdentifier());
            }
        }
        return true;
    }

    public static void removeMBeanToModuleMap(MBeanStatDescriptor msd) {
        if (msd != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeMBeanToModuleMap(): " + msd.getIdentifier());
            }
            mbeanToModuleMap.remove(msd.getIdentifier());
        }
    }

    public static DataDescriptor mBeanToDataDescriptor(MBeanStatDescriptor msd) {
        int i;
        ModuleItem parentMI = PmiRegistry.findModuleItem(msd.getObjectName());
        if (parentMI == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mBeanToDataDescriptor(): ModuleItem not found for key:" + msd.getObjectName().toString());
            }
            return null;
        }
        if (parentMI.getInstance() == null) {
            StatDescriptor sd = msd.getStatDescriptor();
            if (sd == null) {
                return new DataDescriptor(new String[]{"pmi"});
            }
            String[] sdpath = msd.getStatDescriptor().getPath();
            if (sdpath == null || sdpath.length == 0) {
                return new DataDescriptor(new String[]{"pmi"});
            }
            return new DataDescriptor(sdpath);
        }
        int subPathLen = 0;
        String[] parentPath = parentMI.getInstance().getPath();
        String[] subPath = null;
        StatDescriptor sd = msd.getStatDescriptor();
        if (sd != null && (subPath = msd.getStatDescriptor().getPath()) != null) {
            subPathLen = subPath.length;
        }
        String[] newPath = new String[parentPath.length + subPathLen];
        for (i = 0; i < parentPath.length; ++i) {
            newPath[i] = parentPath[i];
        }
        for (i = parentPath.length; i < newPath.length; ++i) {
            newPath[i] = subPath[i - parentPath.length];
        }
        return new DataDescriptor(newPath);
    }

    public static boolean isDuplicateModule(String name) {
        return moduleRoot.find(name) != null;
    }

    public static ObjectName getServerMBean() {
        if (serverMBean == null) {
            serverMBean = jmxMapper.findObjectName(null, "Server", null, null);
        }
        return serverMBean;
    }

    public static PmiJmxBridge getPmiJmxBridge(ObjectName mbeanName) {
        return (PmiJmxBridge)((Object)PmiRegistry.findModuleItem(mbeanName));
    }

    public static WSStats getServerSnapshot() {
        return moduleRoot.getStats(true);
    }

    public static void printpath(String[] path) {
        StringBuffer b = new StringBuffer("printpath: ");
        for (int i = 0; i < path.length; ++i) {
            b.append(path[i]).append("/");
        }
        Tr.debug(tc, b.toString());
    }

    private static String pathToString(int indent, String[] path) {
        StringBuffer b = new StringBuffer("|");
        while (indent != 0) {
            b.append("_");
            --indent;
        }
        b.append("_ ");
        for (int i = 0; i < path.length; ++i) {
            b.append("/").append(path[i]);
        }
        return b.toString();
    }

    public static void printPMITree(ModuleItem root) {
        if (moduleRoot == null) {
            Tr.debug(tc, "Specified PMI ModuleItem is empty!");
            return;
        }
        Tr.debug(tc, ">> Begin PMI tree");
        StringBuffer b = new StringBuffer();
        PmiRegistry._printTree(0, root, b);
        System.err.println(b.toString());
        Tr.debug(tc, "<< End PMI tree");
    }

    private static void _printTree(int level, ModuleItem root, StringBuffer buf) {
        ModuleItem[] child = root.children();
        if (child == null) {
            return;
        }
        for (int i = 0; i < child.length; ++i) {
            buf.append("\r\n").append(PmiRegistry.pathToString(level, child[i].getInstance().getPath()));
            PmiRegistry._printTree(level + 1, child[i], buf);
        }
    }

    public static void setSynchronizedUpdate(boolean flag) {
        if (moduleRoot != null) {
            PmiRegistry._setSyncEnabled(moduleRoot, flag);
        }
    }

    private static void _setSyncEnabled(ModuleItem m, boolean flag) {
        if (m != null) {
            ModuleItem[] mi;
            PmiModule pm = m.getInstance();
            if (pm != null) {
                pm.setSyncEnabled(flag);
            }
            if ((mi = m.children()) != null) {
                for (int i = 0; i < mi.length; ++i) {
                    PmiRegistry._setSyncEnabled(mi[i], flag);
                }
            }
        }
    }

    static {
        rootEnabled = new int[0];
        moduleAggregates = new Hashtable();
        mbeanToModuleMap = new HashMap();
        _plds = null;
        tc = Tr.register(PmiRegistry.class, null, MSG_BUNDLE);
        jmxMapper = null;
    }
}

