/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.server.PmiModuleAggregate;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdGroup;
import com.ibm.ws.pmi.server.PmiConfigManager;

public class ModuleAggregate
extends PmiAbstractModule
implements PmiModuleAggregate {
    private static final long serialVersionUID = -8176996451666384014L;
    private String moduleID = null;
    private final int defaultLevel = 0;
    private String[] path = null;
    private static final String BeanModuleWccmType = "beanModule#";

    public ModuleAggregate(String name) {
        this(name, null);
    }

    public ModuleAggregate(String name, boolean bRegister) {
        super(name, null);
        this.moduleID = name;
        this.type = this.categoryName == null ? 13 : 19;
        this.aggregateModule = true;
        if (bRegister) {
            this.registerModule(this);
        }
    }

    public ModuleAggregate(String name, String categoryName) {
        super(name, null);
        this.moduleID = name;
        this.categoryName = categoryName;
        this.type = categoryName == null ? 13 : 19;
        this.aggregateModule = true;
        this.registerModule(this);
    }

    public ModuleAggregate(String name, String instanceName, String submoduleName) {
        this(name, null, instanceName, submoduleName);
    }

    public ModuleAggregate(String name, String categoryName, String instanceName, String submoduleName) {
        super(name, instanceName);
        this.moduleID = name;
        this.categoryName = categoryName;
        this.submoduleName = submoduleName;
        this.type = 15;
        this.aggregateModule = true;
        this.registerModule(this);
    }

    public ModuleAggregate(String[] path, String name, int type) {
        super(path[0], path[1]);
        this.path = path;
        this.type = type;
        this.moduleID = path[0];
        if (type == 14) {
            this.instanceName = name;
        } else if (type == 15) {
            this.submoduleName = name;
        } else if (type == 19) {
            this.categoryName = name;
        }
        this.aggregateModule = true;
        this.registerModule(this);
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public String[] getPath() {
        if (this.path != null) {
            return this.path;
        }
        if (this.instanceName == null && this.type == 15) {
            return new String[]{this.moduleID, this.submoduleName};
        }
        return super.getPath();
    }

    public synchronized void add(PmiModule instance) {
        if (instance == null) {
            return;
        }
        PmiModuleConfig instanceModCfg = null;
        boolean bSameSubMod = true;
        if (!instance.getModuleID().equals(this.getModuleID())) {
            bSameSubMod = false;
            this.addModuleID(instance.getModuleID());
            instanceModCfg = PerfModules.getConfig(instance.getModuleID());
        } else {
            instanceModCfg = this.moduleConfig;
        }
        SpdData[] dataList = instance.listData();
        if (dataList == null || instanceModCfg == null) {
            return;
        }
        for (int i = 0; i < dataList.length; ++i) {
            int dataId = dataList[i].getId();
            PmiDataInfo info = instanceModCfg.getDataInfo(dataId);
            if (info == null || !info.isAggregatable()) continue;
            SpdGroup aggregateData = (SpdGroup)this.dataTable.get(new Integer(dataId));
            if (aggregateData == null) {
                aggregateData = (SpdGroup)this.createAggregateData(info);
                if (aggregateData != null) {
                    if (this.currentLevel == -2) {
                        if (!this.isEnabledInConfig(dataId)) {
                            aggregateData.disable();
                        }
                    } else if (info.getLevel() > this.currentLevel) {
                        aggregateData.disable();
                    }
                }
                this.putToTable(aggregateData);
            }
            aggregateData.add(dataList[i]);
        }
    }

    public synchronized void remove(PmiModule instance) {
        if (instance == null) {
            return;
        }
        this.remove(instance.listData());
    }

    public synchronized void remove(SpdData[] dataList) {
        if (dataList == null) {
            return;
        }
        for (int i = 0; i < dataList.length; ++i) {
            SpdGroup aggregateData = (SpdGroup)this.dataTable.get(new Integer(dataList[i].getId()));
            if (aggregateData == null) continue;
            aggregateData.remove(dataList[i]);
        }
    }

    public synchronized boolean remove(SpdData data) {
        if (data == null) {
            return false;
        }
        SpdGroup aggregateData = (SpdGroup)this.dataTable.get(new Integer(data.getId()));
        if (aggregateData == null) {
            return false;
        }
        return aggregateData.remove(data);
    }

    public void addModuleID(String id) {
    }

    public String getWCCMStatsType() {
        if (this.moduleID.equals("beanModule")) {
            String[] p = this.getPath();
            if (p != null && p.length == 3) {
                return BeanModuleWccmType + p[2];
            }
            return BeanModuleWccmType;
        }
        if (this.moduleID.equals("wlmModule")) {
            String[] p = this.getPath();
            if (p != null && p.length == 1) {
                return "wlmModule#";
            }
            return super.getWCCMStatsType();
        }
        return super.getWCCMStatsType();
    }

    private boolean isEnabledInConfig(int ordinal) {
        int[] search;
        boolean retval = false;
        int[][] fgSpec = PmiConfigManager.getSpec(this.getPath());
        if (fgSpec != null && (search = fgSpec[0] != null ? fgSpec[0] : fgSpec[1]) != null) {
            for (int i = 0; i < search.length; ++i) {
                if (ordinal != search[i]) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }
}

