/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.factory;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import javax.management.ObjectName;

public class StatsFactoryUtil {
    public static final String DEFAULT_MBEAN = "CustomStats";
    private static final String DEFAULT_MBEAN_DESCRIPTOR = "com/ibm/ws/pmi/factory/CustomStats.xml";
    private static final TraceComponent tc = Tr.register(StatsFactoryUtil.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.pmi.properties.PMIMessages");

    public static MBeanStatDescriptor createMBean(Object runtimeObject, String beanName, ObjectName userProvidedMBeanObjectName, boolean bCreateDefaultMBean) throws StatsFactoryException {
        if (userProvidedMBeanObjectName != null) {
            return new MBeanStatDescriptor(userProvidedMBeanObjectName);
        }
        return null;
    }

    private static ObjectName createDefaultMBean(Object runtimeObject, String beanName) throws StatsFactoryException {
        return null;
    }

    public static void registerModule(PmiModule module, MBeanStatDescriptor msd) throws StatsFactoryException {
        ModuleItem mItem = PmiRegistry.registerModule(module);
        if (mItem == null) {
            Tr.warning(tc, "PMI0103W", module.getName());
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0103W", new Object[]{module.getName()}, "Unable to register custom PMI module due to duplicate name under the same parent or invalid PMI tree path: {0}"));
        }
        if (msd != null) {
            StatsFactoryUtil.setMBeanMapping(mItem, msd);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No MBean associated with " + module.getName());
        }
    }

    public static void setMBeanMapping(ModuleItem mItem, MBeanStatDescriptor msd) {
        PmiRegistry.setMBeanToModuleMap(mItem, msd);
    }

    public static void setMBeanMapping(ModuleItem mItem, ObjectName mBean) {
        MBeanStatDescriptor msd = new MBeanStatDescriptor(mBean);
        PmiRegistry.setMBeanToModuleMap(mItem, msd);
    }

    private static String getMBeanID(String[] path) {
        if (path == null || path.length == 0) {
            return null;
        }
        StringBuffer b = new StringBuffer(path[0]);
        for (int i = 1; i < path.length; ++i) {
            b.append("#").append(path[i]);
        }
        return b.toString();
    }

    public static void unRegisterStats(PmiModule mod, ObjectName mbean) throws StatsFactoryException {
        PmiRegistry.unregisterModule(mod);
    }

    public static void deactivateMBean(ObjectName mbean) {
    }

    public static void checkDataIDUniqueness(PmiModule parentMod, PmiModuleConfig cfg) throws StatsFactoryException {
        for (ModuleItem parent = PmiRegistry.findModuleItem(parentMod.getPath()); parent != null && parent.getInstance() != null; parent = parent.getParent()) {
            PmiModuleConfig pCfg = parent.getInstance().getModuleConfig();
            if (pCfg.getUID().equals(cfg.getUID())) continue;
            PmiDataInfo[] dInfo1 = pCfg.listAllData();
            PmiDataInfo[] dInfo2 = cfg.listAllData();
            for (int i = 0; i < dInfo1.length; ++i) {
                int id = dInfo1[i].getId();
                for (int k = 0; k < dInfo2.length; ++k) {
                    if (dInfo2[k].getId() != id) continue;
                    throw new StatsFactoryException(nls.getFormattedMessage("PMI0108W", new Object[]{new Integer(id), pCfg.getUID()}, "Unable to register custom PMI module due to duplicate statistic id in the parent stats group/instance: ID={0}; ParentStats={1}"));
                }
            }
        }
    }
}

