/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.transport;

import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ffdc.Manager;
import com.ibm.jsse2.SSLSocketFD;
import com.ibm.rmi.iiop.Connection;
import com.ibm.ws.orbimpl.MessageUtility;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import javax.net.ssl.SSLSocket;
import org.omg.CORBA.INTERNAL;

final class JNIReaderThread
extends Thread {
    protected int queueDepth = 0;
    protected String localHost = null;
    protected boolean useSingleNIC = false;
    private Hashtable fdConnectionMap = new Hashtable();
    private Hashtable fdConnectionReverseMap = new Hashtable();
    private long self;
    public int thisInstanceNumber;
    public static int instanceCounter = 0;
    private int nativeCodeQueueSize;
    private SocketPair theSocketPair;
    private int currentQueueSize = 0;
    private static boolean libraryHasBeenLoaded = false;

    private static native void load0();

    private native void run0();

    private native int init0(Socket var1, Socket var2);

    private native void addConnection0(FileDescriptor var1);

    private native void removeConnection0(FileDescriptor var1);

    private native FileDescriptor getSSLSocketFD0(SSLSocket var1);

    public void run() {
        block4: {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(256L, (Object)this, "ijavaorb", (Object)"run)");
            }
            try {
                this.run0();
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.run", "173", this);
                if (!ORBRas.isTrcLogging) break block4;
                ORBRas.orbTrcLogger.exception(8L, (Object)this, "run", e);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(256L, (Object)this, "ijavaorb", (Object)"run)");
        }
    }

    JNIReaderThread() {
        super("JNIReaderThread");
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(256L, (Object)this, "ijavaorb", (Object)"Constructor");
        }
        if (!libraryHasBeenLoaded) {
            System.loadLibrary("Selector");
            JNIReaderThread.load0();
            libraryHasBeenLoaded = true;
        }
    }

    public JNIReaderThread(int queueDepth, String localHost, boolean useSingleNIC) {
        this();
        String methodName = "<init>(int, String";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(256L, (Object)this, "ijavaorb <init>(int, String", (Object)"Constructor");
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "<init>(int, String", "queueDepth is " + queueDepth + " LocalHost is " + localHost + " Bind To Single NIC Card is " + useSingleNIC);
        }
        this.queueDepth = queueDepth;
        this.localHost = localHost;
        this.useSingleNIC = useSingleNIC;
        this.thisInstanceNumber = instanceCounter++;
        SocketPairFactory sa = new SocketPairFactory(queueDepth, localHost, useSingleNIC);
        this.theSocketPair = sa.createSocketPair();
        this.nativeCodeQueueSize = this.init0(this.theSocketPair.getReadSocket(), this.theSocketPair.getWriteSocket());
        this.setDaemon(true);
        this.start();
    }

    void addConnection(ORBConnection c) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(256L, (Object)this, "addConnection", (Object)("ORBConnection=" + c));
        }
        FileDescriptor theFileDescriptor = null;
        try {
            Socket socket = c.getSocket();
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(256L, (Object)this, "addConnection", (Object)("ORBConnection socket=" + socket));
            }
            theFileDescriptor = socket instanceof SSLSocket ? SSLSocketFD.getFD((SSLSocket)((SSLSocket)socket)) : ((FileInputStream)((Connection)c).getInputStream()).getFD();
        }
        catch (ClassCastException ex) {
            if (ORBRas.isMsgLogging) {
                String stdOutMsg = MessageUtility.getMessage("JNIReaderManager.ClassCastError");
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.orbimpl.transport.JNIReaderThread", "addConnection", stdOutMsg, null);
            }
            throw ex;
        }
        catch (IOException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.addConnection", "335", this);
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, (Object)this, "addConnection Exception =" + ex, MessageUtility.getMessage("JNIReaderManager.invalidNumberOfReaders"), (String)null, (Object[])null);
            }
            throw new INTERNAL(ex.toString());
        }
        this.fdConnectionMap.put(theFileDescriptor, c);
        this.fdConnectionReverseMap.put(c, theFileDescriptor);
        if (ORBRas.isTrcLogging) {
            String[] fillins = new String[]{this.fdConnectionMap.toString(), theFileDescriptor.toString()};
            String traceString = MessageUtility.getMessage("JNIReaderThread.showfdConnectionMap", fillins);
            ORBRas.orbTrcLogger.trace(16L, (Object)this, "addConnection", traceString);
        }
        try {
            this.addConnection0(theFileDescriptor);
            ++this.currentQueueSize;
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.addConnection", "377", this);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(8L, (Object)this, "addConnection", ex);
            }
            if (theFileDescriptor != null) {
                this.fdConnectionMap.remove(theFileDescriptor);
                this.fdConnectionReverseMap.remove(c);
            }
            throw new INTERNAL(ex.toString());
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(256L, (Object)this, "addConnection", (Object)("fileDescriptor=" + theFileDescriptor));
        }
    }

    void removeConnection(ORBConnection c) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(256L, (Object)this, "ijavaorb", (Object)"removeConnection)");
        }
        FileDescriptor theFileDescriptor = (FileDescriptor)this.fdConnectionReverseMap.get(c);
        try {
            this.removeConnection0(theFileDescriptor);
            --this.currentQueueSize;
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.removeConnection", "429", this);
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, (Object)this, "removeConnection Exception = " + ex, MessageUtility.getMessage("JNIReaderManager.invalidNumberOfReaders"), (String)null, (Object[])null);
            }
            throw new INTERNAL(ex.toString());
        }
        this.fdConnectionMap.remove(theFileDescriptor);
        this.fdConnectionReverseMap.remove(c);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(256L, (Object)this, "ijavaorb", (Object)"removeConnection");
        }
    }

    private void doConnectionRead(FileDescriptor theFileDescriptor) {
        block6: {
            ORBConnection c = (ORBConnection)this.fdConnectionMap.get(theFileDescriptor);
            if (ORBRas.isTrcLogging) {
                String[] fillins = new String[]{theFileDescriptor.toString(), c.toString(), this.fdConnectionMap.toString()};
                String traceString = MessageUtility.getMessage("JNIReaderThread.fdConnectionMap.get", fillins);
                ORBRas.orbTrcLogger.trace(16L, (Object)this, "doConnectionRead", traceString);
            }
            if (c == null) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(8L, (Object)this, "doConnectionRead", "c==null");
                }
                return;
            }
            try {
                c.doReaderWorkOnce();
            }
            catch (Exception ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.doConnectionRead", "522", this);
                if (!ORBRas.isTrcLogging) break block6;
                ORBRas.orbTrcLogger.exception(8L, (Object)this, "doConnectionRead", ex);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(256L, (Object)this, "ijavaorb", (Object)"doConnectionRead)");
        }
    }

    public String toString() {
        String superString = super.toString();
        String result = "[JNIReaderThread: " + superString;
        result = result + " fdConnectionMap contains: " + this.fdConnectionMap;
        result = result + " fdConnectionReverseMap contains: " + this.fdConnectionReverseMap;
        result = result + "]";
        return result;
    }

    public int getQueueSize() {
        return this.nativeCodeQueueSize;
    }

    public int getAvailableQueueSpace() {
        return this.nativeCodeQueueSize - this.currentQueueSize;
    }

    public class SocketPairFactory
    extends Thread {
        private ServerSocket theServerSocket;
        private Socket acceptedSocket;
        private int queueDepth;
        private String localHost;
        private boolean useSingleNIC;

        public SocketPairFactory() {
            super("SocketPairFactory");
            this.theServerSocket = null;
            this.acceptedSocket = null;
            this.queueDepth = 0;
            this.localHost = null;
            this.useSingleNIC = false;
            String methodName = "<init>()";
        }

        public SocketPairFactory(int queueDepth, String localHost, boolean useSingleNIC) {
            this();
            String methodName = "<init>(int, String)";
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "<init>(int, String)", "queueDepth is " + queueDepth + " localHost is " + localHost + " useSingleNIC is " + useSingleNIC);
            }
            this.queueDepth = queueDepth;
            this.localHost = localHost;
            this.useSingleNIC = useSingleNIC;
        }

        public SocketPair createSocketPair() {
            Socket clientSideSocket = null;
            try {
                if (this.useSingleNIC) {
                    this.theServerSocket = new ServerSocket(0, this.queueDepth, InetAddress.getByName(this.localHost));
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocketPair", "ServerSocketQueueDepth is set to " + this.queueDepth, (Object)("useSingleNIC is set to " + this.useSingleNIC));
                    }
                } else {
                    this.theServerSocket = new ServerSocket(0, this.queueDepth);
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocketPair", "ServerSocketQueueDepth is set to " + this.queueDepth);
                    }
                }
                this.start();
                while (true) {
                    try {
                        if (this.useSingleNIC) {
                            clientSideSocket = new Socket(InetAddress.getLocalHost(), this.theServerSocket.getLocalPort(), InetAddress.getByName(this.localHost), 0);
                            break;
                        }
                        clientSideSocket = new Socket(InetAddress.getLocalHost(), this.theServerSocket.getLocalPort());
                    }
                    catch (IOException ex) {
                        Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.createSocketPair", "721", this);
                        continue;
                    }
                    break;
                }
                return new SocketPair(clientSideSocket, this.getAcceptedSocket());
            }
            catch (IOException ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.createSocketPair", "665", this);
                throw new INTERNAL(ex.toString());
            }
        }

        public synchronized void run() {
            try {
                this.acceptedSocket = null;
                this.acceptedSocket = this.theServerSocket.accept();
                this.notifyAll();
            }
            catch (IOException ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.run", "757", this);
                throw new INTERNAL(ex.toString());
            }
        }

        private synchronized Socket getAcceptedSocket() {
            while (this.acceptedSocket == null) {
                try {
                    this.wait();
                    continue;
                }
                catch (InterruptedException ex) {
                    Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.getAcceptedSocket", "780", this);
                    continue;
                }
                break;
            }
            return this.acceptedSocket;
        }
    }

    public class SocketPair {
        final Socket readSocket;
        final Socket writeSocket;

        public SocketPair(Socket readSocket, Socket writeSocket) {
            this.readSocket = readSocket;
            this.writeSocket = writeSocket;
        }

        public Socket getReadSocket() {
            return this.readSocket;
        }

        public Socket getWriteSocket() {
            return this.writeSocket;
        }
    }
}

