/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.WsnNameParser;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WsnNamingEnumeration<T>
implements NamingEnumeration<T> {
    private static final TraceComponent _tc = Tr.register(WsnNamingEnumeration.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static boolean _debug;
    protected static final int USE_DEFAULT_BATCH_SIZE = 0;
    protected static final int DEFAULT_BATCH_SIZE = 32;
    protected final Hashtable<?, ?> _env;
    protected final WsnNameParser _nameParser;
    protected final int _batchSize;
    protected final Queue<Object> _batch = new LinkedList<Object>();
    protected Boolean _more = null;
    protected boolean _closed = false;

    protected WsnNamingEnumeration(Hashtable<?, ?> env, WsnNameParser nameParser) throws NamingException {
        this(env, nameParser, 0);
    }

    protected WsnNamingEnumeration(Hashtable<?, ?> env, WsnNameParser nameParser, int batchSize) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", new String[]{"env=" + env, "nameParser=" + nameParser, "batchSize=" + batchSize});
        }
        this._env = env;
        this._nameParser = nameParser;
        this._batchSize = this.determineBatchSize(env, batchSize);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "<init>");
        }
    }

    protected void init() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "init");
        }
        this._more = this.doInit();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "init", "batch size=" + this._batch.size() + ", _more=" + this._more);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "init");
        }
    }

    protected abstract Boolean doInit() throws NamingException;

    @Override
    public boolean hasMoreElements() {
        boolean more;
        block4: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "hasMoreElements");
            }
            more = false;
            try {
                more = this.hasMore();
            }
            catch (NamingException e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "hasMoreElements", "155", this);
                if (!_tc.isEventEnabled()) break block4;
                Tr.event(_tc, "hasMoreElements", e.toString());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "hasMoreElements", Boolean.toString(more));
        }
        return more;
    }

    @Override
    public T nextElement() {
        T nextElement;
        block4: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "nextElement");
            }
            nextElement = null;
            try {
                nextElement = this.next();
            }
            catch (NamingException e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "nextElement", "184", this);
                if (!_tc.isEventEnabled()) break block4;
                Tr.event(_tc, "nextElement", e.toString());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "nextElement", nextElement);
        }
        return nextElement;
    }

    @Override
    public boolean hasMore() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "hasMore");
        }
        boolean more = false;
        if (!this._closed) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "hasMore", "batch size=" + this._batch.size());
            }
            if (this._batch.peek() != null) {
                more = true;
            } else {
                if (this._more == null || this._more.booleanValue()) {
                    this.nextBatch();
                }
                if (this._batch.peek() != null) {
                    more = true;
                } else {
                    this.close();
                }
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "hasMore", "enumeration closed");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "hasMore", Boolean.toString(more));
        }
        return more;
    }

    @Override
    public T next() throws NamingException {
        Object element;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "next");
        }
        Object next = null;
        if (this.hasMore()) {
            element = this._batch.poll();
            if (element instanceof NamingException) {
                NamingException ne = (NamingException)element;
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "next", ne.toString());
                }
                throw ne;
            }
        } else {
            NoSuchElementException e = new NoSuchElementException();
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "next", e.toString());
            }
            throw e;
        }
        next = element;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "next", next);
        }
        return (T)next;
    }

    @Override
    public void close() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "close");
        }
        if (!this._closed) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "close", "close enumeration");
            }
            this.doClose();
            this._batch.clear();
            this._closed = true;
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "close", "enumeration already closed");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "close");
        }
    }

    protected abstract void doClose();

    private void nextBatch() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "nextBatch");
        }
        this._batch.clear();
        if (this._more == null || this._more.booleanValue()) {
            this._more = this.doNextBatch();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "nextBatch", "batch size=" + this._batch.size() + ", _more=" + this._more);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "nextBatch");
        }
    }

    protected abstract Boolean doNextBatch() throws NamingException;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[_env=");
        stringBuilder.append(this._env);
        stringBuilder.append(", _nameParser=");
        stringBuilder.append(this._nameParser);
        stringBuilder.append(", _batchSize=");
        stringBuilder.append(this._batchSize);
        stringBuilder.append(", _batch=");
        if (_debug) {
            stringBuilder.append(this._batch);
        } else {
            stringBuilder.append(Helpers.collectionToTerseString(this._batch));
        }
        stringBuilder.append(", _more=");
        stringBuilder.append(this._more);
        stringBuilder.append(", _closed=");
        stringBuilder.append(this._closed);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private int determineBatchSize(Hashtable<?, ?> env, int batchSize) {
        int result;
        block14: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "determineBatchSize", new String[]{"env=" + env, "batchSize=" + batchSize});
            }
            result = 0;
            Object o = this._env.get("java.naming.batchsize");
            if (o instanceof String) {
                String batchSizeString = (String)o;
                try {
                    int batchSizeInt = Integer.parseInt(batchSizeString);
                    if (batchSizeInt >= 0) {
                        result = batchSizeInt;
                    } else if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "determineBatchSize", "Value of environment property java.naming.batchsize is not a positive integer; value=\"" + batchSizeString + "\"");
                    }
                    break block14;
                }
                catch (NumberFormatException e) {
                    RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "determineBatchSize", "415", this);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "determineBatchSize", "Value of environment property java.naming.batchsize is not a valid integer; value=\"" + batchSizeString + "\"");
                    }
                    break block14;
                }
            }
            if (o != null && _tc.isEventEnabled()) {
                Tr.event(_tc, "determineBatchSize", "Value of environment property java.naming.batchsize is not a string; value=" + o + " (class=" + o.getClass().getName() + ")");
            }
        }
        if (result == 0) {
            if (batchSize > 0) {
                result = batchSize;
            } else {
                if (batchSize < 0 && _tc.isEventEnabled()) {
                    Tr.event(_tc, "determineBatchSize", "Specified batch size " + batchSize + " is not valid");
                }
                result = 32;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "determineBatchSize", result);
        }
        return result;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/util/WsnNamingEnumeration.java, WAS.naming.client, WAS70.SERV1, cf050925.09, ver. 1.11");
        }
        CLASS_NAME = WsnNamingEnumeration.class.getName();
        _debug = Boolean.getBoolean("com.ibm.ws.naming.debug");
    }
}

