/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.InvalidNameSyntaxException;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.WsnNameEnumeration;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.omg.CosNaming.NameComponent;

public class WsnName
implements Name {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent _tc = Tr.register(WsnName.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static final int JNDI = 0;
    private static final int INS = 1;
    private static final char SEP_DEFAULT = '.';
    private static final char PATH_SEP = '/';
    private static final char ESC = '\\';
    private static final NameComponent EMPTY_COSNAME_COMPONENT;
    private Hashtable _env;
    private int _syntax = 0;
    private char _sep;
    private NameComponent[] _name;
    private String _syntaxName;

    public WsnName(NameComponent[] name, Hashtable env) throws InvalidNameException, InvalidNameSyntaxException {
        try {
            this.init(env);
            this.setName(name);
        }
        catch (InvalidNameException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "<init>", "107", this);
            throw e;
        }
        catch (InvalidNameSyntaxException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "<init>", "112", this);
            throw e;
        }
    }

    public WsnName(Name jndiName, Hashtable env) throws InvalidNameException, InvalidNameSyntaxException {
        try {
            this.init(env);
            this.setName(jndiName);
        }
        catch (InvalidNameException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "<init>", "145", this);
            throw e;
        }
        catch (InvalidNameSyntaxException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "<init>", "150", this);
            throw e;
        }
    }

    public WsnName(String nameString, Hashtable env) throws InvalidNameException, InvalidNameSyntaxException {
        try {
            this.init(env);
            this.setName(nameString);
        }
        catch (InvalidNameException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "<init>", "181", this);
            throw e;
        }
        catch (InvalidNameSyntaxException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "<init>", "186", this);
            throw e;
        }
    }

    private void init(Hashtable env) throws InvalidNameSyntaxException {
        this.setEnvironment(env);
        this.setSyntax(env);
    }

    private void setEnvironment(Hashtable env) {
        this._env = env != null ? (Hashtable)env.clone() : null;
    }

    private void setSyntax(Hashtable env) throws InvalidNameSyntaxException {
        this._syntax = 0;
        this._syntaxName = "JNDI";
        String syntaxString = WsnName.syntaxProperty(env);
        if (syntaxString.equals("ins")) {
            this._syntax = 1;
            this._syntaxName = "INS";
            this._sep = (char)46;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String syntaxProperty(Hashtable env) throws InvalidNameSyntaxException {
        String syntaxString = "jndi";
        if (env != null) {
            Object o = env.get("com.ibm.websphere.naming.name.syntax");
            if (o == null) return syntaxString;
            if (o instanceof String) {
                String propString = (String)o;
                if (propString.equals("jndi")) return propString;
                if (propString.equals("ins")) {
                    return propString;
                }
                String msg = "The name syntax property com.ibm.websphere.naming.name.syntax is set to an unrecognized value of " + propString + ".";
                InvalidNameSyntaxException ne = new InvalidNameSyntaxException(msg);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "syntaxProperty", new Object[]{"Invalid name syntax property", ne});
                }
                Tr.warning(_tc, "badNameSyntax", new Object[]{"com.ibm.websphere.naming.name.syntax", propString});
                throw ne;
            }
            String msg = "Value for the property \"com.ibm.websphere.naming.name.syntax\" is not a String.";
            InvalidNameSyntaxException ne = new InvalidNameSyntaxException(msg);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "syntaxProperty", new Object[]{"Invalid name syntax property", ne});
            }
            Tr.warning(_tc, "badNameSyntax", new Object[]{"com.ibm.websphere.naming.name.syntax", o});
            throw ne;
        }
        if (!_tc.isDebugEnabled()) return syntaxString;
        Tr.debug(_tc, "syntaxProperty", "null environment");
        return syntaxString;
    }

    public NameComponent[] toCosName() throws InvalidNameException {
        if (this._name.length == 0) {
            throw new InvalidNameException("This name cannot be represented as a CORBA CosNaming name because a CosNaming name cannot be empty.");
        }
        return this.cloneCosName(this._name);
    }

    public Name toJndiName() {
        return (WsnName)this.clone();
    }

    public String toString() {
        StringBuffer s = new StringBuffer(64);
        int allButLast = this._name.length - 1;
        for (int i = 0; i < allButLast; ++i) {
            this.cosComponentToString(this._name[i], s);
            s.append('/');
        }
        if (allButLast >= 0) {
            this.cosComponentToString(this._name[allButLast], s);
        } else {
            this.cosComponentToString(EMPTY_COSNAME_COMPONENT, s);
        }
        return s.toString();
    }

    public Name add(int posn, String componentString) throws InvalidNameException, ArrayIndexOutOfBoundsException {
        NameComponent[] newComp = new NameComponent[]{this.parseJndiNameComponentString(componentString)};
        this.insertComponents(newComp, posn);
        return this;
    }

    public Name add(String componentString) throws InvalidNameException {
        NameComponent[] newComp = new NameComponent[]{this.parseJndiNameComponentString(componentString)};
        try {
            this.insertComponents(newComp, this._name.length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "add", "416", this);
        }
        return this;
    }

    public Name addAll(int posn, Name n) throws InvalidNameException, ArrayIndexOutOfBoundsException {
        NameComponent[] newComps = this.jndiNameToCosName(n);
        this.insertComponents(newComps, posn);
        return this;
    }

    public Name addAll(Name suffix) throws InvalidNameException {
        NameComponent[] newComps = this.jndiNameToCosName(suffix);
        try {
            this.insertComponents(newComps, this._name.length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "addAll", "483", this);
        }
        return this;
    }

    public Object clone() {
        WsnName nameClone = null;
        try {
            nameClone = this._name.length > 0 ? new WsnName(this._name, this._env) : new WsnName("", this._env);
        }
        catch (InvalidNameException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "clone", "513", this);
        }
        catch (InvalidNameSyntaxException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "clone", "518", this);
        }
        return nameClone;
    }

    public int compareTo(Object obj) {
        Name n = (Name)obj;
        int thisLength = this._name.length;
        int nLength = n.size();
        for (int i = 0; i < thisLength && i < nLength; ++i) {
            int result;
            try {
                NameComponent cosComp = this.parseJndiNameComponentString(n.get(i));
                result = this._name[i].id.compareTo(cosComp.id);
                if (result != 0) {
                    return result;
                }
                result = this._name[i].kind.compareTo(cosComp.kind);
                if (result == 0) continue;
                return result;
            }
            catch (InvalidNameException e) {
                StringBuffer s = new StringBuffer(64);
                this.cosComponentToString(this._name[i], s);
                String thisComp = s.toString();
                String thatComp = n.get(i);
                result = thisComp.compareTo(thatComp);
                if (result == 0) continue;
                return result;
            }
        }
        if (thisLength > nLength) {
            return 1;
        }
        if (thisLength < nLength) {
            return -1;
        }
        return 0;
    }

    public boolean endsWith(Name n) {
        try {
            NameComponent[] suffix = this.jndiNameToCosName(n);
            boolean match = this.compareName(this._name.length - suffix.length, suffix);
            return match;
        }
        catch (InvalidNameException e) {
            return false;
        }
    }

    public String get(int posn) throws ArrayIndexOutOfBoundsException {
        if (posn < 0 || posn > this._name.length) {
            throw new ArrayIndexOutOfBoundsException("Specified prefix position of " + posn + " is out of range.  The current name length is " + this._name.length + ".");
        }
        StringBuffer s = new StringBuffer(64);
        this.cosComponentToString(this._name[posn], s);
        return s.toString();
    }

    public Enumeration getAll() {
        WsnNameEnumeration vEnum = new WsnNameEnumeration(this);
        return vEnum;
    }

    public Name getPrefix(int posn) throws ArrayIndexOutOfBoundsException {
        if (posn < 0 || posn > this._name.length) {
            throw new ArrayIndexOutOfBoundsException("Specified prefix position of " + posn + " is out of range.  The current name length is " + this._name.length + ".");
        }
        WsnName prefix = null;
        try {
            if (posn == 0) {
                prefix = new WsnName("", this._env);
            } else {
                NameComponent[] cosPrefix = this.subname(0, posn);
                prefix = new WsnName(cosPrefix, this._env);
            }
        }
        catch (InvalidNameException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "getPrefix", "687", this);
        }
        catch (InvalidNameSyntaxException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "getPrefix", "692", this);
        }
        return prefix;
    }

    public Name getSuffix(int posn) throws ArrayIndexOutOfBoundsException {
        if (posn < 0 || posn > this._name.length) {
            throw new ArrayIndexOutOfBoundsException("Specified suffix position of " + posn + " is out of range.  The current name length is " + this._name.length + ".");
        }
        WsnName suffix = null;
        try {
            if (posn == this._name.length) {
                suffix = new WsnName("", this._env);
            } else {
                NameComponent[] cosSuffix = this.subname(posn, this._name.length);
                suffix = new WsnName(cosSuffix, this._env);
            }
        }
        catch (InvalidNameException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "getSuffix", "734", this);
        }
        catch (InvalidNameSyntaxException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "getSuffix", "739", this);
        }
        return suffix;
    }

    public boolean isEmpty() {
        return this._name.length == 0;
    }

    public Object remove(int posn) throws InvalidNameException, ArrayIndexOutOfBoundsException {
        int i;
        String removedComp = this.get(posn);
        NameComponent[] newName = new NameComponent[this._name.length - 1];
        for (i = 0; i < posn; ++i) {
            newName[i] = this._name[i];
        }
        for (i = posn + 1; i < this._name.length; ++i) {
            newName[i - 1] = this._name[i];
        }
        this._name = newName;
        return removedComp;
    }

    public int size() {
        return this._name.length;
    }

    public boolean startsWith(Name n) {
        try {
            NameComponent[] prefix = this.jndiNameToCosName(n);
            boolean match = this.compareName(0, prefix);
            return match;
        }
        catch (InvalidNameException e) {
            return false;
        }
    }

    public void setName(NameComponent[] name) throws InvalidNameException {
        if (name == null || name.length == 0) {
            throw new InvalidNameException("Null or empty CosNaming names are not allowed.");
        }
        if (_tc.isDebugEnabled()) {
            StringBuffer nameDump = new StringBuffer(64);
            for (int i = 0; i < name.length; ++i) {
                nameDump.append("id=");
                nameDump.append(name[i].id);
                nameDump.append(", kind=");
                nameDump.append(name[i].kind);
                nameDump.append(";");
            }
            Tr.debug(_tc, "setName", "Name info: syntax=" + this._syntaxName + ", size=" + name.length + ", name=" + nameDump.toString());
        }
        for (int i = 0; i < name.length; ++i) {
            if (this._syntax != 0 || name[i].kind.equals("")) continue;
            throw new InvalidNameException("JNDI name syntax is being used and  the kind field in element " + i + " is not empty.");
        }
        this._name = this.cloneCosName(name);
    }

    public void setName(Name jndiName) throws InvalidNameException {
        if (jndiName == null) {
            throw new InvalidNameException("Null names are not allowed.");
        }
        int nameSize = jndiName.size();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setName", "Name info: syntax=" + this._syntaxName + ", size=" + nameSize + ", name=\"" + jndiName.toString() + "\"");
        }
        this._name = new NameComponent[nameSize];
        for (int i = 0; i < nameSize; ++i) {
            this._name[i] = this.parseJndiNameComponentString(jndiName.get(i));
        }
    }

    public void setName(String nameString) throws InvalidNameException {
        if (nameString == null) {
            throw new InvalidNameException("Null names are not allowed.");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setName", "Name info: syntax=" + this._syntaxName + ", name=\"" + nameString + "\"");
        }
        String[] nameComponents = this.separateNameComponents(nameString);
        int nameSize = nameComponents.length;
        this._name = new NameComponent[nameSize];
        for (int i = 0; i < nameSize; ++i) {
            this._name[i] = this.parseJndiNameComponentString(nameComponents[i]);
        }
    }

    public void clearName() {
        this._name = new NameComponent[0];
    }

    private String[] separateNameComponents(String nameString) throws InvalidNameException {
        int i;
        int nameLength = nameString.length();
        if (nameLength == 0) {
            return new String[0];
        }
        char[] nameChars = new char[nameLength];
        nameString.getChars(0, nameLength, nameChars, 0);
        int compCount = 1;
        for (int i2 = 0; i2 < nameLength; ++i2) {
            char currChar = nameChars[i2];
            if (currChar == '/') {
                ++compCount;
                continue;
            }
            if (currChar != '\\') continue;
            ++i2;
        }
        String[] nameComps = new String[compCount];
        compCount = 0;
        int compStartIdx = 0;
        for (i = 0; i < nameLength; ++i) {
            char currChar = nameChars[i];
            if (currChar == '/') {
                nameComps[compCount++] = nameString.substring(compStartIdx, i);
                compStartIdx = i + 1;
                continue;
            }
            if (currChar == '\\' && ++i >= nameLength) break;
        }
        nameComps[compCount] = nameString.substring(compStartIdx, i);
        return nameComps;
    }

    private NameComponent parseJndiNameComponentString(String nameComponent) throws InvalidNameException {
        char currChar;
        int currIdx;
        int nameLength = nameComponent.length();
        if (this._syntax == 1 && nameLength == 0) {
            throw new InvalidNameException("The name component \"\" violates INS syntax.  An empty name component in INS syntax is represented as \".\".");
        }
        char[] nameChars = new char[nameLength];
        nameComponent.getChars(0, nameLength, nameChars, 0);
        int shiftToIdx = 0;
        boolean shiftChar = false;
        for (currIdx = 0; currIdx < nameLength; ++currIdx) {
            currChar = nameChars[currIdx];
            if (this._syntax == 1 && currChar == this._sep) {
                if (++currIdx <= 1 || currIdx < nameLength) break;
                throw new InvalidNameException("The name component \"" + nameComponent + "\" violates INS name syntax.  The non-empty id value ends with an " + "unescaped ID/KIND separator (\"" + this._sep + "\") and there is no kind value.");
            }
            if (currChar == '\\') {
                shiftChar = true;
                if (++currIdx >= nameLength) {
                    throw new InvalidNameException("Escape character (\\) occurred at end of the name component, \"" + nameComponent + "\".");
                }
                currChar = nameChars[currIdx];
                this.validateEscapedCharacter(currChar, nameComponent);
            }
            if (shiftChar) {
                nameChars[shiftToIdx] = currChar;
            }
            ++shiftToIdx;
        }
        String id = new String(nameChars, 0, shiftToIdx);
        int kindStartIdx = shiftToIdx = currIdx;
        shiftChar = false;
        while (currIdx < nameLength) {
            currChar = nameChars[currIdx];
            if (currChar == this._sep) {
                throw new InvalidNameException("The name component \"" + nameComponent + "\" violates INS name syntax.  " + "There is more than one unescaped ID/KIND separator (\"" + this._sep + "\").");
            }
            if (currChar == '\\') {
                shiftChar = true;
                if (++currIdx >= nameLength) {
                    throw new InvalidNameException("Escape character (\\) occurred at end of the name component, \"" + nameComponent + "\".");
                }
                currChar = nameChars[currIdx];
                this.validateEscapedCharacter(currChar, nameComponent);
            }
            if (shiftChar) {
                nameChars[shiftToIdx] = currChar;
            }
            ++shiftToIdx;
            ++currIdx;
        }
        String kind = new String(nameChars, kindStartIdx, shiftToIdx - kindStartIdx);
        return new NameComponent(id, kind);
    }

    private void validateEscapedCharacter(char c, String nameComponent) throws InvalidNameException {
        switch (this._syntax) {
            case 0: {
                if (c == '\\' || c == '/') break;
                throw new InvalidNameException("Escape character (\\) was followed by a character other than \"/\" or \"\\\" in the name component, \"" + nameComponent + "\".");
            }
            case 1: {
                if (c == '\\' || c == '/' || c == this._sep) break;
                throw new InvalidNameException("Escape character (\\) was followed by a character other than \"/\", \"\\\", or \"" + this._sep + "\" in the name component, \"" + nameComponent + "\".");
            }
        }
    }

    private NameComponent[] jndiNameToCosName(Name n) throws InvalidNameException {
        int nSize = n.size();
        NameComponent[] cosName = new NameComponent[nSize];
        for (int i = 0; i < nSize; ++i) {
            cosName[i] = this.parseJndiNameComponentString(n.get(i));
        }
        return cosName;
    }

    private void cosComponentToString(NameComponent comp, StringBuffer outString) {
        this.insertEscapes(comp.id, outString);
        if (this._syntax != 0) {
            if (comp.id.length() == 0 || comp.kind.length() > 0) {
                outString.append(this._sep);
            }
            this.insertEscapes(comp.kind, outString);
        }
    }

    private void insertEscapes(String inString, StringBuffer outString) {
        for (int i = 0; i < inString.length(); ++i) {
            char currChar = inString.charAt(i);
            if (currChar == '/' || currChar == '\\') {
                outString.append('\\');
            } else if (this._syntax != 0 && currChar == this._sep) {
                outString.append('\\');
            }
            outString.append(currChar);
        }
    }

    private NameComponent[] subname(int start, int stop) {
        NameComponent[] subname = new NameComponent[stop - start];
        int i = start;
        int j = 0;
        while (i < stop) {
            subname[j] = new NameComponent(this._name[i].id, this._name[i].kind);
            ++i;
            ++j;
        }
        return subname;
    }

    private boolean compareName(int posn, NameComponent[] name) {
        if (posn < 0 || posn + name.length > this._name.length) {
            return false;
        }
        int i = 0;
        int j = posn;
        while (i < name.length) {
            if (!this._name[j].id.equals(name[i].id) || !this._name[j].kind.equals(name[i].kind)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private NameComponent[] cloneCosName(NameComponent[] name) {
        NameComponent[] clone = new NameComponent[name.length];
        for (int i = 0; i < name.length; ++i) {
            clone[i] = new NameComponent(name[i].id, name[i].kind);
        }
        return clone;
    }

    private void insertComponents(NameComponent[] newComponents, int posn) throws ArrayIndexOutOfBoundsException {
        int i;
        if (posn < 0 || posn > this._name.length) {
            throw new ArrayIndexOutOfBoundsException("Name component insertion position of " + posn + " is out of range.  The current name length is " + this._name.length + ".");
        }
        NameComponent[] newName = new NameComponent[this._name.length + newComponents.length];
        for (i = 0; i < posn; ++i) {
            newName[i] = this._name[i];
        }
        i = 0;
        int j = posn;
        while (i < newComponents.length) {
            newName[j] = newComponents[i];
            ++i;
            ++j;
        }
        i = posn;
        j = posn + newComponents.length;
        while (i < this._name.length) {
            newName[j] = this._name[i];
            ++i;
            ++j;
        }
        this._name = newName;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/ws/naming/util/WsnName.java, WAS.naming, WAS70.SERV1, cf050925.09, ver. 1.8.1.15");
        }
        CLASS_NAME = WsnName.class.getName();
        EMPTY_COSNAME_COMPONENT = new NameComponent("", "");
    }
}

