/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.jndicos.CNContextImpl;
import com.ibm.ws.naming.util.NameFormatHelper;
import com.ibm.ws.naming.util.WsnInitCtxFactory;
import com.ibm.ws.naming.util.WsnNameParser;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsnInitCtx
implements Context {
    private static final TraceComponent _tc = Tr.register(WsnInitCtx.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static final String SOURCE_INFO = "SERV1/ws/code/naming.client/src/com/ibm/ws/naming/util/WsnInitCtx.java, WAS.naming.client, WAS70.SERV1, cf050925.09, ver. 1.12";
    private final Hashtable<?, ?> _env;
    private final WsnInitCtxFactory _factory;
    private final NameParser _parser;
    private Context _context = null;
    private boolean _haveInitCtx = false;
    private boolean _closed = false;
    private Object _initCtxLock = new Object();

    public WsnInitCtx(Hashtable<?, ?> env, WsnInitCtxFactory factory) throws NamingException {
        Object nsConnection;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", new String[]{"env=" + env, "factory=" + factory});
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "<init>", SOURCE_INFO);
        }
        this._env = env;
        this._factory = factory;
        this._parser = WsnNameParser.getParser(env);
        if (this._env != null && "eager".equals(nsConnection = this._env.get("com.ibm.websphere.naming.namespace.connection"))) {
            this.getContextIfNull();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "<init>", this.toDebugString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getContext() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getContext");
        }
        Object object = this._initCtxLock;
        synchronized (object) {
            if (!this._haveInitCtx) {
                this._context = this._factory.getInitialContextInternal(this._env);
                this._haveInitCtx = true;
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getContext", "_context=" + this._context);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getContext");
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "lookup", "name=" + name);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "lookup", namingException);
            }
            throw namingException;
        }
        Object object = null;
        Context urlCtx = null;
        if (name != null) {
            urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
        }
        if (urlCtx != null) {
            object = urlCtx.lookup(name);
        } else {
            this.getContextIfNull();
            object = this._context.lookup(name);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "lookup", object);
        }
        return object;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(this._parser.parse(name));
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "bind", new String[]{"name=" + name, "object=" + object});
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "bind", namingException);
            }
            throw namingException;
        }
        CNContextImpl.validateName(name);
        Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
        if (urlCtx != null) {
            urlCtx.bind(name, object);
        } else {
            this.getContextIfNull();
            this._context.bind(name, object);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "bind");
        }
    }

    @Override
    public void bind(String name, Object object) throws NamingException {
        this.bind(this._parser.parse(name), object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "rebind", new String[]{"name=" + name, "object=" + object});
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "rebind", namingException);
            }
            throw namingException;
        }
        CNContextImpl.validateName(name);
        Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
        if (urlCtx != null) {
            urlCtx.rebind(name, object);
        } else {
            this.getContextIfNull();
            this._context.rebind(name, object);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "rebind");
        }
    }

    @Override
    public void rebind(String name, Object object) throws NamingException {
        this.rebind(this._parser.parse(name), object);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "unbind", "name=" + name);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "unbind", namingException);
            }
            throw namingException;
        }
        CNContextImpl.validateName(name);
        Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
        if (urlCtx != null) {
            urlCtx.unbind(name);
        } else {
            this.getContextIfNull();
            this._context.unbind(name);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "unbind");
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(this._parser.parse(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "rename", new String[]{"oldName=" + oldName, "newName=" + newName});
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "rename", namingException);
            }
            throw namingException;
        }
        CNContextImpl.validateName(oldName);
        CNContextImpl.validateName(newName);
        boolean oldIsUrl = NameFormatHelper.isUrl(oldName);
        boolean newIsUrl = NameFormatHelper.isUrl(newName);
        if (oldIsUrl && newIsUrl) {
            Context urlCtxOld = CNContextImpl.checkForUrlContext(oldName, this._env);
            urlCtxOld.rename(oldName, newName);
        } else if (!oldIsUrl && !newIsUrl) {
            this.getContextIfNull();
            this._context.rename(oldName, newName);
        } else {
            OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException("Crossing name spaces is not supported: " + oldName + " " + newName);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "rename", operationNotSupportedException);
            }
            throw operationNotSupportedException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "rename");
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(this._parser.parse(oldName), this._parser.parse(newName));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createSubcontext", "name=" + name);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createSubcontext", namingException);
            }
            throw namingException;
        }
        Context newContext = null;
        CNContextImpl.validateName(name);
        Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
        if (urlCtx != null) {
            newContext = urlCtx.createSubcontext(name);
        } else {
            this.getContextIfNull();
            newContext = this._context.createSubcontext(name);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createSubcontext", newContext);
        }
        return newContext;
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this._parser.parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroySubcontext", "name=" + name);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "destroySubcontext", namingException);
            }
            throw namingException;
        }
        CNContextImpl.validateName(name);
        Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
        if (urlCtx != null) {
            urlCtx.destroySubcontext(name);
        } else {
            this.getContextIfNull();
            this._context.destroySubcontext(name);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroySubcontext");
        }
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(this._parser.parse(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "list", "name=" + name);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "list", namingException);
            }
            throw namingException;
        }
        NamingEnumeration<NameClassPair> namingEnumeration = null;
        Context urlCtx = null;
        if (name != null) {
            urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
        }
        if (urlCtx != null) {
            namingEnumeration = urlCtx.list(name);
        } else {
            this.getContextIfNull();
            namingEnumeration = this._context.list(name);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "list", namingEnumeration);
        }
        return namingEnumeration;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(this._parser.parse(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "listBindings", "name=" + name);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "listBindings", namingException);
            }
            throw namingException;
        }
        NamingEnumeration<Binding> namingEnumeration = null;
        Context urlCtx = null;
        if (name != null) {
            urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
        }
        if (urlCtx != null) {
            namingEnumeration = urlCtx.listBindings(name);
        } else {
            this.getContextIfNull();
            namingEnumeration = this._context.listBindings(name);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "listBindings", namingEnumeration);
        }
        return namingEnumeration;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(this._parser.parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "lookupLink", "name=" + name);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "lookupLink", namingException);
            }
            throw namingException;
        }
        Object object = null;
        Context urlCtx = null;
        if (name != null) {
            urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
        }
        if (urlCtx != null) {
            object = urlCtx.lookupLink(name);
        } else {
            this.getContextIfNull();
            object = this._context.lookupLink(name);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "lookupLink", object);
        }
        return object;
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this._parser.parse(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNameParser", "name=" + name);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getNameParser", namingException);
            }
            throw namingException;
        }
        NameParser nameParser = null;
        Context urlCtx = null;
        if (name != null) {
            urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
        }
        if (urlCtx != null) {
            nameParser = urlCtx.getNameParser(name);
        } else {
            this.getContextIfNull();
            nameParser = this._context.getNameParser(name);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNameParser", nameParser);
        }
        return nameParser;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(this._parser.parse(name));
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "composeName", new String[]{"name=" + name, "prefix=" + prefix});
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "composeName", namingException);
            }
            throw namingException;
        }
        Name newName = null;
        Context urlCtx = null;
        if (name != null) {
            urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
        }
        if (urlCtx != null) {
            newName = urlCtx.composeName(name, prefix);
        } else {
            this.getContextIfNull();
            newName = this._context.composeName(name, prefix);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "composeName", newName);
        }
        return newName;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(this._parser.parse(name), this._parser.parse(prefix)).toString();
    }

    @Override
    public Object addToEnvironment(String propertyName, Object propertyValue) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addToEnvironment", new String[]{"propertyName=" + propertyName, "propertyValue=" + propertyValue});
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "addToEnvironment", namingException);
            }
            throw namingException;
        }
        this.getContextIfNull();
        Object previousValue = this._context.addToEnvironment(propertyName, propertyValue);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addToEnvironment", previousValue);
        }
        return previousValue;
    }

    @Override
    public Object removeFromEnvironment(String propertyName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "removeFromEnvironment", "propertyName=" + propertyName);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "removeFromEnvironment", namingException);
            }
            throw namingException;
        }
        this.getContextIfNull();
        Object previousValue = this._context.removeFromEnvironment(propertyName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeFromEnvironment", previousValue);
        }
        return previousValue;
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getEnvironment", namingException);
            }
            throw namingException;
        }
        this.getContextIfNull();
        return this._context.getEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "close");
        }
        Object object = this._initCtxLock;
        synchronized (object) {
            if (this._haveInitCtx && this._context != null) {
                this._context.close();
            }
            this._closed = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "close");
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getNameInNamespace", namingException);
            }
            throw namingException;
        }
        this.getContextIfNull();
        return this._context.getNameInNamespace();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append('[');
        try {
            stringBuilder.append(this.getNameInNamespace());
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toDebugString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[_env=");
        stringBuilder.append(this._env);
        stringBuilder.append(", _factory=");
        stringBuilder.append(this._factory);
        stringBuilder.append(", _parser=");
        stringBuilder.append(this._parser);
        stringBuilder.append(", _context=");
        stringBuilder.append(this._context);
        stringBuilder.append(", _haveInitCtx=");
        stringBuilder.append(this._haveInitCtx);
        stringBuilder.append(", _closed=");
        stringBuilder.append(this._closed);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void getContextIfNull() throws NamingException {
        if (!this._haveInitCtx) {
            this.getContext();
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/util/WsnInitCtx.java, WAS.naming.client, WAS70.SERV1, cf050925.09, ver. 1.12");
        }
        CLASS_NAME = WsnInitCtx.class.getName();
    }
}

