/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.CannotInstantiateObjectException;
import com.ibm.ws.naming.util.CommonHelpers;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.naming.NamingException;

public class Serialization {
    private static final TraceComponent _tc = Tr.register(Serialization.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;

    public static byte[] serializeObject(Object obj) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "serializeObject");
        }
        if (obj == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "serializeObject", "Object is null.");
            }
            return null;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "serializeObject", "Class name=" + obj.getClass().getName());
        }
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oo = new ObjectOutputStream(bo);
            oo.writeObject(obj);
            oo.flush();
        }
        catch (IOException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "serializeObject", "92");
            Tr.warning(_tc, "serializationErr");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "serializeObject", e);
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "serializeObject");
        }
        return bo.toByteArray();
    }

    public static Object deserializeObject(byte[] val) throws IOException, ClassNotFoundException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "deserializeObject");
        }
        if (val == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "deserializeObject", "Value is null.");
            }
            return null;
        }
        try {
            final ByteArrayInputStream bi = new ByteArrayInputStream(val);
            Object retObj = null;
            try {
                retObj = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        WsObjectInputStream oi = new WsObjectInputStream(bi);
                        return oi.readObject();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                RasUtil.logException(pae, _tc, CLASS_NAME, "deserializeObject", "133");
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)e;
                }
                CommonHelpers.handleDoPrivilegedUnmatchedException(e, _tc);
            }
            if (retObj != null && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "deserializeObject", "Class name=" + retObj.getClass().getName());
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "deserializeObject", retObj);
            }
            return retObj;
        }
        catch (IOException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "deserializeObject", "153");
            Tr.warning(_tc, "deserializationErr");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "deserializeObject", e);
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "deserializeObject", "161");
            Tr.warning(_tc, "deserializationErr");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "deserializeObject", e);
            }
            throw e;
        }
    }

    public static String bytesToString(byte[] byteArray) {
        StringBuilder result = new StringBuilder(byteArray.length * 2);
        for (byte b : byteArray) {
            String string = Integer.toHexString(b);
            int length = string.length();
            if (length > 2) {
                result.append(string.substring(length - 2));
                continue;
            }
            if (length == 1) {
                result.append("0");
                result.append(string.substring(0, 1));
                continue;
            }
            result.append(string);
        }
        return result.toString();
    }

    public static byte[] stringToBytes(String string) throws NamingException {
        int length;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stringToBytes", "string=" + string);
        }
        if ((length = string.length()) % 2 != 0) {
            CannotInstantiateObjectException ne = new CannotInstantiateObjectException("Length of string \"" + string + "\" is not a multiple of 2.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "stringToBytes", ne);
            }
            throw ne;
        }
        byte[] result = new byte[length / 2];
        try {
            int i = 0;
            int j = 0;
            while (i < length) {
                String high = string.substring(i, i + 1);
                byte highNibble = Byte.parseByte(high, 16);
                String low = string.substring(i + 1, i + 2);
                byte lowNibble = Byte.parseByte(low, 16);
                result[j] = (byte)(highNibble << 4 | lowNibble);
                i += 2;
                ++j;
            }
        }
        catch (NumberFormatException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "stringToBytes", "224");
            CannotInstantiateObjectException ne = new CannotInstantiateObjectException("Error converting string \"" + string + "\" to a byte array.");
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "stringToBytes", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stringToBytes");
        }
        return result;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/ws/naming/util/Serialization.java, WAS.naming, WAS70.SERV1, cf050925.09, ver. 1.4.1.13");
        }
        CLASS_NAME = Serialization.class.getName();
    }
}

