/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.InsJndiNameImpl;
import com.ibm.ws.naming.util.LdapJndiNameImpl;
import com.ibm.ws.naming.util.RasUtil;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class NameFormatHelper {
    private static final TraceComponent _tc = Tr.register(NameFormatHelper.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static final String[] SINO_JNDI_NAME_DELIMITER;
    private static final String[] LDAP_JNDI_NAME_NEEDS_ESCAPING;
    private static final String[] LDAP_JNDI_NAME_ESCAPE_SEQUENCE;
    private static final String LDAP_JNDI_NAME_PREFIX = "ibm-wsnName=";
    private static final String LDAP_JNDI_NAME_DELIMITER = ",";

    public static Name convertInsJndiNameToLdapJndiName(Name insJndiName) throws InvalidNameException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "convertInsJndiNameToLdapJndiName", "insJndiName=" + insJndiName);
        }
        LdapJndiNameImpl ldapJndiName = new LdapJndiNameImpl();
        boolean isEscaped = false;
        int insJndiNameSize = insJndiName.size();
        for (int i = 0; i < insJndiNameSize; ++i) {
            String currentInsJndiNamePiece = insJndiName.get(i);
            String currentJndiNameComponent = "";
            int currentInsJndiNameLength = currentInsJndiNamePiece.length();
            for (int j = 0; j < currentInsJndiNameLength; ++j) {
                for (int k = 0; k < LDAP_JNDI_NAME_NEEDS_ESCAPING.length; ++k) {
                    if (!currentInsJndiNamePiece.regionMatches(j, LDAP_JNDI_NAME_NEEDS_ESCAPING[k], 0, LDAP_JNDI_NAME_NEEDS_ESCAPING[k].length())) continue;
                    isEscaped = true;
                    currentJndiNameComponent = currentJndiNameComponent + LDAP_JNDI_NAME_ESCAPE_SEQUENCE[k];
                    int ttmp = LDAP_JNDI_NAME_NEEDS_ESCAPING[k].length() - 1;
                    if (ttmp <= 0) continue;
                    j += ttmp;
                }
                if (!isEscaped) {
                    currentJndiNameComponent = currentJndiNameComponent + currentInsJndiNamePiece.charAt(j);
                    continue;
                }
                isEscaped = false;
            }
            try {
                ldapJndiName.add(LDAP_JNDI_NAME_PREFIX + currentJndiNameComponent);
                continue;
            }
            catch (InvalidNameException e) {
                RasUtil.logException(e, _tc, CLASS_NAME, "convertInsJndiNameToLdapJndiName", "129");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "convertInsJndiNameToLdapJndiName", "current JndiName component \"" + currentJndiNameComponent + "\" was invalid");
                }
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "convertInsJndiNameToLdapJndiName", e.toString());
                }
                throw e;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "convertInsJndiNameToLdapJndiName", ldapJndiName);
        }
        return ldapJndiName;
    }

    public static Name convertLdapStringNameToLdapJndiName(String ldapStringName) throws InvalidNameException {
        return new LdapJndiNameImpl(ldapStringName);
    }

    public static Name convertLdapJndiNameToInsJndiName(Name ldapJndiName) throws InvalidNameException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "convertLdapJndiNameToInsJndiName", "ldapJndiName=" + ldapJndiName);
        }
        InsJndiNameImpl insJndiName = new InsJndiNameImpl();
        boolean isEscaped = false;
        int ldapJndiNameSize = ldapJndiName.size();
        for (int i = 0; i < ldapJndiNameSize; ++i) {
            String currentLdapJndiNamePiece = ldapJndiName.get(i);
            String currentJndiNameComponent = "";
            if (!currentLdapJndiNamePiece.regionMatches(0, LDAP_JNDI_NAME_PREFIX, 0, LDAP_JNDI_NAME_PREFIX.length())) {
                InvalidNameException ine = new InvalidNameException("LdapJndiName \"" + ldapJndiName + "\" did not have the expected prefix");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "convertLdapJndiNameToInsJndiName", ine.toString());
                }
                throw ine;
            }
            currentLdapJndiNamePiece = currentLdapJndiNamePiece.substring(LDAP_JNDI_NAME_PREFIX.length());
            int currentLdapJndiNamePieceLength = currentLdapJndiNamePiece.length();
            for (int j = 0; j < currentLdapJndiNamePieceLength; ++j) {
                for (int k = 0; k < LDAP_JNDI_NAME_NEEDS_ESCAPING.length; ++k) {
                    if (!currentLdapJndiNamePiece.regionMatches(j, LDAP_JNDI_NAME_ESCAPE_SEQUENCE[k], 0, LDAP_JNDI_NAME_ESCAPE_SEQUENCE[k].length())) continue;
                    isEscaped = true;
                    currentJndiNameComponent = currentJndiNameComponent + LDAP_JNDI_NAME_NEEDS_ESCAPING[k];
                    int ttmp = LDAP_JNDI_NAME_ESCAPE_SEQUENCE[k].length() - 1;
                    if (ttmp <= 0) continue;
                    j += ttmp;
                }
                if (!isEscaped) {
                    currentJndiNameComponent = currentJndiNameComponent + currentLdapJndiNamePiece.charAt(j);
                    continue;
                }
                isEscaped = false;
            }
            insJndiName.add(currentJndiNameComponent);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "convertLdapJndiNameToInsJndiName", insJndiName);
        }
        return insJndiName;
    }

    public static String convertLdapJndiNameToLdapStringName(Name ldapJndiName) throws InvalidNameException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "convertLdapJndiNameToLdapStringName", "ldapJndiName=" + ldapJndiName);
        }
        String ldapStringName = "";
        int ldapJndiNameSize = ldapJndiName.size();
        for (int i = ldapJndiNameSize - 1; i >= 0; --i) {
            String currentJndiNameComponent = ldapJndiName.get(i);
            for (int j = 0; j < SINO_JNDI_NAME_DELIMITER.length; ++j) {
                if (currentJndiNameComponent.indexOf(LDAP_JNDI_NAME_DELIMITER) == -1) continue;
                InvalidNameException ine = new InvalidNameException("LdapJndiName \"" + ldapJndiName + "\" component \"" + currentJndiNameComponent + "\" contains delimiters");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "convertLdapJndiNameToLdapStringName", ine.toString());
                }
                throw ine;
            }
            ldapStringName = ldapStringName + currentJndiNameComponent;
            if (i == 0) continue;
            ldapStringName = ldapStringName + LDAP_JNDI_NAME_DELIMITER;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "convertLdapJndiNameToLdapStringName", ldapStringName);
        }
        return ldapStringName;
    }

    public static String getUrlScheme(String url) {
        int colonLoc;
        String scheme = null;
        if (url != null && NameFormatHelper.isSchemeValid(url, colonLoc = url.indexOf(58))) {
            scheme = url.substring(0, colonLoc).toLowerCase();
        }
        return scheme;
    }

    public static String getUrlScheme(Name name) {
        return !name.isEmpty() ? NameFormatHelper.getUrlScheme(name.get(0)) : null;
    }

    public static boolean isUrl(String url) {
        boolean result = false;
        if (url != null) {
            int colonLoc = url.indexOf(58);
            result = NameFormatHelper.isSchemeValid(url, colonLoc);
        }
        return result;
    }

    public static boolean isUrl(Name name) {
        return !name.isEmpty() ? NameFormatHelper.isUrl(name.get(0)) : false;
    }

    public static boolean isSchemeValid(String scheme, int colonLoc) {
        if (colonLoc < 1) {
            return false;
        }
        if (!Character.isLetter(scheme.charAt(0))) {
            return false;
        }
        for (int i = 1; i < colonLoc; ++i) {
            char c = scheme.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') continue;
            return false;
        }
        return true;
    }

    private NameFormatHelper() {
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/ws/naming/util/NameFormatHelper.java, WAS.naming, WAS70.SERV1, cf050925.09, ver. 1.8.1.11");
        }
        CLASS_NAME = NameFormatHelper.class.getName();
        SINO_JNDI_NAME_DELIMITER = new String[]{"/", "\\"};
        LDAP_JNDI_NAME_NEEDS_ESCAPING = new String[]{LDAP_JNDI_NAME_DELIMITER, "=", "+", "<", ">", "#", ";", "\\", "\""};
        LDAP_JNDI_NAME_ESCAPE_SEQUENCE = new String[]{"\\,", "\\=", "\\+", "\\<", "\\>", "\\#", "\\;", "\\\\\\", "\\\""};
    }
}

