/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.jndicos.CNContext;
import com.ibm.ws.naming.util.BooleanWrapper;
import com.ibm.ws.naming.util.JavaObjectHolder;
import com.ibm.ws.naming.util.JndiLookupInfo;
import com.ibm.ws.naming.util.NullRefAddrException;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.Serialization;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndirectJndiLookupObjectFactory
implements ObjectFactory {
    private static final TraceComponent _tc = Tr.register(IndirectJndiLookupObjectFactory.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static final Set<String> _jndiListProperties;

    public IndirectJndiLookupObjectFactory() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "<init>");
        }
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> env) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getObjectInstance", new String[]{"obj=" + obj, "name=" + name, "nameCtx=" + nameCtx, "env=" + env});
        }
        Object object = null;
        try {
            object = IndirectJndiLookupObjectFactory.getObjectInstanceExt(obj, name, nameCtx, env, new BooleanWrapper(false), new JavaObjectHolder());
        }
        catch (NamingException ne) {
            RasUtil.logException((Throwable)ne, _tc, CLASS_NAME, "getObjectInstance", "157", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getObjectInstance", ne.toString());
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getObjectInstance", object);
        }
        return object;
    }

    public static Object getObjectInstanceExt(final Object obj, Name name, Context nameCtx, final Hashtable<?, ?> env, final BooleanWrapper haveExtendedData, final JavaObjectHolder unprocessedJavaObject) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getObjectInstanceExt", new String[]{"obj=" + obj, "name=" + name, "nameCtx=" + nameCtx, "env=" + env, "haveExtendedData=" + haveExtendedData, "unprocessedJavaObject=" + unprocessedJavaObject});
        }
        haveExtendedData.value = false;
        unprocessedJavaObject.value = null;
        Object object = null;
        try {
            object = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    InitialContext initCtx;
                    Object retObj = null;
                    if (!(obj instanceof Reference)) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "getObjectInstanceExt", "obj is not an instance of Reference" + (obj != null ? " (class=" + obj.getClass().getName() + ")" : ""));
                        }
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "getObjectInstanceExt", retObj);
                        }
                        return retObj;
                    }
                    Reference ref = (Reference)obj;
                    String factoryClassName = ref.getFactoryClassName();
                    if (!IndirectJndiLookupObjectFactory.class.getName().equals(factoryClassName)) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "getObjectInstanceExt", "This is not the factory for this object; factoryClassName=" + factoryClassName);
                        }
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "getObjectInstanceExt", retObj);
                        }
                        return retObj;
                    }
                    RefAddr addr = ref.get("JndiLookupInfo");
                    if (addr == null) {
                        NullRefAddrException ne = new NullRefAddrException("The address for this Reference is null");
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "getObjectInstanceExt", ne.toString());
                        }
                        throw ne;
                    }
                    JndiLookupInfo info = (JndiLookupInfo)addr.getContent();
                    String jndiNameString = info.getJndiName();
                    if (jndiNameString == null || jndiNameString.length() == 0) {
                        NamingException ne = new NamingException("Failed to lookup the object configured with a null or empty name.");
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "getObjectInstanceExt", ne.toString());
                        }
                        throw ne;
                    }
                    Properties props = null;
                    addr = ref.get("IndirectJndiLookupAdditionalProperties");
                    if (addr != null) {
                        byte[] propsBytes = (byte[])addr.getContent();
                        try {
                            props = (Properties)Serialization.deserializeObject(propsBytes);
                        }
                        catch (Throwable t) {
                            RasUtil.logException(t, _tc, CLASS_NAME, "getObjectInstanceExt", "283");
                            NamingException ne = new NamingException("Error occurred while attempting to deserialize Properties object.");
                            ne.initCause(t);
                            if (_tc.isEntryEnabled()) {
                                Tr.exit(_tc, "getObjectInstanceExt", ne);
                            }
                            throw ne;
                        }
                    }
                    Hashtable clonedEnv = null;
                    clonedEnv = env != null ? (Hashtable)env.clone() : new Hashtable();
                    IndirectJndiLookupObjectFactory.mergePropsIntoEnv(clonedEnv, props);
                    String initFactory = info.getInitialContextFactory();
                    if (initFactory == null || initFactory.length() == 0) {
                        Object o = clonedEnv.get("com.ibm.ws.naming.java.realns.factory.initial");
                        if (o == null) {
                            initFactory = "com.ibm.websphere.naming.WsnInitialContextFactory";
                        } else if (o instanceof String) {
                            initFactory = (String)o;
                            if (initFactory.length() == 0) {
                                initFactory = "com.ibm.websphere.naming.WsnInitialContextFactory";
                            }
                        } else {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "getObjectInstanceExt", "Value for the property \"com.ibm.ws.naming.java.realns.factory.initial\" is not a String.");
                            }
                            initFactory = "com.ibm.websphere.naming.WsnInitialContextFactory";
                        }
                    }
                    clonedEnv.remove("java.naming.factory.initial");
                    clonedEnv.put("java.naming.factory.initial", initFactory);
                    String provUrl = info.getProviderUrl();
                    if (provUrl == null || provUrl.length() == 0) {
                        Object o = clonedEnv.get("com.ibm.ws.naming.java.realns.provider.url");
                        if (o == null) {
                            provUrl = null;
                        } else if (o instanceof String) {
                            provUrl = (String)o;
                        } else {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "getObjectInstanceExt", "Value for the property \"com.ibm.ws.naming.java.realns.provider.url\" is not a String.");
                            }
                            provUrl = null;
                        }
                    }
                    clonedEnv.remove("java.naming.provider.url");
                    if (provUrl != null) {
                        clonedEnv.put("java.naming.provider.url", provUrl);
                    }
                    try {
                        initCtx = new InitialContext(clonedEnv);
                    }
                    catch (NamingException ne) {
                        RasUtil.logException((Throwable)ne, _tc, CLASS_NAME, "getObjectInstanceExt", "358", this);
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "getObjectInstanceExt", ne.toString());
                        }
                        throw ne;
                    }
                    try {
                        Context ctx = (Context)initCtx.lookup("");
                        if (ctx instanceof CNContext) {
                            haveExtendedData.value = true;
                            retObj = ((CNContext)ctx).lookupExt(jndiNameString, haveExtendedData, unprocessedJavaObject);
                        } else {
                            retObj = initCtx.lookup(jndiNameString);
                        }
                    }
                    catch (NamingException ne) {
                        try {
                            int i;
                            NameParser parser2 = initCtx.getNameParser("");
                            Name jndiName = parser2.parse(jndiNameString);
                            int jndiNameSize = jndiName.size();
                            Context currCtx = initCtx;
                            for (i = 0; i < jndiNameSize - 1; ++i) {
                                Object intermediateObj;
                                String nameCompString = jndiName.get(i);
                                Name nameComp = parser2.parse(nameCompString);
                                if (nameCompString.length() == 0) {
                                    nameComp.add("");
                                }
                                if (!((intermediateObj = currCtx.lookup(nameComp)) instanceof Context)) break;
                                currCtx = (Context)intermediateObj;
                                parser2 = currCtx.getNameParser("");
                            }
                            if (i != jndiNameSize - 1) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "getObjectInstanceExt", "Indirect federated lookup: Object bound with name " + jndiName.getPrefix(i + 1) + " is not a context.");
                                }
                                if (_tc.isEntryEnabled()) {
                                    Tr.exit(_tc, "getObjectInstanceExt", ne.toString());
                                }
                                throw ne;
                            }
                            Name leafName = jndiName.getSuffix(jndiNameSize - 1);
                            retObj = currCtx.lookup(leafName);
                        }
                        catch (NamingException ne2) {
                            RasUtil.logException((Throwable)ne2, _tc, CLASS_NAME, "getObjectInstanceExt", "433", this);
                            if (_tc.isEntryEnabled()) {
                                Tr.exit(_tc, "getObjectInstanceExt", ne.toString());
                            }
                            throw ne;
                        }
                    }
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getObjectInstanceExt", retObj);
                    }
                    return retObj;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            RasUtil.logException(pae, _tc, CLASS_NAME, "getObjectInstanceExt", "447");
            Exception e = pae.getException();
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getObjectInstanceExt", "Throwing original exception: " + e);
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getObjectInstanceExt", object);
        }
        return object;
    }

    private static void mergePropsIntoEnv(Hashtable<Object, Object> env, Properties props) {
        if (props == null) {
            return;
        }
        for (Map.Entry<Object, Object> property : props.entrySet()) {
            Object o;
            String key = (String)property.getKey();
            String value = (String)property.getValue();
            if (_jndiListProperties.contains(key) && (o = env.get(key)) instanceof String) {
                value = (String)o + ":" + value;
            }
            env.put(key, value);
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/ws/naming/util/IndirectJndiLookupObjectFactory.java, WAS.naming, WAS70.SERV1, cf050925.09, ver. 1.30");
        }
        CLASS_NAME = IndirectJndiLookupObjectFactory.class.getName();
        _jndiListProperties = new HashSet<String>();
        _jndiListProperties.add("java.naming.factory.object");
        _jndiListProperties.add("java.naming.factory.state");
        _jndiListProperties.add("java.naming.factory.url.pkgs");
        _jndiListProperties.add("java.naming.language");
    }
}

