/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.IndirectJndiLookupObjectFactory;
import com.ibm.ws.naming.util.JndiLookupInfo;
import com.ibm.ws.naming.util.JndiLookupInfoRefAddr;
import com.ibm.ws.naming.util.Serialization;
import java.io.IOException;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class IndirectJndiLookup
implements Referenceable {
    public static final String REF_ADDR_TYPE_PROPERTIES = "IndirectJndiLookupAdditionalProperties";
    private static final TraceComponent tc = Tr.register(IndirectJndiLookup.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String REF_CLASS_NAME = "java.lang.Object";
    private JndiLookupInfo _info;
    private String _refClassName;
    private Properties _props;
    private static final String METHOD_init = "init(String, String, String, String, Properties)";
    private static final String METHOD_getReference = "getReference()";

    public IndirectJndiLookup(String jndiName, String initialContextFactory, String providerUrl, boolean cacheable, String refClassName, Properties props) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IndirectJndiLookup(String, String, String, boolean, String, Properties)", "jndiName = " + jndiName);
        }
        this.init(jndiName, initialContextFactory, providerUrl, refClassName, props);
    }

    public IndirectJndiLookup(String jndiName, String initialContextFactory, String providerUrl, String refClassName, Properties props) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IndirectJndiLookup(String, String, String, String, Properties)", "jndiName = " + jndiName);
        }
        this.init(jndiName, initialContextFactory, providerUrl, refClassName, props);
    }

    public IndirectJndiLookup(String jndiName) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IndirectJndiLookup(String)", "jndiName = " + jndiName);
        }
        this.init(jndiName, "", "", REF_CLASS_NAME, null);
    }

    public IndirectJndiLookup(String jndiName, boolean cacheable) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IndirectJndiLookup(String, boolean)", "jndiName = " + jndiName);
        }
        this.init(jndiName, "", "", REF_CLASS_NAME, null);
    }

    public IndirectJndiLookup(String jndiName, String initialContextFactory, String providerUrl) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IndirectJndiLookup(String, String, String)", "jndiName = " + jndiName);
        }
        this.init(jndiName, initialContextFactory, providerUrl, REF_CLASS_NAME, null);
    }

    public IndirectJndiLookup(String jndiName, String initialContextFactory, String providerUrl, boolean cacheable) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IndirectJndiLookup(String, String, String, boolean)", "jndiName = " + jndiName);
        }
        this.init(jndiName, initialContextFactory, providerUrl, REF_CLASS_NAME, null);
    }

    public IndirectJndiLookup(String jndiName, String initialContextFactory, String providerUrl, boolean cacheable, String refClassName) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IndirectJndiLookup(String, String, String, boolean, String)", "jndiName = " + jndiName);
        }
        this.init(jndiName, initialContextFactory, providerUrl, refClassName, null);
    }

    public IndirectJndiLookup(String jndiName, String initialContextFactory, String providerUrl, String refClassName) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IndirectJndiLookup(String, String, String, String)", "jndiName = " + jndiName);
        }
        this.init(jndiName, initialContextFactory, providerUrl, refClassName, null);
    }

    private void init(String jndiName, String initialContextFactory, String providerUrl, String refClassName, Properties props) {
        Tr.entry(tc, METHOD_init);
        if (jndiName == null || jndiName.equals("")) {
            Tr.warning(tc, "indJndiLookupEmptyName", new Throwable());
        }
        this._info = new JndiLookupInfo(jndiName, initialContextFactory, providerUrl);
        if (refClassName == null || refClassName.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null or empty Reference class name specified.  Defaulting to java.lang.Object");
            }
            refClassName = REF_CLASS_NAME;
        }
        this._refClassName = refClassName;
        this._props = props;
        Tr.exit(tc, METHOD_init);
    }

    public Reference getReference() throws NamingException {
        Tr.entry(tc, METHOD_getReference);
        Reference ref = null;
        ref = new Reference(this._refClassName, new JndiLookupInfoRefAddr(this._info), IndirectJndiLookupObjectFactory.class.getName(), null);
        if (this._props != null) {
            byte[] propsBytes = null;
            try {
                propsBytes = Serialization.serializeObject(this._props);
            }
            catch (IOException e) {
                NamingException ne = new NamingException("Could not serialize Properties object.");
                ne.setRootCause(e);
                throw ne;
            }
            BinaryRefAddr propsRefAddr = new BinaryRefAddr(REF_ADDR_TYPE_PROPERTIES, propsBytes);
            ref.add(propsRefAddr);
        }
        Tr.exit(tc, METHOD_getReference);
        return ref;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/ws/naming/util/IndirectJndiLookup.java, WAS.naming, WAS70.SERV1, cf050925.09, ver. 1.18");
        }
    }
}

