/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.RasUtil;
import java.lang.reflect.Constructor;

public abstract class ImportProfileUtility {
    private static final TraceComponent _tc = Tr.register(ImportProfileUtility.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME = ImportProfileUtility.class.getName();
    private static final String IMPL_CLASS_NAME = "com.ibm.ws.naming.util.ImportProfileUtilityImpl";
    private static Constructor _implClassCtor;

    public static ImportProfileUtility createUtilityInstance(String workSpaceID, String targetNodeName) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", "workSpaceID=" + workSpaceID + ", targetNodeName" + targetNodeName);
        }
        if (_implClassCtor == null) {
            ImportProfileUtility.init_implClassCtor();
        }
        ImportProfileUtility instance = ImportProfileUtility.createImplInstance(workSpaceID, targetNodeName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "com.ibm.ws.naming.util.createUtilityInstance", instance);
        }
        return instance;
    }

    public abstract void updateNameBindings() throws Exception;

    private static ImportProfileUtility createImplInstance(String workSpaceID, String targetNodeName) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createImplInstance");
        }
        ImportProfileUtility instance = null;
        try {
            Object[] args = new Object[]{workSpaceID, targetNodeName};
            instance = (ImportProfileUtility)_implClassCtor.newInstance(args);
        }
        catch (Exception ex) {
            RasUtil.logException(ex, _tc, CLASS_NAME, "createImplInstance", "105");
            throw ex;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createImplInstance", instance);
        }
        return instance;
    }

    private static synchronized void init_implClassCtor() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "init_implClassCtor");
        }
        if (_implClassCtor == null) {
            try {
                Class<?> implClass = Class.forName(IMPL_CLASS_NAME);
                Class[] parameterType = new Class[]{String.class, String.class};
                _implClassCtor = implClass.getConstructor(parameterType);
            }
            catch (Exception ex) {
                RasUtil.logException(ex, _tc, CLASS_NAME, "init_implClassCtor", "127");
                _implClassCtor = null;
                Tr.warning(_tc, "cannotCreateImplClassCtor", IMPL_CLASS_NAME);
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "_implClassCtor already exists. ");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "init_implClassCtor");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/ws/naming/util/ImportProfileUtility.java, WAS.naming, WAS70.SERV1, cf050925.09, ver. 1.2");
        }
        _implClassCtor = null;
    }
}

