/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.oa.EJSORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.CannotInstantiateObjectException;
import com.ibm.ws.naming.util.BooleanWrapper;
import com.ibm.ws.naming.util.CacheableReference;
import com.ibm.ws.naming.util.CannotBindObjectException;
import com.ibm.ws.naming.util.CommonHelpers;
import com.ibm.ws.naming.util.DestroyedContext;
import com.ibm.ws.naming.util.IndirectJndiLookupObjectFactory;
import com.ibm.ws.naming.util.InvalidNameSyntaxException;
import com.ibm.ws.naming.util.InvalidObjectException;
import com.ibm.ws.naming.util.JavaObjectHolder;
import com.ibm.ws.naming.util.NameServerObjectFactoryException;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.Serialization;
import com.ibm.ws.naming.util.UnresolvedIORBinding;
import com.ibm.ws.naming.util.UnresolvedURLBinding;
import com.ibm.ws.naming.util.UnresolvedURLException;
import com.ibm.ws.naming.util.WsnName;
import com.ibm.ws.security.util.AccessController;
import java.applet.Applet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CosNaming.NameComponent;

public class Helpers
extends CommonHelpers {
    private static final TraceComponent _tc = Tr.register(Helpers.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static final String[] WSN_JNDI_PROPS;
    private static final char CONTEXT_ID_DELIMITER = ';';
    private static final String ORB_TO_USE_FACTORY_METHOD = "getORB";
    private static Hashtable<Object, Object> _wsnNameProps;
    private static ResourceBundle _wsnResourceBundle;
    private static Object _propLock;
    private static String[] _propKeys;
    private static String[] _propValues;
    private static int _propSize;
    private static boolean _providerPropertiesRead;

    private Helpers() {
    }

    public static ORB getOrb(Hashtable env) throws NamingException {
        Tr.entry(_tc, "getOrb()");
        ORB theOrb = null;
        try {
            if (env != null) {
                Throwable throwable;
                block12: {
                    throwable = null;
                    try {
                        Class orbAccessorClass;
                        theOrb = (ORB)env.get("java.naming.corba.orb");
                        if (theOrb != null) {
                            Tr.exit(_tc, "getOrb() - Using ORB from java.naming.corba.orb");
                            return theOrb;
                        }
                        String orbAccessorName = (String)env.get("com.ibm.CORBA.ORBInit");
                        if (orbAccessorName == null || orbAccessorName.length() <= 0) break block12;
                        final String tmpName = orbAccessorName;
                        try {
                            orbAccessorClass = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                                @Override
                                public Class run() throws Exception, LinkageError {
                                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                                    if (contextClassLoader == null) {
                                        throw new NullPointerException("Context class loader is null");
                                    }
                                    return Class.forName(tmpName, true, contextClassLoader);
                                }
                            });
                        }
                        catch (PrivilegedActionException pae) {
                            throw pae.getException();
                        }
                        Method method2 = orbAccessorClass.getMethod(ORB_TO_USE_FACTORY_METHOD, null);
                        theOrb = (ORB)method2.invoke(null, (Object[])null);
                        if (theOrb != null) {
                            Tr.exit(_tc, "getOrb() - Using ORB from com.ibm.CORBA.ORBInit");
                            return theOrb;
                        }
                    }
                    catch (Exception ex) {
                        throwable = ex;
                    }
                    catch (LinkageError ex) {
                        throwable = ex;
                    }
                }
                if (throwable != null) {
                    RasUtil.logException(throwable, _tc, CLASS_NAME, "getOrb", "337");
                    Tr.event(_tc, "Failed to successfully obtain ORB from from property java.naming.corba.orb or com.ibm.CORBA.ORBInit ignoring Exception: " + throwable);
                }
            }
            Applet applet = null;
            Properties props = null;
            if (env != null) {
                applet = (Applet)env.get("java.naming.applet");
                props = Helpers.hashtableToProperties(env);
            }
            theOrb = applet != null ? EJSORB.init(applet, null, -1, props) : EJSORB.init(null, -1, props);
            Tr.exit(_tc, "getOrb() - Using ORB from EJSORB.init()");
            return theOrb;
        }
        catch (Exception ex) {
            RasUtil.logException(ex, _tc, CLASS_NAME, "getOrb", "362");
            Tr.event(_tc, "Failed to initialize the ORB, Exception: " + ex);
            NamingException ne = new NamingException("Failed to initialize the ORB");
            ne.initCause(ex);
            throw ne;
        }
    }

    public static Properties hashtableToProperties(Hashtable h) {
        Properties p = new Properties();
        if (h != null) {
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                p.put(key, h.get(key));
            }
        }
        return p;
    }

    public static void throwIfNull(String name, String method2, Context thisCtx) throws NamingException {
        if (name == null) {
            String thisCtxName = thisCtx.getNameInNamespace();
            Tr.warning(_tc, "jndiNullName", new Object[]{thisCtxName, method2});
            String errMsg = "The Context at name path " + thisCtxName + " was passed a null name to the method " + method2 + ".";
            throw new InvalidNameException(errMsg);
        }
    }

    public static void throwIfNull(Name name, String method2, Context thisCtx) throws NamingException {
        if (name == null) {
            Helpers.throwIfNull((String)null, method2, thisCtx);
        }
    }

    public static void throwIfNullOrEmpty(String name, String method2, Context thisCtx) throws NamingException {
        if (name == null) {
            Helpers.throwIfNull((String)null, method2, thisCtx);
        }
        if (name.equals("")) {
            String thisCtxName = thisCtx.getNameInNamespace();
            Tr.warning(_tc, "jndiEmptyName", new Object[]{thisCtxName, method2});
            String errMsg = "The Context at name path " + thisCtxName + " was passed an empty name to the method " + method2 + ".";
            throw new InvalidNameException(errMsg);
        }
    }

    public static void throwIfNullOrEmpty(Name name, String method2, Context thisCtx) throws NamingException {
        if (name == null) {
            Helpers.throwIfNull((String)null, method2, thisCtx);
        }
        if (name.isEmpty()) {
            Helpers.throwIfNullOrEmpty("", method2, thisCtx);
        }
    }

    public static boolean trueIfEmptyOrThrowIfNull(String name, String method2, Context thisCtx) throws NamingException {
        if (name == null) {
            Helpers.throwIfNull((String)null, method2, thisCtx);
        }
        return name.equals("");
    }

    public static boolean trueIfEmptyOrThrowIfNull(Name name, String method2, Context thisCtx) throws NamingException {
        if (name == null) {
            Helpers.throwIfNull((String)null, method2, thisCtx);
        }
        return name.isEmpty();
    }

    public static String toString(NameComponent[] nc) {
        String retval = null;
        if (_wsnNameProps == null) {
            _wsnNameProps = new Hashtable();
            _wsnNameProps.put("com.ibm.websphere.naming.name.syntax", "ins");
        }
        try {
            WsnName wsnName = new WsnName(nc, _wsnNameProps);
            retval = "INSName-> " + wsnName.toString();
        }
        catch (InvalidNameException ine) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "toString(NameComponent[]) caught and ignored InvalidNameException:" + ine);
            }
            Tr.warning(_tc, "invCosNameIgnored");
            retval = "";
        }
        catch (InvalidNameSyntaxException inse) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "toString(NameComponent[]) caught and ignored InvalidNameSyntaxException:" + inse);
            }
            retval = "";
        }
        return retval;
    }

    public static Object processRemoteObjectForBinding(Object obj, ORB orb) throws NoSuchObjectException {
        Tr.entry(_tc, "processRemoteObjectForBinding");
        Object retObj = obj;
        if (obj instanceof Remote) {
            block4: {
                Tr.debug(_tc, "processRemoteObjectForBinding: Object is a remote object.");
                retObj = PortableRemoteObject.toStub((Remote)((Remote)obj));
                try {
                    if (retObj instanceof Stub) {
                        Tr.debug(_tc, "processRemoteObjectForBinding: Stub is a CORBA stub.");
                        ((Stub)retObj).connect(orb);
                    }
                }
                catch (RemoteException e) {
                    RasUtil.logException(e, _tc, CLASS_NAME, "processRemoteObjectForBinding", "538");
                    if (!_tc.isDebugEnabled()) break block4;
                    Tr.debug(_tc, "Could not connect CORBA stub to ORB. Assuming that stub is already connected. Ignoring exception.");
                }
            }
            Tr.exit(_tc, "processRemoteObjectForBinding: Remote object");
            return retObj;
        }
        Tr.exit(_tc, "processRemoteObjectForBinding: Non-remote object");
        return retObj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object processJavaObjectForBinding(Object obj, boolean remoteContext, StringBuffer className) throws IOException, CannotBindObjectException, NamingException {
        Tr.entry(_tc, "processJavaObjectForBinding");
        if (obj == null) {
            Tr.exit(_tc, "processJavaObjectForBinding: null Java object");
            return null;
        }
        Object serializedObj = null;
        if (obj instanceof Referenceable) {
            try {
                Reference refObj = ((Referenceable)obj).getReference();
                if (refObj == null) {
                    String nameRefObj = obj.getClass().getName();
                    String cause = nameRefObj + ".getReference() returned null in " + "violation of the JNDI API";
                    NamingException ne = new NamingException(cause);
                    String tmpnameRefObj = nameRefObj;
                    Object tmpobj = obj;
                    Tr.warning(_tc, "getRefReturnNull", new String[]{tmpobj.toString(), tmpnameRefObj});
                    Tr.exit(_tc, "processJavaObjectForBinding", "getReference returns null ");
                    throw ne;
                }
                obj = refObj;
            }
            catch (NamingException e) {
                RasUtil.logException(e, _tc, CLASS_NAME, "processJavaObjectForBinding", "616");
                Tr.warning(_tc, "jndiGetRefErr");
                Tr.exit(_tc, "processJavaObjectForBinding", "getReference error");
                throw e;
            }
        }
        if (obj instanceof Reference) {
            className.append(((Reference)obj).getClassName());
        } else if (obj instanceof Context) {
            className.append("javax.naming.Context");
        } else {
            className.append(obj.getClass().getName());
        }
        if (remoteContext) {
            if (!(obj instanceof Serializable)) {
                Tr.warning(_tc, "jndiCannotBindObj");
                Tr.exit(_tc, "processJavaObjectForBinding", "Not Serializable");
                String msg = "Object is not of any type which can be bound.";
                throw new CannotBindObjectException(msg);
            }
            try {
                serializedObj = Serialization.serializeObject(obj);
            }
            catch (IOException e) {
                RasUtil.logException(e, _tc, CLASS_NAME, "processJavaObjectForBinding", "636");
                Tr.exit(_tc, "processJavaObjectForBinding", "IOException thrown");
                throw e;
            }
        } else if (!(!(obj instanceof Serializable) || obj instanceof String || obj instanceof Number || obj instanceof URL || obj instanceof Boolean || obj instanceof Character)) {
            try {
                serializedObj = Serialization.serializeObject(obj);
            }
            catch (IOException e) {
                RasUtil.logException(e, _tc, CLASS_NAME, "processJavaObjectForBinding", "660");
                Tr.exit(_tc, "processJavaObjectForBinding", "IOException thrown");
                throw e;
            }
        } else {
            serializedObj = obj;
        }
        Tr.exit(_tc, "processJavaObjectForBinding");
        return serializedObj;
    }

    public static Object processSerializedObjectForLookup(byte[] serializedObj, Context ctx, String bindingName, String className, Hashtable env, JavaObjectHolder unprocessedJavaObject, BooleanWrapper isCacheableReference) throws CannotInstantiateObjectException, InvalidObjectException, UnresolvedURLException, NameServerObjectFactoryException {
        Tr.entry(_tc, "processSerializedObjectForLookup");
        Object obj = Helpers.processSerializedObjectForLookupExt(serializedObj, ctx, bindingName, className, env, unprocessedJavaObject, isCacheableReference, new BooleanWrapper(false), new JavaObjectHolder());
        Tr.exit(_tc, "processSerializedObjectForLookup");
        return obj;
    }

    public static Object processSerializedObjectForLookupExt(byte[] serializedObj, Context ctx, String bindingName, String className, Hashtable env, JavaObjectHolder unprocessedJavaObject, BooleanWrapper isCacheableReference, BooleanWrapper haveExtendedData, JavaObjectHolder unprocessedIndirectJavaObject) throws CannotInstantiateObjectException, InvalidObjectException, UnresolvedURLException, NameServerObjectFactoryException {
        Tr.entry(_tc, "processSerializedObjectForLookupExt");
        String ctxName = "[not available]";
        try {
            ctxName = ctx.getNameInNamespace();
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "processSerializedObjectForLookupExt", "806");
        }
        haveExtendedData.value = false;
        unprocessedIndirectJavaObject.value = null;
        Object obj = null;
        try {
            unprocessedJavaObject.value = obj = Serialization.deserializeObject(serializedObj);
        }
        catch (IOException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "processSerializedObjectForLookupExt", "817");
            NameClassPair ncp = new NameClassPair(bindingName, className);
            CannotInstantiateObjectException ne = new CannotInstantiateObjectException("I/O Exception occurred while attempting to deserialize a retrieved object.", ncp);
            ne.initCause(e);
            Tr.exit(_tc, "processSerializedObjectForLookupExt", "CannotInstantiateObjectException thrown (root cause: I/O exception)");
            throw ne;
        }
        catch (ClassNotFoundException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "processSerializedObjectForLookupExt", "827");
            NameClassPair ncp = new NameClassPair(bindingName, className);
            CannotInstantiateObjectException ne = new CannotInstantiateObjectException("ClassNotFoundException occurred while attempting to deserialize retrieved object.", ncp);
            ne.initCause(e);
            Tr.exit(_tc, "processSerializedObjectForLookupExt", "CannotInstantiateObjectException thrown (root cause: Class not found)");
            throw ne;
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "processSerializedObjectForLookupExt", "837");
            NameClassPair ncp = new NameClassPair(bindingName, className);
            CannotInstantiateObjectException ne = new CannotInstantiateObjectException("An unexpected error occurred while attempting to deserialize retrieved object.", ncp);
            ne.initCause(t);
            Tr.exit(_tc, "processSerializedObjectForLookupExt", "CannotInstantiateObjectException thrown (root cause: Unexpected error)");
            throw ne;
        }
        if (obj instanceof DestroyedContext) {
            NameClassPair ncp = new NameClassPair(bindingName, "javax.naming.Context");
            Tr.exit(_tc, "processSerializedObjectForLookupExt: Throwing InvalidObjectException");
            throw new InvalidObjectException("Some context in the name \"" + bindingName + "\" relative to " + "the context \"" + ctxName + "\" has been destroyed.", ncp);
        }
        if (obj instanceof UnresolvedIORBinding) {
            NameClassPair ncp = new NameClassPair(bindingName, className);
            Tr.exit(_tc, "processSerializedObjectForLookupExt: Throwing InvalidObjectException");
            throw new InvalidObjectException("The IOR associated with the binding \"" + bindingName + "\" relative to the " + "context \"" + ctxName + "\" could not be resolved.  If the binding is for an " + "application object, make sure the application has started successfully. " + "IOR: " + ((UnresolvedIORBinding)obj).getIOR(), ncp);
        }
        if (obj instanceof UnresolvedURLBinding) {
            NameClassPair ncp = new NameClassPair(bindingName, className);
            Tr.exit(_tc, "processSerializedObjectForLookupExt: Throwing UnresolvedURLException");
            throw new UnresolvedURLException(bindingName + " is an UnresolvedURLBinding ", ncp, ((UnresolvedURLBinding)obj).getURL());
        }
        if (obj instanceof UNKNOWN) {
            UNKNOWN ue = (UNKNOWN)obj;
            if (ue.minor == 1229066372) {
                NameClassPair ncp = new NameClassPair(bindingName, className);
                NameServerObjectFactoryException nsofe = new NameServerObjectFactoryException("The binding \"" + bindingName + "\" could not be resolved due to an internal name server error.", ncp);
                nsofe.initCause((Throwable)ue);
                Tr.exit(_tc, "processSerializedObjectForLookupExt: Throwing NameServerObjectFactoryException", nsofe);
                throw nsofe;
            }
        }
        if (obj instanceof Reference) {
            Name n = null;
            try {
                try {
                    n = ctx.getNameParser("").parse(bindingName);
                }
                catch (Throwable t) {
                    RasUtil.logException(t, _tc, CLASS_NAME, "processSerializedObjectForLookupExt", "906");
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, "processSerializedObjectForLookupExt: Received an exception from the name parser while attempting to parse the name \"" + bindingName + "\".");
                }
                Object newObj = null;
                newObj = Helpers.isIndirectLookupReference(obj) ? IndirectJndiLookupObjectFactory.getObjectInstanceExt(obj, n, ctx, env, haveExtendedData, unprocessedIndirectJavaObject) : NamingManager.getObjectInstance(obj, n, ctx, env);
                try {
                    final Object tmpnewObj = newObj;
                    final String tmpctxName = ctxName;
                    final String tmpbindingName = bindingName;
                    final Object tmpobj = obj;
                    final Name tmpn = n;
                    final Context tmpctx = ctx;
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            if (tmpobj == tmpnewObj) {
                                Tr.warning(_tc, "jndiGetObjInstNoop", new String[]{tmpctxName, tmpbindingName, ((Reference)tmpobj).getFactoryClassName(), ((Reference)tmpobj).getFactoryClassLocation(), tmpobj.toString()});
                            }
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, "result of call: retObj=NamingManager.getObjectInstance(obj,n,ctx,env);", new String[]{"obj = " + tmpobj, "n   = " + tmpn, "ctx = " + tmpctx, "retObj = " + tmpnewObj});
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                if (obj instanceof CacheableReference) {
                    isCacheableReference.value = true;
                }
                obj = newObj;
            }
            catch (NameNotFoundException nnfe) {
                String javaLookupName;
                String exceptionMsg = null;
                RasUtil.logException(nnfe, _tc, CLASS_NAME, "processSerializedObjectForLookupExt", "967");
                String stringSeparator = "/";
                if (ctxName.endsWith(":") || ctxName.endsWith("/")) {
                    stringSeparator = "";
                }
                if ((javaLookupName = ctxName + stringSeparator + bindingName).startsWith("java:comp/env")) {
                    Tr.warning(_tc, "indirectNameNotFound", new String[]{javaLookupName, Helpers.getStackTrace(nnfe)});
                    exceptionMsg = "A NameNotFoundException occurred on an indirect lookup on the name " + javaLookupName + ". The name " + javaLookupName + " maps to a " + "JNDI name in deployment descriptor bindings for the application " + "performing the JNDI lookup. Make sure that the JNDI name mapping in " + "the deployment descriptor binding is correct. If the JNDI name mapping is " + "correct, make sure the target resource can be resolved with the " + "specified name relative to the default initial context. ";
                } else {
                    Tr.warning(_tc, "jndiGetObjInstErr", new String[]{ctxName, bindingName, ((Reference)obj).getFactoryClassName(), ((Reference)obj).getFactoryClassLocation(), obj.toString(), Helpers.getStackTrace(nnfe)});
                    exceptionMsg = "threw NameNotFoundException while the JNDI NamingManager was processing a javax.naming.Reference object.";
                }
                NameClassPair ncp = new NameClassPair(bindingName, className);
                CannotInstantiateObjectException coe = new CannotInstantiateObjectException(exceptionMsg, ncp, (Reference)obj);
                coe.initCause(nnfe);
                Tr.exit(_tc, "processSerializedObjectForLookupExt", "NameNotFoundException thrown in IndirectJndiLookupObjectFactory.getObjectInstance");
                throw coe;
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "processSerializedObjectForLookupExt", "1006");
                Tr.warning(_tc, "jndiGetObjInstErr", new String[]{ctxName, bindingName, ((Reference)obj).getFactoryClassName(), ((Reference)obj).getFactoryClassLocation(), obj.toString(), Helpers.getStackTrace(t)});
                NameClassPair ncp = new NameClassPair(bindingName, className);
                CannotInstantiateObjectException coe = new CannotInstantiateObjectException("Exception occurred while the JNDI NamingManager was processing a javax.naming.Reference object.", ncp, (Reference)obj);
                coe.initCause(t);
                Tr.exit(_tc, "processSerializedObjectForLookupExt", "Error occurred in NamingManager.getObjectInstance");
                throw coe;
            }
        }
        Tr.exit(_tc, "processSerializedObjectForLookupExt");
        return obj;
    }

    public static boolean isIndirectLookupReference(Object object) {
        boolean indirectLookupReference = false;
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            String factoryName = reference.getFactoryClassName();
            indirectLookupReference = IndirectJndiLookupObjectFactory.class.getName().equals(factoryName);
        }
        return indirectLookupReference;
    }

    public static Any bytesToAny(byte[] bytes, ORB orb) {
        Tr.entry(_tc, "bytesToAny");
        Any any = orb.create_any();
        any.insert_Value((Serializable)bytes);
        Tr.exit(_tc, "bytesToAny");
        return any;
    }

    public static byte[] anyToBytes(Any any) {
        return (byte[])any.extract_Value();
    }

    public static String formatMessage(String msgKey) {
        ResourceBundle msgs = Helpers.getWsnResourceBundle();
        String msg = null;
        try {
            if (msgs != null) {
                String format = MessageFormat.format(msgs.getString(msgKey), null);
                return format;
            }
            msg = "WebSphere Naming message table not found.";
        }
        catch (MissingResourceException e) {
            msg = "WebSphere Naming message or message table not found.";
        }
        return msg;
    }

    public static String formatMessage(String msgKey, String[] inserts) {
        ResourceBundle msgs = Helpers.getWsnResourceBundle();
        String msg = null;
        try {
            if (msgs != null) {
                String format = MessageFormat.format(msgs.getString(msgKey), inserts);
                return format;
            }
            msg = "WebSphere Naming message table not found.";
        }
        catch (MissingResourceException e) {
            msg = "WebSphere Naming message or message table not found.";
        }
        return msg;
    }

    private static ResourceBundle getWsnResourceBundle() {
        if (_wsnResourceBundle == null) {
            _wsnResourceBundle = (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

                @Override
                public ResourceBundle run() {
                    return ResourceBundle.getBundle("com.ibm.ws.naming.util.WsnMessages");
                }
            });
        }
        return _wsnResourceBundle;
    }

    public static String getStackTrace(Throwable t) {
        ByteArrayOutputStream baStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(baStream);
        t.printStackTrace(printStream);
        return baStream.toString();
    }

    public static String contextIDsToString(String[] contextIDs) {
        StringBuilder buff = new StringBuilder(256);
        for (int i = 0; i < contextIDs.length; ++i) {
            buff.append(contextIDs[i]);
            if (i >= contextIDs.length - 1) continue;
            buff.append(';');
        }
        return buff.toString();
    }

    public static String[] stringToContextIDs(String contextIDs) {
        if (contextIDs == null) {
            contextIDs = "";
        }
        int numIDs = contextIDs.length() > 0 ? 1 : 0;
        int idIndex = contextIDs.indexOf(59);
        while (idIndex != -1) {
            ++numIDs;
            ++idIndex;
            idIndex = contextIDs.indexOf(59, idIndex);
        }
        String[] outArray = new String[numIDs];
        if (numIDs == 0) {
            return outArray;
        }
        int i = 0;
        int idIndex2 = contextIDs.indexOf(59);
        int idStart = 0;
        while (idIndex2 != -1) {
            outArray[i] = contextIDs.substring(idStart, idIndex2);
            ++i;
            idStart = ++idIndex2;
            idIndex2 = contextIDs.indexOf(59, idIndex2);
        }
        outArray[i] = contextIDs.substring(idStart);
        return outArray;
    }

    public static boolean isCacheable(String[] contextIDStrings) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "isCacheable", "contextIDStrings=" + Arrays.toString(contextIDStrings));
        }
        boolean cacheable = true;
        if (contextIDStrings != null) {
            for (int i = 0; i < contextIDStrings.length && cacheable; ++i) {
                if (!"<...DO NOT CACHE...>".equals(contextIDStrings[i])) continue;
                cacheable = false;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "isCacheable", Boolean.toString(cacheable));
        }
        return cacheable;
    }

    public static NamingException logJndiContextException(Throwable t, Context ctx, String ctxMethod, Name targetName, String otherData) {
        String targetNameString = targetName == null ? null : targetName.toString();
        return Helpers.logJndiContextException(t, ctx, ctxMethod, targetNameString, otherData);
    }

    public static NamingException logJndiContextException(Throwable t, Context ctx, String ctxMethod, String targetName, String otherData) {
        String nameInNameSpace;
        int STACK_TRACE_INDEX = 5;
        if (targetName == null) {
            targetName = "[N/A]";
        }
        if (otherData == null) {
            otherData = "";
        }
        try {
            nameInNameSpace = ctx.getNameInNamespace();
        }
        catch (NamingException e) {
            nameInNameSpace = "[N/A]";
        }
        String msgKey = "jndiNamingException";
        String[] msgInserts = new String[]{ctx.getClass().getName(), ctxMethod, nameInNameSpace, targetName, otherData, ""};
        NamingException ne = null;
        if (!(t instanceof NamingException)) {
            ne = new NamingException("The JNDI operation \"" + ctxMethod + "\" on the context \"" + nameInNameSpace + "\" with the name \"" + targetName + "\" failed.  Please get the root cause Throwable contained in this " + "NamingException for more information.");
            ne.initCause(t);
        } else {
            ne = (NamingException)t;
        }
        if (ne instanceof NameNotFoundException) {
            if (_tc.isDebugEnabled()) {
                msgInserts[5] = Helpers.getStackTrace(t);
                Tr.debug(_tc, msgKey, msgInserts);
            }
        } else if (ne instanceof NameAlreadyBoundException) {
            if (_tc.isDebugEnabled()) {
                msgInserts[5] = Helpers.getStackTrace(t);
                Tr.debug(_tc, Helpers.formatMessage(msgKey, msgInserts));
            }
        } else {
            msgInserts[5] = Helpers.getStackTrace(t);
            Tr.warning(_tc, msgKey, msgInserts);
        }
        return ne;
    }

    public static Object extractCtxImplFromInitCtx(Object o) throws NamingException {
        if (o instanceof InitialContext) {
            Tr.debug(_tc, "extractCtxImplFromInitCtx: Extracting Context Impl from InitialContext.");
            return ((InitialContext)o).lookup("");
        }
        return o;
    }

    public static Throwable findRootCause(Throwable throwable) {
        Throwable root;
        Tr.entry(_tc, "findRootCause");
        Throwable next = root = throwable;
        while (next != null) {
            root = next;
            Tr.debug(_tc, "findRootCause unwrapping " + root.getClass().getName());
            if (root instanceof RemoteException) {
                next = ((RemoteException)root).detail;
                continue;
            }
            if (root instanceof UnknownException) {
                next = ((UnknownException)root).originalEx;
                continue;
            }
            next = null;
        }
        Tr.exit(_tc, "findRootCause");
        return root;
    }

    public static UnknownException createUnknownException(Throwable cause) {
        Throwable rootCause = Helpers.findRootCause(cause);
        UnknownException ue = new UnknownException(rootCause);
        return ue;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/util/Helpers.java, WAS.naming.client, WAS70.SERV1, cf050925.09, ver. 1.26.1.76");
        }
        CLASS_NAME = Helpers.class.getName();
        WSN_JNDI_PROPS = new String[]{"java.naming.corba.orb", "com.ibm.CORBA.ORBInit", "com.ibm.websphere.naming.namespaceroot", "com.ibm.websphere.naming.namespace.connection", "com.ibm.websphere.naming.jndicache.cacheobject", "com.ibm.websphere.naming.jndicache.cachename", "com.ibm.websphere.naming.jndicache.maxcachelife", "com.ibm.websphere.naming.jndicache.maxentrylife", "com.ibm.websphere.naming.name.syntax", "com.ibm.websphere.naming.generic.url.schemeid", "com.ibm.websphere.naming.generic.url.package", "com.ibm.websphere.naming.hostname.normalizer", "com.ibm.ws.naming.implementation", "com.ibm.ws.naming.ldap.masterurl", "com.ibm.ws.naming.ldap.containerdn", "com.ibm.ws.naming.ldap.noderootrdn", "com.ibm.ws.naming.ldap.config", "com.ibm.websphere.naming.ldapprotocoltrace", "com.ibm.websphere.naming.ldapprotocoltracefile"};
        _wsnNameProps = null;
        _wsnResourceBundle = null;
        _propLock = new Object();
        _propKeys = null;
        _propValues = null;
        _propSize = 0;
        _providerPropertiesRead = false;
    }
}

