/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.NameFormatHelper;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.RetryableAction;
import com.ibm.ws.naming.util.RetryableActionException;
import com.ibm.ws.naming.util.RetryableExceptionAction;
import com.ibm.ws.security.util.AccessController;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosNaming.NamingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonHelpers {
    private static final TraceComponent _tc = Tr.register(CommonHelpers.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static final boolean _debug;
    private static final String[] CACHEABLE_SYSTEM_PROPERTIES;
    private static final String[] NON_CACHEABLE_SYSTEM_PROPERTIES;
    private static Map<String, String> _cachedSystemProperties;
    private static Properties _jndiProviderProperties;
    private static Hashtable<Object, Object> _insEnv;
    private static Hashtable<Object, Object> _jndiEnv;

    protected CommonHelpers() {
    }

    public static void mergeWsnJndiProperties(Hashtable<?, ?> env) {
        CommonHelpers.mergeWsnJndiPropertiesFromSysEnv(env);
        CommonHelpers.mergeJndiProviderProperties(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeWsnJndiPropertiesFromSysEnv(Hashtable<?, ?> env) {
        String propertyValue;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "mergeWsnJndiPropertiesFromSysEnv", "env=" + env);
        }
        HashMap<String, String> propertiesToAdd = new HashMap<String, String>();
        Properties systemProperties = null;
        try {
            systemProperties = (Properties)AccessController.doPrivileged(new PrivilegedAction<Properties>(){

                @Override
                public Properties run() {
                    return System.getProperties();
                }
            });
            Class<CommonHelpers> clazz = CommonHelpers.class;
            synchronized (CommonHelpers.class) {
                if (_cachedSystemProperties == null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "mergeWsnJndiPropertiesFromSysEnv", "Caching system properties");
                    }
                    _cachedSystemProperties = new HashMap<String, String>();
                    for (String propertyName : CACHEABLE_SYSTEM_PROPERTIES) {
                        String propertyValue2 = systemProperties.getProperty(propertyName);
                        if (propertyValue2 == null) continue;
                        _cachedSystemProperties.put(propertyName, propertyValue2);
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "mergeWsnJndiPropertiesFromSysEnv", "_cachedSystemProperties=" + _cachedSystemProperties);
                }
                for (String propertyName : NON_CACHEABLE_SYSTEM_PROPERTIES) {
                    propertyValue = systemProperties.getProperty(propertyName);
                    if (propertyValue == null) continue;
                    propertiesToAdd.put(propertyName, propertyValue);
                }
                if (_cachedSystemProperties.size() > 0) {
                    propertiesToAdd.putAll(_cachedSystemProperties);
                }
            }
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "mergeWsnJndiPropertiesFromSysEnv", "219");
        }
        {
            if (propertiesToAdd.size() > 0) {
                Hashtable<?, ?> writableEnv = env;
                for (Map.Entry property : propertiesToAdd.entrySet()) {
                    String propertyName = (String)property.getKey();
                    propertyValue = (String)property.getValue();
                    if (writableEnv.containsKey(propertyName)) continue;
                    writableEnv.put(propertyName, propertyValue);
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "mergeWsnJndiPropertiesFromSysEnv", "No properties to add");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "mergeWsnJndiPropertiesFromSysEnv");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeJndiProviderProperties(Hashtable<?, ?> env) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "mergeJndiProviderProperties", "env=" + env);
        }
        Class<CommonHelpers> clazz = CommonHelpers.class;
        synchronized (CommonHelpers.class) {
            if (_jndiProviderProperties == null) {
                _jndiProviderProperties = new Properties();
                final InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        ClassLoader classLoader = this.getClass().getClassLoader();
                        return classLoader.getResourceAsStream("com/ibm/websphere/naming/jndiprovider.properties");
                    }
                });
                if (inputStream != null) {
                    try {
                        try {
                            _jndiProviderProperties = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                                @Override
                                public Properties run() throws Exception {
                                    Properties properties = new Properties();
                                    properties.load(inputStream);
                                    return properties;
                                }
                            });
                        }
                        catch (PrivilegedActionException pae) {
                            throw pae.getException();
                        }
                    }
                    catch (Exception e) {
                        RasUtil.logException(e, _tc, CLASS_NAME, "mergeJndiProviderProperties", "289");
                        Tr.warning(_tc, "jndiproviderProperties");
                    }
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "mergeJndiProviderProperties", "Resource not found: com/ibm/websphere/naming/jndiprovider.properties");
                    }
                    Tr.warning(_tc, "jndiproviderProperties");
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "mergeJndiProviderProperties", CommonHelpers.traceHashtable("com/ibm/websphere/naming/jndiprovider.properties", _jndiProviderProperties));
                }
                if (_jndiProviderProperties.size() == 0) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "mergeJndiProviderProperties", "com/ibm/websphere/naming/jndiprovider.properties contains no properties");
                    }
                    Tr.warning(_tc, "jndiproviderProperties");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Hashtable<?, ?> writableEnv = env;
            for (Map.Entry<Object, Object> property : _jndiProviderProperties.entrySet()) {
                String propertyName = (String)property.getKey();
                String propertyValue = (String)property.getValue();
                if (writableEnv.containsKey(propertyName)) continue;
                writableEnv.put(propertyName, propertyValue);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "mergeJndiProviderProperties");
            }
            return;
        }
    }

    public static Hashtable<?, ?> getWsnJndiProperties() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getWsnJndiProperties");
        }
        Hashtable<?, ?> env = null;
        try {
            Context ctx = null;
            try {
                ctx = (Context)AccessController.doPrivileged(new PrivilegedExceptionAction<Context>(){

                    @Override
                    public Context run() throws Exception {
                        Hashtable<String, String> env = new Hashtable<String, String>();
                        env.put("java.naming.factory.initial", "com.ibm.ws.naming.util.EnvOnlyContextFactory");
                        return new InitialContext(env);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
            env = ctx.getEnvironment();
        }
        catch (Exception e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "getWsnJndiProperties", "364");
            String cause = "Failed to get environment. ";
            Tr.warning(_tc, "generalWithInsert", "getWsnJndiProperties: " + cause);
            NamingException ne = null;
            if (e instanceof NamingException) {
                ne = (NamingException)e;
            } else {
                ne = new NamingException(cause);
                ne.initCause(e);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getWsnJndiProperties", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getWsnJndiProperties", env);
        }
        return env;
    }

    public static Context getContextIfUrlName(Name name, Hashtable<?, ?> env) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getContextIfUrlName", new String[]{"name=" + name, "env=" + env});
        }
        Context ctx = null;
        if (!name.isEmpty()) {
            ctx = CommonHelpers.getContextIfUrlName(name.get(0), env);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getContextIfUrlName", ctx);
        }
        return ctx;
    }

    public static Context getContextIfUrlName(String name, Hashtable<?, ?> env) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getContextIfUrlName", new String[]{"name=" + name, "env=" + env});
        }
        Context ctx = null;
        if (NameFormatHelper.isUrl(name)) {
            String scheme = NameFormatHelper.getUrlScheme(name);
            try {
                ctx = NamingManager.getURLContext(scheme, (Hashtable)env.clone());
            }
            catch (NamingException ne) {
                RasUtil.logException(ne, _tc, CLASS_NAME, "getContextIfUrlName", "442");
                Tr.warning(_tc, "urlGetUrlCtxErr", scheme);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getContextIfUrlName", ne);
                }
                throw ne;
            }
            if (ctx == null) {
                Tr.warning(_tc, "urlNullUrlCtx", scheme);
                ConfigurationException ne = new ConfigurationException("NamingManager.getURLContext returned a null Context for the scheme " + scheme + ".");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getContextIfUrlName", ne);
                }
                throw ne;
            }
        }
        if (ctx != null && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "getContextIfUrlName", "ctx class=" + ctx.getClass().getName());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getContextIfUrlName", ctx);
        }
        return ctx;
    }

    public static Object extractCtxImplFromInitCtx(Object o) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getContextIfUrlName", "o=" + o + (o != null ? " (class=" + o.getClass().getName() + ")" : ""));
        }
        Object ctxImpl = null;
        if (o instanceof InitialContext) {
            InitialContext initCtx = (InitialContext)o;
            ctxImpl = initCtx.lookup("");
        } else {
            ctxImpl = o;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getContextIfUrlName", ctxImpl);
        }
        return ctxImpl;
    }

    public static boolean isDistributedNC(NamingContext ctx) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "isDistributedNC", "ctx=" + ctx);
        }
        boolean distributedNC = false;
        if (ctx instanceof com.ibm.WsnOptimizedNaming.NamingContext) {
            final com.ibm.WsnOptimizedNaming.NamingContext nc = (com.ibm.WsnOptimizedNaming.NamingContext)ctx;
            distributedNC = CommonHelpers.retry(new RetryableAction<Boolean>(){

                @Override
                public Boolean run() {
                    return nc.get_compatibility_level() >= 1;
                }
            });
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "isDistributedNC", Boolean.toString(distributedNC));
        }
        return distributedNC;
    }

    public static String[] traceHashtable(String title, Hashtable<?, ?> hashtable) {
        int size = hashtable.size();
        ArrayList<String> output = new ArrayList<String>(size + 1);
        output.add("Hashtable \"" + title + "\" (size=" + size + "):");
        for (Map.Entry<?, ?> entry : hashtable.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            output.add("  " + key + " --> " + value);
        }
        return output.toArray(new String[output.size()]);
    }

    public static void handleDoPrivilegedUnmatchedException(Exception e, TraceComponent tcOfCaller) {
        TraceComponent tcToUse = tcOfCaller;
        if (tcToUse == null) {
            tcToUse = _tc;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        NamingException ne = new NamingException("Exception occurring in doPrivileged block was not properly handled.");
        ne.initCause(e);
        Tr.warning(tcToUse, "generalWithInsert", ne);
    }

    public static String objectToTerseString(Object object) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(object.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(object.hashCode()));
        return stringBuilder.toString();
    }

    public static String collectionToTerseString(Collection<?> collection) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(collection.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(((Object)collection).hashCode()));
        stringBuilder.append("[size=");
        stringBuilder.append(collection.size());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String mapToTerseString(Map<?, ?> map) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(map.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(((Object)map).hashCode()));
        stringBuilder.append("[size=");
        stringBuilder.append(map.size());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static Hashtable<?, ?> getJNDIEnvironment() {
        return _jndiEnv;
    }

    public static Hashtable<?, ?> getINSEnvironment() {
        return _insEnv;
    }

    public static void closeIfContext(Object object) {
        block3: {
            if (object instanceof Context) {
                Context context = (Context)object;
                try {
                    context.close();
                }
                catch (Exception e) {
                    RasUtil.logException(e, _tc, CLASS_NAME, "closeIfContext", "692");
                    if (!_tc.isDebugEnabled()) break block3;
                    Tr.debug(_tc, "closeIfContext", "context=" + context);
                }
            }
        }
    }

    public static <T> T retry(RetryableAction<T> action) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "retry");
        }
        T result = null;
        boolean retry = false;
        do {
            retry = false;
            try {
                result = action.run();
            }
            catch (TRANSIENT e) {
                if (e.minor != 1229066306) {
                    RasUtil.logException(e, _tc, CLASS_NAME, "retry", "721");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "retry", (Object)e);
                    }
                    throw e;
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "retry", "received WLM exception signaling a retry: " + e.toString());
                }
                retry = true;
            }
            catch (RuntimeException e) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "retry", e.toString());
                }
                throw e;
            }
        } while (retry);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "retry", result);
        }
        return result;
    }

    public static <T> T retry(RetryableExceptionAction<T> action) throws RetryableActionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "retry");
        }
        T result = null;
        boolean retry = false;
        do {
            retry = false;
            try {
                result = action.run();
            }
            catch (TRANSIENT e) {
                if (e.minor != 1229066306) {
                    RasUtil.logException(e, _tc, CLASS_NAME, "retry", "767");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "retry", (Object)e);
                    }
                    throw e;
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "retry", "received WLM exception signaling a retry: " + e.toString());
                }
                retry = true;
            }
            catch (RuntimeException e) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "retry", e.toString());
                }
                throw e;
            }
            catch (Exception e) {
                RetryableActionException wrapper = new RetryableActionException(e);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "retry", wrapper.toString());
                }
                throw wrapper;
            }
        } while (retry);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "retry", result);
        }
        return result;
    }

    public static String getStringProperty(Hashtable<?, ?> env, String key) throws ConfigurationException {
        return CommonHelpers.getStringProperty(env, key, false, null);
    }

    public static String getStringProperty(Hashtable<?, ?> env, String key, boolean required) throws ConfigurationException {
        return CommonHelpers.getStringProperty(env, key, required, null);
    }

    public static String getStringProperty(Hashtable<?, ?> env, String key, boolean required, String defaultValue) throws ConfigurationException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getStringProperty", new String[]{"env=" + (_debug ? env.toString() : CommonHelpers.mapToTerseString(env)), "key=" + key, "required=" + required, "defaultValue=" + defaultValue});
        }
        String value = defaultValue;
        Object object = env.get(key);
        if (object instanceof String) {
            value = (String)object;
        } else if (object == null) {
            if (required) {
                String message = "No value specified for required property " + key;
                ConfigurationException ce = new ConfigurationException(message);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getStringProperty", ce);
                }
                throw ce;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getStringProperty", "key \"" + key + "\" not found");
            }
        } else {
            String message = "The value of property " + key + " is not a string.";
            ConfigurationException ce = new ConfigurationException(message);
            RasUtil.logException(ce, _tc, CLASS_NAME, "getStringProperty", "867");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getStringProperty", ce);
            }
            throw ce;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getStringProperty", value);
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean getBooleanProperty(Hashtable<?, ?> env, String key, boolean required, boolean defaultValue) throws ConfigurationException {
        boolean value;
        block14: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getBooleanProperty", new String[]{"env=" + (_debug ? env.toString() : CommonHelpers.mapToTerseString(env)), "key=" + key, "required=" + required, "defaultValue=" + defaultValue});
            }
            value = defaultValue;
            Object object = env.get(key);
            if (object instanceof String) {
                String string = (String)object;
                if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false")) {
                    value = Boolean.parseBoolean(string);
                    break block14;
                } else {
                    String message = "Invalid value \"" + string + "\" specified for property " + key + ".  Valid values are \"true\" or \"false\".";
                    ConfigurationException ce = new ConfigurationException(message);
                    RasUtil.logException(ce, _tc, CLASS_NAME, "getBooleanProperty", "910");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getBooleanProperty", ce);
                    }
                    throw ce;
                }
            }
            if (object instanceof Boolean) {
                value = (Boolean)object;
            } else if (object == null) {
                if (required) {
                    String message = "No value specified for required property " + key;
                    ConfigurationException ce = new ConfigurationException(message);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getBooleanProperty", ce);
                    }
                    throw ce;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getBooleanProperty", "key \"" + key + "\" not found");
                }
            } else {
                String message = "The value of property " + key + " is not a string.";
                ConfigurationException ce = new ConfigurationException(message);
                RasUtil.logException(ce, _tc, CLASS_NAME, "getBooleanProperty", "931");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getBooleanProperty", ce);
                }
                throw ce;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getBooleanProperty", value);
        }
        return value;
    }

    public static String normalizeHostForUrl(String host) {
        String normalizedHost = null;
        if (host.indexOf(58) != -1) {
            StringBuilder stringBuilder = new StringBuilder(host.length() + 2);
            stringBuilder.append('[');
            stringBuilder.append(host);
            stringBuilder.append(']');
            normalizedHost = stringBuilder.toString();
        } else {
            normalizedHost = host;
        }
        return normalizedHost;
    }

    public static String getSystemProperty(final String key) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getSystemProperty", "key=" + key);
        }
        String value = (String)AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getSystemProperty", value);
        }
        return value;
    }

    public static void setSystemProperty(final String key, final String value) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setSystemProperty", new String[]{"key=" + key, "value=" + value});
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.setProperty(key, value);
                return null;
            }
        });
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setSystemProperty");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/ws/naming/util/CommonHelpers.java, WAS.naming, WAS70.SERV1, cf050925.09, ver. 1.19");
        }
        CLASS_NAME = CommonHelpers.class.getName();
        _debug = Boolean.getBoolean("com.ibm.ws.naming.debug");
        CACHEABLE_SYSTEM_PROPERTIES = new String[]{"com.ibm.websphere.naming.generic.url.schemeid", "com.ibm.websphere.naming.generic.url.package", "com.ibm.ws.naming.implementation", "com.ibm.ws.naming.ldap.masterurl", "com.ibm.ws.naming.ldap.containerdn", "com.ibm.ws.naming.ldap.noderootrdn", "com.ibm.ws.naming.ldap.config"};
        NON_CACHEABLE_SYSTEM_PROPERTIES = new String[]{"java.naming.corba.orb", "com.ibm.CORBA.ORBInit", "com.ibm.websphere.naming.namespaceroot", "com.ibm.websphere.naming.namespace.connection", "com.ibm.websphere.naming.jndicache.cacheobject", "com.ibm.websphere.naming.jndicache.cachename", "com.ibm.websphere.naming.jndicache.maxcachelife", "com.ibm.websphere.naming.jndicache.maxentrylife", "com.ibm.websphere.naming.name.syntax", "com.ibm.websphere.naming.hostname.normalizer", "com.ibm.websphere.naming.ldapprotocoltrace", "com.ibm.websphere.naming.ldapprotocoltracefile"};
        _cachedSystemProperties = null;
        _jndiProviderProperties = null;
        _insEnv = new Hashtable();
        _jndiEnv = new Hashtable();
        _insEnv.put("com.ibm.websphere.naming.name.syntax", "ins");
        _jndiEnv.put("com.ibm.websphere.naming.name.syntax", "jndi");
    }
}

