/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.urlbase;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.ipbase.ContextID;
import com.ibm.ws.naming.ipbase.NameNotAtomicException;
import com.ibm.ws.naming.ipbase.NameSpace;
import com.ibm.ws.naming.ipbase.NameSpaceBindingData;
import com.ibm.ws.naming.ipbase.NameSpaceEnumeration;
import com.ibm.ws.naming.ipbase.NameSpaceException;
import com.ibm.ws.naming.ipbase.NameSpaceInconsistentException;
import com.ibm.ws.naming.ipbase.StringContextID;
import com.ibm.ws.naming.ipbase.UuidContext;
import com.ibm.ws.naming.urlbase.UrlBindingEnumeration;
import com.ibm.ws.naming.urlbase.UrlContext;
import com.ibm.ws.naming.urlbase.UrlContextHelper;
import com.ibm.ws.naming.urlbase.UrlNameEnumeration;
import com.ibm.ws.naming.util.BooleanWrapper;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.JavaObjectHolder;
import com.ibm.ws.naming.util.NameFormatHelper;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.WsnNameParser;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public abstract class UrlContextImpl
implements UrlContext,
Serializable {
    protected static final int STRINGBUFFER_SIZE = 64;
    private static final TraceComponent _tc = Tr.register(UrlContextImpl.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    protected transient NameSpace _ns = null;
    protected transient StringContextID _strCtxID = null;
    protected transient UuidContext _parentCtx = null;
    protected transient WsnNameParser _parser = null;
    protected transient ORB _orb = null;
    protected Hashtable _env = null;
    protected String _schemeId = null;
    private static final String CLASS_ctor = "UrlContextImpl() Ctor";
    private static final String METHOD_bind = "bind(Name, Object)";
    private static final String METHOD_bindS = "bind(String, Object)";
    private static final String METHOD_rebind = "rebind(Name, Object)";
    private static final String METHOD_rebindS = "rebind(String, Object)";
    private static final String METHOD_unbind = "unbind(Name, Object)";
    private static final String METHOD_unbindS = "unbind(String, Object)";
    private static final String METHOD_composeName = "ComposeName(Name, Name)";
    private static final String METHOD_composeNameS = "ComposeName(String, String)";
    private static final String METHOD_createSubcontext = "createSubcontext(Name)";
    private static final String METHOD_createSubcontextS = "createSubcontext(String)";
    private static final String METHOD_destroySubcontext = "destroySubcontext(Name)";
    private static final String METHOD_destroySubcontextS = "destroySubcontext(String)";
    private static final String METHOD_getNameParser = "getNameParser(Name)";
    private static final String METHOD_getNameParserS = "getNameParser(String)";
    private static final String METHOD_list = "list(Name)";
    private static final String METHOD_listS = "list(String)";
    private static final String METHOD_listBindings = "listBinding(Name)";
    private static final String METHOD_listBindingsS = "listBindings(String)";
    private static final String METHOD_lookup = "lookup(Name)";
    private static final String METHOD_lookupS = "lookup(String)";
    private static final String METHOD_rename = "rename(Name, Name)";
    private static final String METHOD_renameS = "rename(String, String)";
    private static final String METHOD_addToEnvironment = "addToEnvironment(String, Object)";
    private static final String METHOD_getEnvironment = "getEnvironment()";
    private static final String METHOD_removeFromEnvironment = "removeEnvironment()";
    private static final String METHOD_close = "close()";
    private static final String METHOD_getParentBindingData = "getParentBindingData(Name)";
    private static final String METHOD_writeObject = "writeObject(ObjectOutputStream)";
    private static final String METHOD_readObject = "readObject(ObjectInputStream)";
    private static final String METHOD_processBoundObjectForLookup = "processBoundObjectForLookup";

    public UrlContextImpl(NameSpace ns, Hashtable env, StringContextID strCtxID, UuidContext parentCtx) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, CLASS_ctor);
        }
        this._env = env != null ? (Hashtable)env.clone() : new Hashtable();
        this._ns = ns;
        this._strCtxID = strCtxID;
        this._parentCtx = parentCtx;
        this._parser = WsnNameParser.getParser(env);
        this._orb = Helpers.getOrb(this._env);
        Tr.exit(_tc, CLASS_ctor);
    }

    public ContextID getContextID() {
        return this._strCtxID;
    }

    public UuidContext getParentCtx() {
        return this._parentCtx;
    }

    public void bind(Name inName, java.lang.Object obj) throws NamingException {
        block15: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, METHOD_bind, new String[]{"inName=" + inName + ", obj=" + obj});
            }
            try {
                Helpers.throwIfNullOrEmpty(inName, METHOD_bind, (Context)this);
                Name name = this.stripSchemeIdForUrlRootContext(inName);
                Context urlCtx = Helpers.getContextIfUrlName(name, this._env);
                if (urlCtx != null) {
                    urlCtx.bind(name, obj);
                    break block15;
                }
                try {
                    NameSpaceBindingData parentData = this.getParentBindingData(name);
                    if (this.isThisContextUpdatable(parentData)) {
                        String className = null;
                        java.lang.Object bindObj = null;
                        if ((obj = Helpers.processRemoteObjectForBinding(obj, this._orb)) instanceof Object) {
                            className = obj.getClass().getName();
                            bindObj = this.getStringifiedIOR((Object)obj);
                        } else if (obj instanceof Context) {
                            bindObj = obj;
                            className = "javax.naming.Context";
                        } else {
                            StringBuffer sbuf = new StringBuffer(64);
                            bindObj = Helpers.processJavaObjectForBinding(obj, this.isThisContextRemote(), sbuf);
                            className = sbuf.toString();
                        }
                        java.lang.Object addtionalData = this.createAdditionalData(parentData, className);
                        UrlContextImpl targetCtx = parentData != null ? (UuidContext)parentData.getBoundObject() : this;
                        this._ns.bind(targetCtx, name.getSuffix(name.size() - 1), bindObj, addtionalData);
                    }
                }
                catch (IOException ioe) {
                    RasUtil.logException((Throwable)ioe, _tc, CLASS_NAME, "bind", "265", this);
                    NamingException ne = new NamingException("java.io.IOException occurred during the serialization and the object cannot be bound.name=" + name);
                    ne.setRootCause(ioe);
                    Tr.debug(_tc, "Serialization failed and the object cannot be bound: " + ioe.getClass().getName());
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, METHOD_bind, " name=" + name);
                    }
                    throw ne;
                }
                catch (NameNotAtomicException nnae) {
                    RasUtil.logException((Throwable)nnae, _tc, CLASS_NAME, "bind", "291", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_bind, new java.lang.Object[]{"Internal error.  Failed with NameNotAtomicException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameNotAtomicException: " + nnae.toString());
                    ne.setRootCause(nnae);
                    Tr.exit(_tc, METHOD_bind);
                    throw ne;
                }
                catch (NameSpaceInconsistentException nsie) {
                    RasUtil.logException((Throwable)nsie, _tc, CLASS_NAME, "bind", "302", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_bind, new java.lang.Object[]{"Internal error.  Failed with NameSpaceInconsistentException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameSpaceInconsistentException: " + nsie.toString());
                    ne.setRootCause(nsie);
                    Tr.exit(_tc, METHOD_bind);
                    throw ne;
                }
                catch (NameSpaceException nse) {
                    RasUtil.logException((Throwable)nse, _tc, CLASS_NAME, "bind", "313", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_bind, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameSpaceException: " + nse.toString());
                    ne.setRootCause(nse);
                    Tr.exit(_tc, METHOD_bind);
                    throw ne;
                }
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "bind", "327", this);
                Tr.exit(_tc, "bind(Name, Object): exception");
                throw Helpers.logJndiContextException(t, (Context)this, METHOD_bind, inName, "Object to bind: " + obj);
            }
        }
        Tr.exit(_tc, METHOD_bind);
    }

    public void bind(String name, java.lang.Object obj) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "bind(String, Object) name=" + name);
        }
        try {
            Helpers.throwIfNullOrEmpty(name, METHOD_bindS, (Context)this);
            this.bind(this._parser.parse(name), obj);
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "bind", "349", this);
            Tr.exit(_tc, "bind(String, Object): exception");
            throw Helpers.logJndiContextException(t, (Context)this, METHOD_bindS, name, "Object to bind: " + obj);
        }
        Tr.exit(_tc, METHOD_bindS);
    }

    public void rebind(Name inName, java.lang.Object obj) throws NamingException {
        block15: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, METHOD_rebind, new String[]{"inName=" + inName + ", obj=" + obj});
            }
            try {
                Helpers.throwIfNullOrEmpty(inName, METHOD_rebind, (Context)this);
                Name name = this.stripSchemeIdForUrlRootContext(inName);
                Context urlCtx = Helpers.getContextIfUrlName(name, this._env);
                if (urlCtx != null) {
                    urlCtx.rebind(name, obj);
                    break block15;
                }
                try {
                    NameSpaceBindingData parentData = this.getParentBindingData(name);
                    if (this.isThisContextUpdatable(parentData)) {
                        String className = null;
                        java.lang.Object bindObj = null;
                        if ((obj = Helpers.processRemoteObjectForBinding(obj, this._orb)) instanceof Object) {
                            className = obj.getClass().getName();
                            bindObj = this.getStringifiedIOR((Object)obj);
                        } else if (obj instanceof Context) {
                            bindObj = obj;
                            className = "javax.naming.Context";
                        } else {
                            StringBuffer sbuf = new StringBuffer(64);
                            bindObj = Helpers.processJavaObjectForBinding(obj, this.isThisContextRemote(), sbuf);
                            className = sbuf.toString();
                        }
                        java.lang.Object addtionalData = this.createAdditionalData(parentData, className);
                        UrlContextImpl targetCtx = parentData != null ? (UuidContext)parentData.getBoundObject() : this;
                        this._ns.rebind(targetCtx, name.getSuffix(name.size() - 1), bindObj, addtionalData);
                    }
                }
                catch (IOException ioe) {
                    RasUtil.logException((Throwable)ioe, _tc, CLASS_NAME, "rebind", "436", this);
                    NamingException ne = new NamingException("java.io.IOException occurred during the serialization and the object cannot be bound.name=" + name);
                    ne.setRootCause(ioe);
                    Tr.debug(_tc, "Serialization failed and the object cannot be bound: " + ioe.getClass().getName());
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, METHOD_rebind, " name=" + name);
                    }
                    throw ne;
                }
                catch (NameNotAtomicException nnae) {
                    RasUtil.logException((Throwable)nnae, _tc, CLASS_NAME, "rebind", "460", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_rebind, new java.lang.Object[]{"Internal error.  Failed with NameNotAtomicException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameNotAtomicException: " + nnae.toString());
                    ne.setRootCause(nnae);
                    Tr.exit(_tc, METHOD_rebind);
                    throw ne;
                }
                catch (NameSpaceInconsistentException nsie) {
                    RasUtil.logException((Throwable)nsie, _tc, CLASS_NAME, "rebind", "471", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_rebind, new java.lang.Object[]{"Internal error.  Failed with NameSpaceInconsistentException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameSpaceInconsistentException: " + nsie.toString());
                    ne.setRootCause(nsie);
                    Tr.exit(_tc, METHOD_rebind);
                    throw ne;
                }
                catch (NameSpaceException nse) {
                    RasUtil.logException((Throwable)nse, _tc, CLASS_NAME, "rebind", "482", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_rebind, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameSpaceException: " + nse.toString());
                    ne.setRootCause(nse);
                    Tr.exit(_tc, METHOD_rebind);
                    throw ne;
                }
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "rebind", "496", this);
                Tr.exit(_tc, "rebind(Name, Object): exception");
                throw Helpers.logJndiContextException(t, (Context)this, METHOD_rebind, inName, "Object to bind: " + obj);
            }
        }
        Tr.exit(_tc, METHOD_rebind);
    }

    public void rebind(String name, java.lang.Object obj) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "rebind(String, Object) name=" + name);
        }
        try {
            Helpers.throwIfNullOrEmpty(name, METHOD_rebindS, (Context)this);
            this.rebind(this._parser.parse(name), obj);
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "rebind", "518", this);
            Tr.exit(_tc, "rebind(String, Object): exception");
            throw Helpers.logJndiContextException(t, (Context)this, METHOD_rebindS, name, "Object to bind: " + obj);
        }
        Tr.exit(_tc, METHOD_rebindS);
    }

    public void unbind(Name inName) throws NamingException {
        block9: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "unbind(Name, Object) inName=" + inName);
            }
            try {
                Helpers.throwIfNullOrEmpty(inName, METHOD_unbind, (Context)this);
                Name name = this.stripSchemeIdForUrlRootContext(inName);
                Context urlCtx = Helpers.getContextIfUrlName(name, this._env);
                if (urlCtx != null) {
                    urlCtx.unbind(name);
                    break block9;
                }
                try {
                    NameSpaceBindingData parentData = this.getParentBindingData(name);
                    if (this.isThisContextUpdatable(parentData)) {
                        UrlContextImpl targetCtx = parentData != null ? (UuidContext)parentData.getBoundObject() : this;
                        this._ns.unbind(targetCtx, name.getSuffix(name.size() - 1));
                    }
                }
                catch (NameNotAtomicException nnae) {
                    RasUtil.logException((Throwable)nnae, _tc, CLASS_NAME, "unbind", "573", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_unbind, new java.lang.Object[]{"Internal error.  Failed with NameNotAtomicException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameNotAtomicException: " + nnae.toString());
                    ne.setRootCause(nnae);
                    Tr.exit(_tc, METHOD_unbind);
                    throw ne;
                }
                catch (NameSpaceInconsistentException nsie) {
                    RasUtil.logException((Throwable)nsie, _tc, CLASS_NAME, "unbind", "584", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_unbind, new java.lang.Object[]{"Internal error.  Failed with NameSpaceInconsistentException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameSpaceInconsistentException: " + nsie.toString());
                    ne.setRootCause(nsie);
                    Tr.exit(_tc, METHOD_unbind);
                    throw ne;
                }
                catch (NameSpaceException nse) {
                    RasUtil.logException((Throwable)nse, _tc, CLASS_NAME, "unbind", "595", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_unbind, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameSpaceException: " + nse.toString());
                    ne.setRootCause(nse);
                    Tr.exit(_tc, METHOD_unbind);
                    throw ne;
                }
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "unbind", "609", this);
                Tr.exit(_tc, "unbind(Name, Object): exception");
                throw Helpers.logJndiContextException(t, (Context)this, METHOD_unbind, inName, null);
            }
        }
        Tr.exit(_tc, METHOD_unbind);
    }

    public void unbind(String name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "unbind(String, Object) name=" + name);
        }
        try {
            Helpers.throwIfNullOrEmpty(name, METHOD_unbindS, (Context)this);
            this.unbind(this._parser.parse(name));
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "unbind", "630", this);
            Tr.exit(_tc, "unbind(String, Object): exception");
            throw Helpers.logJndiContextException(t, (Context)this, METHOD_unbindS, name, null);
        }
        Tr.exit(_tc, METHOD_unbindS);
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ComposeName(Name, Name) name=" + name + " prefix=" + prefix);
        }
        Name retName = null;
        try {
            Helpers.throwIfNull(name, METHOD_composeName, (Context)this);
            Helpers.throwIfNull(prefix, METHOD_composeName, (Context)this);
            Context urlCtx = Helpers.getContextIfUrlName(name, this._env);
            if (urlCtx != null) {
                retName = urlCtx.composeName(name, prefix);
            } else {
                retName = this._parser.parse("");
                Enumeration<String> e = prefix.getAll();
                while (e.hasMoreElements()) {
                    String elem = e.nextElement();
                    retName.add(elem);
                }
                e = name.getAll();
                while (e.hasMoreElements()) {
                    retName.add(e.nextElement());
                }
            }
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "composeName", "676", this);
            Tr.exit(_tc, "ComposeName(Name, Name): exception");
            throw Helpers.logJndiContextException(t, (Context)this, METHOD_composeName, name, "prefix: " + prefix);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ComposeName(Name, Name) retName=" + retName);
        }
        return retName;
    }

    public String composeName(String name, String prefix) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ComposeName(String, String) name=" + name + " prefix=" + prefix);
        }
        String retStr = null;
        try {
            Helpers.throwIfNull(name, METHOD_composeNameS, (Context)this);
            Helpers.throwIfNull(prefix, METHOD_composeNameS, (Context)this);
            Name retName = this.composeName(this._parser.parse(name), this._parser.parse(prefix));
            retStr = retName.toString();
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "composeName", "708", this);
            Tr.exit(_tc, "ComposeName(String, String): exception");
            throw Helpers.logJndiContextException(t, (Context)this, METHOD_composeNameS, name, "prefix: " + prefix);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ComposeName(String, String) retStr=" + retStr);
        }
        return retStr;
    }

    public Context createSubcontext(Name inName) throws NamingException {
        Context retCtx;
        block9: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "createSubcontext(Name) inName=" + inName);
            }
            retCtx = null;
            try {
                Helpers.throwIfNullOrEmpty(inName, METHOD_createSubcontext, (Context)this);
                Name name = this.stripSchemeIdForUrlRootContext(inName);
                Context urlCtx = Helpers.getContextIfUrlName(name, this._env);
                if (urlCtx != null) {
                    retCtx = urlCtx.createSubcontext(name);
                    break block9;
                }
                try {
                    NameSpaceBindingData parentData = this.getParentBindingData(name);
                    if (this.isThisContextUpdatable(parentData)) {
                        String className = "javax.naming.Context";
                        java.lang.Object addtionalData = this.createAdditionalData(parentData, className);
                        UrlContextImpl targetCtx = parentData != null ? (UuidContext)parentData.getBoundObject() : this;
                        UuidContext newCtx = this.createNewSubcontext(name, targetCtx);
                        this._ns.createSubcontext(targetCtx, name.getSuffix(name.size() - 1), newCtx, addtionalData);
                        retCtx = (Context)((java.lang.Object)newCtx);
                    }
                }
                catch (NameNotAtomicException nnae) {
                    RasUtil.logException((Throwable)nnae, _tc, CLASS_NAME, "createSubcontext", "785", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_createSubcontext, new java.lang.Object[]{"Internal error.  Failed with NameNotAtomicException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameNotAtomicException: " + nnae.toString());
                    ne.setRootCause(nnae);
                    Tr.exit(_tc, METHOD_createSubcontext);
                    throw ne;
                }
                catch (NameSpaceInconsistentException nsie) {
                    RasUtil.logException((Throwable)nsie, _tc, CLASS_NAME, "createSubcontext", "796", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_createSubcontext, new java.lang.Object[]{"Internal error.  Failed with NameSpaceInconsistentException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameSpaceInconsistentException: " + nsie.toString());
                    ne.setRootCause(nsie);
                    Tr.exit(_tc, METHOD_createSubcontext);
                    throw ne;
                }
                catch (NameSpaceException nse) {
                    RasUtil.logException((Throwable)nse, _tc, CLASS_NAME, "createSubcontext", "807", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_createSubcontext, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameSpaceException: " + nse.toString());
                    ne.setRootCause(nse);
                    Tr.exit(_tc, METHOD_createSubcontext);
                    throw ne;
                }
            }
            catch (Throwable t) {
                Tr.exit(_tc, "createSubcontext(Name): exception");
                throw Helpers.logJndiContextException(t, (Context)this, METHOD_createSubcontext, inName, null);
            }
        }
        Tr.exit(_tc, METHOD_createSubcontext);
        return retCtx;
    }

    public Context createSubcontext(String name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createSubcontext(String) name=" + name);
        }
        Context retCtx = null;
        try {
            Helpers.throwIfNullOrEmpty(name, METHOD_createSubcontextS, (Context)this);
            retCtx = this.createSubcontext(this._parser.parse(name));
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "createSubcontext", "844", this);
            Tr.exit(_tc, "createSubcontext(String): exception");
            throw Helpers.logJndiContextException(t, (Context)this, METHOD_createSubcontextS, name, null);
        }
        Tr.exit(_tc, METHOD_createSubcontextS);
        return retCtx;
    }

    public void destroySubcontext(Name inName) throws NamingException {
        block9: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "destroySubcontext(Name) inName=" + inName);
            }
            try {
                Helpers.throwIfNullOrEmpty(inName, METHOD_destroySubcontext, (Context)this);
                Name name = this.stripSchemeIdForUrlRootContext(inName);
                Context urlCtx = Helpers.getContextIfUrlName(name, this._env);
                if (urlCtx != null) {
                    urlCtx.destroySubcontext(name);
                    break block9;
                }
                try {
                    NameSpaceBindingData parentData = this.getParentBindingData(name);
                    if (this.isThisContextUpdatable(parentData)) {
                        UrlContextImpl targetCtx = parentData != null ? (UuidContext)parentData.getBoundObject() : this;
                        this._ns.destroySubcontext(targetCtx, name.getSuffix(name.size() - 1));
                    }
                }
                catch (NameNotAtomicException nnae) {
                    RasUtil.logException((Throwable)nnae, _tc, CLASS_NAME, "destroySubcontext", "897", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_destroySubcontext, new java.lang.Object[]{"Internal error.  Failed with NameNotAtomicException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameNotAtomicException: " + nnae.toString());
                    ne.setRootCause(nnae);
                    Tr.exit(_tc, METHOD_destroySubcontext);
                    throw ne;
                }
                catch (NameSpaceInconsistentException nsie) {
                    RasUtil.logException((Throwable)nsie, _tc, CLASS_NAME, "destroySubcontext", "908", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_destroySubcontext, new java.lang.Object[]{"Internal error.  Failed with NameSpaceInconsistentException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameSpaceInconsistentException: " + nsie.toString());
                    ne.setRootCause(nsie);
                    Tr.exit(_tc, METHOD_destroySubcontext);
                    throw ne;
                }
                catch (NameSpaceException nse) {
                    RasUtil.logException((Throwable)nse, _tc, CLASS_NAME, "destroySubcontext", "919", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_destroySubcontext, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameSpaceException: " + nse.toString());
                    ne.setRootCause(nse);
                    Tr.exit(_tc, METHOD_destroySubcontext);
                    throw ne;
                }
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "destroySubcontext", "933", this);
                Tr.exit(_tc, "destroySubcontext(Name): exception");
                throw Helpers.logJndiContextException(t, (Context)this, METHOD_destroySubcontext, inName, null);
            }
        }
        Tr.exit(_tc, METHOD_destroySubcontext);
    }

    public void destroySubcontext(String name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroySubcontext(String) name=" + name);
        }
        Helpers.throwIfNullOrEmpty(name, METHOD_destroySubcontextS, (Context)this);
        try {
            this.destroySubcontext(this._parser.parse(name));
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "destroySubcontext", "954", this);
            Tr.exit(_tc, "destroySubcontext(String): exception");
            throw Helpers.logJndiContextException(t, (Context)this, METHOD_destroySubcontextS, name, null);
        }
        Tr.exit(_tc, METHOD_destroySubcontextS);
    }

    public NameParser getNameParser(Name inName) throws NamingException {
        NameParser retParser;
        block6: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getNameParser(Name) inName=" + inName);
            }
            retParser = null;
            try {
                if (Helpers.trueIfEmptyOrThrowIfNull(inName, METHOD_getNameParser, (Context)this)) {
                    retParser = this._parser;
                    break block6;
                }
                Name name = this.stripSchemeIdForUrlRootContext(inName);
                Context urlCtx = Helpers.getContextIfUrlName(inName, this._env);
                if (urlCtx != null) {
                    retParser = urlCtx.getNameParser(name);
                    break block6;
                }
                java.lang.Object targetCtx = this.lookup(name);
                if (targetCtx instanceof Context) {
                    retParser = ((Context)targetCtx).getNameParser("");
                    break block6;
                }
                String cause = "The bound object by " + name.toString() + " is not a context";
                Tr.exit(_tc, METHOD_getNameParser);
                throw new NotContextException(cause);
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "getNameParser", "1005", this);
                Tr.exit(_tc, "getNameParser(Name): exception");
                throw Helpers.logJndiContextException(t, (Context)this, METHOD_getNameParser, inName, null);
            }
        }
        Tr.exit(_tc, METHOD_getNameParser);
        return retParser;
    }

    public NameParser getNameParser(String name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNameParser(String) name=" + name);
        }
        NameParser retParser = null;
        try {
            retParser = Helpers.trueIfEmptyOrThrowIfNull(name, METHOD_getNameParserS, (Context)this) ? this._parser : this.getNameParser(this._parser.parse(name));
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "getNameParser", "1030", this);
            Tr.exit(_tc, "getNameParser(String): exception");
            throw Helpers.logJndiContextException(t, (Context)this, METHOD_getNameParserS, name, null);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNameParser(String) retParser=" + retParser);
        }
        return retParser;
    }

    public NamingEnumeration list(Name inName) throws NamingException {
        UrlNameEnumeration retEnum;
        block6: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "list(Name) inName=" + inName);
            }
            retEnum = null;
            try {
                Helpers.throwIfNull(inName, METHOD_list, (Context)this);
                Name name = this.stripSchemeIdForUrlRootContext(inName);
                Context urlCtx = Helpers.getContextIfUrlName(inName, this._env);
                if (urlCtx != null) {
                    retEnum = urlCtx.list(name);
                    break block6;
                }
                try {
                    retEnum = new UrlNameEnumeration(this, this._parser, (NameSpaceEnumeration)this._ns.list(this, name));
                }
                catch (NameSpaceException nse) {
                    RasUtil.logException((Throwable)nse, _tc, CLASS_NAME, "list", "1071", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_list, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameSpaceException: " + nse.toString());
                    ne.setRootCause(nse);
                    Tr.exit(_tc, METHOD_list);
                    throw ne;
                }
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "list", "1085", this);
                Tr.exit(_tc, "list(Name): exception");
                throw Helpers.logJndiContextException(t, (Context)this, METHOD_list, inName, null);
            }
        }
        Tr.exit(_tc, METHOD_list);
        return retEnum;
    }

    public NamingEnumeration list(String name) throws NamingException {
        NamingEnumeration retEnum;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "list(String) name=" + name);
        }
        try {
            Helpers.throwIfNull(name, METHOD_listS, (Context)this);
            retEnum = this.list(this._parser.parse(name));
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "list", "1108", this);
            Tr.exit(_tc, "list(String): exception");
            throw Helpers.logJndiContextException(t, (Context)this, METHOD_listS, name, null);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "list(String) name=" + name);
        }
        return retEnum;
    }

    public NamingEnumeration listBindings(Name inName) throws NamingException {
        UrlBindingEnumeration retEnum;
        block6: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "listBinding(Name) inName=" + inName);
            }
            retEnum = null;
            try {
                Helpers.throwIfNull(inName, METHOD_listBindings, (Context)this);
                Name name = this.stripSchemeIdForUrlRootContext(inName);
                Context urlCtx = Helpers.getContextIfUrlName(inName, this._env);
                if (urlCtx != null) {
                    retEnum = urlCtx.listBindings(name);
                    break block6;
                }
                try {
                    retEnum = new UrlBindingEnumeration(this, this._parser, (NameSpaceEnumeration)this._ns.list(this, name));
                }
                catch (NameSpaceException nse) {
                    RasUtil.logException((Throwable)nse, _tc, CLASS_NAME, "listBindings", "1150", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_listBindings, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "name=" + name});
                    NamingException ne = new NamingException("Received unexpected NameSpaceException: " + nse.toString());
                    ne.setRootCause(nse);
                    Tr.exit(_tc, METHOD_listBindings);
                    throw ne;
                }
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "listBindings", "1164", this);
                Tr.exit(_tc, "listBinding(Name): exception");
                throw Helpers.logJndiContextException(t, (Context)this, METHOD_listBindings, inName, null);
            }
        }
        Tr.exit(_tc, METHOD_listBindings);
        return retEnum;
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        NamingEnumeration retEnum;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "listBindings(String) name=" + name);
        }
        try {
            Helpers.throwIfNull(name, METHOD_listBindingsS, (Context)this);
            retEnum = this.listBindings(this._parser.parse(name));
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "listBindings", "1187", this);
            Tr.exit(_tc, "listBindings(String): exception");
            throw Helpers.logJndiContextException(t, (Context)this, METHOD_listBindingsS, name, null);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "listBindings(String) name=" + name);
        }
        return retEnum;
    }

    public java.lang.Object lookup(Name inName) throws NamingException {
        java.lang.Object retObj;
        block8: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "lookup(Name) inName=" + inName);
            }
            retObj = null;
            try {
                if (Helpers.trueIfEmptyOrThrowIfNull(inName, METHOD_lookup, (Context)this)) {
                    retObj = this.cloneContext();
                    break block8;
                }
                Name name = this.stripSchemeIdForUrlRootContext(inName);
                Context urlCtx = Helpers.getContextIfUrlName(inName, this._env);
                if (urlCtx != null) {
                    retObj = urlCtx.lookup(name);
                    break block8;
                }
                NameSpaceBindingData bindingData = null;
                try {
                    bindingData = this._ns.lookup(this, name);
                }
                catch (NameSpaceException nse) {
                    RasUtil.logException((Throwable)nse, _tc, CLASS_NAME, "lookup", "1235", this);
                    Tr.warning(_tc, "unexpectedErr");
                    Tr.debug(_tc, METHOD_lookup, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "name=" + name});
                    Tr.exit(_tc, METHOD_lookup);
                    NamingException ne = new NamingException("Received unexpected NameSpaceException: " + nse.toString());
                    ne.setRootCause(nse);
                    throw ne;
                }
                java.lang.Object boundObj = bindingData.getBoundObject();
                retObj = this.processBoundObjectForLookup(bindingData, boundObj, inName, this._env);
            }
            catch (Throwable t) {
                Tr.exit(_tc, "lookup(Name): exception");
                throw Helpers.logJndiContextException(t, (Context)this, METHOD_lookup, inName, null);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "lookup(Name) retObj = " + retObj);
        }
        return retObj;
    }

    public java.lang.Object lookup(String name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "lookup(String) name=" + name);
        }
        java.lang.Object retObj = null;
        try {
            retObj = Helpers.trueIfEmptyOrThrowIfNull(name, METHOD_lookupS, (Context)this) ? this.cloneContext() : this.lookup(this._parser.parse(name));
        }
        catch (Throwable t) {
            Tr.exit(_tc, "lookup(String): exception");
            throw Helpers.logJndiContextException(t, (Context)this, METHOD_lookupS, name, null);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "lookup(String) retObj =" + retObj);
        }
        return retObj;
    }

    public java.lang.Object lookupLink(Name name) throws NamingException {
        OperationNotSupportedException ne = new OperationNotSupportedException();
        throw Helpers.logJndiContextException((Throwable)ne, (Context)this, "lookupLink(Name)", name, null);
    }

    public java.lang.Object lookupLink(String name) throws NamingException {
        OperationNotSupportedException ne = new OperationNotSupportedException();
        throw Helpers.logJndiContextException((Throwable)ne, (Context)this, "lookupLink(String)", name, null);
    }

    public void rename(Name inOldName, Name inNewName) throws NamingException {
        Name newName;
        Name oldName;
        block13: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "rename(Name, Name) inOldName=" + inOldName + "inNewName=" + inNewName);
            }
            try {
                Helpers.throwIfNullOrEmpty(inOldName, METHOD_rename, (Context)this);
                Helpers.throwIfNullOrEmpty(inNewName, METHOD_rename, (Context)this);
                if (inOldName.compareTo(inNewName) == 0) {
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "rename(Name, Name): The old and new names are the same");
                    }
                    return;
                }
                Name[] names = this.stripSchemeIdForUrlRootContextForRename(inOldName, inNewName);
                oldName = names[0];
                newName = names[1];
                boolean oldIsUrl = NameFormatHelper.isUrl(oldName);
                boolean newIsUrl = NameFormatHelper.isUrl(newName);
                String oldScheme = NameFormatHelper.getUrlScheme(oldName);
                String newScheme = NameFormatHelper.getUrlScheme(newName);
                if (oldIsUrl && newIsUrl && oldScheme.equals(newScheme)) {
                    Context urlCtx = Helpers.getContextIfUrlName(oldName, this._env);
                    urlCtx.rename(oldName, newName);
                    break block13;
                }
                if (!oldIsUrl && !newIsUrl) {
                    try {
                        NameSpaceBindingData oldParentData = this.getParentBindingData(oldName);
                        NameSpaceBindingData newParentData = this.getParentBindingData(newName);
                        if (this.isThisContextUpdatable(oldParentData) && this.isThisContextUpdatable(newParentData)) {
                            UrlContextImpl oldTargetCtx = oldParentData != null ? (UuidContext)oldParentData.getBoundObject() : this;
                            UrlContextImpl newTargetCtx = newParentData != null ? (UuidContext)newParentData.getBoundObject() : this;
                            NameSpaceBindingData nsBindingData = this._ns.lookup(oldTargetCtx, oldName.getSuffix(oldName.size() - 1));
                            this._ns.bind(newTargetCtx, newName.getSuffix(newName.size() - 1), nsBindingData.getBoundObject(), nsBindingData.getAdditionalData());
                            this._ns.unbind(oldTargetCtx, oldName.getSuffix(oldName.size() - 1));
                        }
                        break block13;
                    }
                    catch (NameNotAtomicException nnae) {
                        RasUtil.logException((Throwable)nnae, _tc, CLASS_NAME, "rename", "1390", this);
                        Tr.warning(_tc, "unexpectedErr");
                        Tr.debug(_tc, METHOD_rename, new java.lang.Object[]{"Internal error.  Failed with NameNotAtomicException", "name=" + newName});
                        NamingException ne = new NamingException("Received unexpected NameNotAtomicException: " + nnae.toString());
                        ne.setRootCause(nnae);
                        Tr.exit(_tc, METHOD_rename);
                        throw ne;
                    }
                    catch (NameSpaceInconsistentException nsie) {
                        RasUtil.logException((Throwable)nsie, _tc, CLASS_NAME, "rename", "1401", this);
                        Tr.warning(_tc, "unexpectedErr");
                        Tr.debug(_tc, METHOD_rename, new java.lang.Object[]{"Internal error.  Failed with NameSpaceInconsistentException", "oldName=" + oldName, "newName=" + newName});
                        NamingException ne = new NamingException("Received unexpected NameSpaceInconsistentException: " + nsie.toString());
                        ne.setRootCause(nsie);
                        Tr.exit(_tc, METHOD_rename);
                        throw ne;
                    }
                    catch (NameSpaceException nse) {
                        RasUtil.logException((Throwable)nse, _tc, CLASS_NAME, "rename", "1412", this);
                        Tr.warning(_tc, "unexpectedErr");
                        Tr.debug(_tc, METHOD_rename, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "oldName=" + oldName, "newName=" + newName});
                        NamingException ne = new NamingException("Received unexpected NameSpaceException: " + nse.toString());
                        ne.setRootCause(nse);
                        Tr.exit(_tc, METHOD_rename);
                        throw ne;
                    }
                }
                throw new OperationNotSupportedException("Do not support rename cross different name spaces:" + oldName + " " + newName);
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "rename", "1430", this);
                Tr.exit(_tc, "rename(Name, Name): exception");
                throw Helpers.logJndiContextException(t, (Context)this, METHOD_rename, inOldName, "New name: " + inNewName);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "rename(Name, Name) oldName=" + oldName + "newName=" + newName);
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "rename(String, String) oldName=" + oldName + "newName=" + newName);
        }
        try {
            Helpers.throwIfNullOrEmpty(oldName, METHOD_renameS, (Context)this);
            Helpers.throwIfNullOrEmpty(newName, METHOD_renameS, (Context)this);
            this.rename(this._parser.parse(oldName), this._parser.parse(newName));
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "rename", "1457", this);
            Tr.exit(_tc, "rename(String, String): exception");
            throw Helpers.logJndiContextException(t, (Context)this, METHOD_renameS, oldName, "New name: " + newName);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "rename(String, String) oldName=" + oldName + "newName=" + newName);
        }
    }

    public java.lang.Object addToEnvironment(String propName, java.lang.Object propVal) throws NamingException {
        java.lang.Object retVal;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addToEnvironment(String, Object) propName =" + propName);
        }
        try {
            if (propName == null || propVal == null) {
                throw new NamingException();
            }
            retVal = this._env.put(propName, propVal);
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "addToEnvironment", "1484", this);
            Tr.exit(_tc, "addToEnvironment(String, Object): exception");
            throw Helpers.logJndiContextException(t, (Context)this, METHOD_addToEnvironment, (String)null, "property name: \"" + propName + "\", property value: \"" + propVal + "\"");
        }
        Tr.exit(_tc, METHOD_addToEnvironment);
        return retVal;
    }

    public Hashtable getEnvironment() throws NamingException {
        Hashtable retHash;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_getEnvironment);
        }
        try {
            retHash = new Hashtable();
            Enumeration e = this._env.keys();
            while (e.hasMoreElements()) {
                java.lang.Object key = e.nextElement();
                retHash.put(key, this._env.get(key));
            }
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "getEnvironment", "1511", this);
            Tr.exit(_tc, "getEnvironment(): exception");
            throw Helpers.logJndiContextException(t, (Context)this, METHOD_getEnvironment, (String)null, null);
        }
        Tr.exit(_tc, METHOD_getEnvironment);
        return retHash;
    }

    public java.lang.Object removeFromEnvironment(String propName) throws NamingException {
        java.lang.Object retValue;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "removeEnvironment() propName =" + propName);
        }
        try {
            if (propName == null) {
                throw new NamingException();
            }
            retValue = this._env.remove(propName);
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "removeFromEnvironment", "1536", this);
            Tr.exit(_tc, "removeEnvironment(): exception");
            throw Helpers.logJndiContextException(t, (Context)this, METHOD_removeFromEnvironment, (String)null, "property name: \"" + propName + "\"");
        }
        Tr.exit(_tc, METHOD_removeFromEnvironment);
        return retValue;
    }

    public void close() throws NamingException {
        Tr.entry(_tc, METHOD_close);
        this._env = null;
        this._ns = null;
        this._strCtxID = null;
        Tr.exit(_tc, METHOD_close);
    }

    public String getNameInNamespace() throws NamingException {
        String nins = this.doGetNameInNamespace();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getNameInNamespace()-->>" + nins);
        }
        return nins;
    }

    public String toString() {
        String nins = this.doGetNameInNamespace();
        return this.getClass().getName() + "(" + nins + ")";
    }

    private NameSpaceBindingData getParentBindingData(Name name) throws NameSpaceException, NamingException {
        Tr.entry(_tc, "getParentBindingData(Name) name=" + name);
        NameSpaceBindingData retBindingData = null;
        if (name.size() > 1) {
            retBindingData = this._ns.getParentContext(this, name);
        } else if (this._parentCtx != null) {
            Name targetName = this.getContextName();
            targetName = targetName.getSuffix(targetName.size() - 1);
            retBindingData = this._ns.lookup(this._parentCtx, targetName);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getParentBindingData(Name) name=" + name);
        }
        return retBindingData;
    }

    protected String getStringifiedIOR(Object corbaObj) throws NamingException {
        String ior = this._orb.object_to_string(corbaObj);
        return ior;
    }

    public void listNameSpace() {
        this._ns.dumpNameSpace(null);
    }

    private void writeObject(ObjectOutputStream out_stream) throws IOException {
        Tr.entry(_tc, METHOD_writeObject);
        java.lang.Object orbObj = this._env.get("java.naming.corba.orb");
        if (orbObj instanceof ORB && !(orbObj instanceof Serializable)) {
            Tr.warning(_tc, "generalWithInsert", "UrlContextImpl.writeObject determined the Context " + this.toString() + " contains in it's environment Hashtable the property " + "java.naming.corba.orb" + " which contains the object " + orbObj.toString() + " which is not Serializable. Serialization will probably fail. " + "This property value should be removed prior to serialization of this Context.");
        }
        out_stream.defaultWriteObject();
        Tr.exit(_tc, METHOD_writeObject);
    }

    private void readObject(ObjectInputStream in_stream) throws IOException, ClassNotFoundException, NamingException {
        Tr.entry(_tc, METHOD_readObject);
        in_stream.defaultReadObject();
        this._orb = Helpers.getOrb(this._env);
        Tr.exit(_tc, METHOD_readObject);
    }

    protected java.lang.Object processBoundObjectForLookup(NameSpaceBindingData bindingData, java.lang.Object boundObj, Name name, Hashtable env) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, METHOD_processBoundObjectForLookup);
        }
        return UrlContextHelper.processBoundObjectForLookup(bindingData, boundObj, this, env, new BooleanWrapper(false), new JavaObjectHolder(), new BooleanWrapper(false), new JavaObjectHolder());
    }

    protected abstract boolean isThisContextUpdatable(NameSpaceBindingData var1) throws NamingException;

    protected abstract boolean isThisContextRemote();

    protected abstract java.lang.Object createAdditionalData(NameSpaceBindingData var1, String var2);

    protected abstract UuidContext createNewSubcontext(Name var1, UuidContext var2) throws NamingException;

    protected abstract String doGetNameInNamespace();

    protected abstract Name getContextName() throws NamingException;

    protected abstract Name stripSchemeIdForUrlRootContext(Name var1) throws NamingException;

    protected abstract Name[] stripSchemeIdForUrlRootContextForRename(Name var1, Name var2) throws NamingException;

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/urlbase/UrlContextImpl.java, WAS.naming.client, WAS70.SERV1, cf050925.09, ver. 1.8");
        }
        CLASS_NAME = UrlContextImpl.class.getName();
    }
}

