/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.urlbase;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.ipbase.NameSpaceBindingData;
import com.ibm.ws.naming.urlbase.UrlBindingData;
import com.ibm.ws.naming.urlbase.UrlContextImpl;
import com.ibm.ws.naming.util.BooleanWrapper;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.JavaObjectHolder;
import com.ibm.ws.naming.util.NameFormatHelper;
import java.util.Hashtable;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlContextHelper {
    private static final TraceComponent _tc = Tr.register(UrlContextHelper.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static final String IOR_URL_PREFIX = "IOR:";
    private static final String NAME_DELIMITER = "/";

    public static Object processBoundObjectForLookup(NameSpaceBindingData bindingData, Object boundObj, UrlContextImpl ctx, Hashtable<?, ?> env, BooleanWrapper isCacheableReference, JavaObjectHolder unprocessedJavaObject, BooleanWrapper haveUnprocessedIndirectJavaObject, JavaObjectHolder unprocessedIndirectJavaObject) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processBoundObjectForLookup", new String[]{"bindingData=" + bindingData, "boundObj=" + boundObj, "ctx=" + ctx, "env=" + env, "isCacheableReference=" + isCacheableReference, "unprocessedJavaObject=" + unprocessedJavaObject, "haveUnprocessedIndirectJavaObject=" + haveUnprocessedIndirectJavaObject, "unprocessedIndirectJavaObject=" + unprocessedIndirectJavaObject});
        }
        unprocessedJavaObject.value = null;
        haveUnprocessedIndirectJavaObject.value = false;
        unprocessedIndirectJavaObject.value = null;
        UrlBindingData urlBindingData = (UrlBindingData)bindingData.getAdditionalData();
        Object retObj = urlBindingData.getCachedObj();
        unprocessedJavaObject.value = urlBindingData.getReferenceForCachedObj();
        if (retObj == null) {
            if (boundObj instanceof String) {
                String boundString;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "processBoundObjectForLookup", "bound object is a String");
                }
                if ((boundString = (String)boundObj).toUpperCase().startsWith(IOR_URL_PREFIX)) {
                    retObj = ctx._orb.string_to_object(boundString);
                } else {
                    unprocessedJavaObject.value = boundObj;
                    retObj = boundObj;
                }
            } else if (boundObj instanceof byte[]) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "processBoundObjectForLookup", "bound object is a byte array");
                }
                retObj = Helpers.processSerializedObjectForLookupExt((byte[])boundObj, ctx, bindingData.getBindingName(), urlBindingData.getClassName(), env, unprocessedJavaObject, isCacheableReference, haveUnprocessedIndirectJavaObject, unprocessedIndirectJavaObject);
                if (isCacheableReference.value) {
                    urlBindingData.setCachedObj(retObj);
                    if (unprocessedJavaObject.value instanceof Reference) {
                        urlBindingData.setReferenceForCachedObj((Reference)unprocessedJavaObject.value);
                    }
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "processBoundObjectForLookup", "bound object: class=" + boundObj.getClass().getName());
                }
                retObj = boundObj;
                unprocessedJavaObject.value = boundObj;
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "processBoundObjectForLookup", "returning cached object");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processBoundObjectForLookup", retObj);
        }
        return retObj;
    }

    public static Name stripSchemeIdForUrlRootContext(Name name, String schemeId, NameParser parser2) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stripSchemeIdForUrlRootContext", new String[]{"name=" + name, "schemeId=" + schemeId, "parser=" + parser2});
        }
        Name retName = name;
        if (NameFormatHelper.isUrl(name)) {
            String scheme = NameFormatHelper.getUrlScheme(name);
            if (scheme.equals(schemeId)) {
                String strName = name.toString();
                strName = strName.substring(scheme.length() + 1);
                retName = parser2.parse(strName);
            } else {
                OperationNotSupportedException onse = new OperationNotSupportedException("Do not support naming operation cross different name spaces: " + name);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "stripSchemeIdForUrlRootContext", onse);
                }
                throw onse;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stripSchemeIdForUrlRootContext", retName);
        }
        return retName;
    }

    public static Name[] stripSchemeIdForUrlRootContextForRename(Name oldName, Name newName, String schemeId, NameParser parser2) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stripSchemeIdForUrlRootContextForRename", new String[]{"oldName=" + oldName, "newName=" + newName, "schemeId=" + schemeId, "parser=" + parser2});
        }
        Name[] retName = new Name[]{oldName, newName};
        boolean oldIsUrl = NameFormatHelper.isUrl(oldName);
        boolean newIsUrl = NameFormatHelper.isUrl(newName);
        String oldScheme = NameFormatHelper.getUrlScheme(oldName);
        String newScheme = NameFormatHelper.getUrlScheme(newName);
        if (oldIsUrl || newIsUrl) {
            if (oldIsUrl && newIsUrl && oldScheme.equals(newScheme) && oldScheme.equals(schemeId)) {
                String strName = oldName.toString();
                strName = strName.substring(schemeId.length() + 1);
                retName[0] = parser2.parse(strName);
                strName = newName.toString();
                strName = strName.substring(schemeId.length() + 1);
                retName[1] = parser2.parse(strName);
            } else {
                OperationNotSupportedException onse = new OperationNotSupportedException("Rename across different name spaces not spported: rename " + oldName + " to " + newName);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "stripSchemeIdForUrlRootContextForRename", onse);
                }
                throw onse;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stripSchemeIdForUrlRootContextForRename", retName);
        }
        return retName;
    }

    public static String getFullyQualifiedName(String name, String contextName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getFullyQualifiedName", new String[]{"name = " + name, "contextName=" + contextName});
        }
        String retName = null;
        retName = contextName.equals("") ? name : (name.equals("") ? contextName : contextName + NAME_DELIMITER + name);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getFullyQualifiedName", retName);
        }
        return retName;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/urlbase/UrlContextHelper.java, WAS.naming.client, WAS70.SERV1, cf050925.09, ver. 1.34");
        }
        CLASS_NAME = UrlContextHelper.class.getName();
    }
}

