/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.ldap.WsnLdapContextImpl;
import com.ibm.ws.naming.ldap.WsnLdapContextPerTreeInfo;
import com.ibm.ws.naming.ldap.WsnLdapHelpers;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.RasUtil;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.spi.InitialContextFactory;
import org.omg.CORBA.ORB;

public class WsnLdapInitCtxFactory
implements InitialContextFactory {
    private static final TraceComponent _tc = Tr.register(WsnLdapInitCtxFactory.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;

    public WsnLdapInitCtxFactory() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "<init>");
        }
    }

    public Context getInitialContext(Hashtable env) throws NamingException {
        String nameSpaceRoot;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInitialContext", "env=" + env);
        }
        if (env.get("com.ibm.ws.naming.ldap.masterurl") == null) {
            ConfigurationException ce = new ConfigurationException("Url of Master LDAP Server not specified in property com.ibm.ws.naming.ldap.masterurl");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getInitialContext", "Throwing ConfigurationException: " + ce);
            }
            throw ce;
        }
        String masterServerUrl = (String)env.get("com.ibm.ws.naming.ldap.masterurl");
        if (env.get("com.ibm.ws.naming.ldap.noderootrdn") == null) {
            ConfigurationException ce = new ConfigurationException("LDAP DN of Host Root Context not specified in property com.ibm.ws.naming.ldap.noderootrdn");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getInitialContext", "Throwing ConfigurationException: " + ce);
            }
            throw ce;
        }
        String hostRootRDN = (String)env.get("com.ibm.ws.naming.ldap.noderootrdn");
        if (env.get("com.ibm.ws.naming.ldap.containerdn") == null) {
            ConfigurationException ce = new ConfigurationException("LDAP DN of Name Tree Container not specified in property com.ibm.ws.naming.ldap.containerdn");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getInitialContext", "Throwing ConfigurationException: " + ce);
            }
            throw ce;
        }
        String nameTreeContainerDN = (String)env.get("com.ibm.ws.naming.ldap.containerdn");
        String ldapInitCtxFactory = env.get("com.ibm.ws.naming.ldap.ldapinitctxfactory") != null ? (String)env.get("com.ibm.ws.naming.ldap.ldapinitctxfactory") : "com.sun.jndi.ldap.LdapCtxFactory";
        if (env.get("com.ibm.websphere.naming.namespaceroot") != null) {
            nameSpaceRoot = (String)env.get("com.ibm.websphere.naming.namespaceroot");
            if (!(nameSpaceRoot.equals("legacydomainroot") || nameSpaceRoot.equals("bootstraphostroot") || nameSpaceRoot.equals("treeinfrastructureroot"))) {
                ConfigurationException ce = new ConfigurationException("Property com.ibm.websphere.naming.namespaceroot=" + nameSpaceRoot + " is not a valid value");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getInitialContext", "Throwing ConfigurationException: " + ce);
                }
                throw ce;
            }
        } else {
            nameSpaceRoot = "legacydomainroot";
        }
        Hashtable clonedEnv = (Hashtable)env.clone();
        clonedEnv.put("java.naming.factory.initial", ldapInitCtxFactory);
        clonedEnv.put("java.naming.provider.url", masterServerUrl);
        clonedEnv.put("java.naming.ldap.derefAliases", "finding");
        WsnLdapHelpers.setupLdapProtocolTracing(clonedEnv);
        InitialDirContext idc = null;
        DirContext initialLdapCtx = null;
        try {
            idc = new InitialDirContext(clonedEnv);
            initialLdapCtx = (DirContext)idc.lookup("");
        }
        catch (NamingException ne) {
            RasUtil.logException((Throwable)ne, _tc, CLASS_NAME, "getInitialContext", "180", this);
            Helpers.closeIfContext(idc);
            Helpers.closeIfContext(initialLdapCtx);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getInitialContext", "Exception creating InitialDirContext for LDAP plug-in: " + ne);
            }
            throw ne;
        }
        String rootLdapCtxDN = null;
        rootLdapCtxDN = nameSpaceRoot.equals("treeinfrastructureroot") ? WsnLdapHelpers.doubleEscapeEscapes(nameTreeContainerDN) : WsnLdapHelpers.doubleEscapeEscapes(hostRootRDN + "," + nameTreeContainerDN);
        DirContext rootLdapCtx = null;
        try {
            rootLdapCtx = (DirContext)initialLdapCtx.lookup(rootLdapCtxDN);
        }
        catch (NamingException ex) {
            RasUtil.logException((Throwable)ex, _tc, CLASS_NAME, "getInitialContext", "204", this);
            Helpers.closeIfContext(initialLdapCtx);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getInitialContext", "lookup failed for WebSphere Name Tree at: " + rootLdapCtxDN + " -- Exception: " + ex);
            }
            throw ex;
        }
        ORB orb = Helpers.getOrb(env);
        WsnLdapContextPerTreeInfo pti = new WsnLdapContextPerTreeInfo(initialLdapCtx, rootLdapCtx, rootLdapCtxDN, masterServerUrl, nameTreeContainerDN, hostRootRDN, "", "", orb);
        Context wsnCtx = new WsnLdapContextImpl(env, rootLdapCtx, pti);
        if (nameSpaceRoot.equals("legacydomainroot")) {
            WsnLdapContextImpl hostRootCtx = wsnCtx;
            wsnCtx = null;
            String info = null;
            try {
                info = "ibm-wsnName=domain," + rootLdapCtxDN;
                Context domainRootCtx = (Context)hostRootCtx.lookup("domain");
                info = "ibm-wsnName=legacyRoot," + info;
                wsnCtx = (Context)domainRootCtx.lookup("legacyRoot");
            }
            catch (NamingException ex) {
                RasUtil.logException((Throwable)ex, _tc, CLASS_NAME, "getInitialContext", "253", this);
                Helpers.closeIfContext(initialLdapCtx);
                Helpers.closeIfContext(rootLdapCtx);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getInitialContext", "lookup failed for WebSphere Name Tree at: " + info + " -- Exception: " + ex);
                }
                throw ex;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getInitialContext", wsnCtx);
        }
        return wsnCtx;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/ldap/WsnLdapInitCtxFactory.java, WAS.naming.client, WAS70.SERV1, cf050925.09, ver. 1.21");
        }
        CLASS_NAME = WsnLdapInitCtxFactory.class.getName();
    }
}

